/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.cli;

import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommand
implements Comparable<AbstractCommand> {
    public static final Integer EXIT_OK = IApplication.EXIT_OK;
    public static final Integer EXIT_ERROR = 13;
    @Option(name="-?", aliases={"--help"}, usage="Print help screen for specified command")
    private boolean help;
    @Option(name="--stacktrace", usage="Display stack trace on error")
    private boolean displayStacktrace;
    private String name;

    @Override
    public final int compareTo(AbstractCommand another) {
        return another == null ? 1 : this.getName().compareTo(another.getName());
    }

    public InputStream getHelpStream() {
        return null;
    }

    public final String getName() {
        return this.name;
    }

    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return this.getDefaultMonitor();
            }
        };
    }

    public abstract String getShortDescription();

    public String getUsageTitle() {
        return String.valueOf(this.getName()) + " [options...]";
    }

    public boolean isDisplayStacktrace() {
        return this.displayStacktrace;
    }

    public boolean isHelp() {
        return this.help;
    }

    public final int run() throws Exception {
        IProgressMonitor monitor = this.getProgressProvider().getDefaultMonitor();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int n = this.run(monitor);
            return n;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract int run(IProgressMonitor var1) throws Exception;

    final void setName(String name) {
        this.name = name;
    }
}

