/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.VersionSupplier;

public class VersionHashMap
extends MappedList
implements Comparator {
    private ResolverImpl resolver;

    public VersionHashMap(ResolverImpl resolver) {
        this.resolver = resolver;
    }

    protected int insertionIndex(Object[] existing, Object value) {
        int index = existing.length;
        if (this.compare(existing[existing.length - 1], value) > 0 && (index = Arrays.binarySearch(existing, value, this)) < 0) {
            index = -index - 1;
        }
        return index;
    }

    public void put(VersionSupplier[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.put(versionSuppliers[i].getName(), versionSuppliers[i]);
            ++i;
        }
    }

    public boolean contains(VersionSupplier vs) {
        return this.contains(vs, false) != null;
    }

    private VersionSupplier contains(VersionSupplier vs, boolean remove) {
        Object existing = this.internal.get(vs.getName());
        if (existing == null) {
            return null;
        }
        if (existing == vs) {
            if (remove) {
                this.internal.remove(vs.getName());
            }
            return vs;
        }
        if (!existing.getClass().isArray()) {
            return null;
        }
        Object[] existingValues = (Object[])existing;
        int i = 0;
        while (i < existingValues.length) {
            if (existingValues[i] == vs) {
                if (remove) {
                    if (existingValues.length == 2) {
                        this.internal.put(vs.getName(), existingValues[i == 0 ? 1 : 0]);
                        return vs;
                    }
                    Object[] newExisting = new Object[existingValues.length - 1];
                    System.arraycopy(existingValues, 0, newExisting, 0, i);
                    if (i + 1 < existingValues.length) {
                        System.arraycopy(existingValues, i + 1, newExisting, i, existingValues.length - i - 1);
                    }
                    this.internal.put(vs.getName(), newExisting);
                }
                return vs;
            }
            ++i;
        }
        return null;
    }

    public Object remove(VersionSupplier toBeRemoved) {
        return this.contains(toBeRemoved, true);
    }

    public void remove(VersionSupplier[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.remove(versionSuppliers[i]);
            ++i;
        }
    }

    void reorder() {
        Iterator it = this.internal.values().iterator();
        while (it.hasNext()) {
            Object existing = it.next();
            if (!existing.getClass().isArray()) continue;
            Arrays.sort((Object[])existing, this);
        }
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof VersionSupplier) || !(o2 instanceof VersionSupplier)) {
            throw new IllegalArgumentException();
        }
        VersionSupplier vs1 = (VersionSupplier)o1;
        VersionSupplier vs2 = (VersionSupplier)o2;
        if (this.resolver.getSelectionPolicy() != null) {
            return this.resolver.getSelectionPolicy().compare(vs1.getBaseDescription(), vs2.getBaseDescription());
        }
        String systemBundle = this.resolver.getSystemBundle();
        if (systemBundle.equals(vs1.getBundle().getSymbolicName()) && !systemBundle.equals(vs2.getBundle().getSymbolicName())) {
            return -1;
        }
        if (!systemBundle.equals(vs1.getBundle().getSymbolicName()) && systemBundle.equals(vs2.getBundle().getSymbolicName())) {
            return 1;
        }
        if (vs1.getBundle().isResolved() != vs2.getBundle().isResolved()) {
            return vs1.getBundle().isResolved() ? -1 : 1;
        }
        int versionCompare = -vs1.getVersion().compareTo(vs2.getVersion());
        if (versionCompare != 0) {
            return versionCompare;
        }
        return vs1.getBundle().getBundleId() <= vs2.getBundle().getBundleId() ? -1 : 1;
    }
}

