/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.util;

import org.eclipse.b3.util.B3Util;
import org.eclipse.b3.util.LogLevel;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class LogUtils {
    private static final int MAGIC = B3Util.getPluginID().hashCode();

    public static void debug(String msg, Object ... args) {
        LogUtils.log(LogLevel.DEBUG, msg, args);
    }

    public static void debug(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.DEBUG, t, msg, args);
    }

    public static void error(String msg, Object ... args) {
        LogUtils.log(LogLevel.ERROR, msg, args);
    }

    public static void error(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.ERROR, t, msg, args);
    }

    public static ILog getLog() {
        return Platform.getLog((Bundle)B3Util.getPlugin().getBundle());
    }

    public static void info(String msg, Object ... args) {
        LogUtils.log(LogLevel.INFO, msg, args);
    }

    public static void info(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.INFO, t, msg, args);
    }

    public static void log(LogLevel level, String msg, Object ... args) {
        LogUtils.log(level, null, msg, args);
    }

    public static void log(LogLevel level, Throwable t, String msg, Object ... args) {
        String fullMessage = args == null || args.length == 0 ? msg : String.format(msg, args);
        B3Util plugin = B3Util.getPlugin();
        if (level.ordinal() >= plugin.getConsoleLogLevel().ordinal()) {
            System.out.println(fullMessage);
        }
        if (level.ordinal() >= plugin.getEclipseLogLevel().ordinal()) {
            LogUtils.getLog().log((IStatus)new Status(level.getStatusLevel(), B3Util.getPluginID(), MAGIC, fullMessage, t));
        }
    }

    public static void warning(String msg, Object ... args) {
        LogUtils.log(LogLevel.WARNING, msg, args);
    }

    public static void warning(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.WARNING, t, msg, args);
    }
}

