/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.engine.VerificationFeatureAction;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class VerificationFeatureGenerator
extends BuilderPhase {
    public VerificationFeatureGenerator(Builder builder) {
        super(builder);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        long start = TimeUtils.getNow();
        MonitorUtils.begin((IProgressMonitor)monitor, (String)"Verifying Features", (int)100);
        String info = "Starting generation of verification feature";
        LogUtils.info((String)info, (Object[])new Object[0]);
        MonitorUtils.subTask((IProgressMonitor)monitor, (String)info);
        String name = String.valueOf(this.getBuilder().getAggregator().getLabel()) + " Verification Feature";
        File globalLocation = new File(this.getBuilder().getBuildRoot(), "interim");
        File location = new File(globalLocation, "verification");
        FileUtils.deleteAll((File)location);
        HashMap properties = new HashMap();
        URI locationURI = Builder.createURI(location);
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IMetadataRepositoryManager.class);
        try {
            mdrMgr.removeRepository(locationURI);
            IMetadataRepository mdr = mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            PublisherInfo pubInfo = new PublisherInfo();
            pubInfo.setMetadataRepository(mdr);
            Publisher publisher = new Publisher((IPublisherInfo)pubInfo);
            IStatus result = publisher.publish(this.createActions(mdr), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            if (result.getSeverity() == 4) {
                throw new CoreException(result);
            }
            this.getBuilder().getSourceComposite().addChild(mdr.getLocation());
        }
        finally {
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), (IRepositoryManager)mdrMgr);
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
    }

    private IPublisherAction[] createActions(IMetadataRepository mdr) {
        return new IPublisherAction[]{new VerificationFeatureAction(this.getBuilder(), mdr)};
    }
}

