/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.transformer.TransformationManager;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.cli.AbstractCommand;
import org.eclipse.b3.p2.util.ResourceSetWithAgent;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.kohsuke.args4j.Option;

public abstract class ModelAbstractCommand
extends AbstractCommand {
    @Option(name="--buildModel", required=true, usage="Appoints the aggregation definition that drives the execution")
    protected File buildModelLocation;
    protected ResourceSet resourceSet;

    protected Aggregator loadModelFromFile() throws CoreException {
        try {
            Resource resource;
            this.resourceSet = new ResourceSetWithAgent();
            String modelPath = this.buildModelLocation.getAbsolutePath();
            File modelFile = new File(modelPath);
            if (!modelFile.exists()) {
                throw ExceptionUtils.fromMessage((String)"Specified build model file does not exist", (Object[])new Object[0]);
            }
            if (!modelFile.isFile()) {
                throw ExceptionUtils.fromMessage((String)"Specified build model location does not appoint a file", (Object[])new Object[0]);
            }
            URI fileURI = URI.createFileURI((String)modelPath);
            if (ResourceUtils.isCurrentModel((URI)fileURI)) {
                resource = this.resourceSet.getResource(fileURI, true);
            } else {
                LogUtils.warning((String)"The build model file is obsolete, using the default transformation", (Object[])new Object[0]);
                TransformationManager tm = new TransformationManager(fileURI);
                if (!tm.isSrcNamespaceFound()) {
                    throw ExceptionUtils.fromMessage((String)"No transformation found for specified build model", (Object[])new Object[0]);
                }
                resource = tm.transformResource();
                this.resourceSet.getResources().add((Object)resource);
            }
            EList content = resource.getContents();
            if (content.size() != 1) {
                throw ExceptionUtils.fromMessage((String)"ECore Resource did not contain one resource. It had %d", (Object[])new Object[]{content.size()});
            }
            return (Aggregator)content.get(0);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap((Throwable)e);
        }
    }
}

