/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.maven.util;

import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.eclipse.b3.p2.maven.util.UriUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriIterator
implements Iterator<URI> {
    private final URI root;
    private final URI[] uris;
    private final Pattern excludePattern;
    private int index;

    public UriIterator(URI root, Pattern excludePattern, IProgressMonitor monitor) throws CoreException {
        this.uris = UriUtils.list(UriUtils.appendTrailingSlash(root), monitor);
        this.excludePattern = excludePattern;
        this.root = root;
        this.index = -1;
        this.positionNext();
    }

    public UriIterator(URI root, Pattern excludePattern, URI[] uris) {
        this.uris = uris;
        this.excludePattern = excludePattern;
        this.root = root;
        this.index = -1;
        this.positionNext();
    }

    public URI getRoot() {
        return this.root;
    }

    public URI[] getURIs() {
        return this.uris;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.uris.length;
    }

    @Override
    public URI next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        URI nextURL = this.uris[this.index];
        this.positionNext();
        return nextURL;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.uris.length;
    }

    private void positionNext() {
        if (this.excludePattern == null) {
            ++this.index;
        } else {
            int top = this.uris.length;
            while (++this.index < top && this.excludePattern.matcher(this.uris[this.index].toString()).matches()) {
            }
        }
    }
}

