/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Architecture;
import org.eclipse.b3.aggregator.Configuration;
import org.eclipse.b3.aggregator.OperatingSystem;
import org.eclipse.b3.aggregator.WindowSystem;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

public class ConfigurationImpl
extends MinimalEObjectImpl.Container
implements Configuration {
    protected int eFlags = 0;
    protected static final boolean ENABLED_EDEFAULT = true;
    protected static final int ENABLED_EFLAG = 1;
    protected static final OperatingSystem OPERATING_SYSTEM_EDEFAULT = OperatingSystem.WIN32;
    protected static final int OPERATING_SYSTEM_EFLAG_OFFSET = 1;
    protected static final int OPERATING_SYSTEM_EFLAG_DEFAULT = OPERATING_SYSTEM_EDEFAULT.ordinal() << 1;
    private static final OperatingSystem[] OPERATING_SYSTEM_EFLAG_VALUES = OperatingSystem.values();
    protected static final int OPERATING_SYSTEM_EFLAG = 14;
    protected static final WindowSystem WINDOW_SYSTEM_EDEFAULT = WindowSystem.WIN32;
    protected static final int WINDOW_SYSTEM_EFLAG_OFFSET = 4;
    protected static final int WINDOW_SYSTEM_EFLAG_DEFAULT = WINDOW_SYSTEM_EDEFAULT.ordinal() << 4;
    private static final WindowSystem[] WINDOW_SYSTEM_EFLAG_VALUES = WindowSystem.values();
    protected static final int WINDOW_SYSTEM_EFLAG = 112;
    protected static final Architecture ARCHITECTURE_EDEFAULT = Architecture.X86;
    protected static final int ARCHITECTURE_EFLAG_OFFSET = 7;
    protected static final int ARCHITECTURE_EFLAG_DEFAULT = ARCHITECTURE_EDEFAULT.ordinal() << 7;
    private static final Architecture[] ARCHITECTURE_EFLAG_VALUES = Architecture.values();
    protected static final int ARCHITECTURE_EFLAG = 1920;

    protected ConfigurationImpl() {
        this.eFlags |= 1;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isEnabled();
            }
            case 1: {
                return this.getOperatingSystem();
            }
            case 2: {
                return this.getWindowSystem();
            }
            case 3: {
                return this.getArchitecture();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return (this.eFlags & 1) == 0;
            }
            case 1: {
                return (this.eFlags & 0xE) != OPERATING_SYSTEM_EFLAG_DEFAULT;
            }
            case 2: {
                return (this.eFlags & 0x70) != WINDOW_SYSTEM_EFLAG_DEFAULT;
            }
            case 3: {
                return (this.eFlags & 0x780) != ARCHITECTURE_EFLAG_DEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 1: {
                this.setOperatingSystem((OperatingSystem)((Object)newValue));
                return;
            }
            case 2: {
                this.setWindowSystem((WindowSystem)((Object)newValue));
                return;
            }
            case 3: {
                this.setArchitecture((Architecture)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setEnabled(true);
                return;
            }
            case 1: {
                this.setOperatingSystem(OPERATING_SYSTEM_EDEFAULT);
                return;
            }
            case 2: {
                this.setWindowSystem(WINDOW_SYSTEM_EDEFAULT);
                return;
            }
            case 3: {
                this.setArchitecture(ARCHITECTURE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public Architecture getArchitecture() {
        return ARCHITECTURE_EFLAG_VALUES[(this.eFlags & 0x780) >>> 7];
    }

    public String getName() {
        StringBuilder bld = new StringBuilder();
        bld.append((Object)OPERATING_SYSTEM_EFLAG_VALUES[(this.eFlags & 0xE) >>> 1]);
        bld.append(',');
        bld.append((Object)WINDOW_SYSTEM_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4]);
        bld.append(',');
        bld.append((Object)ARCHITECTURE_EFLAG_VALUES[(this.eFlags & 0x780) >>> 7]);
        return bld.toString();
    }

    public OperatingSystem getOperatingSystem() {
        return OPERATING_SYSTEM_EFLAG_VALUES[(this.eFlags & 0xE) >>> 1];
    }

    public String getOSGiEnvironmentString() {
        StringBuilder bld = new StringBuilder();
        bld.append("osgi.os=");
        bld.append((Object)OPERATING_SYSTEM_EFLAG_VALUES[(this.eFlags & 0xE) >>> 1]);
        bld.append(",osgi.ws=");
        bld.append((Object)WINDOW_SYSTEM_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4]);
        bld.append(",osgi.arch=");
        bld.append((Object)ARCHITECTURE_EFLAG_VALUES[(this.eFlags & 0x780) >>> 7]);
        return bld.toString();
    }

    public WindowSystem getWindowSystem() {
        return WINDOW_SYSTEM_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4];
    }

    public boolean isEnabled() {
        return (this.eFlags & 1) != 0;
    }

    public void setArchitecture(Architecture newArchitecture) {
        Architecture oldArchitecture = ARCHITECTURE_EFLAG_VALUES[(this.eFlags & 0x780) >>> 7];
        if (newArchitecture == null) {
            newArchitecture = ARCHITECTURE_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFF87F | newArchitecture.ordinal() << 7;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldArchitecture, (Object)newArchitecture));
        }
    }

    public void setEnabled(boolean newEnabled) {
        boolean oldEnabled;
        boolean bl = oldEnabled = (this.eFlags & 1) != 0;
        this.eFlags = newEnabled ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldEnabled, newEnabled));
        }
    }

    public void setOperatingSystem(OperatingSystem newOperatingSystem) {
        OperatingSystem oldOperatingSystem = OPERATING_SYSTEM_EFLAG_VALUES[(this.eFlags & 0xE) >>> 1];
        if (newOperatingSystem == null) {
            newOperatingSystem = OPERATING_SYSTEM_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFFF1 | newOperatingSystem.ordinal() << 1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldOperatingSystem, (Object)newOperatingSystem));
        }
    }

    public void setWindowSystem(WindowSystem newWindowSystem) {
        WindowSystem oldWindowSystem = WINDOW_SYSTEM_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4];
        if (newWindowSystem == null) {
            newWindowSystem = WINDOW_SYSTEM_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFF8F | newWindowSystem.ordinal() << 4;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldWindowSystem, (Object)newWindowSystem));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (enabled: ");
        result.append((this.eFlags & 1) != 0);
        result.append(", operatingSystem: ");
        result.append((Object)OPERATING_SYSTEM_EFLAG_VALUES[(this.eFlags & 0xE) >>> 1]);
        result.append(", windowSystem: ");
        result.append((Object)WINDOW_SYSTEM_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4]);
        result.append(", architecture: ");
        result.append((Object)ARCHITECTURE_EFLAG_VALUES[(this.eFlags & 0x780) >>> 7]);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.CONFIGURATION;
    }
}

