/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WindowSystem implements Enumerator
{
    WIN32(0, "Win32", "win32"),
    GTK(1, "GTK", "gtk"),
    CARBON(2, "Carbon", "carbon"),
    COCOA(3, "Cocoa", "cocoa"),
    MOTIF(4, "Motif", "motif"),
    PHOTON(0, "Photon", "photon");

    public static final int WIN32_VALUE = 0;
    public static final int GTK_VALUE = 1;
    public static final int CARBON_VALUE = 2;
    public static final int COCOA_VALUE = 3;
    public static final int MOTIF_VALUE = 4;
    public static final int PHOTON_VALUE = 0;
    private static final WindowSystem[] VALUES_ARRAY;
    public static final List<WindowSystem> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WindowSystem[]{WIN32, GTK, CARBON, COCOA, MOTIF, PHOTON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WindowSystem get(int value) {
        switch (value) {
            case 0: {
                return WIN32;
            }
            case 1: {
                return GTK;
            }
            case 2: {
                return CARBON;
            }
            case 3: {
                return COCOA;
            }
            case 4: {
                return MOTIF;
            }
        }
        return null;
    }

    public static WindowSystem get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WindowSystem result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WindowSystem getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WindowSystem result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private WindowSystem(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

