/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.legacy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.legacy.TreePath;
import org.eclipse.b3.aggregator.util.ITransformer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceTransformer
implements ITransformer {
    protected Resource srcResource;
    protected Resource trgtResource;
    protected EPackage trgtPackage;
    protected EFactory trgtPackageFactory;
    protected Map<EObject, EObject> transformationMapping = new HashMap<EObject, EObject>();

    protected static Object getFeatureValue(EObject eobject, String featureName) {
        EStructuralFeature feature = eobject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            throw new IllegalArgumentException(String.valueOf(featureName) + " is not a valid feature name of " + eobject.eClass().getName() + " EClass");
        }
        return eobject.eGet(feature);
    }

    public void initTransformer(Resource srcResource, Resource trgtResource, EPackage trgtPackage) {
        this.srcResource = srcResource;
        this.trgtResource = trgtResource;
        this.trgtPackage = trgtPackage;
        this.trgtPackageFactory = trgtPackage.getEFactoryInstance();
    }

    public void startTransformation() {
        for (EObject srcEObject : this.srcResource.getContents()) {
            this.transform(srcEObject, new TreePath(this.trgtResource));
        }
        for (EObject srcEObject : this.srcResource.getContents()) {
            this.transformRef(srcEObject);
        }
    }

    protected void copyAttributes(EObject srcEObject, EObject trgtEObject) {
        for (EAttribute srcEAttr : srcEObject.eClass().getEAllAttributes()) {
            EAttribute trgtEAttr;
            Object srcEAttrValue = srcEObject.eGet((EStructuralFeature)srcEAttr);
            if (srcEAttrValue == null || (trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(srcEAttr.getName())) == null) continue;
            trgtEObject.eSet((EStructuralFeature)trgtEAttr, srcEAttrValue);
        }
    }

    protected Object createTrgtEEnumLiteral(String enumName, String literal) {
        EDataType trgtEDataType = (EDataType)this.trgtPackage.getEClassifier(enumName);
        if (enumName == null) {
            throw new IllegalArgumentException(String.valueOf(enumName) + " is not a valid EEnum in the target model");
        }
        Object enumerator = this.trgtPackageFactory.createFromString(trgtEDataType, literal);
        if (enumerator == null) {
            throw new IllegalArgumentException(String.valueOf(literal) + " is not a valid literal for EEnum " + enumName + " in the target model");
        }
        return enumerator;
    }

    protected EObject createTrgtEObject(String className, EObject mappedFromSrcEObject) {
        EClass trgtEClass = (EClass)this.trgtPackage.getEClassifier(className);
        if (trgtEClass == null) {
            throw new IllegalArgumentException(String.valueOf(className) + " is not a valid EClass in the target model");
        }
        EObject trgtEObject = this.trgtPackageFactory.create(trgtEClass);
        if (mappedFromSrcEObject != null) {
            this.transformationMapping.put(mappedFromSrcEObject, trgtEObject);
        }
        return trgtEObject;
    }

    protected Object getValue(EObject eobject, String featureName) {
        EStructuralFeature feature = eobject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            throw new IllegalArgumentException(String.valueOf(featureName) + " is not a valid feature in " + eobject.eClass().getName() + " EClass");
        }
        return eobject.eGet(feature);
    }

    protected void transform(EObject srcEObject, TreePath trgtParentTreePath) {
        EClass scrEClass = srcEObject.eClass();
        EObject trgtEObject = this.createTrgtEObject(scrEClass.getName(), srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(trgtEObject);
        this.copyAttributes(srcEObject, trgtEObject);
        for (EReference srcERef : scrEClass.getEAllContainments()) {
            EReference trgtERef;
            Object srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef);
            if (srcERefValue == null || (trgtERef = (EReference)trgtEObject.eClass().getEStructuralFeature(srcERef.getName())) == null) continue;
            TreePath trgtTreePath = trgtParentTreePath.createChildTreePath(trgtEObject, trgtERef);
            if (!srcERef.isMany()) {
                this.transform((EObject)srcERefValue, trgtTreePath);
                continue;
            }
            for (EObject srcChild : (List)srcERefValue) {
                this.transform(srcChild, trgtTreePath);
            }
        }
    }

    protected void transformRef(EObject srcEObject) {
        EClass scrEClass = srcEObject.eClass();
        EObject trgtEObject = this.transformationMapping.get(srcEObject);
        if (trgtEObject != null) {
            EClass trgtEClass = trgtEObject.eClass();
            for (EReference srcERef : scrEClass.getEAllReferences()) {
                EReference trgtERef;
                Object srcERefValue;
                if (scrEClass.getEAllContainments().contains((Object)srcERef) || (srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef)) == null || (trgtERef = (EReference)trgtEClass.getEStructuralFeature(srcERef.getName())) == null) continue;
                if (!trgtERef.isMany()) {
                    trgtEObject.eSet((EStructuralFeature)trgtERef, (Object)this.transformationMapping.get(srcERefValue));
                    continue;
                }
                if (!(srcERefValue instanceof List)) continue;
                List trgtRefList = (List)trgtEObject.eGet((EStructuralFeature)trgtERef);
                for (EObject srcChild : (List)srcERefValue) {
                    trgtRefList.add(this.transformationMapping.get(srcChild));
                }
            }
        }
        for (EReference srcERef : scrEClass.getEAllContainments()) {
            Object srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef);
            if (srcERefValue == null) continue;
            if (!srcERef.isMany()) {
                this.transformRef((EObject)srcERefValue);
                continue;
            }
            for (EObject srcChild : (List)srcERefValue) {
                this.transformRef(srcChild);
            }
        }
    }
}

