/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import org.eclipse.b3.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.b3.aggregator.presentation.UIUtils;
import org.eclipse.equinox.internal.p2.metadata.VersionFormat;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionFormatException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class VersionRangeEditorDialog
extends Dialog {
    private static final Version OSGi_versionMax = Version.createOSGi((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
    private static final int VERSION_TEXT_WIDTH_HINT = 160;
    private static final String VERSION_TYPE_OSGI = "OSGi";
    private static final int VERSION_TYPE_OSGI_IDX = 0;
    private static final String VERSION_TYPE_STRING = "String";
    private static final String VERSION_TYPE_TIMESTAMP = "Timestamp";
    private static final String VERSION_TYPE_TRIPLET = "Triplet";
    private static final String VERSION_TYPE_USER_DEFINED = "User Defined";
    private static final int VERSION_TYPE_USER_DEFINED_IDX = 4;
    private static final String[] VERSION_TYPES = new String[]{"OSGi", "String", "Timestamp", "Triplet", "User Defined"};
    private static final IVersionFormat VERSION_FORMAT_OSGI;
    private static final IVersionFormat VERSION_FORMAT_STRING;
    private static final IVersionFormat VERSION_FORMAT_TIMESTAMP;
    private static final IVersionFormat VERSION_FORMAT_TRIPLET;
    private static final IVersionFormat[] VERSION_FORMATS;
    protected ILabelProvider labelProvider;
    protected VersionRange versionRange;
    private Composite topComposite;
    private Text minVersionText;
    private Combo minVersionInclusiveCombo;
    private Text maxVersionText;
    private Combo maxVersionInclusiveCombo;
    private Label statusLabel;
    private Button okButton;
    private VersionRange result;
    private int labelWidth;
    private Composite advancedComposite;
    private Button advancedButton;
    private Composite advancedFieldsComposite;
    private int advancedFieldsHeight = -1;
    private Combo versionTypeCombo;
    private Text formatStringText;
    private int currentVersionTypeIdx;
    private IVersionFormat currentFormat;
    private Exception formatStringException;

    static {
        try {
            VERSION_FORMAT_OSGI = VersionFormat.compile((String)"n[.n=0;[.n=0;[.S=\"\";=[A-Za-z0-9_-];]]]");
            VERSION_FORMAT_STRING = VersionFormat.compile((String)"S");
            VERSION_FORMAT_TIMESTAMP = VersionFormat.compile((String)"S=[0-9];={8};[.S=[0-9];={6};=\"000000\";]");
            VERSION_FORMAT_TRIPLET = VersionFormat.compile((String)"n[.n=0;[.n=0;]][d?S=M;]");
        }
        catch (VersionFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        VERSION_FORMATS = new IVersionFormat[]{VERSION_FORMAT_OSGI, VERSION_FORMAT_STRING, VERSION_FORMAT_TIMESTAMP, VERSION_FORMAT_TRIPLET};
    }

    private static String getString(String key) {
        return AggregatorEditorPlugin.INSTANCE.getString(key);
    }

    protected VersionRangeEditorDialog(Shell parent, ILabelProvider labelProvider, Object object) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.labelProvider = labelProvider;
        this.versionRange = (VersionRange)object;
        IVersionFormat versionFormat = this.versionRange.getMinimum().getFormat();
        this.currentVersionTypeIdx = 0;
        this.currentFormat = VERSION_FORMAT_OSGI;
        if (versionFormat != null) {
            this.currentVersionTypeIdx = 4;
            this.currentFormat = versionFormat;
            int i = 0;
            IVersionFormat[] iVersionFormatArray = VERSION_FORMATS;
            int n = VERSION_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                IVersionFormat formatString = iVersionFormatArray[n2];
                if (versionFormat.equals(formatString)) {
                    this.currentVersionTypeIdx = i;
                }
                ++i;
                ++n2;
            }
        }
    }

    public VersionRange getResult() {
        return this.result;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                this.close();
                break;
            }
            default: {
                if (!this.performAction(buttonId)) break;
                this.close();
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_windowTitle"));
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        ++layout.numColumns;
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.isOKEnabled());
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Control fContents = this.createPageArea(result);
        fContents.setLayoutData((Object)new GridData(1808));
        return result;
    }

    protected Control createPageArea(Composite parent) {
        String[] inclusiveExclusive = new String[]{VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_inclusiveChoice"), VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_exclusiveChoice")};
        this.topComposite = new Composite(parent, 0);
        this.topComposite.setFont(parent.getFont());
        this.topComposite.setLayout((Layout)new GridLayout(3, false));
        this.topComposite.setLayoutData((Object)new GridData(1808));
        new Label(this.topComposite, 0).setText(VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_minimumVersionLabel"));
        this.minVersionText = new Text(this.topComposite, 2048);
        this.minVersionText.setText(this.versionRange.getMinimum().getOriginal());
        GridData gridData = new GridData(768);
        gridData.widthHint = 160;
        this.minVersionText.setLayoutData((Object)gridData);
        this.minVersionInclusiveCombo = new Combo(this.topComposite, 8);
        this.minVersionInclusiveCombo.setItems(inclusiveExclusive);
        this.minVersionInclusiveCombo.select(this.versionRange.getIncludeMinimum() ? 0 : 1);
        Label label = new Label(this.topComposite, 0);
        label.setText(VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_maximumVersionLabel"));
        this.labelWidth = label.computeSize((int)-1, (int)-1, (boolean)true).x;
        this.maxVersionText = new Text(this.topComposite, 2048);
        Version maxVersion = this.versionRange.getMaximum();
        this.maxVersionText.setText(Version.MAX_VERSION.equals(maxVersion) || OSGi_versionMax.equals(maxVersion) ? "" : maxVersion.getOriginal());
        this.maxVersionText.setLayoutData((Object)new GridData(768));
        this.maxVersionInclusiveCombo = new Combo(this.topComposite, 8);
        this.maxVersionInclusiveCombo.setItems(inclusiveExclusive);
        this.maxVersionInclusiveCombo.select(this.versionRange.getIncludeMaximum() ? 0 : 1);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VersionRangeEditorDialog.this.okButton.setEnabled(VersionRangeEditorDialog.this.isOKEnabled());
            }
        };
        this.minVersionText.addModifyListener(modifyListener);
        this.minVersionInclusiveCombo.addModifyListener(modifyListener);
        this.maxVersionText.addModifyListener(modifyListener);
        this.maxVersionInclusiveCombo.addModifyListener(modifyListener);
        this.statusLabel = new Label(this.topComposite, 16384);
        GridData layoutData = new GridData(4, 2, true, false);
        layoutData.horizontalSpan = 3;
        this.statusLabel.setLayoutData((Object)layoutData);
        this.advancedComposite = new Composite(this.topComposite, 0);
        this.advancedComposite.setFont(this.topComposite.getFont());
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.advancedComposite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.advancedComposite.setLayout((Layout)layout);
        this.advancedButton = new Button(this.advancedComposite, 8);
        this.advancedButton.setFont(this.advancedComposite.getFont());
        this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        GridData data = new GridData(256);
        int widthHint = 61;
        Point minSize = this.advancedButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        data.horizontalAlignment = 1;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionRangeEditorDialog.this.handleAdvancedButtonSelect();
            }
        });
        return this.topComposite;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (this.advancedFieldsComposite != null) {
            this.advancedFieldsComposite.dispose();
            this.advancedFieldsComposite = null;
            this.topComposite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.advancedFieldsHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.advancedFieldsComposite = this.createAdvancedContent();
            if (this.advancedFieldsHeight == -1) {
                Point groupSize = this.advancedFieldsComposite.computeSize(-1, -1, true);
                this.advancedFieldsHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.advancedFieldsHeight);
            this.topComposite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    protected boolean performAction(int actionID) {
        this.result = null;
        switch (actionID) {
            case 1: {
                return true;
            }
            case 0: {
                try {
                    this.result = this.createVersionRange();
                }
                catch (IllegalArgumentException e) {
                    this.statusMessage(true, e.getMessage());
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private Composite createAdvancedContent() {
        Composite composite = new Composite(this.advancedComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        composite.setFont(this.advancedComposite.getFont());
        Label label = new Label(composite, 0);
        label.setText("Version Type:");
        GridData layoutData = new GridData();
        layoutData.widthHint = this.labelWidth;
        label.setLayoutData((Object)layoutData);
        this.versionTypeCombo = new Combo(composite, 2056);
        this.versionTypeCombo.setLayoutData((Object)new GridData(768));
        this.versionTypeCombo.setItems(VERSION_TYPES);
        this.versionTypeCombo.select(this.currentVersionTypeIdx);
        this.versionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionRangeEditorDialog.this.currentVersionTypeIdx = VersionRangeEditorDialog.this.versionTypeCombo.getSelectionIndex();
                if (VersionRangeEditorDialog.VERSION_TYPE_USER_DEFINED.equals(VersionRangeEditorDialog.this.versionTypeCombo.getText())) {
                    VersionRangeEditorDialog.this.formatStringText.setEnabled(true);
                } else {
                    VersionRangeEditorDialog.this.currentFormat = VERSION_FORMATS[VersionRangeEditorDialog.this.currentVersionTypeIdx];
                    VersionRangeEditorDialog.this.formatStringText.setText(VersionRangeEditorDialog.this.extractFormat(VersionRangeEditorDialog.this.currentFormat.toString()));
                    VersionRangeEditorDialog.this.formatStringText.setEnabled(false);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("Format String:");
        layoutData = new GridData();
        layoutData.widthHint = this.labelWidth;
        label.setLayoutData((Object)layoutData);
        this.formatStringText = new Text(composite, 2048);
        this.formatStringText.setLayoutData((Object)new GridData(768));
        UIUtils.safeSetText(this.formatStringText, this.extractFormat(this.currentFormat.toString()));
        this.formatStringText.setEnabled(VERSION_TYPE_USER_DEFINED.equals(this.versionTypeCombo.getText()));
        this.formatStringText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    try {
                        VersionRangeEditorDialog.this.currentFormat = VersionFormat.compile((String)UIUtils.trimmedValue(VersionRangeEditorDialog.this.formatStringText));
                        VersionRangeEditorDialog.this.formatStringException = null;
                    }
                    catch (VersionFormatException ex) {
                        VersionRangeEditorDialog.this.formatStringException = (Exception)((Object)ex);
                        VersionRangeEditorDialog.this.okButton.setEnabled(VersionRangeEditorDialog.this.isOKEnabled());
                    }
                }
                finally {
                    VersionRangeEditorDialog.this.okButton.setEnabled(VersionRangeEditorDialog.this.isOKEnabled());
                }
            }
        });
        return composite;
    }

    private VersionRange createVersionRange() throws IllegalArgumentException {
        if (this.formatStringException != null) {
            throw new IllegalArgumentException(this.formatStringException.getMessage());
        }
        String minVersionString = UIUtils.trimmedValue(this.minVersionText);
        String maxVersionString = UIUtils.trimmedValue(this.maxVersionText);
        if (minVersionString == null) {
            throw new IllegalArgumentException(String.valueOf(VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_minimumVersionMessage")) + " " + VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_notSpecifiedMessage"));
        }
        Version minVersion = null;
        Version maxVersion = null;
        try {
            minVersion = VERSION_FORMAT_OSGI.equals(this.currentFormat) ? Version.create((String)minVersionString) : this.currentFormat.parse(minVersionString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_minimumVersionMessage")) + " " + e.getMessage());
        }
        if (maxVersionString != null) {
            try {
                maxVersion = VERSION_FORMAT_OSGI.equals(this.currentFormat) ? Version.create((String)maxVersionString) : this.currentFormat.parse(maxVersionString);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(VersionRangeEditorDialog.getString("_UI_VersionRangeEditor_maximumVersionMessage")) + " " + e.getMessage());
            }
        }
        return new VersionRange(minVersion, this.minVersionInclusiveCombo.getSelectionIndex() == 0, maxVersion, this.maxVersionInclusiveCombo.getSelectionIndex() == 0);
    }

    private String extractFormat(String string) {
        return string.substring(7, string.length() - 1);
    }

    private boolean isOKEnabled() {
        try {
            this.createVersionRange();
        }
        catch (IllegalArgumentException e) {
            this.statusMessage(true, e.getMessage());
            return false;
        }
        this.statusMessage(true, "");
        return true;
    }

    private void statusMessage(boolean error, String message) {
        this.statusLabel.setText(message);
        if (error) {
            this.statusLabel.setForeground(JFaceColors.getErrorText((Display)this.statusLabel.getDisplay()));
        } else {
            this.statusLabel.setForeground(null);
        }
        if (UIUtils.trimmedValue(message) != null) {
            this.getShell().getDisplay().beep();
        }
    }
}

