/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.engine.internal.MultiRangeRequirement;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementUtils {
    public static IRequirement[] createAllAvailableVersionsRequirements(List<IInstallableUnit> ius, Filter filter) {
        HashMap<String, HashSet<Version>> versionMap = new HashMap<String, HashSet<Version>>();
        for (IInstallableUnit iu : ius) {
            HashSet<Version> versionSet = (HashSet<Version>)versionMap.get(iu.getId());
            if (versionSet == null) {
                versionSet = new HashSet<Version>();
                versionMap.put(iu.getId(), versionSet);
            }
            versionSet.add(iu.getVersion());
        }
        IRequirement[] requirements = new IRequirement[versionMap.size()];
        int i = 0;
        for (Map.Entry iuEntry : versionMap.entrySet()) {
            String name = (String)iuEntry.getKey();
            String namespace = "org.eclipse.equinox.p2.iu";
            requirements[i++] = new MultiRangeRequirement(name, namespace, (Set)iuEntry.getValue(), null, filter);
        }
        return requirements;
    }

    public static IRequirement createMultiRangeRequirement(MetadataRepository mdr, IRequirement req) {
        HashSet<Version> matchingVersions = new HashSet<Version>();
        String name = null;
        String namespace = "org.eclipse.equinox.p2.iu";
        for (IInstallableUnit iu : mdr.getInstallableUnits()) {
            if (!req.isMatch(iu)) continue;
            matchingVersions.add(iu.getVersion());
            if (name == null) {
                name = iu.getId();
                continue;
            }
            if (name.equals(iu.getId())) continue;
            throw new RuntimeException("Requirement must contain strict name filter");
        }
        return new MultiRangeRequirement(name, namespace, matchingVersions, null, req.getFilter());
    }

    public static String getName(IRequirement req) {
        if (req instanceof IRequiredCapability) {
            return ((IRequiredCapability)req).getName();
        }
        if (req instanceof MultiRangeRequirement) {
            return ((MultiRangeRequirement)req).getName();
        }
        throw new RuntimeException("Unable to extrace IU name from requirement of class " + req.getClass().getName());
    }

    public static IRequirement versionUnion(IRequirement req1, IRequirement req2) {
        if (req1 instanceof MultiRangeRequirement && req2 instanceof MultiRangeRequirement) {
            MultiRangeRequirement vreq1 = (MultiRangeRequirement)req1;
            MultiRangeRequirement vreq2 = (MultiRangeRequirement)req2;
            if (!vreq1.getName().equals(vreq2.getName())) {
                throw new RuntimeException("Unable to create a version union of expressions with different name requests");
            }
            if (!vreq1.getNamespace().equals(vreq2.getNamespace())) {
                throw new RuntimeException("Unable to create a version union of expressions with different namespace requests");
            }
            Filter f1 = vreq1.getFilter();
            Filter f2 = vreq2.getFilter();
            if (f1 != null && !f1.equals((Object)f2) || f1 == null && f2 != null) {
                throw new RuntimeException("Unable to create a version union of expressions with different filters");
            }
            HashSet<Version> allVersions = new HashSet<Version>();
            allVersions.addAll(vreq1.getVersions());
            allVersions.addAll(vreq2.getVersions());
            return new MultiRangeRequirement(vreq1.getName(), vreq1.getNamespace(), allVersions, null, f1);
        }
        throw new RuntimeException("Unable to create a version union of expressions: " + req1 + ", " + req2);
    }
}

