/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import java.util.Collection;
import org.eclipse.b3.aggregator.AggregateType;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Configuration;
import org.eclipse.b3.aggregator.Contact;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.CustomCategory;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MavenMapping;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.StatusProvider;
import org.eclipse.b3.aggregator.impl.DescriptionProviderImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorImpl
extends DescriptionProviderImpl
implements Aggregator {
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected EList<Configuration> configurations;
    protected EList<Contribution> contributions;
    protected Contact buildmaster;
    protected EList<Contact> contacts;
    protected EList<CustomCategory> customCategories;
    protected static final String LABEL_EDEFAULT = null;
    protected String label = LABEL_EDEFAULT;
    protected static final String BUILD_ROOT_EDEFAULT = "${user.home}/build";
    protected String buildRoot = "${user.home}/build";
    protected static final PackedStrategy PACKED_STRATEGY_EDEFAULT = PackedStrategy.COPY;
    protected static final int PACKED_STRATEGY_EFLAG_OFFSET = 0;
    protected static final int PACKED_STRATEGY_EFLAG_DEFAULT = PACKED_STRATEGY_EDEFAULT.ordinal() << 0;
    private static final PackedStrategy[] PACKED_STRATEGY_EFLAG_VALUES = PackedStrategy.values();
    protected static final int PACKED_STRATEGY_EFLAG = 7;
    protected static final boolean SENDMAIL_EDEFAULT = false;
    protected static final int SENDMAIL_EFLAG = 8;
    protected static final AggregateType TYPE_EDEFAULT = AggregateType.STABLE;
    protected static final int TYPE_EFLAG_OFFSET = 4;
    protected static final int TYPE_EFLAG_DEFAULT = TYPE_EDEFAULT.ordinal() << 4;
    private static final AggregateType[] TYPE_EFLAG_VALUES = AggregateType.values();
    protected static final int TYPE_EFLAG = 112;
    protected static final boolean MAVEN_RESULT_EDEFAULT = false;
    protected static final int MAVEN_RESULT_EFLAG = 128;
    protected EList<MetadataRepositoryReference> validationRepositories;
    protected EList<MavenMapping> mavenMappings;

    protected AggregatorImpl() {
    }

    public Contact basicGetBuildmaster() {
        return this.buildmaster;
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == StatusProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == StatusProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getStatus();
            }
            case 2: {
                return this.getErrors();
            }
            case 3: {
                return this.getWarnings();
            }
            case 4: {
                return this.getInfos();
            }
            case 5: {
                return this.getConfigurations();
            }
            case 6: {
                return this.getContributions();
            }
            case 7: {
                if (resolve) {
                    return this.getBuildmaster();
                }
                return this.basicGetBuildmaster();
            }
            case 8: {
                return this.getContacts();
            }
            case 9: {
                return this.getCustomCategories();
            }
            case 10: {
                return this.getLabel();
            }
            case 11: {
                return this.getBuildRoot();
            }
            case 12: {
                return this.getPackedStrategy();
            }
            case 13: {
                return this.isSendmail();
            }
            case 14: {
                return this.getType();
            }
            case 15: {
                return this.isMavenResult();
            }
            case 16: {
                return this.getValidationRepositories();
            }
            case 17: {
                return this.getMavenMappings();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getContacts()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getConfigurations()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getContributions()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getContacts()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getCustomCategories()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getValidationRepositories()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getMavenMappings()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.getStatus() != null;
            }
            case 2: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 3: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 4: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 5: {
                return this.configurations != null && !this.configurations.isEmpty();
            }
            case 6: {
                return this.contributions != null && !this.contributions.isEmpty();
            }
            case 7: {
                return this.buildmaster != null;
            }
            case 8: {
                return this.contacts != null && !this.contacts.isEmpty();
            }
            case 9: {
                return this.customCategories != null && !this.customCategories.isEmpty();
            }
            case 10: {
                return LABEL_EDEFAULT == null ? this.label != null : !LABEL_EDEFAULT.equals(this.label);
            }
            case 11: {
                return BUILD_ROOT_EDEFAULT == null ? this.buildRoot != null : !BUILD_ROOT_EDEFAULT.equals(this.buildRoot);
            }
            case 12: {
                return (this.eFlags & 7) != PACKED_STRATEGY_EFLAG_DEFAULT;
            }
            case 13: {
                return (this.eFlags & 8) != 0;
            }
            case 14: {
                return (this.eFlags & 0x70) != TYPE_EFLAG_DEFAULT;
            }
            case 15: {
                return (this.eFlags & 0x80) != 0;
            }
            case 16: {
                return this.validationRepositories != null && !this.validationRepositories.isEmpty();
            }
            case 17: {
                return this.mavenMappings != null && !this.mavenMappings.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getConfigurations().clear();
                this.getConfigurations().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getContributions().clear();
                this.getContributions().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setBuildmaster((Contact)newValue);
                return;
            }
            case 8: {
                this.getContacts().clear();
                this.getContacts().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getCustomCategories().clear();
                this.getCustomCategories().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setLabel((String)newValue);
                return;
            }
            case 11: {
                this.setBuildRoot((String)newValue);
                return;
            }
            case 12: {
                this.setPackedStrategy((PackedStrategy)((Object)newValue));
                return;
            }
            case 13: {
                this.setSendmail((Boolean)newValue);
                return;
            }
            case 14: {
                this.setType((AggregateType)((Object)newValue));
                return;
            }
            case 15: {
                this.setMavenResult((Boolean)newValue);
                return;
            }
            case 16: {
                this.getValidationRepositories().clear();
                this.getValidationRepositories().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getMavenMappings().clear();
                this.getMavenMappings().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getErrors().clear();
                return;
            }
            case 3: {
                this.getWarnings().clear();
                return;
            }
            case 4: {
                this.getInfos().clear();
                return;
            }
            case 5: {
                this.getConfigurations().clear();
                return;
            }
            case 6: {
                this.getContributions().clear();
                return;
            }
            case 7: {
                this.setBuildmaster(null);
                return;
            }
            case 8: {
                this.getContacts().clear();
                return;
            }
            case 9: {
                this.getCustomCategories().clear();
                return;
            }
            case 10: {
                this.setLabel(LABEL_EDEFAULT);
                return;
            }
            case 11: {
                this.setBuildRoot(BUILD_ROOT_EDEFAULT);
                return;
            }
            case 12: {
                this.setPackedStrategy(PACKED_STRATEGY_EDEFAULT);
                return;
            }
            case 13: {
                this.setSendmail(false);
                return;
            }
            case 14: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 15: {
                this.setMavenResult(false);
                return;
            }
            case 16: {
                this.getValidationRepositories().clear();
                return;
            }
            case 17: {
                this.getMavenMappings().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<MetadataRepositoryReference> getAllMetadataRepositoryReferences(boolean enabledOnly) {
        BasicEList allRepos = new BasicEList();
        for (Contribution contribution : this.getContributions(enabledOnly)) {
            for (MappedRepository mappedRepository : contribution.getRepositories(enabledOnly)) {
                allRepos.add((Object)mappedRepository);
            }
        }
        allRepos.addAll(this.getValidationRepositories(enabledOnly));
        return allRepos;
    }

    @Override
    public Contact getBuildmaster() {
        if (this.buildmaster != null && ((EObject)this.buildmaster).eIsProxy()) {
            InternalEObject oldBuildmaster = (InternalEObject)this.buildmaster;
            this.buildmaster = (Contact)this.eResolveProxy(oldBuildmaster);
            if (this.buildmaster != oldBuildmaster && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldBuildmaster, (Object)this.buildmaster));
            }
        }
        return this.buildmaster;
    }

    @Override
    public String getBuildRoot() {
        return this.buildRoot;
    }

    @Override
    public EList<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new EObjectContainmentEList(Configuration.class, (InternalEObject)this, 5);
        }
        return this.configurations;
    }

    @Override
    public EList<Contact> getContacts() {
        if (this.contacts == null) {
            this.contacts = new EObjectContainmentWithInverseEList(Contact.class, (InternalEObject)this, 8, 2);
        }
        return this.contacts;
    }

    @Override
    public EList<Contribution> getContributions() {
        if (this.contributions == null) {
            this.contributions = new EObjectContainmentEList(Contribution.class, (InternalEObject)this, 6);
        }
        return this.contributions;
    }

    @Override
    public EList<Contribution> getContributions(boolean enabledOnly) {
        EList<Contribution> contribs = this.getContributions();
        if (enabledOnly) {
            BasicEList enabledContribs = null;
            int top = contribs.size();
            int idx = 0;
            while (idx < top) {
                Contribution contrib = (Contribution)contribs.get(idx);
                if (contrib.isEnabled()) {
                    if (enabledContribs != null) {
                        enabledContribs.add((Object)contrib);
                    }
                } else if (enabledContribs == null) {
                    enabledContribs = new BasicEList(contribs.size() - 1);
                    int sdx = 0;
                    while (sdx < idx) {
                        enabledContribs.add((Object)((Contribution)contribs.get(sdx)));
                        ++sdx;
                    }
                }
                ++idx;
            }
            if (enabledContribs != null) {
                contribs = enabledContribs;
            }
        }
        return contribs;
    }

    @Override
    public EList<CustomCategory> getCustomCategories() {
        if (this.customCategories == null) {
            this.customCategories = new EObjectContainmentEList(CustomCategory.class, (InternalEObject)this, 9);
        }
        return this.customCategories;
    }

    @Override
    public EList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.errors;
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 4);
        }
        return this.infos;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public EList<MavenMapping> getMavenMappings() {
        if (this.mavenMappings == null) {
            this.mavenMappings = new EObjectContainmentEList(MavenMapping.class, (InternalEObject)this, 17);
        }
        return this.mavenMappings;
    }

    @Override
    public PackedStrategy getPackedStrategy() {
        return PACKED_STRATEGY_EFLAG_VALUES[(this.eFlags & 7) >>> 0];
    }

    @Override
    public synchronized Status getStatus() {
        StatusCode statusCode;
        for (Contribution contribution : this.getContributions()) {
            statusCode = contribution.getStatus().getCode();
            if (statusCode == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        for (MetadataRepositoryReference repo : this.getValidationRepositories(true)) {
            statusCode = repo.getStatus().getCode();
            if (statusCode == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        for (MavenMapping mapping : this.getMavenMappings()) {
            statusCode = mapping.getStatus().getCode();
            if (statusCode == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public AggregateType getType() {
        return TYPE_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4];
    }

    @Override
    public EList<MetadataRepositoryReference> getValidationRepositories() {
        if (this.validationRepositories == null) {
            this.validationRepositories = new EObjectContainmentEList(MetadataRepositoryReference.class, (InternalEObject)this, 16);
        }
        return this.validationRepositories;
    }

    @Override
    public EList<MetadataRepositoryReference> getValidationRepositories(boolean enabledOnly) {
        EList<MetadataRepositoryReference> validationRepositories = this.getValidationRepositories();
        if (enabledOnly) {
            BasicEList enabledValidationRepositories = null;
            int top = validationRepositories.size();
            int idx = 0;
            while (idx < top) {
                MetadataRepositoryReference validationRepository = (MetadataRepositoryReference)validationRepositories.get(idx);
                if (validationRepository.isEnabled()) {
                    if (enabledValidationRepositories != null) {
                        enabledValidationRepositories.add((Object)validationRepository);
                    }
                } else if (enabledValidationRepositories == null) {
                    enabledValidationRepositories = new BasicEList(validationRepositories.size() - 1);
                    int sdx = 0;
                    while (sdx < idx) {
                        enabledValidationRepositories.add((Object)((MetadataRepositoryReference)validationRepositories.get(sdx)));
                        ++sdx;
                    }
                }
                ++idx;
            }
            if (enabledValidationRepositories != null) {
                validationRepositories = enabledValidationRepositories;
            }
        }
        return validationRepositories;
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 3);
        }
        return this.warnings;
    }

    @Override
    public boolean isMavenResult() {
        return (this.eFlags & 0x80) != 0;
    }

    @Override
    public boolean isSendmail() {
        return (this.eFlags & 8) != 0;
    }

    @Override
    public void setBuildmaster(Contact newBuildmaster) {
        Contact oldBuildmaster = this.buildmaster;
        this.buildmaster = newBuildmaster;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldBuildmaster, (Object)this.buildmaster));
        }
    }

    @Override
    public void setBuildRoot(String newBuildRoot) {
        String oldBuildRoot = this.buildRoot;
        this.buildRoot = newBuildRoot;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldBuildRoot, (Object)this.buildRoot));
        }
    }

    @Override
    public void setLabel(String newLabel) {
        String oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLabel, (Object)this.label));
        }
    }

    @Override
    public void setMavenResult(boolean newMavenResult) {
        boolean oldMavenResult;
        boolean bl = oldMavenResult = (this.eFlags & 0x80) != 0;
        this.eFlags = newMavenResult ? (this.eFlags |= 0x80) : (this.eFlags &= 0xFFFFFF7F);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldMavenResult, newMavenResult));
        }
    }

    @Override
    public void setPackedStrategy(PackedStrategy newPackedStrategy) {
        PackedStrategy oldPackedStrategy = PACKED_STRATEGY_EFLAG_VALUES[(this.eFlags & 7) >>> 0];
        if (newPackedStrategy == null) {
            newPackedStrategy = PACKED_STRATEGY_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFFF8 | newPackedStrategy.ordinal() << 0;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldPackedStrategy, (Object)newPackedStrategy));
        }
    }

    @Override
    public void setSendmail(boolean newSendmail) {
        boolean oldSendmail;
        boolean bl = oldSendmail = (this.eFlags & 8) != 0;
        this.eFlags = newSendmail ? (this.eFlags |= 8) : (this.eFlags &= 0xFFFFFFF7);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldSendmail, newSendmail));
        }
    }

    @Override
    public void setType(AggregateType newType) {
        AggregateType oldType = TYPE_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4];
        if (newType == null) {
            newType = TYPE_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFF8F | newType.ordinal() << 4;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldType, (Object)newType));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", label: ");
        result.append(this.label);
        result.append(", buildRoot: ");
        result.append(this.buildRoot);
        result.append(", packedStrategy: ");
        result.append((Object)PACKED_STRATEGY_EFLAG_VALUES[(this.eFlags & 7) >>> 0]);
        result.append(", sendmail: ");
        result.append((this.eFlags & 8) != 0);
        result.append(", type: ");
        result.append((Object)TYPE_EFLAG_VALUES[(this.eFlags & 0x70) >>> 4]);
        result.append(", mavenResult: ");
        result.append((this.eFlags & 0x80) != 0);
        result.append(')');
        return result.toString();
    }

    @Override
    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.AGGREGATOR;
    }
}

