/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.p2.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.ChildrenProvider;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.InstallableUnitType;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.Property;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.StatusProvider;
import org.eclipse.b3.aggregator.loader.IRepositoryLoader;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.aggregator.p2.impl.MetadataRepositoryImpl;
import org.eclipse.b3.aggregator.p2view.Bundle;
import org.eclipse.b3.aggregator.p2view.Categories;
import org.eclipse.b3.aggregator.p2view.Category;
import org.eclipse.b3.aggregator.p2view.Feature;
import org.eclipse.b3.aggregator.p2view.Fragment;
import org.eclipse.b3.aggregator.p2view.IUPresentation;
import org.eclipse.b3.aggregator.p2view.MetadataRepositoryStructuredView;
import org.eclipse.b3.aggregator.p2view.OtherIU;
import org.eclipse.b3.aggregator.p2view.P2viewFactory;
import org.eclipse.b3.aggregator.p2view.Product;
import org.eclipse.b3.aggregator.util.GeneralUtils;
import org.eclipse.b3.aggregator.util.InstallableUnitUtils;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.aggregator.util.MonitorUtils;
import org.eclipse.b3.aggregator.util.RepositoryTranslationSupport;
import org.eclipse.b3.aggregator.util.ResourceDiagnosticImpl;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.aggregator.util.TimeUtils;
import org.eclipse.b3.aggregator.util.TwoColumnMatrix;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryable;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoryResourceImpl
extends ResourceImpl
implements StatusProvider {
    private static final String NOTIFICATION_KEY = "notification";
    private AsynchronousLoader asynchronousLoader;
    private IRepositoryLoader loader;
    private MetadataRepositoryStructuredView repoView;
    private final TwoColumnMatrix<IUPresentation, Object[]> allIUPresentationMatrix = new TwoColumnMatrix();
    private Exception lastException = null;
    private boolean forceReload = false;
    private RepositoryLoaderJob loadingJob;
    private Diagnostic diagnostic;
    private Status status = AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);

    public static void cancelLoadRepository(String nature, String repositoryLocation, Aggregator aggregator) {
        Resource mdr = MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, repositoryLocation, aggregator);
        if (mdr instanceof MetadataRepositoryResourceImpl) {
            ((MetadataRepositoryResourceImpl)mdr).cancelLoadingJob();
        }
    }

    public static Resource getResourceForNatureAndLocation(String nature, String repositoryLocation, Aggregator aggregator) {
        return MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, repositoryLocation, aggregator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResourceForNatureAndLocation(String nature, String repositoryLocation, Aggregator aggregator, boolean create) {
        if (nature == null || repositoryLocation == null) {
            return null;
        }
        ResourceSet topSet = ((EObject)aggregator).eResource().getResourceSet();
        char c = repositoryLocation.charAt(repositoryLocation.length() - 1);
        if (c == '/' || c == '\\') {
            repositoryLocation = repositoryLocation.substring(0, repositoryLocation.length() - 1);
        }
        URI repoURI = MetadataRepositoryResourceImpl.getResourceUriForNatureAndLocation(nature, repositoryLocation);
        Resource mdr = null;
        ResourceSet resourceSet = topSet;
        synchronized (resourceSet) {
            mdr = topSet.getResource(repoURI, false);
            if (mdr == null && create) {
                mdr = topSet.createResource(repoURI);
            }
        }
        if (mdr != null && !(mdr instanceof MetadataRepositoryResourceImpl)) {
            topSet.getResources().remove((Object)mdr);
            mdr = null;
        }
        return mdr;
    }

    public static URI getResourceUriForNatureAndLocation(String nature, String location) {
        return URI.createGenericURI((String)nature, (String)location, null);
    }

    private static Throwable unwrap(Exception loadException) {
        Throwable rootCauseCandidate = loadException;
        while (rootCauseCandidate.getCause() != null) {
            rootCauseCandidate = rootCauseCandidate.getCause();
        }
        return rootCauseCandidate;
    }

    public MetadataRepositoryResourceImpl(URI uri, IRepositoryLoader loader) {
        super(uri);
        this.loader = loader;
    }

    public synchronized void cancelLoadingJob() {
        if (this.loadingJob != null) {
            this.loadingJob.cancel();
        }
    }

    public Object[] findIUPresentation(Pattern iuIdPattern, VersionRange iuVersionRange, Object[] startAfterPath, boolean forward) {
        List<Object> firstNodePath = null;
        firstNodePath = startAfterPath != null && startAfterPath[0] == this && startAfterPath.length > 1 ? this.getFirstNode(startAfterPath, forward) : this.getFirstNode(null, forward);
        if (firstNodePath == null) {
            return null;
        }
        List<Object> foundIUPath = this.findIU(firstNodePath, iuIdPattern, iuVersionRange, forward);
        return foundIUPath == null ? null : foundIUPath.toArray();
    }

    public TwoColumnMatrix<IUPresentation, Object[]> findIUPresentations(Pattern iuIdPattern, VersionRange iuVersionRange, boolean skipCategoriesSubTree) {
        TwoColumnMatrix<IUPresentation, Object[]> found = new TwoColumnMatrix<IUPresentation, Object[]>();
        int i = 0;
        while (i < this.allIUPresentationMatrix.size()) {
            IInstallableUnit iu;
            IUPresentation iup = this.allIUPresentationMatrix.getKey(i);
            if (iup != null && iuIdPattern.matcher((iu = iup.getInstallableUnit()).getId()).find() && iuVersionRange.isIncluded(iu.getVersion()) && (!skipCategoriesSubTree || !(this.allIUPresentationMatrix.getValue(i)[2] instanceof Categories))) {
                found.add(iup, this.allIUPresentationMatrix.getValue(i));
            }
            ++i;
        }
        return found;
    }

    public TwoColumnMatrix<IUPresentation, Object[]> findIUPresentationsWhichSatisfies(IRequirement rc, boolean skipCategoriesSubTree) {
        TwoColumnMatrix<IUPresentation, Object[]> found = new TwoColumnMatrix<IUPresentation, Object[]>();
        int i = 0;
        while (i < this.allIUPresentationMatrix.size()) {
            IInstallableUnit iu;
            IUPresentation iup = this.allIUPresentationMatrix.getKey(i);
            if (!(iup == null || !(iu = iup.getInstallableUnit()).satisfies(rc) || skipCategoriesSubTree && this.allIUPresentationMatrix.getValue(i)[2] instanceof Categories)) {
                found.add(iup, this.allIUPresentationMatrix.getValue(i));
            }
            ++i;
        }
        return found;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public MetadataRepository getMetadataRepository() {
        if (this.repoView != null) {
            return this.repoView.getMetadataRepository();
        }
        return null;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    /*
     * Exception decompiling
     */
    public void load(Map<?, ?> options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MetadataRepository loadRepository(boolean force) {
        Exception loadException = null;
        Map<String, Notification[]> notificationCollector = Collections.singletonMap(NOTIFICATION_KEY, new Notification[1]);
        try {
            if (this.warnings != null) {
                this.warnings.clear();
            }
            if (this.errors != null) {
                this.errors.clear();
            }
            this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.WAITING));
            if (force) {
                this.unload();
                this.load(notificationCollector);
            } else if (!this.isLoaded()) {
                this.load(notificationCollector);
            }
            if (this.getLastException() != null) {
                throw this.getLastException();
            }
            EList contents = this.getContents();
            if (contents.size() != 1 || ((MetadataRepositoryStructuredView)contents.get(0)).getMetadataRepository().getLocation() == null) {
                throw new Exception(String.format("Unable to load repository %s", this.getURI().toString()));
            }
            MetadataRepository metadataRepository = ((MetadataRepositoryStructuredView)contents.get(0)).getMetadataRepository();
            return metadataRepository;
        }
        catch (Exception e) {
            loadException = e;
            return null;
        }
        finally {
            if (loadException != null) {
                this.getErrors().add((Object)new ResourceDiagnosticImpl(loadException.getMessage(), this.getURI().toString()));
                String message = StringUtils.trimmedOrNull((String)loadException.getMessage());
                if (message == null && MetadataRepositoryResourceImpl.unwrap(loadException) instanceof OperationCanceledException) {
                    message = "Repository loading was cancelled";
                }
                this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, message));
            } else {
                this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK));
            }
            Notification[] notificationRef = notificationCollector.get(NOTIFICATION_KEY);
            Notification notification = notificationRef[0];
            if (notification != null && this.eNotificationRequired()) {
                this.eNotify(notification);
            }
        }
    }

    public void save(Map<?, ?> options) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startAsynchronousLoad(boolean forceReload) {
        MetadataRepository myMDR;
        this.setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.WAITING));
        boolean wasLoaded = false;
        MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = this;
        synchronized (metadataRepositoryResourceImpl) {
            this.eNotify(this.setLoaded(this.isLoaded));
            wasLoaded = this.isLoaded() && !this.isLoading();
        }
        String myLocation = this.getURI().toString();
        boolean mdrFinal = false;
        if (!forceReload && wasLoaded) {
            myMDR = this.loadRepository(false);
            mdrFinal = true;
        } else {
            myMDR = null;
        }
        Aggregator aggregator = this.getAggregator();
        for (MetadataRepositoryReference mdr : aggregator.getAllMetadataRepositoryReferences(true)) {
            String refLocation = String.valueOf(mdr.getNature()) + ":" + mdr.getResolvedLocation();
            if (!myLocation.equals(refLocation)) continue;
            mdr.setMetadataRepository(myMDR);
            if (!mdrFinal) continue;
            mdr.onRepositoryLoad();
        }
        ResourceUtils.cleanUpResources(aggregator, false);
        if (mdrFinal) {
            return;
        }
        AsynchronousLoader lastLoader = this.asynchronousLoader;
        if (lastLoader == null || forceReload && !lastLoader.isForce()) {
            this.asynchronousLoader = new AsynchronousLoader("Loading " + myLocation, lastLoader, forceReload);
            this.asynchronousLoader.setUser(false);
            this.asynchronousLoader.schedule();
        }
    }

    protected void doUnload() {
        super.doUnload();
        this.forceReload = true;
    }

    private List<Object> findIU(List<Object> nodePath, Pattern iuIdPattern, VersionRange iuVersionRange, boolean forward) {
        List<Object> foundInSubTreePath = null;
        foundInSubTreePath = forward ? this.findIUInSubTree(nodePath, iuIdPattern, iuVersionRange) : this.findIUInNode(nodePath, iuIdPattern, iuVersionRange);
        if (foundInSubTreePath != null) {
            return foundInSubTreePath;
        }
        List<Object> nextNodePath = this.getNextNode(nodePath, forward);
        if (nextNodePath != null) {
            return this.findIU(nextNodePath, iuIdPattern, iuVersionRange, forward);
        }
        return null;
    }

    private List<Object> findIUInNode(List<Object> nodePath, Pattern iuIdPattern, VersionRange iuVersionRange) {
        IUPresentation iup;
        IInstallableUnit iu;
        Object node = nodePath.get(nodePath.size() - 1);
        if (node instanceof IUPresentation && iuIdPattern.matcher((iu = (iup = (IUPresentation)node).getInstallableUnit()).getId()).find() && iuVersionRange.isIncluded(iu.getVersion())) {
            return nodePath;
        }
        return null;
    }

    private List<Object> findIUInSubTree(List<Object> nodePath, Pattern iuIdPattern, VersionRange iuVersionRange) {
        List<Object> foundIUPath = this.findIUInNode(nodePath, iuIdPattern, iuVersionRange);
        if (foundIUPath != null) {
            return foundIUPath;
        }
        Object node = nodePath.get(nodePath.size() - 1);
        if (node instanceof ChildrenProvider) {
            for (Object child : ((ChildrenProvider)node).getChildren()) {
                ArrayList<Object> childPath = new ArrayList<Object>(nodePath);
                childPath.add(child);
                foundIUPath = this.findIUInSubTree(childPath, iuIdPattern, iuVersionRange);
                if (foundIUPath == null) continue;
                return foundIUPath;
            }
        }
        return null;
    }

    private Aggregator getAggregator() {
        return (Aggregator)((Resource)this.getResourceSet().getResources().get(0)).getContents().get(0);
    }

    private List<Object> getFirstNode(Object[] startAfterPath, boolean forward) {
        List<Object> firstNodePath = new ArrayList<Object>();
        if (startAfterPath == null) {
            firstNodePath.add(this);
            firstNodePath.add(this.repoView);
            if (!forward) {
                firstNodePath = this.getLastChild(firstNodePath);
            }
        } else {
            firstNodePath = this.getNextNode(Arrays.asList(startAfterPath), forward);
        }
        return firstNodePath;
    }

    private List<Object> getLastChild(List<Object> nodePath) {
        if (!(nodePath.get(nodePath.size() - 1) instanceof ChildrenProvider)) {
            return nodePath;
        }
        EList children = ((ChildrenProvider)nodePath.get(nodePath.size() - 1)).getChildren();
        if (children == null || children.size() == 0) {
            return nodePath;
        }
        Object lastChild = children.get(children.size() - 1);
        ArrayList<Object> childPath = new ArrayList<Object>(nodePath);
        childPath.add(lastChild);
        return this.getLastChild(childPath);
    }

    private List<Object> getNextNode(List<Object> nodePath, boolean forward) {
        EList children;
        int nodeIndex;
        Object parent = nodePath.get(nodePath.size() - 2);
        if (forward) {
            EList children2;
            int nodeIndex2;
            if (parent instanceof ChildrenProvider && (nodeIndex2 = (children2 = ((ChildrenProvider)parent).getChildren()).indexOf(nodePath.get(nodePath.size() - 1))) < children2.size() - 1) {
                ArrayList<Object> nextNodePath = new ArrayList<Object>(nodePath);
                nextNodePath.remove(nodePath.size() - 1);
                nextNodePath.add(children2.get(nodeIndex2 + 1));
                return nextNodePath;
            }
            ArrayList<Object> parentPath = new ArrayList<Object>(nodePath);
            parentPath.remove(nodePath.size() - 1);
            return parentPath.size() > 2 ? this.getNextNode(parentPath, forward) : null;
        }
        if (parent instanceof ChildrenProvider && (nodeIndex = (children = ((ChildrenProvider)parent).getChildren()).indexOf(nodePath.get(nodePath.size() - 1))) > 0) {
            ArrayList<Object> nextNodePath = new ArrayList<Object>(nodePath);
            nextNodePath.remove(nodePath.size() - 1);
            nextNodePath.add(children.get(nodeIndex - 1));
            return this.getLastChild(nextNodePath);
        }
        ArrayList<Object> parentPath = new ArrayList<Object>(nodePath);
        parentPath.remove(nodePath.size() - 1);
        return parentPath.size() > 2 ? parentPath : null;
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    class AsynchronousLoader
    extends Job {
        private Job replaceJob;
        private boolean force;

        public AsynchronousLoader(String name, Job replaceJob, boolean force) {
            super(name);
            this.replaceJob = replaceJob;
            this.force = force;
        }

        public boolean isForce() {
            return this.force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            class MonitorWatchDog
            extends Thread {
                private boolean done;
                private final /* synthetic */ IProgressMonitor val$monitor;

                MonitorWatchDog(IProgressMonitor iProgressMonitor) {
                    this.val$monitor = iProgressMonitor;
                }

                public void run() {
                    while (!this.done) {
                        if (this.val$monitor.isCanceled()) {
                            MetadataRepositoryResourceImpl.this.cancelLoadingJob();
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }

                public void setDone() {
                    this.done = true;
                }
            }
            MonitorWatchDog watchDog = new MonitorWatchDog(monitor);
            try {
                if (this.replaceJob != null) {
                    this.replaceJob.cancel();
                    this.replaceJob.join();
                }
                watchDog.start();
                MetadataRepository mdr = MetadataRepositoryResourceImpl.this.loadRepository(this.force);
                IStatus status = org.eclipse.core.runtime.Status.OK_STATUS;
                if (monitor.isCanceled()) {
                    status = org.eclipse.core.runtime.Status.CANCEL_STATUS;
                    mdr = null;
                }
                MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = MetadataRepositoryResourceImpl.this;
                synchronized (metadataRepositoryResourceImpl) {
                    String myLocation = MetadataRepositoryResourceImpl.this.getURI().toString();
                    Aggregator aggregator = MetadataRepositoryResourceImpl.this.getAggregator();
                    Iterator iterator = aggregator.getAllMetadataRepositoryReferences(true).iterator();
                    while (iterator.hasNext()) {
                        MetadataRepositoryReference repoRef;
                        MetadataRepositoryReference metadataRepositoryReference = repoRef = (MetadataRepositoryReference)iterator.next();
                        synchronized (metadataRepositoryReference) {
                            String refLocation = String.valueOf(repoRef.getNature()) + ":" + repoRef.getResolvedLocation();
                            if (myLocation.equals(refLocation)) {
                                repoRef.setMetadataRepository(mdr);
                                repoRef.onRepositoryLoad();
                            }
                        }
                    }
                }
                iStatus = status;
            }
            catch (InterruptedException e) {
                try {
                    throw new RuntimeException("Repository load was interrupted");
                }
                catch (Throwable throwable) {
                    monitor.done();
                    watchDog.setDone();
                    MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = MetadataRepositoryResourceImpl.this;
                    synchronized (metadataRepositoryResourceImpl) {
                        if (MetadataRepositoryResourceImpl.this.asynchronousLoader == this) {
                            MetadataRepositoryResourceImpl.this.asynchronousLoader = null;
                        }
                    }
                    throw throwable;
                }
            }
            monitor.done();
            watchDog.setDone();
            MetadataRepositoryResourceImpl metadataRepositoryResourceImpl = MetadataRepositoryResourceImpl.this;
            synchronized (metadataRepositoryResourceImpl) {
                if (MetadataRepositoryResourceImpl.this.asynchronousLoader == this) {
                    MetadataRepositoryResourceImpl.this.asynchronousLoader = null;
                }
            }
            return iStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RepositoryLoaderJob
    extends Job {
        private final MetadataRepositoryImpl repository;
        private final java.net.URI location;
        private boolean forceReload;
        private final MetadataRepositoryStructuredView repoView;
        private Exception exception;
        private TwoColumnMatrix<IUPresentation, Object[]> allIUMatrix;

        public RepositoryLoaderJob(MetadataRepositoryImpl repository, java.net.URI location, boolean forceReload, MetadataRepositoryStructuredView repoView, TwoColumnMatrix<IUPresentation, Object[]> allIUMap) {
            super("Repository Loader");
            this.repository = repository;
            this.location = location;
            this.forceReload = forceReload;
            this.repoView = repoView;
            this.allIUMatrix = allIUMap;
            this.setUser(false);
            this.setSystem(false);
            this.setPriority(20);
        }

        public Exception getException() {
            return this.exception;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block13: {
                this.exception = null;
                String msg = String.format("Loading repository %s", this.location);
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)msg, (int)100);
                try {
                    try {
                        MetadataRepositoryResourceImpl.this.loader.open(this.location, this.repository);
                        LogUtils.debug(msg, new Object[0]);
                        long start = TimeUtils.getNow();
                        SubMonitor loaderMonitor = subMon.newChild(100, 2);
                        if (!this.forceReload) {
                            MetadataRepositoryResourceImpl.this.loader.load((IProgressMonitor)loaderMonitor);
                        } else {
                            MetadataRepositoryResourceImpl.this.loader.reload((IProgressMonitor)loaderMonitor);
                        }
                        this.updateAvailableVersions();
                        this.createStructuredView();
                        LogUtils.debug("Repository %s loaded (Took %s)", this.location, TimeUtils.getFormattedDuration(start));
                    }
                    catch (Exception e) {
                        this.exception = e;
                        LogUtils.error(e, "Unable to load repository %s", this.location);
                        try {
                            MetadataRepositoryResourceImpl.this.loader.close();
                        }
                        catch (CoreException e2) {
                            this.exception = e2;
                            LogUtils.error(e2, "Unable to close repository loader for %s", this.location);
                        }
                        MonitorUtils.done((IProgressMonitor)subMon);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        MetadataRepositoryResourceImpl.this.loader.close();
                    }
                    catch (CoreException e) {
                        this.exception = e;
                        LogUtils.error(e, "Unable to close repository loader for %s", this.location);
                    }
                    MonitorUtils.done((IProgressMonitor)subMon);
                    throw throwable;
                }
                try {
                    MetadataRepositoryResourceImpl.this.loader.close();
                }
                catch (CoreException e) {
                    this.exception = e;
                    LogUtils.error(e, "Unable to close repository loader for %s", this.location);
                }
                MonitorUtils.done((IProgressMonitor)subMon);
            }
            return org.eclipse.core.runtime.Status.OK_STATUS;
        }

        private void addIUsToMap(Object container, List<? extends IUPresentation> iuPresentations) {
            Object[] treePath = new Object[]{MetadataRepositoryResourceImpl.this, this.repoView, this.repoView.getInstallableUnitList(), container};
            for (IUPresentation iUPresentation : iuPresentations) {
                this.allIUMatrix.add(iUPresentation, treePath);
            }
        }

        private void createStructuredView() {
            Categories categoryContainer;
            this.repoView.setName(this.repository.getName());
            this.repoView.setInstallableUnitList(P2viewFactory.eINSTANCE.createInstallableUnits());
            HashMap<String, Map<Version, IUPresentation>> iuMap = new HashMap<String, Map<Version, IUPresentation>>();
            ArrayList<Category> categories = new ArrayList<Category>();
            ArrayList<Feature> features = new ArrayList<Feature>();
            ArrayList<Product> products = new ArrayList<Product>();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            ArrayList<Fragment> fragments = new ArrayList<Fragment>();
            ArrayList<OtherIU> miscellaneous = new ArrayList<OtherIU>();
            for (IInstallableUnit iu : this.repository.getInstallableUnits()) {
                String name;
                Object iuPresentation;
                switch (InstallableUnitUtils.getType(iu)) {
                    case CATEGORY: {
                        iuPresentation = P2viewFactory.eINSTANCE.createCategory(iu);
                        if (iuPresentation.isNested()) break;
                        categories.add((Category)iuPresentation);
                        break;
                    }
                    case FEATURE: {
                        iuPresentation = P2viewFactory.eINSTANCE.createFeature(iu);
                        features.add((Feature)iuPresentation);
                        break;
                    }
                    case PRODUCT: {
                        iuPresentation = P2viewFactory.eINSTANCE.createProduct(iu);
                        products.add((Product)iuPresentation);
                        break;
                    }
                    case BUNDLE: {
                        iuPresentation = P2viewFactory.eINSTANCE.createBundle(iu);
                        bundles.add((Bundle)iuPresentation);
                        break;
                    }
                    case FRAGMENT: {
                        iuPresentation = P2viewFactory.eINSTANCE.createFragment(iu);
                        fragments.add((Fragment)iuPresentation);
                        break;
                    }
                    default: {
                        iuPresentation = P2viewFactory.eINSTANCE.createOtherIU(iu);
                        miscellaneous.add((OtherIU)iuPresentation);
                    }
                }
                iuPresentation.setId(iu.getId());
                iuPresentation.setVersion(iu.getVersion());
                Filter filter = iu.getFilter();
                if (filter != null) {
                    iuPresentation.setFilter(filter.toString());
                }
                if ((name = RepositoryTranslationSupport.getInstance((IQueryable<IInstallableUnit>)((MetadataRepository)((InstallableUnitImpl)iu).eContainer())).getIUProperty(iu, "org.eclipse.equinox.p2.name")) == null || name.length() == 0) {
                    iuPresentation.setName(iu.getId());
                } else {
                    iuPresentation.setName(name);
                }
                if (name != null && name.startsWith("%")) {
                    name = null;
                }
                if (InstallableUnitUtils.getType(iu) == InstallableUnitType.CATEGORY || iu.getVersion() == null) {
                    iuPresentation.setLabel(name != null && name.length() > 0 ? name : iu.getId());
                } else {
                    iuPresentation.setLabel(String.valueOf(iu.getId()) + " / " + GeneralUtils.stringifyVersion(iu.getVersion()) + (name != null && name.length() > 0 ? " (" + name + ")" : ""));
                }
                iuPresentation.setDescription(RepositoryTranslationSupport.getInstance((IQueryable<IInstallableUnit>)((MetadataRepository)((InstallableUnitImpl)iu).eContainer())).getIUProperty(iu, "org.eclipse.equinox.p2.description"));
                HashMap<Version, Object> versionMap = (HashMap<Version, Object>)iuMap.get(iu.getId());
                if (versionMap == null) {
                    versionMap = new HashMap<Version, Object>();
                    iuMap.put(iu.getId(), versionMap);
                }
                versionMap.put(iu.getVersion(), iuPresentation);
            }
            if (categories.size() > 0) {
                Collections.sort(categories, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullCategoryContainer().getCategories().addAll(categories);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getCategoryContainer(), categories);
            }
            if (features.size() > 0) {
                Collections.sort(features, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullFeatureContainer().getFeatures().addAll(features);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getFeatureContainer(), features);
            }
            if (products.size() > 0) {
                Collections.sort(products, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullProductContainer().getProducts().addAll(products);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getProductContainer(), products);
            }
            if (bundles.size() > 0) {
                Collections.sort(bundles, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullBundleContainer().getBundles().addAll(bundles);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getBundleContainer(), bundles);
            }
            if (fragments.size() > 0) {
                Collections.sort(fragments, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullFragmentContainer().getFragments().addAll(fragments);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getFragmentContainer(), fragments);
            }
            if (miscellaneous.size() > 0) {
                Collections.sort(miscellaneous, IUPresentation.COMPARATOR);
                this.repoView.getInstallableUnitList().getNotNullMiscellaneousContainer().getOthers().addAll(miscellaneous);
                this.addIUsToMap(this.repoView.getInstallableUnitList().getMiscellaneousContainer(), miscellaneous);
            }
            if ((categoryContainer = this.repoView.getInstallableUnitList().getCategoryContainer()) != null) {
                for (Category category : categoryContainer.getCategories()) {
                    this.exploreCategory(category, iuMap);
                }
            }
            ArrayList<Property> propList = new ArrayList<Property>();
            for (Map.Entry property : this.repository.getPropertyMap()) {
                propList.add(AggregatorFactory.eINSTANCE.createProperty((String)property.getKey(), (String)property.getValue()));
            }
            if (propList.size() > 0) {
                this.repoView.setProperties(P2viewFactory.eINSTANCE.createProperties());
                Collections.sort(propList);
                this.repoView.getProperties().getPropertyList().addAll(propList);
            }
            this.repoView.setLoaded(true);
            MetadataRepositoryResourceImpl.this.getContents().add((Object)((EObject)this.repoView));
            Aggregator aggregator = ResourceUtils.getAggregator(MetadataRepositoryResourceImpl.this.getResourceSet());
            if (aggregator != null) {
                for (MetadataRepositoryReference mdrReference : aggregator.getAllMetadataRepositoryReferences(true)) {
                    String refLocation = mdrReference.getLocation();
                    if (refLocation != null && refLocation.endsWith("/")) {
                        refLocation = refLocation.substring(0, refLocation.length() - 1);
                    }
                    if (!this.repository.getLocation().toString().equals(refLocation)) continue;
                    mdrReference.setLocation(mdrReference.getLocation());
                }
            }
        }

        private void exploreCategory(Category category, Map<String, Map<Version, IUPresentation>> iuMap) {
            ArrayList<Category> categories = new ArrayList<Category>();
            ArrayList<Feature> features = new ArrayList<Feature>();
            ArrayList<Product> products = new ArrayList<Product>();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            ArrayList<Fragment> fragments = new ArrayList<Fragment>();
            int idx = this.allIUMatrix.indexOf(category);
            Object[] oldTreePath = this.allIUMatrix.getValue(idx);
            int len = oldTreePath.length;
            Object[] categoryTreePath = new Object[len + 1];
            System.arraycopy(oldTreePath, 0, categoryTreePath, 0, len);
            categoryTreePath[len] = category;
            for (IRequirement requirement : category.getInstallableUnit().getRequiredCapabilities()) {
                IUPresentation iuPresentation;
                Map<Version, IUPresentation> iuCandidates;
                IRequiredCapability rc;
                VersionRange range;
                if (!(requirement instanceof IRequiredCapability) || !(range = (rc = (IRequiredCapability)requirement).getRange()).getMinimum().equals(range.getMaximum()) || !range.getIncludeMinimum() || !range.getIncludeMaximum() || (iuCandidates = iuMap.get(rc.getName())) == null || (iuPresentation = iuCandidates.get(range.getMinimum())) == null) continue;
                this.allIUMatrix.add(++idx, iuPresentation, categoryTreePath);
                if (iuPresentation instanceof Category) {
                    categories.add((Category)iuPresentation);
                    this.exploreCategory((Category)iuPresentation, iuMap);
                    continue;
                }
                if (iuPresentation instanceof Feature) {
                    features.add((Feature)iuPresentation);
                    continue;
                }
                if (iuPresentation instanceof Product) {
                    products.add((Product)iuPresentation);
                    continue;
                }
                if (iuPresentation instanceof Fragment) {
                    fragments.add((Fragment)iuPresentation);
                    continue;
                }
                if (!(iuPresentation instanceof Bundle)) continue;
                bundles.add((Bundle)iuPresentation);
            }
            if (categories.size() > 0) {
                Collections.sort(categories, IUPresentation.COMPARATOR);
                category.getNotNullCategoryContainer().getCategories().addAll(categories);
            }
            if (features.size() > 0) {
                Collections.sort(features, IUPresentation.COMPARATOR);
                category.getNotNullFeatureContainer().getFeatures().addAll(features);
            }
            if (products.size() > 0) {
                Collections.sort(products, IUPresentation.COMPARATOR);
                category.getNotNullProductContainer().getProducts().addAll(products);
            }
            if (bundles.size() > 0) {
                Collections.sort(bundles, IUPresentation.COMPARATOR);
                category.getNotNullBundleContainer().getBundles().addAll(bundles);
            }
            if (fragments.size() > 0) {
                Collections.sort(fragments, IUPresentation.COMPARATOR);
                category.getNotNullFragmentContainer().getFragments().addAll(fragments);
            }
        }

        private void updateAvailableVersions() {
            Aggregator aggregator = ResourceUtils.getAggregator(MetadataRepositoryResourceImpl.this.getResourceSet());
            if (aggregator != null) {
                for (Contribution contribution : aggregator.getContributions()) {
                    for (MappedRepository mappedRepo : contribution.getRepositories()) {
                        if (!this.repository.getLocation().toString().equals(mappedRepo.getLocation())) continue;
                        for (MappedUnit unit : mappedRepo.getUnits(false)) {
                            unit.resolveAvailableVersions(true);
                        }
                    }
                }
            }
        }
    }

    class UnknownStatusException
    extends Exception {
        UnknownStatusException(String message) {
            super(message);
        }
    }
}

