/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.util;

import java.util.IdentityHashMap;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B3Util
extends Plugin {
    private static Plugin plugin;
    private IdentityHashMap<Object, ServiceReference> services;

    public static B3Util getPlugin() {
        return (B3Util)plugin;
    }

    public static String getPluginID() {
        return plugin.getBundle().getSymbolicName();
    }

    public B3Util() {
        plugin = this;
    }

    public <T> T getService(Class<T> serviceClass) throws CoreException {
        return this.getService(serviceClass, null);
    }

    public <T> T getService(Class<T> serviceClass, String filter) throws CoreException {
        ServiceReference[] serviceRef;
        BundleContext context = B3Util.getPlugin().getBundle().getBundleContext();
        String serviceName = serviceClass.getName();
        try {
            serviceRef = context.getAllServiceReferences(serviceName, filter);
        }
        catch (InvalidSyntaxException e) {
            throw ExceptionUtils.wrap(e);
        }
        if (serviceRef == null || serviceRef.length == 0) {
            throw ExceptionUtils.fromMessage("Missing OSGi Service %s", serviceName);
        }
        T service = serviceClass.cast(context.getService(serviceRef[0]));
        if (this.services == null) {
            this.services = new IdentityHashMap();
        }
        this.services.put(service, serviceRef[0]);
        return service;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public void ungetService(Object service) {
        ServiceReference serviceRef;
        if (this.services != null && service != null && (serviceRef = this.services.remove(service)) != null) {
            B3Util.getPlugin().getBundle().getBundleContext().ungetService(serviceRef);
        }
    }
}

