/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.projectvariables;

import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.variableresolvers.PathVariableResolver;
import org.eclipse.core.runtime.IPath;

public class ParentVariableResolver
extends PathVariableResolver {
    public static final String NAME = "PARENT";

    public Object[] getExtensions(String variable, IResource resource) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<String> it = Arrays.asList(resource.getProject().getPathVariableManager().getPathVariableNames()).iterator();
        while (it.hasNext()) {
            String value = it.next();
            if (value.equals(NAME)) continue;
            result.add("1-" + value);
        }
        return result.toArray();
    }

    public String getValue(String variable, IResource resource) {
        int index = variable.indexOf(45);
        if (index == -1 || index == variable.length() - 1) {
            return null;
        }
        String countRemaining = variable.substring(index + 1);
        if ((index = countRemaining.indexOf(45)) == -1 || index == variable.length() - 1) {
            return null;
        }
        String countString = countRemaining.substring(0, index);
        int count = 0;
        try {
            count = Integer.parseInt(countString);
            if (count < 0) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        String argument = countRemaining.substring(index + 1);
        URI value = resource.getProject().getPathVariableManager().getValue(argument, resource);
        if (value == null) {
            return null;
        }
        value = resource.getProject().getPathVariableManager().resolveURI(value, resource);
        value = URIUtil.toURI((IPath)URIUtil.toPath((URI)value).removeLastSegments(count));
        return value.toASCIIString();
    }
}

