/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactRepositoryFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionLocationArtifactRepositoryFactory
extends ArtifactRepositoryFactory {
    public IArtifactRepository create(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URI repoLocation = ExtensionLocationArtifactRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        boolean failed = false;
        SimpleArtifactRepositoryFactory simpleFactory = new SimpleArtifactRepositoryFactory();
        simpleFactory.setAgent(this.getAgent());
        try {
            simpleFactory.load(repoLocation, 0, null);
            failed = true;
        }
        catch (ProvisionException provisionException) {}
        if (failed) {
            String msg = NLS.bind((String)Messages.repo_already_exists, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1001, msg, null));
        }
        IFileArtifactRepository repo = (IFileArtifactRepository)simpleFactory.create(repoLocation, name, type, properties);
        return new ExtensionLocationArtifactRepository(location, repo, null);
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URI repoLocation = ExtensionLocationArtifactRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        try {
            SimpleArtifactRepositoryFactory simpleFactory = new SimpleArtifactRepositoryFactory();
            simpleFactory.setAgent(this.getAgent());
            IFileArtifactRepository repo = (IFileArtifactRepository)simpleFactory.load(repoLocation, flags, null);
            return new ExtensionLocationArtifactRepository(location, repo, monitor);
        }
        catch (ProvisionException provisionException) {
            return this.create(location, Activator.getRepositoryName(location), "org.eclipse.equinox.p2.extensionlocation.artifactRepository", null);
        }
    }

    public IStatus validate(URI location, IProgressMonitor monitor) {
        try {
            ExtensionLocationArtifactRepository.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

