/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.Configuration;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.engine.MirrorGenerator;
import org.eclipse.b3.aggregator.p2.InstallableUnit;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.aggregator.util.MonitorUtils;
import org.eclipse.b3.aggregator.util.P2Utils;
import org.eclipse.b3.aggregator.util.TimeUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.PublisherUtil;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.p2.engine.Operand;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.query.CompoundQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryVerifier
extends BuilderPhase {
    private static Set<Explanation> getExplanations(RequestStatus requestStatus) {
        return requestStatus.getExplanations();
    }

    private static IInstallableUnit[] getRootIUs(IMetadataRepository site, IProfile profile, String iuName, Version version, IProgressMonitor monitor) throws CoreException {
        InstallableUnitQuery query = new InstallableUnitQuery(iuName, new VersionRange(version, true, version, true));
        IQueryResult roots = site.query((IQuery)CompoundQuery.createCompoundQuery((IQuery)query, (IQuery)new LatestIUVersionQuery(), (boolean)true), monitor);
        if (roots.isEmpty()) {
            roots = profile.query((IQuery)query, (IProgressMonitor)new NullProgressMonitor());
        }
        if (roots.isEmpty()) {
            throw ExceptionUtils.fromMessage((String)"Feature %s not found", (Object[])new Object[]{iuName});
        }
        return (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
    }

    public RepositoryVerifier(Builder builder) {
        super(builder);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Builder builder = this.getBuilder();
        Aggregator aggregator = builder.getAggregator();
        EList configs = aggregator.getConfigurations();
        int configCount = configs.size();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(configCount * 100));
        LogUtils.info((String)"Starting planner verification", (Object[])new Object[0]);
        long start = TimeUtils.getNow();
        String profilePrefix = "b3AggregatorProfile_";
        final Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate();
        IProfileRegistry profileRegistry = P2Utils.getProfileRegistry((IProvisioningAgent)this.getBuilder().getProvisioningAgent());
        IPlanner planner = P2Utils.getPlanner((IProvisioningAgent)this.getBuilder().getProvisioningAgent());
        URI repoLocation = builder.getSourceCompositeURI();
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IMetadataRepositoryManager.class);
        try {
            try {
                Set validationOnlyIUs = null;
                EList validationRepos = aggregator.getValidationRepositories();
                for (MetadataRepositoryReference validationRepo : validationRepos) {
                    if (!validationRepo.isEnabled()) continue;
                    if (validationOnlyIUs == null) {
                        validationOnlyIUs = new HashSet();
                    }
                    validationOnlyIUs.addAll(validationRepo.getMetadataRepository().getInstallableUnits());
                }
                if (validationOnlyIUs == null) {
                    validationOnlyIUs = Collections.emptySet();
                }
                IMetadataRepository sourceRepo = mdrMgr.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(1));
                int configIdx = 0;
                while (configIdx < configCount) {
                    Configuration config = (Configuration)configs.get(configIdx);
                    if (config.isEnabled()) {
                        String configName = config.getName();
                        String info = String.format("Verifying config %s...", configName);
                        LogUtils.info((String)info, (Object[])new Object[0]);
                        subMon.setTaskName(info);
                        HashMap<String, String> props = new HashMap<String, String>();
                        props.put("org.eclipse.equinox.p2.environments", config.getOSGiEnvironmentString());
                        props.put("org.eclipse.update.install.features", "true");
                        IProfile profile = null;
                        String profileId = String.valueOf(profilePrefix) + configName;
                        if (builder.isCleanBuild()) {
                            profile = profileRegistry.getProfile(profileId);
                        }
                        if (profile == null) {
                            profile = profileRegistry.addProfile(profileId, props);
                        }
                        IInstallableUnit[] rootArr = RepositoryVerifier.getRootIUs(sourceRepo, profile, "all.contributed.content.feature.group", Builder.ALL_CONTRIBUTED_CONTENT_VERSION, (IProgressMonitor)subMon.newChild(9));
                        ProfileChangeRequest request = new ProfileChangeRequest(profile);
                        IInstallableUnit[] iInstallableUnitArray = rootArr;
                        int n = rootArr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IInstallableUnit rootIU = iInstallableUnitArray[n2];
                            request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
                            ++n2;
                        }
                        request.addInstallableUnits(rootArr);
                        boolean hadPartials = true;
                        while (hadPartials) {
                            hadPartials = false;
                            ProvisioningContext context = this.createContext(repoLocation);
                            ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan(request, context, (IProgressMonitor)subMon.newChild(80, 6));
                            IStatus status = plan.getStatus();
                            if (status.getSeverity() == 4) {
                                this.sendEmails((RequestStatus)plan.getRequestStatus());
                                LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
                                throw new CoreException(status);
                            }
                            HashSet<IInstallableUnit> suspectedValidationOnlyIUs = null;
                            Operand[] ops = plan.getOperands();
                            Operand[] operandArray = ops;
                            int n3 = ops.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String id;
                                InstallableUnitOperand iuOp;
                                IInstallableUnit iu;
                                Operand op = operandArray[n4];
                                if (op instanceof InstallableUnitOperand && (iu = (iuOp = (InstallableUnitOperand)op).second()) != null && !"all.contributed.content.feature.group".equals(id = iu.getId()) && !"Cannot be installed into the IDE".equals(id)) {
                                    if (validationOnlyIUs.contains(iu)) {
                                        if (suspectedValidationOnlyIUs == null) {
                                            suspectedValidationOnlyIUs = new HashSet<IInstallableUnit>();
                                        }
                                        suspectedValidationOnlyIUs.add(iu);
                                    } else if (!unitsToAggregate.contains(iu)) {
                                        if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                                            iu = this.resolvePartialIU(iu, subMon.newChild(1));
                                            hadPartials = true;
                                        }
                                        unitsToAggregate.add(iu);
                                    }
                                }
                                ++n4;
                            }
                            Iterator itor = sourceRepo.query((IQuery)new AllPatchesQuery(), (IProgressMonitor)subMon.newChild(1)).iterator();
                            while (itor.hasNext()) {
                                Set<IInstallableUnit> units = this.getUnpatchedTransitiveScope((IInstallableUnitPatch)itor.next(), profile, planner, repoLocation, subMon.newChild(1));
                                for (IInstallableUnit iu : units) {
                                    if (validationOnlyIUs.contains(iu)) {
                                        if (suspectedValidationOnlyIUs == null) {
                                            suspectedValidationOnlyIUs = new HashSet();
                                        }
                                        suspectedValidationOnlyIUs.add(iu);
                                        continue;
                                    }
                                    if (unitsToAggregate.contains(iu)) continue;
                                    if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                                        iu = this.resolvePartialIU(iu, subMon.newChild(1));
                                        hadPartials = true;
                                    }
                                    unitsToAggregate.add(iu);
                                }
                            }
                            if (suspectedValidationOnlyIUs != null) {
                                final HashSet<IInstallableUnit> candidates = suspectedValidationOnlyIUs;
                                final boolean[] hadPartialsHolder = new boolean[1];
                                sourceRepo.query((IQuery)new MatchQuery<IInstallableUnit>(){

                                    public boolean isMatch(IInstallableUnit iu) {
                                        if (candidates.contains(iu) && !unitsToAggregate.contains(iu)) {
                                            try {
                                                if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                                                    iu = RepositoryVerifier.this.resolvePartialIU(iu, SubMonitor.convert((IProgressMonitor)new NullProgressMonitor()));
                                                    hadPartialsHolder[0] = true;
                                                }
                                            }
                                            catch (CoreException e) {
                                                throw new RuntimeException(e);
                                            }
                                            unitsToAggregate.add(iu);
                                        }
                                        return false;
                                    }
                                }, (IProgressMonitor)subMon.newChild(1));
                            }
                            if (!hadPartials) continue;
                            LogUtils.info((String)"Partial IU's encountered. Verifying %s again...", (Object[])new Object[]{configName});
                        }
                    }
                    ++configIdx;
                }
            }
            catch (RuntimeException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)subMon);
            P2Utils.ungetProfileRegistry((IProfileRegistry)profileRegistry);
            P2Utils.ungetPlanner((IPlanner)planner);
            P2Utils.ungetRepositoryManager((IRepositoryManager)mdrMgr);
        }
    }

    InstallableUnit resolvePartialIU(IInstallableUnit iu, SubMonitor subMon) throws CoreException {
        IArtifactRepositoryManager arMgr = (IArtifactRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IArtifactRepositoryManager.class);
        String info = "Converting partial IU for " + iu.getId() + "...";
        subMon.beginTask(info, -1);
        LogUtils.debug((String)info, (Object[])new Object[0]);
        IInstallableUnit miu = null;
        MetadataRepository mdr = null;
        block5: for (Contribution contrib : this.getBuilder().getAggregator().getContributions(true)) {
            for (MappedRepository repo : contrib.getRepositories(true)) {
                MetadataRepository candidate = repo.getMetadataRepository();
                for (IInstallableUnit candidateIU : candidate.getInstallableUnits()) {
                    if (!iu.getId().equals(candidateIU.getId()) || !iu.getVersion().equals(candidateIU.getVersion())) continue;
                    mdr = candidate;
                    miu = candidateIU;
                    break block5;
                }
            }
        }
        if (mdr == null) {
            throw ExceptionUtils.fromMessage((String)"Unable to locate mapped repository for IU %s/%s", (Object[])new Object[]{iu.getId(), iu.getVersion()});
        }
        try {
            IFileArtifactRepository tempAr;
            IArtifactRepository sourceAr = arMgr.loadRepository(mdr.getLocation(), (IProgressMonitor)subMon.newChild(10));
            File tempRepositoryFolder = this.getBuilder().getTempRepositoryFolder();
            tempRepositoryFolder.mkdirs();
            URI tempRepositoryURI = Builder.createURI(tempRepositoryFolder);
            try {
                tempAr = (IFileArtifactRepository)arMgr.loadRepository(tempRepositoryURI, (IProgressMonitor)subMon.newChild(1));
            }
            catch (ProvisionException e) {
                tempAr = (IFileArtifactRepository)arMgr.createRepository(tempRepositoryURI, "temporary artifacts artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", Collections.emptyMap());
            }
            Collection artifacts = miu.getArtifacts();
            ArrayList<String> errors = new ArrayList<String>();
            MirrorGenerator.mirror(artifacts, null, sourceAr, (IArtifactRepository)tempAr, PackedStrategy.UNPACK_AS_SIBLING, errors, (IProgressMonitor)subMon.newChild(1));
            int numErrors = errors.size();
            if (numErrors > 0) {
                IStatus[] children = new IStatus[numErrors];
                int idx = 0;
                while (idx < numErrors) {
                    children[idx] = new Status(4, "org.eclipse.b3.aggregator.engine", errors.get(idx));
                    ++idx;
                }
                MultiStatus status = new MultiStatus("org.eclipse.b3.aggregator.engine", 4, children, "Unable to mirror", null);
                throw new CoreException((IStatus)status);
            }
            IArtifactKey key = (IArtifactKey)artifacts.iterator().next();
            File bundleFile = tempAr.getArtifactFile(key);
            if (bundleFile == null) {
                throw ExceptionUtils.fromMessage((String)"Unable to resolve partial IU. Artifact file for %s could not be found", (Object[])new Object[]{key});
            }
            IInstallableUnit preparedIU = PublisherUtil.createBundleIU((IArtifactKey)key, (File)bundleFile);
            if (preparedIU == null) {
                throw ExceptionUtils.fromMessage((String)"Unable to resolve partial IU. Artifact file for %s did not contain a bundle manifest", (Object[])new Object[]{key});
            }
            InstallableUnit newIU = InstallableUnitImpl.importToModel((IInstallableUnit)preparedIU);
            EList allIUs = mdr.getInstallableUnits();
            allIUs.remove(miu);
            allIUs.add(newIU);
            InstallableUnit installableUnit = newIU;
            return installableUnit;
        }
        finally {
            P2Utils.ungetRepositoryManager((IRepositoryManager)arMgr);
        }
    }

    private boolean addLeafmostContributions(Set<Explanation> explanations, Map<String, Contribution> contributions, IRequirement prq) {
        boolean contribsFound = false;
        for (Explanation explanation : explanations) {
            IRequirement crq;
            IInstallableUnit iu;
            if (explanation instanceof Explanation.Singleton) {
                if (contribsFound) continue;
                IInstallableUnit[] iInstallableUnitArray = ((Explanation.Singleton)explanation).ius;
                int n = ((Explanation.Singleton)explanation).ius.length;
                int n2 = 0;
                while (n2 < n) {
                    Contribution contrib;
                    iu = iInstallableUnitArray[n2];
                    if (prq.isMatch(iu) && (contrib = this.findContribution(iu.getId())) != null) {
                        contribsFound = true;
                    }
                    ++n2;
                }
                continue;
            }
            if (explanation instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hrq = (Explanation.HardRequirement)explanation;
                iu = hrq.iu;
                crq = hrq.req;
            } else {
                if (!(explanation instanceof Explanation.MissingIU)) continue;
                Explanation.MissingIU miu = (Explanation.MissingIU)explanation;
                iu = miu.iu;
                crq = miu.req;
            }
            if (!prq.isMatch(iu)) continue;
            if (this.addLeafmostContributions(explanations, contributions, crq)) {
                contribsFound = true;
                continue;
            }
            Contribution contrib = this.findContribution(iu, crq);
            if (contrib == null) continue;
            contributions.put(contrib.getLabel(), contrib);
        }
        return contribsFound;
    }

    private ProvisioningContext createContext(URI site) {
        EList validationRepos = this.getBuilder().getAggregator().getValidationRepositories();
        int top = validationRepos.size();
        ArrayList<URI> sites = new ArrayList<URI>(top + 1);
        sites.add(site);
        URI[] repoLocations = new URI[top + 1];
        int idx = 0;
        while (idx < top) {
            MetadataRepositoryReference mdRef = (MetadataRepositoryReference)validationRepos.get(idx);
            if (mdRef.isEnabled()) {
                sites.add(URI.create(mdRef.getResolvedLocation()));
            }
            ++idx;
        }
        repoLocations = sites.toArray(new URI[sites.size()]);
        ProvisioningContext context = new ProvisioningContext(repoLocations);
        context.setArtifactRepositories(repoLocations);
        return context;
    }

    private Contribution findContribution(IInstallableUnit iu, IRequirement rq) {
        if (!(rq instanceof IRequiredCapability)) {
            return null;
        }
        IRequiredCapability cap = (IRequiredCapability)rq;
        Contribution contrib = null;
        if ("osgi.bundle".equals(cap.getNamespace()) || "org.eclipse.equinox.p2.iu".equals(cap.getNamespace())) {
            contrib = this.findContribution(cap.getName());
        }
        if (contrib == null) {
            contrib = this.findContribution(iu.getId());
        }
        return contrib;
    }

    private Contribution findContribution(String componentId) {
        for (Contribution contrib : this.getBuilder().getAggregator().getContributions()) {
            for (MappedRepository repository : contrib.getRepositories()) {
                for (MappedUnit mu : repository.getUnits(true)) {
                    if (!componentId.equals(mu.getName())) continue;
                    return contrib;
                }
            }
        }
        return null;
    }

    private Set<IInstallableUnit> getUnpatchedTransitiveScope(IInstallableUnitPatch patch, IProfile profile, IPlanner planner, URI repoLocation, SubMonitor monitor) throws CoreException {
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IMetadataRepositoryManager.class);
        try {
            Operand[] ops;
            monitor.beginTask(null, 10);
            IMetadataRepository sourceRepo = mdrMgr.loadRepository(repoLocation, (IProgressMonitor)monitor.newChild(1));
            PatchApplicabilityQuery query = new PatchApplicabilityQuery(patch);
            IQueryResult result = sourceRepo.query((IQuery)query, (IProgressMonitor)monitor.newChild(1));
            IInstallableUnit[] rootArr = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
            ProfileChangeRequest request = new ProfileChangeRequest(profile);
            IInstallableUnit[] iInstallableUnitArray = rootArr;
            int n = rootArr.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit rootIU = iInstallableUnitArray[n2];
                request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
                ++n2;
            }
            request.addInstallableUnits(rootArr);
            ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan(request, new ProvisioningContext(new URI[]{repoLocation}), (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(8);
            HashSet<IInstallableUnit> units = new HashSet<IInstallableUnit>();
            units.add((IInstallableUnit)patch);
            Operand[] operandArray = ops = plan.getOperands();
            int n3 = ops.length;
            int n4 = 0;
            while (n4 < n3) {
                InstallableUnitOperand iuOp;
                IInstallableUnit iu;
                Operand op = operandArray[n4];
                if (op instanceof InstallableUnitOperand && (iu = (iuOp = (InstallableUnitOperand)op).second()) != null) {
                    units.add(iu);
                }
                ++n4;
            }
            HashSet<IInstallableUnit> hashSet = units;
            return hashSet;
        }
        finally {
            P2Utils.ungetRepositoryManager((IRepositoryManager)mdrMgr);
        }
    }

    private void sendEmails(RequestStatus requestStatus) {
        Builder builder = this.getBuilder();
        if (!builder.getAggregator().isSendmail()) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        Set<Explanation> explanations = RepositoryVerifier.getExplanations(requestStatus);
        HashMap<String, Contribution> contribs = new HashMap<String, Contribution>();
        for (Explanation explanation : explanations) {
            Contribution contrib;
            IRequirement crq;
            IInstallableUnit iu;
            errors.add(explanation.toString());
            if (explanation instanceof Explanation.Singleton) {
                IInstallableUnit[] iInstallableUnitArray = ((Explanation.Singleton)explanation).ius;
                int n = ((Explanation.Singleton)explanation).ius.length;
                int n2 = 0;
                while (n2 < n) {
                    iu = iInstallableUnitArray[n2];
                    Contribution contrib2 = this.findContribution(iu.getId());
                    if (contrib2 != null) {
                        contribs.put(contrib2.getLabel(), contrib2);
                    }
                    ++n2;
                }
                continue;
            }
            if (explanation instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hrq = (Explanation.HardRequirement)explanation;
                iu = hrq.iu;
                crq = hrq.req;
            } else {
                if (!(explanation instanceof Explanation.MissingIU)) continue;
                Explanation.MissingIU miu = (Explanation.MissingIU)explanation;
                iu = miu.iu;
                crq = miu.req;
            }
            if (this.addLeafmostContributions(explanations, contribs, crq) || (contrib = this.findContribution(iu, crq)) == null) continue;
            contribs.put(contrib.getLabel(), contrib);
        }
        if (contribs.isEmpty()) {
            builder.sendEmail(null, errors);
        } else {
            for (Contribution contrib : contribs.values()) {
                builder.sendEmail(contrib, errors);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AllPatchesQuery
    extends MatchQuery<IInstallableUnit> {
        AllPatchesQuery() {
        }

        public boolean isMatch(IInstallableUnit candidate) {
            return candidate instanceof IInstallableUnitPatch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PatchApplicabilityQuery
    extends MatchQuery<IInstallableUnit> {
        private final IInstallableUnitPatch patch;

        PatchApplicabilityQuery(IInstallableUnitPatch patch) {
            this.patch = patch;
        }

        public boolean isMatch(IInstallableUnit candidate) {
            IInstallableUnit iu = candidate;
            IRequirement[][] iRequirementArray = this.patch.getApplicabilityScope();
            int n = iRequirementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRequirement[] rqs = iRequirementArray[n2];
                int idx = rqs.length;
                while (--idx >= 0) {
                    if (!iu.satisfies(rqs[idx])) break;
                }
                if (idx < 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

