/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.artifact;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.artifact.UpdateSiteArtifactRepository;
import org.eclipse.equinox.internal.p2.updatesite.metadata.Messages;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactRepositoryFactory;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteArtifactRepositoryFactory
extends ArtifactRepositoryFactory {
    private static final String PROP_ARTIFACT_REFERENCE = "artifact.reference";
    private static final String PROP_FORCE_THREADING = "eclipse.p2.force.threading";
    private static final String PROP_SITE_CHECKSUM = "site.checksum";
    private static final String PROTOCOL_FILE = "file";

    public IArtifactRepository create(URI location, String name, String type, Map<String, String> properties) {
        return null;
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        IArtifactRepository repository = this.loadRepository(location, monitor);
        try {
            this.initializeRepository(repository, location, monitor);
        }
        catch (Exception e) {
            this.resetCache(repository);
            if (e instanceof ProvisionException) {
                throw (ProvisionException)((Object)e);
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.Unexpected_exception, (Object)location.toString()), (Throwable)e));
        }
        return new UpdateSiteArtifactRepository(location, repository);
    }

    private void resetCache(IArtifactRepository repository) {
        repository.setProperty(PROP_SITE_CHECKSUM, "0");
        repository.removeAll();
    }

    public IArtifactRepository loadRepository(URI location, IProgressMonitor monitor) {
        URI localRepositoryURL = UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation(location);
        SimpleArtifactRepositoryFactory factory = new SimpleArtifactRepositoryFactory();
        factory.setAgent(this.getAgent());
        try {
            return factory.load(localRepositoryURL, 0, monitor);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = new StringBuffer("update site: ").append(location).toString();
            return factory.create(localRepositoryURL, repositoryName, null, null);
        }
    }

    public void initializeRepository(IArtifactRepository repository, URI location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite = UpdateSite.load(location, monitor);
        String savedChecksum = (String)repository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        if (!location.getScheme().equals(PROTOCOL_FILE)) {
            repository.setProperty(PROP_FORCE_THREADING, "true");
        }
        repository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
        if (updateSite.getSite().getMirrorsURI() != null) {
            repository.setProperty("p2.mirrorsURL", updateSite.getSite().getMirrorsURI());
        }
        repository.removeAll();
        this.generateArtifactDescriptors(updateSite, repository, monitor);
    }

    private void generateArtifactDescriptors(UpdateSite updateSite, IArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        Feature[] features = updateSite.loadFeatures(monitor);
        HashSet<SimpleArtifactDescriptor> allSiteArtifacts = new HashSet<SimpleArtifactDescriptor>();
        boolean packSupported = updateSite.getSite().isPack200Supported();
        int i = 0;
        while (i < features.length) {
            Feature feature = features[i];
            IArtifactKey featureKey = FeaturesAction.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
            SimpleArtifactDescriptor featureArtifactDescriptor = new SimpleArtifactDescriptor(featureKey);
            URI featureURL = updateSite.getFeatureURI(feature.getId(), feature.getVersion());
            featureArtifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, featureURL.toString());
            allSiteArtifacts.add(featureArtifactDescriptor);
            if (packSupported) {
                featureArtifactDescriptor = new SimpleArtifactDescriptor(featureKey);
                featureURL = updateSite.getFeatureURI(feature.getId(), feature.getVersion());
                featureArtifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, new StringBuffer(String.valueOf(featureURL.toString())).append(".pack.gz").toString());
                IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
                featureArtifactDescriptor.setProcessingSteps(steps);
                featureArtifactDescriptor.setProperty("format", "packed");
                allSiteArtifacts.add(featureArtifactDescriptor);
            }
            FeatureEntry[] featureEntries = feature.getEntries();
            int j = 0;
            while (j < featureEntries.length) {
                FeatureEntry entry = featureEntries[j];
                if (entry.isPlugin() && !entry.isRequires()) {
                    IArtifactKey key = BundlesAction.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                    SimpleArtifactDescriptor artifactDescriptor = new SimpleArtifactDescriptor(key);
                    URI pluginURL = updateSite.getPluginURI(entry);
                    artifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, pluginURL.toString());
                    allSiteArtifacts.add(artifactDescriptor);
                    if (packSupported) {
                        key = BundlesAction.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                        artifactDescriptor = new SimpleArtifactDescriptor(key);
                        pluginURL = updateSite.getPluginURI(entry);
                        artifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, new StringBuffer(String.valueOf(pluginURL.toString())).append(".pack.gz").toString());
                        IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
                        artifactDescriptor.setProcessingSteps(steps);
                        artifactDescriptor.setProperty("format", "packed");
                        allSiteArtifacts.add(artifactDescriptor);
                    }
                }
                ++j;
            }
            ++i;
        }
        IArtifactDescriptor[] descriptors = allSiteArtifacts.toArray(new IArtifactDescriptor[allSiteArtifacts.size()]);
        repository.addDescriptors(descriptors);
    }
}

