/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.p2.provider.P2ItemProviderAdapterFactory;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.aggregator.p2view.provider.P2viewItemProviderAdapterFactory;
import org.eclipse.b3.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.b3.aggregator.presentation.TransformationWizard;
import org.eclipse.b3.aggregator.presentation.VersionRangeEditorDialog;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.provider.AggregatorItemProviderAdapter;
import org.eclipse.b3.aggregator.provider.AggregatorItemProviderAdapterFactory;
import org.eclipse.b3.aggregator.provider.TooltipTextProvider;
import org.eclipse.b3.aggregator.util.AggregatorResource;
import org.eclipse.b3.aggregator.util.AggregatorResourceImpl;
import org.eclipse.b3.aggregator.util.OverlaidImage;
import org.eclipse.b3.aggregator.util.ResourceDiagnosticImpl;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.aggregator.util.StatusProviderAdapterFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.resource.ResourceItemProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    public static final String AGGREGATOR_EDITOR_SCOPE = "org.eclipse.b3.aggregator.presentation.aggregatorEditorScope";
    public static final String AGGREGATOR_PROBLEM_MARKER = "org.eclipse.b3.aggregator.editor.diagnostic";
    public static final String AGGREGATOR_PERSISTENT_PROBLEM_MARKER = "org.eclipse.b3.aggregator.editor.diagnostic.persistent";
    public static final String AGGREGATOR_NONPERSISTENT_PROBLEM_MARKER = "org.eclipse.b3.aggregator.editor.diagnostic.nonpersistent";
    private IContextActivation contextActivation;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper(){

        protected String getMarkerID() {
            return AggregatorEditor.AGGREGATOR_PROBLEM_MARKER;
        }
    };
    protected AggregatorMarkerHelper managedMarkerHelper = new AggregatorMarkerHelper();
    private Pattern findIUIdPattern;
    private VersionRange findIUVersionRange;
    private boolean updateMarkers;
    private boolean updateMarkersIsRunning;
    private Job repositoryLoadingJob;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == AggregatorEditor.this.contentOutlinePage) {
                    AggregatorEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)AggregatorEditor.this);
                    AggregatorEditor.this.setCurrentViewer((Viewer)AggregatorEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == AggregatorEditor.this.propertySheetPage) {
                    AggregatorEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)AggregatorEditor.this);
                    AggregatorEditor.this.handleActivate();
                }
            } else if (p == AggregatorEditor.this) {
                AggregatorEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
            AggregatorEditor.this.handleDeactivate();
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected Map<Resource, Diagnostic> managedResourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){
        private boolean analysisStarted = false;

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                int featureID = notification.getFeatureID(Resource.class);
                if (featureID == 4) {
                    AggregatorEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AggregatorEditor.this.setSelection((ISelection)((this).AggregatorEditor.this.currentViewer == null ? StructuredSelection.EMPTY : (this).AggregatorEditor.this.currentViewer.getSelection()));
                        }
                    });
                }
                switch (featureID) {
                    case 1002: {
                        this.analysisStarted = true;
                        break;
                    }
                    case 1003: {
                        this.analysisStarted = false;
                    }
                    case 0: 
                    case 4: 
                    case 6: 
                    case 7: {
                        Diagnostic diagnostic;
                        Resource resource = (Resource)notification.getNotifier();
                        if (resource instanceof AggregatorResourceImpl && this.analysisStarted) {
                            return;
                        }
                        if (resource instanceof AggregatorResourceImpl) {
                            diagnostic = AggregatorEditor.this.analyzeResourceProblems(resource, null);
                            if (diagnostic.getSeverity() != 0) {
                                AggregatorEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                            } else {
                                AggregatorEditor.this.resourceToDiagnosticMap.remove(resource);
                            }
                            if (AggregatorEditor.this.updateProblemIndication) {
                                AggregatorEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        AggregatorEditor.this.updateProblemIndication();
                                    }
                                });
                            }
                        }
                        if (resource.getResourceSet() == null) {
                            AggregatorEditor.this.managedResourceToDiagnosticMap.remove(resource);
                        } else {
                            diagnostic = AggregatorEditor.this.analyzeResourceProblems(resource, null, true);
                            if (diagnostic.getSeverity() != 0) {
                                AggregatorEditor.this.managedResourceToDiagnosticMap.put(resource, diagnostic);
                            } else {
                                AggregatorEditor.this.managedResourceToDiagnosticMap.remove(resource);
                            }
                        }
                        this.updateMarkers();
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }

        private void updateMarkers() {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    AggregatorEditor aggregatorEditor = AggregatorEditor.this;
                    synchronized (aggregatorEditor) {
                        block8: while (true) {
                            if (!AggregatorEditor.this.updateMarkers) {
                                return;
                            }
                            AggregatorEditor.this.updateMarkers = false;
                            AggregatorEditor.this.updateMarkersIsRunning = true;
                            Resource aggregatorResource = (Resource)(this).AggregatorEditor.this.editingDomain.getResourceSet().getResources().get(0);
                            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(0, "org.eclipse.b3.aggregator.editor", 0, null, null);
                            Iterator<Diagnostic> iterator = (this).AggregatorEditor.this.managedResourceToDiagnosticMap.values().iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    (this).AggregatorEditor.this.managedMarkerHelper.deleteMarkers(aggregatorResource);
                                    if (basicDiagnostic.getSeverity() == 0) continue block8;
                                    try {
                                        (this).AggregatorEditor.this.managedMarkerHelper.createMarkers(aggregatorResource, (Diagnostic)basicDiagnostic);
                                    }
                                    catch (CoreException exception) {
                                        AggregatorEditorPlugin.INSTANCE.log((Object)exception);
                                    }
                                    continue block8;
                                }
                                Diagnostic diagnostic = iterator.next();
                                basicDiagnostic.add(diagnostic);
                            }
                            break;
                        }
                        finally {
                            AggregatorEditor.this.updateMarkersIsRunning = false;
                        }
                    }
                }
            };
            if (AggregatorEditor.this.updateMarkers) {
                return;
            }
            AggregatorEditor.this.updateMarkers = true;
            if (AggregatorEditor.this.updateMarkersIsRunning) {
                return;
            }
            new Thread(runnable).start();
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).AggregatorEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!(this).AggregatorEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    AggregatorEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).AggregatorEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!AggregatorEditor.this.isDirty()) {
                                AggregatorEditor.this.getSite().getPage().closeEditor((IEditorPart)AggregatorEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    AggregatorEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).AggregatorEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (AggregatorEditor.this.getSite().getPage().getActiveEditor() == AggregatorEditor.this) {
                                AggregatorEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                AggregatorEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };

    private static String getString(String key) {
        return AggregatorEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return AggregatorEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public AggregatorEditor() {
        this.initializeEditingDomain();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        return this.analyzeResourceProblems(resource, exception, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception, boolean managedProblems) {
        if (!(resource == null || resource.getErrors().isEmpty() && resource.getWarnings().isEmpty())) {
            Resource resource2 = resource;
            synchronized (resource2) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.b3.aggregator.editor", 0, AggregatorEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
                Diagnostic diagnostic = this.computeDiagnostic(resource, true, true, managedProblems);
                if (diagnostic.getSeverity() == 0 && (diagnostic.getChildren() == null || diagnostic.getChildren().size() == 0)) {
                    return Diagnostic.OK_INSTANCE;
                }
                basicDiagnostic.merge(diagnostic);
                return basicDiagnostic;
            }
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.b3.aggregator.editor", 0, AggregatorEditor.getString("_UI_CreateModelError_message", resource == null ? null : resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createModel() {
        EList contents;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        if (ResourceUtils.isCurrentModel((URI)resourceURI)) {
            try {
                resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
            }
            catch (Exception e) {
                exception = e;
                resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
            }
        } else {
            TransformationWizard tz = new TransformationWizard(resourceURI);
            tz.init(this.getEditorSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)this.getSelection());
            WizardDialog wd = new WizardDialog(this.getEditorSite().getShell(), (IWizard)tz);
            wd.setHelpAvailable(false);
            if (wd.open() == 0) {
                resource = tz.getTargetResource();
                this.editingDomain.getResourceSet().getResources().add((Object)resource);
                IFile modelFile = tz.getModelFile();
                this.setPartName(modelFile.getName());
                this.setInput((IEditorInput)new FileEditorInput(modelFile));
            } else {
                throw new RuntimeException("Depricated resource was not transformed");
            }
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        if (resource != null && (contents = resource.getContents()).size() == 1 && contents.get(0) instanceof Aggregator) {
            Aggregator aggregator = (Aggregator)contents.get(0);
            for (MetadataRepositoryReference mdrReference : aggregator.getAllMetadataRepositoryReferences(false)) {
                mdrReference.setMetadataRepository(null);
                this.adapterFactory.adapt((Object)mdrReference, IItemLabelProvider.class);
            }
            EList repositoriesToLoad = aggregator.getAllMetadataRepositoryReferences(true);
            this.repositoryLoadingJob = new Job("Loading repositories...", (List)repositoriesToLoad){
                private final /* synthetic */ List val$repositoriesToLoad;
                {
                    this.val$repositoriesToLoad = list;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Collections.sort(this.val$repositoriesToLoad, new Comparator<MetadataRepositoryReference>(){

                            @Override
                            public int compare(MetadataRepositoryReference mdr1, MetadataRepositoryReference mdr2) {
                                String location2;
                                String location1;
                                String string = location1 = mdr1 != null ? mdr1.getResolvedLocation() : null;
                                if (location1 == null) {
                                    location1 = "";
                                }
                                String string2 = location2 = mdr2 != null ? mdr2.getResolvedLocation() : null;
                                if (location2 == null) {
                                    location2 = "";
                                }
                                return location1.compareTo(location2);
                            }
                        });
                        for (MetadataRepositoryReference repo : this.val$repositoriesToLoad) {
                            MetadataRepositoryResourceImpl res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation((String)repo.getNature(), (String)repo.getResolvedLocation(), (Aggregator)repo.getAggregator());
                            if (monitor.isCanceled()) break;
                            res.startAsynchronousLoad(false);
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        if (monitor != null) {
                            monitor.done();
                        }
                    }
                }
            };
            this.repositoryLoadingJob.setSystem(true);
        }
    }

    public void createPages() {
        this.createPagesGen();
        this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreePath path = ((TreeSelection)event.getSelection()).getPaths()[0];
                if (AggregatorEditor.this.selectionViewer.getExpandedState((Object)path)) {
                    AggregatorEditor.this.selectionViewer.collapseToLevel((Object)path, 1);
                } else {
                    AggregatorEditor.this.selectionViewer.expandToLevel((Object)path, 1);
                }
            }
        });
        this.selectionViewer.getTree().addMouseMoveListener(new MouseMoveListener(){
            private TreeItem lastTreeItem;

            public void mouseMove(MouseEvent e) {
                IEditingDomainItemProvider provider;
                TreeItem item = AggregatorEditor.this.selectionViewer.getTree().getItem(new Point(e.x, e.y));
                if (item == this.lastTreeItem) {
                    return;
                }
                String toolTipText = null;
                if (item != null && item.getData() != null && (provider = (IEditingDomainItemProvider)AggregatorEditor.this.adapterFactory.getRootAdapterFactory().adapt(item.getData(), IEditingDomainItemProvider.class)) != null && provider instanceof TooltipTextProvider) {
                    toolTipText = ((TooltipTextProvider)provider).getTooltipText(item.getData());
                }
                AggregatorEditor.this.selectionViewer.getTree().setToolTipText(toolTipText);
                this.lastTreeItem = item;
            }
        });
        if (this.repositoryLoadingJob != null) {
            this.repositoryLoadingJob.schedule();
            this.repositoryLoadingJob = null;
        }
    }

    public void createPagesGen() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, AggregatorEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AggregatorEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    AggregatorEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AggregatorEditor.this.updateProblemIndication();
            }
        });
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : AggregatorEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !AggregatorEditor.this.isPersisted(resource) || AggregatorEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            AggregatorEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        AggregatorEditor.this.resourceToDiagnosticMap.put(resource, AggregatorEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            AggregatorEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    public boolean findNextIU(boolean forward) {
        if (this.findIUIdPattern == null || this.findIUVersionRange == null) {
            return false;
        }
        TreeSelection treeSelection = (TreeSelection)this.getSelection();
        Object[] currentSelection = null;
        if (treeSelection != null && treeSelection.getPaths().length > 0) {
            TreePath path = treeSelection.getPaths()[0];
            currentSelection = new Object[path.getSegmentCount()];
            int i = 0;
            while (i < path.getSegmentCount()) {
                currentSelection[i] = path.getSegment(i);
                ++i;
            }
        }
        boolean firstResourceFound = false;
        Object[] foundNode = null;
        Object resources = this.editingDomain.getResourceSet().getResources();
        if (!forward) {
            ArrayList<Resource> reverseResources = new ArrayList<Resource>();
            int i = resources.size();
            while (i > 0) {
                reverseResources.add((Resource)resources.get(i - 1));
                --i;
            }
            resources = reverseResources;
        }
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!(resource instanceof MetadataRepositoryResourceImpl)) continue;
            if (!firstResourceFound) {
                if (currentSelection != null && currentSelection[0] instanceof MetadataRepositoryResourceImpl && resource != currentSelection[0]) continue;
                firstResourceFound = true;
            }
            if ((foundNode = ((MetadataRepositoryResourceImpl)resource).findIUPresentation(this.findIUIdPattern, this.findIUVersionRange, currentSelection, forward)) != null) break;
        }
        if (foundNode != null) {
            this.getViewer().setSelection((ISelection)new TreeSelection(new TreePath(foundNode)), true);
            return true;
        }
        return false;
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    AggregatorEditor.this.contentOutlineViewer = this.getTreeViewer();
                    AggregatorEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    AggregatorEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)AggregatorEditor.this.adapterFactory));
                    AggregatorEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)AggregatorEditor.this.adapterFactory, (Viewer)AggregatorEditor.this.contentOutlineViewer));
                    AggregatorEditor.this.contentOutlineViewer.setInput((Object)AggregatorEditor.this.editingDomain.getResourceSet());
                    AggregatorEditor.this.createContextMenuFor((StructuredViewer)AggregatorEditor.this.contentOutlineViewer);
                    if (!AggregatorEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        AggregatorEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(AggregatorEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    AggregatorEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    AggregatorEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AggregatorEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    AggregatorEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                public void setSelectionToViewer(List<?> selection) {
                    AggregatorEditor.this.setSelectionToViewer(selection);
                    AggregatorEditor.this.setFocus();
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

                protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
                    return new PropertySource(object, itemPropertySource){

                        protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                            return new PropertyDescriptor(this.object, itemPropertyDescriptor){

                                public CellEditor createPropertyEditor(Composite composite) {
                                    if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                                        return null;
                                    }
                                    EStructuralFeature feature = (EStructuralFeature)this.itemPropertyDescriptor.getFeature(this.object);
                                    EClassifier eType = feature.getEType();
                                    if (VersionRange.class.isAssignableFrom(eType.getInstanceClass())) {
                                        final ILabelProvider editLabelProvider = this.getEditLabelProvider();
                                        return new ExtendedDialogCellEditor(composite, editLabelProvider){

                                            protected Object openDialogBox(Control cellEditorWindow) {
                                                VersionRangeEditorDialog dialog = new VersionRangeEditorDialog(cellEditorWindow.getShell(), editLabelProvider, this.doGetValue());
                                                dialog.open();
                                                return dialog.getResult();
                                            }
                                        };
                                    }
                                    return super.createPropertyEditor(composite);
                                }
                            };
                        }
                    };
                }
            });
        }
        return this.propertySheetPage;
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if ((marker.getType().equals("org.eclipse.emf.ecore.diagnostic") || marker.getType().startsWith(AGGREGATOR_PROBLEM_MARKER)) && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                if (uri.fragment() != null) {
                    EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                    if (eObject != null) {
                        this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                    }
                } else {
                    Resource resource = this.findResource(uri);
                    if (resource != null) {
                        this.setSelectionToViewer(Collections.singleton(resource));
                    }
                }
            }
        }
        catch (CoreException exception) {
            AggregatorEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public void registerFindIUArguments(Pattern idPattern, VersionRange versionRange) {
        this.findIUIdPattern = idPattern;
        this.findIUVersionRange = versionRange;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        AggregatorEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (AggregatorEditor.this.currentViewer != null) {
                        AggregatorEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(AggregatorEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(AggregatorEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(AggregatorEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
        AggregatorEditorPlugin.INSTANCE.setActiveEditingDomain(this.editingDomain);
        this.contextActivation = ((IContextService)this.getSite().getWorkbenchWindow().getWorkbench().getAdapter(IContextService.class)).activateContext(AGGREGATOR_EDITOR_SCOPE);
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void handleDeactivate() {
        AggregatorEditorPlugin.INSTANCE.setActiveEditingDomain(null);
        if (this.contextActivation != null) {
            ((IContextService)this.getSite().getWorkbenchWindow().getWorkbench().getAdapter(IContextService.class)).deactivateContext(this.contextActivation);
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)AggregatorEditor.getString("_UI_FileConflict_label"), (String)AggregatorEditor.getString("_WARN_FileConflict"));
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){
            {
                this.supportedTypes.add(IItemFontProvider.class);
            }

            public Adapter createResourceAdapter() {
                return new ResourceItemProviderWithFontSupport((AdapterFactory)this);
            }

            public Adapter createResourceSetAdapter() {
                return new ResourceSetItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        ResourceSet resourceSet = (ResourceSet)object;
                        ArrayList<Resource> filtered = new ArrayList<Resource>();
                        for (Resource resource : resourceSet.getResources()) {
                            if (!(resource instanceof AggregatorResourceImpl) && !(resource instanceof MetadataRepositoryResourceImpl)) continue;
                            filtered.add(resource);
                        }
                        return filtered;
                    }
                };
            }

            class ResourceItemProviderWithFontSupport
            extends ResourceItemProvider
            implements IItemFontProvider,
            TooltipTextProvider {
                ResourceItemProviderWithFontSupport(AdapterFactory adapterFactory) {
                    super(adapterFactory);
                }

                public Object getFont(Object object) {
                    MetadataRepositoryResourceImpl mdr;
                    if (object instanceof MetadataRepositoryResourceImpl && (mdr = (MetadataRepositoryResourceImpl)object).getStatus().getCode() == StatusCode.WAITING) {
                        return IItemFontProvider.ITALIC_FONT;
                    }
                    return null;
                }

                public Object getImage(Object object) {
                    Object baseImage = null;
                    Object overlayImage = null;
                    if (object instanceof AggregatorResourceImpl) {
                        AggregatorResourceImpl res;
                        baseImage = super.getImage(object);
                        if (!Job.getJobManager().isSuspended() && (res = (AggregatorResourceImpl)object).getContents().size() > 0 && ((Aggregator)res.getContents().get(0)).getStatus().getCode() != StatusCode.OK) {
                            overlayImage = AggregatorEditPlugin.INSTANCE.getImage("full/ovr16/Error");
                        }
                    } else if (object instanceof MetadataRepositoryResourceImpl) {
                        baseImage = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/MetadataRepository");
                        MetadataRepositoryResourceImpl mdr = (MetadataRepositoryResourceImpl)object;
                        if (mdr.getLastException() != null) {
                            overlayImage = AggregatorEditPlugin.INSTANCE.getImage("full/ovr16/Error");
                        } else if (mdr.getStatus().getCode() == StatusCode.WAITING) {
                            overlayImage = AggregatorEditPlugin.INSTANCE.getImage("full/ovr16/Loading");
                        }
                    }
                    if (baseImage != null) {
                        if (overlayImage != null) {
                            Object[] images = new Object[2];
                            int[] positions = new int[2];
                            images[0] = baseImage;
                            positions[0] = 0;
                            images[1] = overlayImage;
                            positions[1] = 4;
                            return new OverlaidImage(images, positions);
                        }
                        return baseImage;
                    }
                    return super.getImage(object);
                }

                public String getTooltipText(Object object) {
                    return AggregatorItemProviderAdapter.getTooltipText((Object)object, (ItemProviderAdapter)this);
                }

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    if (notification.getEventType() == 1 && notification.getFeatureID(Resource.class) == 4) {
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                        Aggregator aggregator = (Aggregator)((Resource)((Resource)notification.getNotifier()).getResourceSet().getResources().get(0)).getContents().get(0);
                        for (MetadataRepositoryReference mdr : aggregator.getAllMetadataRepositoryReferences(true)) {
                            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)mdr, false, true));
                        }
                    }
                }
            }
        });
        this.adapterFactory.addAdapterFactory((AdapterFactory)new StatusProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new AggregatorItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new P2ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new P2viewItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                AggregatorEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        AggregatorEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            AggregatorEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).AggregatorEditor.this.propertySheetPage != null && !(this).AggregatorEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).AggregatorEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected boolean isPersisted(Resource resource) {
        return resource instanceof MetadataRepositoryResourceImpl ? false : this.isPersistedGen(resource);
    }

    protected boolean isPersistedGen(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    protected boolean showOutlineView() {
        return false;
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, AggregatorEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.b3.aggregator.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    AggregatorEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        AggregatorEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    private Diagnostic computeDiagnostic(Resource resource, boolean includeWarnings, boolean includeInfos, boolean managedProblems) {
        String messagePrefix;
        Diagnostic diagnostic;
        if (resource.getErrors().isEmpty() && (!includeWarnings || resource.getWarnings().isEmpty())) {
            return Diagnostic.OK_INSTANCE;
        }
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic();
        for (Resource.Diagnostic resourceDiagnostic : resource.getErrors()) {
            if (managedProblems ? !(resourceDiagnostic instanceof ResourceDiagnosticImpl) : resourceDiagnostic instanceof ResourceDiagnosticImpl) continue;
            diagnostic = null;
            if (resourceDiagnostic instanceof Throwable) {
                diagnostic = BasicDiagnostic.toDiagnostic((Throwable)((Throwable)resourceDiagnostic));
            } else {
                messagePrefix = "";
                if (resourceDiagnostic instanceof ResourceDiagnosticImpl) {
                    messagePrefix = this.getLabelPrefix(resourceDiagnostic.getLocation());
                }
                diagnostic = new BasicDiagnostic(4, "org.eclipse.emf.ecore.resource", 0, String.valueOf(messagePrefix) + resourceDiagnostic.getMessage(), new Object[]{resourceDiagnostic});
            }
            basicDiagnostic.add(diagnostic);
        }
        if (includeWarnings) {
            for (Resource.Diagnostic resourceDiagnostic : resource.getWarnings()) {
                if (managedProblems ? !(resourceDiagnostic instanceof ResourceDiagnosticImpl) : resourceDiagnostic instanceof ResourceDiagnosticImpl) continue;
                diagnostic = null;
                if (resourceDiagnostic instanceof Throwable) {
                    diagnostic = BasicDiagnostic.toDiagnostic((Throwable)((Throwable)resourceDiagnostic));
                } else {
                    messagePrefix = "";
                    if (resourceDiagnostic instanceof ResourceDiagnosticImpl) {
                        messagePrefix = this.getLabelPrefix(resourceDiagnostic.getLocation());
                    }
                    diagnostic = new BasicDiagnostic(2, "org.eclipse.emf.ecore.resource", 0, String.valueOf(messagePrefix) + resourceDiagnostic.getMessage(), new Object[]{resourceDiagnostic});
                }
                basicDiagnostic.add(diagnostic);
            }
        }
        if (includeInfos && resource instanceof AggregatorResource) {
            for (Resource.Diagnostic resourceDiagnostic : ((AggregatorResource)resource).getInfos()) {
                if (managedProblems ? !(resourceDiagnostic instanceof ResourceDiagnosticImpl) : resourceDiagnostic instanceof ResourceDiagnosticImpl) continue;
                diagnostic = null;
                if (resourceDiagnostic instanceof Throwable) {
                    diagnostic = BasicDiagnostic.toDiagnostic((Throwable)((Throwable)resourceDiagnostic));
                } else {
                    messagePrefix = "";
                    if (resourceDiagnostic instanceof ResourceDiagnosticImpl) {
                        messagePrefix = this.getLabelPrefix(resourceDiagnostic.getLocation());
                    }
                    diagnostic = new BasicDiagnostic(1, "org.eclipse.emf.ecore.resource", 0, String.valueOf(messagePrefix) + resourceDiagnostic.getMessage(), new Object[]{resourceDiagnostic});
                }
                basicDiagnostic.add(diagnostic);
            }
        }
        return basicDiagnostic;
    }

    private Resource findResource(URI uri) {
        if (uri == null) {
            return null;
        }
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (!uri.equals((Object)resource.getURI())) continue;
            return resource;
        }
        return null;
    }

    private String getLabelPrefix(String location) {
        IItemLabelProvider labelProvider;
        EObject eObject;
        URI uri;
        if (location != null && (uri = URI.createURI((String)location)) != null && uri.fragment() != null && (eObject = this.editingDomain.getResourceSet().getEObject(uri, true)) != null && (labelProvider = (IItemLabelProvider)this.adapterFactory.getRootAdapterFactory().adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
            return String.valueOf(labelProvider.getText((Object)eObject)) + ": ";
        }
        return "";
    }

    private Resource getResourceByURI(URI uri) {
        if (uri == null) {
            return null;
        }
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (!uri.equals((Object)resource.getURI())) continue;
            return resource;
        }
        return null;
    }

    class AggregatorMarkerHelper
    extends EditUIMarkerHelper {
        AggregatorMarkerHelper() {
        }

        public void createMarkers(Resource markerResource, Diagnostic diagnostic) throws CoreException {
            block5: {
                block4: {
                    if (!diagnostic.getChildren().isEmpty()) break block4;
                    if (diagnostic.getSeverity() == 0) break block5;
                    this.createMarkers((IResource)this.getFile(markerResource), diagnostic, null);
                    break block5;
                }
                if (diagnostic.getMessage() == null) {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        this.createMarkers(markerResource, childDiagnostic);
                    }
                } else {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        this.createMarkers((IResource)this.getFile(markerResource), childDiagnostic, diagnostic);
                    }
                }
            }
        }

        protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
            List data = diagnostic.getData();
            StringBuilder relatedURIs = new StringBuilder();
            boolean first = true;
            for (Object object : data) {
                String uriString = null;
                if (object instanceof Resource.Diagnostic) {
                    uriString = ((Resource.Diagnostic)object).getLocation();
                } else {
                    URI uri = null;
                    if (object instanceof EObject) {
                        uri = EcoreUtil.getURI((EObject)((EObject)object));
                    } else if (object instanceof Resource) {
                        uri = ((Resource)object).getURI();
                    }
                    if (uri != null) {
                        uriString = uri.toString();
                    }
                }
                if (uriString == null) continue;
                if (first) {
                    first = false;
                    marker.setAttribute("uri", (Object)uriString);
                    continue;
                }
                if (relatedURIs.length() != 0) {
                    relatedURIs.append(' ');
                }
                relatedURIs.append(URI.encodeFragment((String)uriString, (boolean)false));
            }
            if (relatedURIs.length() > 0) {
                marker.setAttribute("relatedURIs", (Object)relatedURIs.toString());
            }
        }

        protected String getMarkerID() {
            return AggregatorEditor.AGGREGATOR_NONPERSISTENT_PROBLEM_MARKER;
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }
    }
}

