/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.p2.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.b3.aggregator.loader.IRepositoryLoader;
import org.eclipse.b3.aggregator.p2.InstallableUnit;
import org.eclipse.b3.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.aggregator.p2.impl.MetadataRepositoryImpl;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.aggregator.util.P2Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2RepositoryLoader
implements IRepositoryLoader {
    private URI location;
    private MetadataRepositoryImpl repository;
    private IMetadataRepositoryManager mdrMgr;
    private static final IQuery<IInstallableUnit> QUERY_ALL_IUS = QueryUtil.createIUAnyQuery();

    public void close() {
        P2Utils.ungetRepositoryManager(this.mdrMgr);
    }

    public IArtifactRepository getArtifactRepository(IMetadataRepository mdr, IProgressMonitor monitor) throws CoreException {
        IArtifactRepositoryManager arMgr = null;
        try {
            arMgr = P2Utils.getRepositoryManager(IArtifactRepositoryManager.class);
            IArtifactRepository iArtifactRepository = arMgr.loadRepository(mdr.getLocation(), monitor);
            return iArtifactRepository;
        }
        finally {
            P2Utils.ungetRepositoryManager(arMgr);
        }
    }

    public void load(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, false);
    }

    public void open(URI location, IProvisioningAgent agent, MetadataRepositoryImpl mdr) throws CoreException {
        this.location = location;
        this.repository = mdr;
        this.mdrMgr = P2Utils.getRepositoryManager(agent, IMetadataRepositoryManager.class);
    }

    public void reload(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, true);
    }

    private void load(IProgressMonitor monitor, boolean avoidCache) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMetadataRepository repo = null;
        int i = 2;
        while (i >= 0) {
            try {
                if (avoidCache) {
                    if (this.mdrMgr.contains(this.location)) {
                        repo = this.mdrMgr.refreshRepository(this.location, (IProgressMonitor)subMon.newChild(80));
                        break;
                    }
                    try {
                        this.mdrMgr.refreshRepository(this.location, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (ProvisionException provisionException) {
                        // empty catch block
                    }
                    repo = this.mdrMgr.loadRepository(this.location, (IProgressMonitor)subMon.newChild(80));
                    break;
                }
                repo = this.mdrMgr.loadRepository(this.location, (IProgressMonitor)subMon.newChild(80));
                break;
            }
            catch (ProvisionException e) {
                Throwable t = e.getCause();
                if (i > 0 && t instanceof IOException && t.getMessage() != null && t.getMessage().contains("SAX parser service")) {
                    LogUtils.warning("Error loading repository: %s Trying to recover (attempts remaining: %d)", t.getMessage(), i);
                    try {
                        Thread.sleep(1000 * (3 - i));
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    throw e;
                }
                --i;
            }
        }
        this.repository.setProvisioningAgent(repo.getProvisioningAgent());
        this.repository.setName(repo.getName());
        this.repository.setLocation(repo.getLocation());
        this.repository.setDescription(repo.getDescription());
        this.repository.setProvider(repo.getProvider());
        this.repository.setType(repo.getType());
        this.repository.setVersion(repo.getVersion());
        this.repository.getPropertyMap().putAll(repo.getProperties());
        IQueryResult result = repo.query(QUERY_ALL_IUS, (IProgressMonitor)subMon.newChild(20));
        Iterator itor = result.iterator();
        ArrayList<InstallableUnit> ius = new ArrayList<InstallableUnit>();
        while (itor.hasNext()) {
            ius.add(InstallableUnitImpl.importToModel((IInstallableUnit)itor.next()));
        }
        Collections.sort(ius);
        this.repository.getInstallableUnits().addAll(ius);
        this.repository.addRepositoryReferences(this.mdrMgr, repo);
    }
}

