/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.internal.p2.metadata.expression.LambdaExpression;
import org.eclipse.equinox.internal.p2.metadata.expression.Literal;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.internal.p2.ql.expression.Array;
import org.eclipse.equinox.internal.p2.ql.expression.Assignment;
import org.eclipse.equinox.internal.p2.ql.expression.At;
import org.eclipse.equinox.internal.p2.ql.expression.Collect;
import org.eclipse.equinox.internal.p2.ql.expression.Condition;
import org.eclipse.equinox.internal.p2.ql.expression.CurryedLambdaExpression;
import org.eclipse.equinox.internal.p2.ql.expression.First;
import org.eclipse.equinox.internal.p2.ql.expression.Flatten;
import org.eclipse.equinox.internal.p2.ql.expression.IQLConstants;
import org.eclipse.equinox.internal.p2.ql.expression.Intersect;
import org.eclipse.equinox.internal.p2.ql.expression.Latest;
import org.eclipse.equinox.internal.p2.ql.expression.Limit;
import org.eclipse.equinox.internal.p2.ql.expression.Matches;
import org.eclipse.equinox.internal.p2.ql.expression.Pipe;
import org.eclipse.equinox.internal.p2.ql.expression.Select;
import org.eclipse.equinox.internal.p2.ql.expression.Traverse;
import org.eclipse.equinox.internal.p2.ql.expression.Union;
import org.eclipse.equinox.internal.p2.ql.expression.Unique;
import org.eclipse.equinox.internal.p2.ql.expression.WrappedIQuery;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.ql.IQLFactory;
import org.eclipse.equinox.p2.query.IQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLFactory
extends ExpressionFactory
implements IQLFactory,
IQLConstants {
    public static final IQLFactory INSTANCE;
    protected static final Map<String, Constructor<?>> functionMap;

    static {
        Class<?> clazz;
        INSTANCE = new QLFactory();
        Class[] classArray = new Class[1];
        try {
            clazz = Class.forName("[Lorg.eclipse.equinox.internal.p2.metadata.expression.Expression;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        classArray[0] = clazz;
        Class[] args = classArray;
        HashMap f = new HashMap();
        try {
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8;
            try {
                clazz8 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.BooleanFunction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("boolean", clazz8.getConstructor(args));
            try {
                clazz7 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.FilterFunction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("filter", clazz7.getConstructor(args));
            try {
                clazz6 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.VersionFunction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("version", clazz6.getConstructor(args));
            try {
                clazz5 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.RangeFunction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("range", clazz5.getConstructor(args));
            try {
                clazz4 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.ClassFunction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("class", clazz4.getConstructor(args));
            try {
                clazz3 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.SetFunction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("set", clazz3.getConstructor(args));
            try {
                clazz2 = Class.forName("org.eclipse.equinox.internal.p2.ql.expression.WrappedIQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            f.put("iquery", clazz2.getConstructor(args));
            functionMap = Collections.unmodifiableMap(f);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public IExpression at(IExpression target, IExpression key) {
        return new At((Expression)target, (Expression)key);
    }

    public IExpression intersect(IExpression c1, IExpression c2) {
        return new Intersect((Expression)c1, (Expression)c2);
    }

    @Override
    public IExpression array(IExpression[] operands) {
        return new Array(QLFactory.convertArray((IExpression[])operands));
    }

    @Override
    public IExpression assignment(IExpression variable, IExpression expression) {
        return new Assignment((Variable)variable, (Expression)expression);
    }

    @Override
    public IExpression collect(IExpression collection, IExpression lambda) {
        return new Collect((Expression)collection, (LambdaExpression)lambda);
    }

    @Override
    public IExpression condition(IExpression test, IExpression ifTrue, IExpression ifFalse) {
        return new Condition((Expression)test, (Expression)ifTrue, (Expression)ifFalse);
    }

    @Override
    public IExpression first(IExpression collection, IExpression lambda) {
        return new First((Expression)collection, (LambdaExpression)lambda);
    }

    @Override
    public IExpression flatten(IExpression collection) {
        return new Flatten((Expression)collection);
    }

    @Override
    public IExpression function(Object function, IExpression[] args) {
        try {
            return (IExpression)((Constructor)function).newInstance(new Object[]{QLFactory.convertArray((IExpression[])args)});
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, ? extends Object> getFunctionMap() {
        return functionMap;
    }

    @Override
    public IExpression lambda(IExpression variable, IExpression[] assignments, IExpression body) {
        if (assignments.length == 0) {
            return super.lambda(variable, body);
        }
        Assignment[] asgns = new Assignment[assignments.length];
        System.arraycopy(assignments, 0, asgns, 0, assignments.length);
        return new CurryedLambdaExpression((Variable)variable, asgns, (Expression)body);
    }

    public IExpression latest(IExpression collection) {
        return new Latest((Expression)collection);
    }

    public IExpression limit(IExpression collection, int count) {
        return new Limit((Expression)collection, (Expression)Literal.create((Object)new Integer(count)));
    }

    public IExpression limit(IExpression collection, IExpression limit) {
        return new Limit((Expression)collection, (Expression)limit);
    }

    public IExpression matches(IExpression lhs, IExpression rhs) {
        return new Matches((Expression)lhs, (Expression)rhs);
    }

    @Override
    public IExpression memberCall(IExpression target, String name, IExpression[] args) {
        if (args.length == 0) {
            return this.member(target, name);
        }
        Expression[] eargs = QLFactory.convertArray((IExpression[])args);
        StringBuffer bld = new StringBuffer();
        bld.append("Don't know how to do a member call with ");
        bld.append(name);
        bld.append('(');
        Expression.elementsToString((StringBuffer)bld, null, (Expression[])eargs);
        bld.append(')');
        throw new IllegalArgumentException(bld.toString());
    }

    public IExpression union(IExpression c1, IExpression c2) {
        return new Union((Expression)c1, (Expression)c2);
    }

    public IExpression pipe(IExpression[] operands) {
        return Pipe.createPipe(QLFactory.convertArray((IExpression[])operands));
    }

    public IExpression select(IExpression collection, IExpression lambda) {
        return new Select((Expression)collection, (LambdaExpression)lambda);
    }

    @Override
    public IExpression traverse(IExpression collection, IExpression lambda) {
        return new Traverse((Expression)collection, (LambdaExpression)lambda);
    }

    public IExpression toExpression(IQuery<?> query) {
        Literal queryConstant = Literal.create(query);
        return new WrappedIQuery(new Expression[]{queryConstant});
    }

    @Override
    public IExpression unique(IExpression collection, IExpression cache) {
        return new Unique((Expression)collection, (Expression)cache);
    }
}

