/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.aggregator.util.MonitorUtils;
import org.eclipse.b3.aggregator.util.P2Utils;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.aggregator.util.TimeUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCompositeGenerator
extends BuilderPhase {
    public SourceCompositeGenerator(Builder builder) {
        super(builder);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Aggregator buildModel = this.getBuilder().getAggregator();
        EList contribs = buildModel.getContributions(true);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + contribs.size() * 100));
        String info = "Starting generation of composite repository";
        LogUtils.info((String)info, (Object[])new Object[0]);
        subMon.setTaskName("Generating composite from all sources...");
        long start = TimeUtils.getNow();
        String name = String.valueOf(this.getBuilder().getAggregator().getLabel()) + " Composite";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", Boolean.toString(true));
        boolean errorsFound = false;
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IMetadataRepositoryManager.class);
        Builder builder = this.getBuilder();
        URI locationURI = builder.getSourceCompositeURI();
        mdrMgr.removeRepository(locationURI);
        FileUtils.deleteAll((File)new File(builder.getBuildRoot(), "interim"));
        CompositeMetadataRepository compositeMdr = (CompositeMetadataRepository)mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        MonitorUtils.worked((IProgressMonitor)subMon, (int)100);
        for (Contribution contrib : contribs) {
            SubMonitor contribMonitor = subMon.newChild(100);
            EList repos = contrib.getRepositories(true);
            MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 200));
            ArrayList<String> errors = new ArrayList<String>();
            for (MappedRepository repo : repos) {
                try {
                    URI childLocation = new URI(repo.getLocation());
                    LogUtils.info((String)"Adding child meta-data repository %s", (Object[])new Object[]{childLocation});
                    if (!"p2".equals(repo.getNature())) {
                        childLocation = this.createLocalMdr(locationURI, ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo)).getLocation();
                    }
                    compositeMdr.addChild(childLocation);
                }
                catch (Exception e) {
                    String msg = Builder.getExceptionMessages(e);
                    errors.add(msg);
                    LogUtils.error((Throwable)e, (String)msg, (Object[])new Object[0]);
                }
                contribMonitor.worked(200);
            }
            MonitorUtils.done((IProgressMonitor)contribMonitor);
            if (!errors.isEmpty()) {
                this.getBuilder().sendEmail(contrib, errors);
                errorsFound = true;
            }
            this.getBuilder().setSourceComposite(compositeMdr);
        }
        P2Utils.ungetRepositoryManager((IRepositoryManager)mdrMgr);
        MonitorUtils.done((IProgressMonitor)subMon);
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (errorsFound) {
            throw ExceptionUtils.fromMessage((String)"CompositeRepository generation was not successful", (Object[])new Object[0]);
        }
    }

    private IRepository<IInstallableUnit> createLocalMdr(URI locationBase, MetadataRepository mdr) throws URISyntaxException, NoSuchAlgorithmException {
        URI location = new URI(String.valueOf(locationBase.toString()) + "/transformed/" + this.encode(mdr.getLocation().toString()));
        LocalMetadataRepository localMdr = new LocalMetadataRepository(location, mdr.getName(), mdr.getProperties());
        localMdr.setDescription(mdr.getDescription());
        localMdr.setProvider(mdr.getProvider());
        localMdr.addInstallableUnits((IInstallableUnit[])mdr.getInstallableUnits().toArray((Object[])new IInstallableUnit[mdr.getInstallableUnits().size()]));
        localMdr.setProperty("p2.compressed", "true");
        return localMdr;
    }

    private String encode(String location) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        StringBuilder encoded = new StringBuilder();
        byte[] byArray = digest.digest(location.getBytes());
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            encoded.append(String.format("%02x", b));
            ++n2;
        }
        return encoded.toString();
    }
}

