/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionSuffixGenerator {
    public static final String VERSION_QUALIFIER = "qualifier";
    private static final int QUALIFIER_SUFFIX_VERSION = 1;
    private static final String BASE_64_ENCODING = "-0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private final int maxVersionSuffixLength;
    private final int significantDigits;

    private static void appendEncodedCharacter(StringBuffer buffer, int c) {
        while (c > 62) {
            buffer.append('z');
            c -= 63;
        }
        buffer.append(VersionSuffixGenerator.base64Character(c));
    }

    private static char base64Character(int number) {
        return number < 0 || number > 63 ? (char)' ' : BASE_64_ENCODING.charAt(number);
    }

    private static int charValue(char c) {
        int index = BASE_64_ENCODING.indexOf(c);
        return index + 1;
    }

    private static int computeNameSum(String name) {
        int sum = 0;
        int top = name.length();
        int lshift = 20;
        int idx = 0;
        while (idx < top) {
            int c = name.charAt(idx) & 0xFFFF;
            if (c == 46 && lshift > 0) {
                lshift -= 4;
            } else {
                sum += c << lshift;
            }
            ++idx;
        }
        return sum;
    }

    private static int getIntSegment(Version v, int segment) {
        int segCount = v.getSegmentCount();
        if (segCount <= segment) {
            return 0;
        }
        Comparable seg = v.getSegment(segment);
        return seg instanceof Integer ? (Integer)seg : 0;
    }

    private static int getMajor(Version v) {
        return VersionSuffixGenerator.getIntSegment(v, 0);
    }

    private static int getMicro(Version v) {
        return VersionSuffixGenerator.getIntSegment(v, 2);
    }

    private static int getMinor(Version v) {
        return VersionSuffixGenerator.getIntSegment(v, 1);
    }

    private static String getQualifier(Version v) {
        int segCount = v.getSegmentCount();
        if (segCount == 0) {
            return null;
        }
        Comparable seg = v.getSegment(segCount - 1);
        return seg instanceof String ? (String)((Object)seg) : null;
    }

    private static String lengthPrefixBase64(long number) {
        int length = 7;
        int i = 0;
        while (i < 7) {
            if (number < 1L << i * 6 + 3) {
                length = i;
                break;
            }
            ++i;
        }
        StringBuffer result = new StringBuffer(length + 1);
        result.append(VersionSuffixGenerator.base64Character((length << 3) + (int)(number >> 6 * length & 7L)));
        while (--length >= 0) {
            result.append(VersionSuffixGenerator.base64Character((int)(number >> 6 * length & 0x3FL)));
        }
        return result.toString();
    }

    public VersionSuffixGenerator() {
        this(-1, -1);
    }

    public VersionSuffixGenerator(int maxVersionSuffixLenght, int significantDigits) {
        this.maxVersionSuffixLength = maxVersionSuffixLenght < 0 ? 28 : maxVersionSuffixLenght;
        this.significantDigits = significantDigits < 0 ? Integer.MAX_VALUE : significantDigits;
    }

    public String generateSuffix(Collection<? extends IVersionedId> features, Collection<? extends IVersionedId> others) {
        int n;
        String qualifier;
        Version version;
        if (this.maxVersionSuffixLength <= 0 || features.isEmpty() && others.isEmpty()) {
            return null;
        }
        long majorSum = 0L;
        long minorSum = 0L;
        long serviceSum = 0L;
        long nameCharsSum = 0L;
        ++majorSum;
        ArrayList<String> qualifiers = new ArrayList<String>();
        for (IVersionedId iVersionedId : features) {
            version = iVersionedId.getVersion();
            majorSum += (long)VersionSuffixGenerator.getMajor(version);
            minorSum += (long)VersionSuffixGenerator.getMinor(version);
            serviceSum += (long)VersionSuffixGenerator.getMicro(version);
            qualifiers.add(VersionSuffixGenerator.getQualifier(version));
            nameCharsSum = VersionSuffixGenerator.computeNameSum(iVersionedId.getId());
        }
        for (IVersionedId iVersionedId : features) {
            version = iVersionedId.getVersion();
            majorSum += (long)VersionSuffixGenerator.getMajor(version);
            minorSum += (long)VersionSuffixGenerator.getMinor(version);
            serviceSum += (long)VersionSuffixGenerator.getMicro(version);
            qualifier = VersionSuffixGenerator.getQualifier(version);
            if (qualifier != null && qualifier.endsWith(VERSION_QUALIFIER)) {
                int resultingLength = qualifier.length() - VERSION_QUALIFIER.length();
                if (resultingLength > 0) {
                    if (qualifier.charAt(resultingLength - 1) == '.') {
                        --resultingLength;
                    }
                    qualifier = resultingLength > 0 ? qualifier.substring(0, resultingLength) : null;
                } else {
                    qualifier = null;
                }
            }
            qualifiers.add(qualifier);
        }
        boolean bl = false;
        int idx = qualifiers.size();
        while (--idx >= 0) {
            qualifier = (String)qualifiers.get(idx);
            if (qualifier == null) continue;
            if (qualifier.length() > this.significantDigits) {
                qualifier = qualifier.substring(0, this.significantDigits);
                qualifiers.set(idx, qualifier);
            }
            if (qualifier.length() <= n) continue;
            n = qualifier.length();
        }
        StringBuffer result = new StringBuffer();
        result.append(VersionSuffixGenerator.lengthPrefixBase64(majorSum));
        result.append(VersionSuffixGenerator.lengthPrefixBase64(minorSum));
        result.append(VersionSuffixGenerator.lengthPrefixBase64(serviceSum));
        result.append(VersionSuffixGenerator.lengthPrefixBase64(nameCharsSum));
        if (n > 0) {
            int[] qualifierSums = new int[n];
            int top = qualifiers.size();
            idx = 0;
            while (idx < top) {
                String qualifier2 = (String)qualifiers.get(idx);
                if (qualifier2 != null) {
                    int qlen = qualifier2.length();
                    int j = 0;
                    while (j < qlen) {
                        int n2 = j;
                        qualifierSums[n2] = qualifierSums[n2] + VersionSuffixGenerator.charValue(qualifier2.charAt(j));
                        ++j;
                    }
                }
                ++idx;
            }
            int carry = 0;
            int k = n - 1;
            while (k >= 1) {
                int n3 = k;
                qualifierSums[n3] = qualifierSums[n3] + carry;
                carry = qualifierSums[k] / 65;
                qualifierSums[k] = qualifierSums[k] % 65;
                --k;
            }
            qualifierSums[0] = qualifierSums[0] + carry;
            result.append(VersionSuffixGenerator.lengthPrefixBase64(qualifierSums[0]));
            int m = 1;
            while (m < n) {
                VersionSuffixGenerator.appendEncodedCharacter(result, qualifierSums[m]);
                ++m;
            }
        }
        if (result.length() > this.maxVersionSuffixLength) {
            result.setLength(this.maxVersionSuffixLength);
        }
        int len = result.length();
        while (len > 0 && result.charAt(len - 1) == '-') {
            result.setLength(--len);
        }
        return result.toString();
    }
}

