/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.maven;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.b3.aggregator.engine.maven.ResolvedModel;
import org.eclipse.b3.aggregator.engine.maven.pom.DocumentRoot;
import org.eclipse.b3.aggregator.engine.maven.pom.Model;
import org.eclipse.b3.aggregator.engine.maven.pom.Parent;
import org.eclipse.b3.aggregator.engine.maven.pom.PomFactory;
import org.eclipse.b3.aggregator.engine.maven.pom.impl.ModelImpl;
import org.eclipse.b3.aggregator.engine.maven.pom.util.PomResourceFactoryImpl;
import org.eclipse.b3.aggregator.engine.maven.pom.util.PomResourceImpl;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POM {
    private static final int MAX_CACHE_SIZE = 10;
    private static final HashMap<URI, POM> pomCacheLRU = new LinkedHashMap<URI, POM>(10, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<URI, POM> entry) {
            return this.size() >= 10;
        }
    };
    public static final String XML_SCHEMA_LOCATION = "http://maven.apache.org/maven-v4_0_0.xsd";
    public static final String MODEL_VERSION = "4.0.0";
    private String repoRoot;
    private ResolvedModel resolvedModel;
    private DocumentRoot documentRoot;
    private POM parentPOM;
    private String md5;
    private String sha1;
    private Long timestamp;

    public static String expandProperties(String str, Map<String, String> propertyMap) {
        int pos;
        if (str == null) {
            return "";
        }
        int from = 0;
        while ((pos = str.indexOf(36, from)) != -1) {
            int len = str.length();
            if (len > pos && str.charAt(pos + 1) == '{') {
                int end = str.indexOf(125, pos + 2);
                if (end == -1) break;
                String varValue = propertyMap.get(str.substring(pos + 2, end));
                int varLength = 0;
                if (varValue != null) {
                    StringBuilder newStr = new StringBuilder(str.substring(0, pos));
                    newStr.append(varValue);
                    newStr.append(str.substring(end + 1));
                    str = newStr.toString();
                    varLength = varValue.length();
                }
                from = pos + varLength;
                continue;
            }
            from = pos + 1;
        }
        return str;
    }

    public static synchronized POM getPOM(String repoLocation, String groupId, String artifactId, String version) throws CoreException {
        URI uri = URI.createURI((String)(String.valueOf(repoLocation) + "/" + POM.createRelativePath(groupId, artifactId, version)));
        POM pom = pomCacheLRU.get(uri);
        if (pom != null) {
            return pom;
        }
        pom = new POM(uri, repoLocation);
        pomCacheLRU.put(uri, pom);
        return pom;
    }

    private static String createRelativePath(String groupId, String artifactId, String version) {
        groupId = StringUtils.trimmedOrNull((String)groupId);
        artifactId = StringUtils.trimmedOrNull((String)artifactId);
        version = StringUtils.trimmedOrNull((String)version);
        return String.valueOf(groupId != null ? groupId.replace('.', '/') : groupId) + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".pom";
    }

    public POM() {
        this.documentRoot = PomFactory.eINSTANCE.createDocumentRoot();
        this.documentRoot.getXSISchemaLocation().put((Object)"http://maven.apache.org/POM/4.0.0", (Object)XML_SCHEMA_LOCATION);
        this.documentRoot.setProject(PomFactory.eINSTANCE.createModel());
    }

    private POM(URI uri, String repoRoot) throws CoreException {
        Resource resource = this.getResourceSet().getResource(uri, true);
        EList content = resource.getContents();
        if (content.size() != 1) {
            throw ExceptionUtils.fromMessage((String)"ECore Resource did not contain one resource. It had %d", (Object[])new Object[]{content.size()});
        }
        if (resource instanceof PomResourceImpl) {
            PomResourceImpl pomResource = (PomResourceImpl)resource;
            this.md5 = pomResource.getMd5();
            this.sha1 = pomResource.getSha1();
            this.timestamp = pomResource.getTimestamp();
        }
        this.documentRoot = (DocumentRoot)content.get(0);
        Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)this.documentRoot);
        int modifiedSeverity = 0;
        if (diag.getSeverity() >= 4) {
            for (Diagnostic childDiag : diag.getChildren()) {
                String childMessage = childDiag.getMessage();
                if (childMessage.matches("The feature 'mixed' of 'org.eclipse.b3.aggregator.engine.maven.pom.impl.DocumentRootImpl@[0-9a-f]+\\{[^\\}]+.pom#/\\}' with 2 element values must have exactly 1 element value")) continue;
                LogUtils.error((String)childDiag.getMessage(), (Object[])new Object[0]);
                if (modifiedSeverity >= childDiag.getSeverity()) continue;
                modifiedSeverity = childDiag.getSeverity();
            }
        }
        if (modifiedSeverity >= 4) {
            throw ExceptionUtils.fromMessage((String)"Maven POM model validation failed: %s", (Object[])new Object[]{diag.getMessage()});
        }
        this.repoRoot = repoRoot;
        ResolvedModel resolvedModel = this.getResolvedProject();
        String relativePath = "/" + POM.createRelativePath(resolvedModel.getGroupId(), resolvedModel.getArtifactId(), resolvedModel.getVersion());
        String uriStr = uri.toString();
        if (!uriStr.endsWith(relativePath)) {
            throw ExceptionUtils.fromMessage((String)"Invalid path, %s should end with %s", (Object[])new Object[]{uriStr, relativePath});
        }
    }

    public String getArtifactId() throws CoreException {
        return this.getResolvedProject().getArtifactId();
    }

    public String getGroupId() throws CoreException {
        return this.getResolvedProject().getGroupId();
    }

    public String getMd5() {
        return this.md5;
    }

    public POM getParentPOM() throws CoreException {
        if (this.parentPOM != null) {
            return this.parentPOM;
        }
        Model model = this.getProject();
        Parent parent = model.getParent();
        if (parent != null) {
            this.parentPOM = POM.getPOM(this.repoRoot, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            return this.parentPOM;
        }
        return null;
    }

    public Model getProject() throws CoreException {
        if (this.documentRoot == null || this.documentRoot.getProject() == null) {
            throw ExceptionUtils.fromMessage((String)"No project available", (Object[])new Object[0]);
        }
        return this.documentRoot.getProject();
    }

    public Map<String, String> getProperties() throws CoreException {
        return this.getResolvedProject().getPropertyMap();
    }

    public ResolvedModel getResolvedProject() throws CoreException {
        if (this.resolvedModel == null) {
            this.resolvedModel = new ResolvedModel(this.repoRoot, (ModelImpl)this.getProject());
        }
        return this.resolvedModel;
    }

    public String getSha1() {
        return this.sha1;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getVersion() throws CoreException {
        return this.getResolvedProject().getVersion();
    }

    public void save() throws CoreException {
        this.save((Resource)null);
    }

    public void save(Resource resource) throws CoreException {
        Resource targetResource = resource;
        if (targetResource == null) {
            targetResource = this.documentRoot.eResource();
        }
        if (targetResource == null) {
            throw ExceptionUtils.fromMessage((String)"No resource to store Maven POM", (Object[])new Object[0]);
        }
        if (resource != null && !targetResource.equals(this.documentRoot.eResource())) {
            targetResource.getContents().add((Object)this.documentRoot);
        }
        try {
            targetResource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            throw ExceptionUtils.fromMessage((Throwable)e, (String)"Unable to save Maven POM", (Object[])new Object[0]);
        }
    }

    public void save(URI uri) throws CoreException {
        this.save(this.getResourceSet().createResource(uri));
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistryImpl(){

            public Resource.Factory getFactory(URI uri) {
                return new PomResourceFactoryImpl();
            }

            public Resource.Factory getFactory(URI uri, String contentType) {
                return this.getFactory(uri);
            }
        });
        return resourceSet;
    }
}

