/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.b3.aggregator.util.AggregatorResourceImpl;
import org.eclipse.b3.aggregator.util.ITransformer;
import org.eclipse.b3.aggregator.util.ITransformerContextContributor;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationWizard
extends Wizard
implements INewWizard {
    private static String LEGACY_TRANSFORMATION_ID = "org.eclipse.b3.aggregator.legacy_transformation";
    private static String LEGACY_TRANSFORMATION_ATTR_CLASS = "class";
    private static String LEGACY_TRANSFORMATION_ATTR_SOURCE_NS = "sourceNS";
    private static String LEGACY_TRANSFORMATION_ATTR_TARGET_NS = "targetNS";
    private static String LEGACY_TRANSFORMATION_ATTR_SOURCE_TOP_ELEMENT = "sourceTopElement";
    private static String LEGACY_TRANSFORMATION_ATTR_SOURCE_NS_ATTRIBUTE = "sourceNSAttribute";
    private static String LEGACY_TRANSFORMATION_ATTR_SOURCE_ECORE = "sourceEcoreUri";
    private static String LEGACY_TRANSFORMATION_ATTR_TARGET_ECORE = "targetEcoreUri";
    private static String LEGACY_TRANSFORMATION_ATTR_CONTEXT_CONTRIBUTOR = "contextContributor";
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(AggregatorEditorPlugin.INSTANCE.getString("_UI_AggregatorEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = AggregatorEditorPlugin.INSTANCE.getString("_UI_AggregatorEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected AggregatorPackage aggregatorPackage = AggregatorPackage.eINSTANCE;
    protected AggregatorFactory aggregatorFactory = this.aggregatorPackage.getAggregatorFactory();
    protected InfoPage infoPage;
    protected List<ITransformerContextContributor> contextContributors = new ArrayList<ITransformerContextContributor>();
    protected NewFileCreationPage newFileCreationPage;
    protected URI srcResourceURI;
    protected boolean srcNamespaceFound;
    protected List<IConfigurationElement> transformationSequence;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;
    private IFile modelFile;
    private Resource finalResource;
    private Map<String, Object> context = new HashMap<String, Object>();

    public TransformationWizard(URI srcResourceURI) {
        this.srcResourceURI = srcResourceURI;
        HashSet<String> nsPaths = new HashSet<String>();
        IConfigurationElement[] transformations = Platform.getExtensionRegistry().getConfigurationElementsFor(LEGACY_TRANSFORMATION_ID);
        String xmlns = null;
        String topElement = null;
        String nsAttribute = null;
        int i = 0;
        while (xmlns == null && i < transformations.length) {
            topElement = transformations[i].getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_TOP_ELEMENT);
            nsAttribute = transformations[i].getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_NS_ATTRIBUTE);
            ++i;
            if (StringUtils.trimmedOrNull((String)topElement) == null || StringUtils.trimmedOrNull((String)nsAttribute) == null || nsPaths.contains(String.valueOf(topElement) + "/" + nsAttribute)) continue;
            xmlns = ResourceUtils.getResourceXMLNS((URI)srcResourceURI, (String)topElement, (String)nsAttribute);
            nsPaths.add(String.valueOf(topElement) + "/" + nsAttribute);
        }
        boolean bl = this.srcNamespaceFound = xmlns != null;
        if (this.srcNamespaceFound) {
            String requiredSourceNS = xmlns;
            String requiredTargetNS = "http://www.eclipse.org/b3/2010/aggregator/1.0.0";
            this.transformationSequence = this.resolveTransformationSequence(transformations, requiredSourceNS, requiredTargetNS, new ArrayList<IConfigurationElement>());
            for (IConfigurationElement transformation : this.transformationSequence) {
                ITransformerContextContributor contextContributor = null;
                try {
                    if (transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_CONTEXT_CONTRIBUTOR) != null) {
                        contextContributor = (ITransformerContextContributor)transformation.createExecutableExtension(LEGACY_TRANSFORMATION_ATTR_CONTEXT_CONTRIBUTOR);
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException("Depricated resource was not transformed - transformation wizard cannot be started", e);
                }
                if (contextContributor == null) continue;
                this.contextContributors.add(contextContributor);
            }
        }
    }

    public void addPages() {
        this.infoPage = new InfoPage("InfoPage", this.srcNamespaceFound, this.transformationSequence != null && !this.transformationSequence.isEmpty());
        this.infoPage.setTitle("Depricated Resource");
        this.infoPage.setDescription("Selected resource needs to be transformed to the up-to-date structure");
        this.addPage((IWizardPage)this.infoPage);
        for (ITransformerContextContributor contextContributor : this.contextContributors) {
            if (!(contextContributor instanceof IWizardPage)) continue;
            this.addPage((IWizardPage)contextContributor);
        }
        this.newFileCreationPage = new NewFileCreationPage("FileCreationPage", this.selection);
        this.newFileCreationPage.setTitle("Target Location");
        this.newFileCreationPage.setDescription("Provide location for the transformed model");
        this.newFileCreationPage.setFileName(String.valueOf(this.srcResourceURI.lastSegment().replaceAll("\\.[^.]*$", "")) + "." + FILE_EXTENSIONS.get(0));
        this.newFileCreationPage.setContainerFullPath(Path.fromOSString((String)this.srcResourceURI.toPlatformString(true)).makeAbsolute().removeLastSegments(1));
        this.addPage((IWizardPage)this.newFileCreationPage);
    }

    public IFile getModelFile() {
        return this.modelFile;
    }

    public Resource getTargetResource() {
        return this.finalResource;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Aggregator Model Transformation");
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(AggregatorEditorPlugin.INSTANCE.getImage("full/wizban/NewAggregator.png")));
    }

    public boolean performFinish() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("Transformation is in progress", -1);
                        for (ITransformerContextContributor contextContributor : TransformationWizard.this.contextContributors) {
                            contextContributor.contributeToContext(TransformationWizard.this.context);
                        }
                        TransformationWizard.this.finalResource = TransformationWizard.this.transformResource(TransformationWizard.this.transformationSequence, TransformationWizard.this.srcResourceURI);
                        TransformationWizard.this.finalResource.setURI(URI.createPlatformResourceURI((String)TransformationWizard.this.modelFile.getFullPath().toString(), (boolean)true));
                        TransformationWizard.this.finalResource.save(null);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.setNeedsProgressMonitor(true);
        this.modelFile = this.newFileCreationPage.getModelFile();
        try {
            this.getContainer().run(true, false, operation);
        }
        catch (InvocationTargetException e) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("Transformation error: " + e.getCause().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private List<IConfigurationElement> resolveTransformationSequence(IConfigurationElement[] transformations, String requiredSourceNS, String requiredTargetNS, List<IConfigurationElement> transformerSequence) {
        IConfigurationElement[] iConfigurationElementArray = transformations;
        int n = transformations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement transformation = iConfigurationElementArray[n2];
            String srcNS = transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_NS);
            String trgtNS = transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_TARGET_NS);
            if (requiredSourceNS.equals(srcNS)) {
                ArrayList<IConfigurationElement> newTransformerSequence = new ArrayList<IConfigurationElement>();
                newTransformerSequence.addAll(transformerSequence);
                newTransformerSequence.add(transformation);
                if (requiredTargetNS.equals(trgtNS)) {
                    return newTransformerSequence;
                }
                List<IConfigurationElement> result = this.resolveTransformationSequence(transformations, trgtNS, requiredTargetNS, newTransformerSequence);
                if (result != null) {
                    return result;
                }
            }
            ++n2;
        }
        return null;
    }

    private Resource transformResource(List<IConfigurationElement> transformationSequence, URI originalResourceURI) throws IOException, CoreException {
        ResourceSetImpl ecoreRs01 = null;
        Resource ecoreRes01 = null;
        EPackage package01 = null;
        ResourceSetImpl rs01 = null;
        AggregatorResourceImpl res01 = null;
        ResourceSetImpl ecoreRs02 = null;
        Resource ecoreRes02 = null;
        EPackage package02 = null;
        ResourceSetImpl rs02 = null;
        AggregatorResourceImpl res02 = null;
        int idx = 0;
        for (IConfigurationElement transformation : transformationSequence) {
            if (idx == 0) {
                ecoreRs01 = new ResourceSetImpl();
                ecoreRs01.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                ecoreRes01 = ecoreRs01.getResource(URI.createURI((String)transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_ECORE)), true);
                package01 = (EPackage)ecoreRes01.getContents().get(0);
                rs01 = new ResourceSetImpl();
                rs01.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                rs01.getPackageRegistry().put((Object)package01.getNsURI(), (Object)package01);
                res01 = rs01.getResource(originalResourceURI, true);
                rs01.getResources().add((Object)res01);
            } else {
                ecoreRs01 = ecoreRs02;
                ecoreRes01 = ecoreRes02;
                package01 = package02;
                rs01 = rs02;
                res01 = res02;
            }
            ++idx;
            File tempFile = File.createTempFile("temp", ".b3aggr");
            tempFile.deleteOnExit();
            rs02 = new ResourceSetImpl();
            rs02.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            if ("http://www.eclipse.org/b3/2010/aggregator/1.0.0".equals(transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_TARGET_NS))) {
                package02 = AggregatorPackage.eINSTANCE;
                res02 = new AggregatorResourceImpl(URI.createURI((String)tempFile.toURI().toString()));
                rs02.getResources().add((Object)res02);
            } else {
                ecoreRs02 = new ResourceSetImpl();
                ecoreRs02.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                ecoreRes02 = ecoreRs02.getResource(URI.createURI((String)transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_TARGET_ECORE)), true);
                package02 = (EPackage)ecoreRes02.getContents().get(0);
                res02 = rs02.createResource(URI.createURI((String)tempFile.toURI().toString()));
            }
            rs02.getPackageRegistry().put((Object)package02.getNsURI(), (Object)package02);
            ITransformer transformer = (ITransformer)transformation.createExecutableExtension(LEGACY_TRANSFORMATION_ATTR_CLASS);
            transformer.initTransformer((Resource)res01, (Resource)res02, package02, this.context);
            transformer.startTransformation();
        }
        return res02;
    }

    public class InfoPage
    extends WizardPage {
        private boolean srcNamespaceFound;
        private boolean transformationSequenceExists;

        public InfoPage(String pageId, boolean srcNamespaceFound, boolean transformationSequenceExists) {
            super(pageId);
            this.srcNamespaceFound = srcNamespaceFound;
            this.transformationSequenceExists = transformationSequenceExists;
            this.setPageComplete(srcNamespaceFound && transformationSequenceExists);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            if (!this.srcNamespaceFound || !this.transformationSequenceExists) {
                label.setText("Transformation from the selected resource model was not defined - transformation is not possible");
                label.setForeground(Display.getCurrent().getSystemColor(3));
            } else {
                label.setText("This wizard will take you through Aggregation Model Transformation");
            }
            this.setControl((Control)composite);
        }
    }

    public class NewFileCreationPage
    extends WizardNewFileCreationPage {
        public NewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(AggregatorEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

