/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.maven;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.b3.aggregator.engine.maven.metadata.DocumentRoot;
import org.eclipse.b3.aggregator.engine.maven.metadata.MetaData;
import org.eclipse.b3.aggregator.engine.maven.metadata.MetadataFactory;
import org.eclipse.b3.aggregator.engine.maven.metadata.util.MetadataResourceFactoryImpl;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

public class MavenMetadata {
    private DocumentRoot documentRoot;

    public MavenMetadata() {
        this.documentRoot = MetadataFactory.eINSTANCE.createDocumentRoot();
        this.documentRoot.setMetadata(MetadataFactory.eINSTANCE.createMetaData());
    }

    public MavenMetadata(URI uri) throws CoreException {
        Resource resource = this.getResourceSet().getResource(uri, true);
        EList content = resource.getContents();
        if (content.size() != 1) {
            throw ExceptionUtils.fromMessage((String)"ECore Resource did not contain one resource. It had %d", (Object[])new Object[]{content.size()});
        }
        this.documentRoot = (DocumentRoot)content.get(0);
        Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)this.documentRoot);
        if (diag.getSeverity() == 4) {
            for (Diagnostic childDiag : diag.getChildren()) {
                LogUtils.error((String)childDiag.getMessage(), (Object[])new Object[0]);
            }
            throw ExceptionUtils.fromMessage((String)"Maven Metadata model validation failed: %s", (Object[])new Object[]{diag.getMessage()});
        }
    }

    public MetaData getMetaData() throws CoreException {
        if (this.documentRoot == null || this.documentRoot.getMetadata() == null) {
            throw ExceptionUtils.fromMessage((String)"No metadata available", (Object[])new Object[0]);
        }
        return this.documentRoot.getMetadata();
    }

    public void save() throws CoreException {
        this.save((Resource)null);
    }

    public void save(Resource resource) throws CoreException {
        Resource targetResource = resource;
        if (targetResource == null) {
            targetResource = this.documentRoot.eResource();
        }
        if (targetResource == null) {
            throw ExceptionUtils.fromMessage((String)"No resource to store Maven Metadata", (Object[])new Object[0]);
        }
        if (resource != null && !targetResource.equals(this.documentRoot.eResource())) {
            targetResource.getContents().add((Object)this.documentRoot);
        }
        try {
            targetResource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            throw ExceptionUtils.fromMessage((Throwable)e, (String)"Unable to save Maven Metadata", (Object[])new Object[0]);
        }
    }

    public void save(URI uri) throws CoreException {
        this.save(this.getResourceSet().createResource(uri));
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistryImpl(){

            public Resource.Factory getFactory(URI uri) {
                return new MetadataResourceFactoryImpl();
            }

            public Resource.Factory getFactory(URI uri, String contentType) {
                return this.getFactory(uri);
            }
        });
        return resourceSet;
    }
}

