/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.maven.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.eclipse.b3.aggregator.engine.maven.MavenActivator;
import org.eclipse.b3.aggregator.engine.maven.MavenManager;
import org.eclipse.b3.aggregator.engine.maven.MavenMetadata;
import org.eclipse.b3.aggregator.engine.maven.POM;
import org.eclipse.b3.aggregator.engine.maven.VersionUtil;
import org.eclipse.b3.aggregator.engine.maven.indexer.IMaven2Indexer;
import org.eclipse.b3.aggregator.engine.maven.indexer.IndexNotFoundException;
import org.eclipse.b3.aggregator.engine.maven.indexer.IndexerUtils;
import org.eclipse.b3.aggregator.engine.maven.loader.VersionEntry;
import org.eclipse.b3.aggregator.engine.maven.pom.Dependency;
import org.eclipse.b3.aggregator.engine.maven.pom.License;
import org.eclipse.b3.aggregator.engine.maven.pom.Model;
import org.eclipse.b3.aggregator.loader.IRepositoryLoader;
import org.eclipse.b3.aggregator.p2.InstallableUnit;
import org.eclipse.b3.aggregator.p2.P2Factory;
import org.eclipse.b3.aggregator.p2.impl.ArtifactKeyImpl;
import org.eclipse.b3.aggregator.p2.impl.CopyrightImpl;
import org.eclipse.b3.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.aggregator.p2.impl.LicenseImpl;
import org.eclipse.b3.aggregator.p2.impl.MetadataRepositoryImpl;
import org.eclipse.b3.aggregator.p2.impl.ProvidedCapabilityImpl;
import org.eclipse.b3.aggregator.p2.impl.RequiredCapabilityImpl;
import org.eclipse.b3.aggregator.p2.impl.TouchpointTypeImpl;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.b3.aggregator.util.P2Utils;
import org.eclipse.b3.aggregator.util.RepositoryLoaderUtils;
import org.eclipse.b3.aggregator.util.UriIterator;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven2RepositoryLoader
implements IRepositoryLoader {
    private static final Pattern folderExcludePattern = Pattern.compile("^.*/[0-9]+\\.[^/]*/?$");
    private static final String MAVEN_METADATA = "maven-metadata.xml";
    private static final String MAVEN_METADATA_LOCAL = "maven-metadata-local.xml";
    private static final IQuery<IInstallableUnit> QUERY_ALL_IUS = QueryUtil.createIUAnyQuery();
    public static final String SIMPLE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    private Stack<UriIterator> iteratorStack;
    private Iterator<VersionEntry> versionEntryItor;
    private IMaven2Indexer indexer;
    private java.net.URI location;
    private IProvisioningAgent agent;
    private MetadataRepositoryImpl repository;
    private Map<String, IInstallableUnit> cachedIUs;
    private static final String MAVEN_EMPTY_RANGE_STRING = "0.0.0";
    private static final String REPOSITORY_CANCELLED_MESSAGE = "Repository loading was cancelled";
    private static final String PROP_MAVEN_ID = "maven.artifactId";
    private static final String PROP_MAVEN_GROUP = "maven.groupId";
    private static final String PROP_POM_MD5 = "maven.pom.md5";
    private static final String PROP_POM_SHA1 = "maven.pom.sha1";
    private static final String PROP_POM_TIMESTAMP = "maven.pom.timestamp";
    private static final String PROP_INDEX_TIMESTAMP = "maven.index.timestamp";

    public void close() {
        this.cachedIUs = null;
    }

    public IArtifactRepository getArtifactRepository(IMetadataRepository mdr, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Generating artifact repository", 100);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
        SimpleArtifactRepository ar = new SimpleArtifactRepository(mdr.getProvisioningAgent(), mdr.getName(), mdr.getLocation(), null){

            public void save() {
            }
        };
        IQueryResult result = mdr.query(QUERY_ALL_IUS, (IProgressMonitor)subMon.newChild(40));
        SubProgressMonitor fetchMon = new SubProgressMonitor((IProgressMonitor)subMon, 20);
        fetchMon.beginTask("Collecting all IUs", 1);
        Iterator itor = result.iterator();
        ArrayList<InstallableUnit> ius = new ArrayList<InstallableUnit>();
        while (itor.hasNext()) {
            ius.add(InstallableUnitImpl.importToModel((IInstallableUnit)((IInstallableUnit)itor.next())));
        }
        fetchMon.worked(1);
        Collections.sort(ius);
        subMon.worked(20);
        SubProgressMonitor targetMon = new SubProgressMonitor((IProgressMonitor)subMon, 20);
        targetMon.beginTask("Collecting all IUs", ius.size());
        for (IInstallableUnit iInstallableUnit : ius) {
            for (IArtifactKey key : iInstallableUnit.getArtifacts()) {
                SimpleArtifactDescriptor ad = new SimpleArtifactDescriptor(key);
                String groupPath = iInstallableUnit.getProperty(PROP_MAVEN_GROUP);
                if (groupPath != null) {
                    groupPath = groupPath.replace('.', '/');
                }
                String id = iInstallableUnit.getProperty(PROP_MAVEN_ID);
                String version = MavenManager.getVersionString(iInstallableUnit.getVersion());
                ad.setRepositoryProperty("artifact.reference", String.valueOf(mdr.getLocation().toString()) + '/' + groupPath + '/' + id + '/' + version + '/' + id + '-' + version + '.' + key.getClassifier());
                ar.addDescriptor((IArtifactDescriptor)ad);
            }
            targetMon.worked(1);
        }
        return ar;
    }

    public void load(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, false);
    }

    public void open(java.net.URI location, IProvisioningAgent agent, MetadataRepositoryImpl mdr) throws CoreException {
        this.location = location;
        this.agent = agent;
        this.indexer = IndexerUtils.getIndexer("nexus");
        long remoteIndexTimestamp = this.getRemoteIndexTimestamp();
        if (!(this.indexer != null && remoteIndexTimestamp != 0L || this.robotSafe(location.toString(), "/"))) {
            StringBuilder message = new StringBuilder("Crawling of %1$s is discouraged (see %1$s/robots.txt)");
            if (remoteIndexTimestamp != 0L) {
                message.append(". Hint: The repository is indexed. Install an index reader to map this repository.");
            }
            throw ExceptionUtils.fromMessage((String)message.toString(), (Object[])new Object[]{location.toString()});
        }
        this.repository = mdr;
        this.iteratorStack = new Stack();
        this.versionEntryItor = Collections.emptyList().iterator();
    }

    public void reload(IProgressMonitor monitor) throws CoreException {
        this.load(monitor, true);
    }

    private void append(StringBuilder sb, String name, boolean newLines) {
        if ((name = StringUtils.trimmedOrNull((String)name)) != null) {
            sb.append(name);
            if (newLines) {
                sb.append('\n');
                sb.append('\n');
            }
        }
    }

    private LicenseHelper buildLicense(List<License> licenses) {
        java.net.URI location = null;
        StringBuilder body = new StringBuilder();
        int cnt = licenses.size();
        if (cnt == 1) {
            License license = licenses.get(0);
            try {
                if (StringUtils.trimmedOrNull((String)license.getUrl()) != null) {
                    location = java.net.URI.create(license.getUrl());
                }
                this.append(body, license.getName(), true);
                this.append(body, license.getComments(), true);
                this.append(body, "Distribution: " + license.getDistribution(), false);
                LicenseHelper helper = new LicenseHelper();
                helper.body = body.toString();
                helper.location = location;
                return helper;
            }
            catch (IllegalArgumentException helper) {
                // empty catch block
            }
        }
        int i = 0;
        for (License license : licenses) {
            this.append(body, license.getName(), true);
            this.append(body, license.getComments(), true);
            this.append(body, license.getUrl(), true);
            this.append(body, "Distribution: " + license.getDistribution(), i++ < cnt);
        }
        LicenseHelper helper = new LicenseHelper();
        helper.body = body.toString();
        helper.location = location;
        return helper;
    }

    private IRepositoryLoader checkCache() throws CoreException {
        File p2content = null;
        try {
            p2content = this.getCacheFile();
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.wrap((Throwable)e);
        }
        if (p2content.exists()) {
            IConfigurationElement config = RepositoryLoaderUtils.getLoaderFor((String)"p2");
            return (IRepositoryLoader)config.createExecutableExtension("class");
        }
        return null;
    }

    private InstallableUnit createIU(VersionEntry versionEntry, IProgressMonitor monitor) throws IOException {
        InstallableUnitImpl iu = (InstallableUnitImpl)P2Factory.eINSTANCE.createInstallableUnit();
        iu.setId(this.createP2Id(versionEntry.groupId, versionEntry.artifactId));
        iu.setVersion(versionEntry.version);
        iu.getPropertyMap().put((Object)PROP_MAVEN_ID, (Object)versionEntry.artifactId);
        iu.getPropertyMap().put((Object)PROP_MAVEN_GROUP, (Object)versionEntry.groupId);
        iu.getPropertyMap().put((Object)"original.path", (Object)versionEntry.groupId.replace('.', '/'));
        iu.getPropertyMap().put((Object)"original.id", (Object)versionEntry.artifactId);
        iu.setFilter(null);
        try {
            POM pom = POM.getPOM(this.location.toString(), versionEntry.groupId, versionEntry.artifactId, versionEntry.version.getOriginal());
            String md5 = pom.getMd5();
            String sha1 = pom.getSha1();
            Long timestamp = pom.getTimestamp();
            if (md5 != null) {
                iu.getPropertyMap().put((Object)PROP_POM_MD5, (Object)md5);
            }
            if (sha1 != null) {
                iu.getPropertyMap().put((Object)PROP_POM_SHA1, (Object)sha1);
            }
            if (timestamp != null) {
                iu.getPropertyMap().put((Object)PROP_POM_TIMESTAMP, (Object)timestamp.toString());
            }
            if (!versionEntry.groupId.equals(pom.getGroupId())) {
                throw new IOException(String.format("Bad groupId in POM: expected %s, found %s", versionEntry.groupId, pom.getGroupId()));
            }
            if (!versionEntry.artifactId.equals(pom.getArtifactId())) {
                throw new IOException(String.format("Bad artifactId in POM: expected %s, found %s", versionEntry.artifactId, pom.getArtifactId()));
            }
            Model model = pom.getProject();
            if (model.getDependencies() != null) {
                for (Dependency dependency : model.getDependencies().getDependency()) {
                    String namespace = dependency.isSetType() ? POM.expandProperties(dependency.getType(), pom.getProperties()) : "jar";
                    String groupId = POM.expandProperties(dependency.getGroupId(), pom.getProperties());
                    String artifactId = POM.expandProperties(dependency.getArtifactId(), pom.getProperties());
                    Object versionRange = POM.expandProperties(dependency.getVersion(), pom.getProperties());
                    if (versionRange == null) {
                        versionRange = MAVEN_EMPTY_RANGE_STRING;
                    }
                    RequiredCapabilityImpl rc = (RequiredCapabilityImpl)P2Factory.eINSTANCE.createRequiredCapability();
                    rc.setNamespace(namespace);
                    rc.setName(this.createP2Id(groupId, artifactId));
                    VersionRange vr = VersionUtil.createVersionRange((String)versionRange);
                    rc.setRange(vr);
                    rc.setGreedy(true);
                    if (dependency.isSetOptional()) {
                        rc.setMin(dependency.isOptional() ? 0 : 1);
                    }
                    iu.getRequirements().add((Object)rc);
                }
            }
            ProvidedCapabilityImpl pc = (ProvidedCapabilityImpl)P2Factory.eINSTANCE.createProvidedCapability();
            String version = pom.getVersion();
            pc.setNamespace("org.eclipse.equinox.p2.iu");
            pc.setName(iu.getId());
            pc.setVersion(VersionUtil.createVersion(version));
            iu.getProvidedCapabilities().add((Object)pc);
            pc = (ProvidedCapabilityImpl)P2Factory.eINSTANCE.createProvidedCapability();
            pc.setNamespace(model.getPackaging());
            pc.setName(iu.getId());
            pc.setVersion(VersionUtil.createVersion(version));
            iu.getProvidedCapabilities().add((Object)pc);
            if (model.getLicenses() != null) {
                ArrayList<License> toLicense = new ArrayList<License>();
                ArrayList<License> toCopyright = new ArrayList<License>();
                for (License license : model.getLicenses().getLicense()) {
                    String match = "copyright";
                    String name = license.getName();
                    String comments = license.getComments();
                    if (name != null && name.toLowerCase().contains(match) || comments != null && comments.toLowerCase().contains(match)) {
                        toCopyright.add(license);
                        continue;
                    }
                    toLicense.add(license);
                }
                if (toCopyright.size() > 0) {
                    LicenseHelper copyrightHelper = this.buildLicense(toCopyright);
                    CopyrightImpl copyright = (CopyrightImpl)P2Factory.eINSTANCE.createCopyright();
                    copyright.setBody(copyrightHelper.body);
                    copyright.setLocation(copyrightHelper.location);
                    iu.setCopyright((ICopyright)copyright);
                }
                if (toLicense.size() > 0) {
                    for (License license : toLicense) {
                        LicenseHelper licenseHelper = this.buildLicense(Collections.singletonList(license));
                        LicenseImpl p2License = (LicenseImpl)P2Factory.eINSTANCE.createLicense();
                        p2License.setBody(licenseHelper.body);
                        p2License.setLocation(licenseHelper.location);
                        p2License.setUUID(licenseHelper.getDigest().toString());
                        iu.getLicenses().add((Object)p2License);
                    }
                }
            }
            if (!"pom".equals(model.getPackaging())) {
                ArtifactKeyImpl artifact = (ArtifactKeyImpl)P2Factory.eINSTANCE.createArtifactKey();
                artifact.setId(iu.getId());
                artifact.setVersion(iu.getVersion());
                artifact.setClassifier(model.getPackaging());
                iu.getArtifacts().add((Object)artifact);
            }
        }
        catch (CoreException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        TouchpointTypeImpl touchpointType = (TouchpointTypeImpl)P2Factory.eINSTANCE.createTouchpointType();
        touchpointType.setId(ITouchpointType.NONE.getId());
        touchpointType.setVersion(ITouchpointType.NONE.getVersion());
        iu.setTouchpointType((ITouchpointType)touchpointType);
        LogUtils.debug((String)"Adding IU: %s#%s", (Object[])new Object[]{iu.getId(), MavenManager.getVersionString(iu.getVersion())});
        return iu;
    }

    private String createKey(IInstallableUnit iu) {
        return String.valueOf(iu.getId()) + '#' + iu.getVersion().toString();
    }

    private String createKey(VersionEntry ve) {
        return String.valueOf(this.createP2Id(ve.groupId, ve.artifactId)) + '#' + ve.version.toString();
    }

    private String createP2Id(String groupId, String artifactId) {
        return artifactId.equals(groupId) || artifactId.startsWith(String.valueOf(groupId) + '.') ? artifactId : String.valueOf(groupId) + '/' + artifactId;
    }

    private boolean deleteTree(File root) {
        boolean result = true;
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    if (!this.deleteTree(f)) {
                        result = false;
                    }
                } else if (!f.delete()) {
                    result = false;
                }
                ++n2;
            }
        }
        if (!root.delete()) {
            result = false;
        }
        return result;
    }

    private MavenMetadata findNextComponent(IProgressMonitor monitor) throws CoreException {
        if (this.iteratorStack.isEmpty()) {
            return null;
        }
        UriIterator itor = this.iteratorStack.peek();
        block6: while (itor.hasNext()) {
            java.net.URI uri = itor.next();
            if (this.isFolder(uri)) {
                UriIterator subItor;
                for (UriIterator prev : this.iteratorStack) {
                    if (uri.equals(prev.getRoot())) continue block6;
                }
                try {
                    subItor = new UriIterator(uri, folderExcludePattern, monitor);
                }
                catch (CoreException e) {
                    LogUtils.warning((String)e.getMessage(), (Object[])new Object[0]);
                    continue;
                }
                java.net.URI[] uris = subItor.getURIs();
                int idx = uris.length;
                java.net.URI mavenMetadataURI = null;
                while (--idx >= 0) {
                    java.net.URI subUri = uris[idx];
                    IPath subPath = Path.fromPortableString((String)subUri.getPath());
                    String name = subPath.lastSegment();
                    if (!MAVEN_METADATA.equals(name) && !MAVEN_METADATA_LOCAL.equals(name)) continue;
                    mavenMetadataURI = subUri;
                    break;
                }
                if (mavenMetadataURI != null) {
                    EList<String> versions;
                    try {
                        MavenMetadata md = new MavenMetadata(URI.createURI((String)mavenMetadataURI.toString()));
                        versions = md.getMetaData().getVersioning().getVersions().getVersion();
                    }
                    catch (Exception e) {
                        LogUtils.warning((String)e.getMessage(), (Object[])new Object[0]);
                        continue;
                    }
                    int top = uris.length;
                    ArrayList<java.net.URI> uriList = new ArrayList<java.net.URI>();
                    idx = 0;
                    while (idx < top) {
                        java.net.URI subUri = uris[idx];
                        IPath subPath = Path.fromPortableString((String)subUri.getPath());
                        String file = subPath.lastSegment();
                        if (!versions.contains(file)) {
                            uriList.add(subUri);
                        }
                        ++idx;
                    }
                    if (uriList.size() < top) {
                        subItor = new UriIterator(uri, folderExcludePattern, uriList.toArray(new java.net.URI[uriList.size()]));
                    }
                }
                this.iteratorStack.push(subItor);
                return this.findNextComponent(monitor);
            }
            try {
                IPath path = Path.fromPortableString((String)uri.getPath());
                String file = path.lastSegment();
                if (!MAVEN_METADATA.equals(file) && !MAVEN_METADATA_LOCAL.equals(file)) continue;
                return new MavenMetadata(URI.createURI((String)uri.toString()));
            }
            catch (Exception e) {
                LogUtils.warning((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        this.iteratorStack.pop();
        return this.findNextComponent(monitor);
    }

    /*
     * Unable to fully structure code
     */
    private InstallableUnit findNextIU(IProgressMonitor monitor) throws CoreException {
        while (true) {
            block11: {
                if (this.indexer == null) ** GOTO lbl11
                if (this.versionEntryItor.hasNext()) break block11;
                return null;
lbl-1000:
                // 1 sources

                {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException("Repository loading was cancelled");
                    }
                    md = this.findNextComponent(monitor);
                    if (md == null) {
                        return null;
                    }
                    this.versionEntryItor = this.getVersions(md).iterator();
lbl11:
                    // 2 sources

                    ** while (!this.versionEntryItor.hasNext())
                }
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException("Repository loading was cancelled");
            }
            ve = this.versionEntryItor.next();
            if (this.cachedIUs != null && (iu = (InstallableUnit)this.cachedIUs.get(this.createKey(ve))) != null) {
                return iu;
            }
            try {
                return this.createIU(ve, monitor);
            }
            catch (Exception e) {
                LogUtils.warning((String)("Skipping component " + ve.toString() + ": " + e.getMessage()), (Object[])new Object[0]);
                continue;
            }
            break;
        }
    }

    private File getCacheFile() throws MalformedURLException {
        return new File(this.getCacheLocation(), "content.jar");
    }

    private File getCacheLocation() throws MalformedURLException {
        return MavenActivator.getPlugin().getCacheDirectory(this.location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getRemoteIndexTimestamp() throws CoreException {
        try {
            BufferedReader reader = null;
            String indexPropertiesFile = "/.index/nexus-maven-repository-index.properties";
            if ("http".equals(this.location.getScheme()) || "https".equals(this.location.getScheme())) {
                HttpClient httpClient = new HttpClient();
                GetMethod method = new GetMethod(String.valueOf(this.location.toString()) + indexPropertiesFile);
                method.setRequestHeader("user-agent", "");
                int status = httpClient.executeMethod((HttpMethod)method);
                if (status == 200) {
                    reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
                }
            } else {
                URL url = new URL(String.valueOf(this.location.toString()) + indexPropertiesFile);
                try {
                    URLConnection conn = url.openConnection();
                    reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                }
                catch (FileNotFoundException conn) {
                }
                catch (ConnectException conn) {
                    // empty catch block
                }
            }
            if (reader == null) return 0L;
            try {
                String[] timePrefixes = new String[]{"nexus.index.timestamp=", "nexus.index.time="};
                block9: while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        return 0L;
                    }
                    String[] stringArray = timePrefixes;
                    int n = timePrefixes.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block9;
                        String timePrefix = stringArray[n2];
                        if (line.startsWith(timePrefix)) {
                            String timeStr = line.substring(timePrefix.length());
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
                            long l = dateFormat.parse(timeStr).getTime();
                            return l;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.fromMessage((Throwable)e, (String)"Unable to contact repository %s", (Object[])new Object[]{this.location.toString()});
        }
    }

    private List<VersionEntry> getVersions(MavenMetadata md) throws CoreException {
        EList<String> versions = md.getMetaData().getVersioning().getVersions().getVersion();
        ArrayList<VersionEntry> versionEntries = new ArrayList<VersionEntry>(versions.size());
        String groupId = md.getMetaData().getGroupId();
        String artifactId = md.getMetaData().getArtifactId();
        for (String versionString : versions) {
            try {
                versionEntries.add(new VersionEntry(groupId, artifactId, VersionUtil.createVersion(versionString)));
            }
            catch (IllegalArgumentException e) {
                LogUtils.warning((String)("Skipping component " + groupId + '/' + artifactId + '#' + versionString + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return versionEntries;
    }

    private boolean isFolder(java.net.URI uri) {
        IPath path = Path.fromPortableString((String)uri.getPath());
        if (path.hasTrailingSeparator()) {
            return true;
        }
        String scheme = uri.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            HeadMethod method = new HeadMethod(uri.toString());
            HttpClient httpClient = new HttpClient();
            try {
                Header target;
                method.setFollowRedirects(false);
                int status = httpClient.executeMethod((HttpMethod)method);
                return (status == 301 || status == 302) && (target = method.getResponseHeader("location")) != null && target.getValue() != null && target.getValue().endsWith("/");
            }
            catch (Exception e) {
                LogUtils.warning((Throwable)e, (String)"Unable to check if %s is folder: %s", (Object[])new Object[]{uri.toString(), e.getMessage()});
                return false;
            }
        }
        return false;
    }

    private void load(IProgressMonitor monitor, boolean avoidCache) throws CoreException {
        IRepositoryLoader cacheLoader = null;
        this.cachedIUs = null;
        long remoteTime = this.getRemoteIndexTimestamp();
        if (remoteTime == 0L) {
            this.indexer = null;
        }
        if (avoidCache) {
            this.removeCache();
        } else {
            cacheLoader = this.checkCache();
        }
        if (cacheLoader != null) {
            long cacheTime;
            LogUtils.debug((String)"Opening cache for %s", (Object[])new Object[]{this.repository.toString()});
            try {
                cacheLoader.open(this.getCacheLocation().toURI(), this.agent, this.repository);
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
            cacheLoader.load((IProgressMonitor)new NullProgressMonitor());
            cacheLoader.close();
            this.repository.setLocation(this.location);
            this.repository.getPropertyMap().remove((Object)"p2.compressed");
            this.repository.getPropertyMap().remove((Object)"p2.timestamp");
            String cacheTimeString = (String)this.repository.getPropertyMap().get((Object)PROP_INDEX_TIMESTAMP);
            long l = cacheTime = cacheTimeString != null ? Long.parseLong(cacheTimeString) : 0L;
            if (remoteTime == 0L || remoteTime > cacheTime) {
                if (remoteTime == 0L) {
                    LogUtils.debug((String)"Unable to check if cache for %s is obsolete, repository will be scanned again", (Object[])new Object[]{this.location.toString()});
                } else {
                    LogUtils.debug((String)"Cache for %s is obsolete, repository will be scanned again", (Object[])new Object[]{this.location.toString()});
                }
                this.removeCache();
                this.cachedIUs = new HashMap<String, IInstallableUnit>(this.repository.getInstallableUnits().size());
                for (IInstallableUnit iu : this.repository.getInstallableUnits()) {
                    this.cachedIUs.put(this.createKey(iu), iu);
                }
                this.repository.removeAll();
                this.repository.getPropertyMap().clear();
                this.repository.setDescription(null);
            } else {
                LogUtils.debug((String)"Cache for %s is up-to-date", (Object[])new Object[]{this.repository.toString()});
                monitor.done();
                return;
            }
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            InstallableUnit iu;
            SubMonitor crawlMon;
            if (this.indexer != null) {
                try {
                    this.indexer.openRemoteIndex(this.location, avoidCache);
                    this.versionEntryItor = this.indexer.getArtifacts();
                }
                catch (IndexNotFoundException e) {
                    LogUtils.debug((String)"Indexer: Remote index not found at %s", (Object[])new Object[]{this.location.toString()});
                    this.indexer.closeRemoteIndex();
                    this.indexer = null;
                }
            }
            this.repository.setName("Maven2@" + this.location.toString());
            this.repository.setLocation(this.location);
            this.repository.setDescription(null);
            this.repository.setProvider(null);
            this.repository.setType("maven2");
            this.repository.setVersion(null);
            this.repository.getPropertyMap().put((Object)PROP_INDEX_TIMESTAMP, (Object)Long.valueOf(this.getRemoteIndexTimestamp()).toString());
            if (this.indexer != null) {
                crawlMon = subMon;
                crawlMon.beginTask("Scanning repository", this.indexer.getNumberOfEntries());
            } else {
                final SubMonitor[] crawlMonRef = new SubMonitor[1];
                UriIterator itor = new UriIterator(this.location, folderExcludePattern, (IProgressMonitor)subMon.newChild(1)){

                    public java.net.URI next() {
                        java.net.URI nextURI = super.next();
                        if (nextURI != null) {
                            crawlMonRef[0].worked(1);
                        }
                        return nextURI;
                    }
                };
                crawlMon = subMon.newChild(99);
                crawlMon.beginTask("Scanning repository", itor.size());
                crawlMonRef[0] = crawlMon;
                this.iteratorStack.add(itor);
            }
            EList ius = this.repository.getInstallableUnits();
            HashMap<String, InstallableUnitImpl> categoryMap = new HashMap<String, InstallableUnitImpl>();
            SubProgressMonitor cancellationOnlyMonitor = new SubProgressMonitor(monitor, 0){

                public void beginTask(String name, int work) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                }

                public void worked(int work) {
                }
            };
            while ((iu = this.findNextIU((IProgressMonitor)cancellationOnlyMonitor)) != null) {
                String groupId;
                InstallableUnitImpl category;
                if (crawlMon.isCanceled()) {
                    throw new OperationCanceledException(REPOSITORY_CANCELLED_MESSAGE);
                }
                if (this.indexer != null) {
                    crawlMon.worked(1);
                }
                if ((category = (InstallableUnitImpl)categoryMap.get(groupId = iu.getProperty(PROP_MAVEN_GROUP))) == null) {
                    category = (InstallableUnitImpl)P2Factory.eINSTANCE.createInstallableUnit();
                    category.setId(groupId);
                    category.setVersion(Version.emptyVersion);
                    category.getPropertyMap().put((Object)"org.eclipse.equinox.p2.type.category", (Object)"true");
                    category.getPropertyMap().put((Object)"org.eclipse.equinox.p2.name", (Object)("Group " + groupId));
                    ius.add(category);
                    categoryMap.put(groupId, category);
                }
                RequiredCapabilityImpl rc = (RequiredCapabilityImpl)P2Factory.eINSTANCE.createRequiredCapability();
                rc.setName(iu.getId());
                rc.setNamespace("org.eclipse.equinox.p2.iu");
                rc.setRange(new VersionRange(iu.getVersion(), true, iu.getVersion(), true));
                EList rcList = category.getRequirements();
                rcList.add(rc);
                ius.add(iu);
            }
            this.storeCache();
        }
        finally {
            if (this.indexer != null) {
                this.indexer.closeRemoteIndex();
            }
            subMon.done();
        }
    }

    private void removeCache() throws CoreException {
        IMetadataRepositoryManager mdrMgr = null;
        mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.agent, IMetadataRepositoryManager.class);
        try {
            try {
                mdrMgr.removeRepository(this.getCacheLocation().toURI());
                this.deleteTree(this.getCacheLocation());
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        }
        finally {
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.agent, (IRepositoryManager)mdrMgr);
        }
    }

    private boolean robotSafe(String baseURL, String path) throws CoreException {
        URL robotURL;
        String robotStr = String.valueOf(baseURL) + "/robots.txt";
        try {
            robotURL = new URL(robotStr);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.fromMessage((String)e.getMessage(), (Object[])new Object[0]);
        }
        StringBuilder commands = new StringBuilder();
        InputStream robotStream = null;
        try {
            try {
                int read;
                robotStream = robotURL.openStream();
                byte[] buffer = new byte[1024];
                while ((read = robotStream.read(buffer)) != -1) {
                    commands.append(new String(buffer, 0, read));
                }
            }
            catch (IOException buffer) {
                if (robotStream != null) {
                    try {
                        robotStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        finally {
            if (robotStream != null) {
                try {
                    robotStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        int index = 0;
        String disallow = "Disallow:";
        while ((index = commands.indexOf(disallow, index)) != -1) {
            String commandPath = commands.substring(index += disallow.length());
            StringTokenizer tokenizer = new StringTokenizer(commandPath);
            if (!tokenizer.hasMoreTokens()) break;
            String disallowedPath = tokenizer.nextToken();
            if (path.indexOf(disallowedPath) != 0) continue;
            return false;
        }
        return true;
    }

    private void storeCache() throws CoreException {
        IMetadataRepositoryManager mdrMgr = null;
        mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.agent, IMetadataRepositoryManager.class);
        try {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("p2.compressed", "true");
            properties.put(PROP_INDEX_TIMESTAMP, (String)this.repository.getPropertyMap().get((Object)PROP_INDEX_TIMESTAMP));
            properties.put("description", this.repository.getDescription());
            IMetadataRepository mdr = null;
            try {
                mdr = mdrMgr.createRepository(this.getCacheLocation().toURI(), this.repository.getName(), SIMPLE_METADATA_TYPE, properties);
            }
            catch (MalformedURLException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
            mdr.addInstallableUnits((Collection)this.repository.getInstallableUnits());
        }
        finally {
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.agent, (IRepositoryManager)mdrMgr);
        }
    }

    private class LicenseHelper {
        java.net.URI location;
        String body;

        private LicenseHelper() {
        }

        BigInteger getDigest() {
            String message = this.normalize(this.body);
            try {
                MessageDigest algorithm = MessageDigest.getInstance("MD5");
                algorithm.reset();
                algorithm.update(message.getBytes("UTF-8"));
                byte[] digestBytes = algorithm.digest();
                return new BigInteger(1, digestBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private String normalize(String license) {
            String text = license.trim();
            StringBuffer result = new StringBuffer();
            int length = text.length();
            int i = 0;
            while (i < length) {
                char c = text.charAt(i);
                boolean foundWhitespace = false;
                while (Character.isWhitespace(c) && i < length) {
                    foundWhitespace = true;
                    c = text.charAt(++i);
                }
                if (foundWhitespace) {
                    result.append(' ');
                }
                if (i < length) {
                    result.append(c);
                }
                ++i;
            }
            return result.toString();
        }
    }
}

