/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.expression.CompoundIterator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingArtifactRepository
implements IArtifactRepository,
IFileArtifactRepository {
    private static final String NULL = "";
    private IArtifactRepository innerRepo;
    private Set<IArtifactDescriptor> descriptorsToAdd = new HashSet<IArtifactDescriptor>();
    private Map<IArtifactKey, List<IArtifactDescriptor>> artifactMap = new HashMap<IArtifactKey, List<IArtifactDescriptor>>();
    private Set<IArtifactDescriptor> descriptorsToRemove = new HashSet<IArtifactDescriptor>();
    private Map<String, String> propertyChanges = new HashMap<String, String>();

    protected CachingArtifactRepository(IArtifactRepository innerRepo) {
        this.innerRepo = innerRepo;
    }

    public void save() {
        this.savePropertyChanges();
        this.saveAdditions();
        this.saveRemovals();
    }

    private void saveRemovals() {
        for (IArtifactDescriptor desc : this.descriptorsToRemove) {
            this.innerRepo.removeDescriptor(desc);
        }
        this.descriptorsToRemove.clear();
    }

    private void saveAdditions() {
        if (this.descriptorsToAdd.isEmpty()) {
            return;
        }
        this.innerRepo.addDescriptors(this.descriptorsToAdd.toArray(new IArtifactDescriptor[this.descriptorsToAdd.size()]));
        this.descriptorsToAdd.clear();
        this.artifactMap.clear();
    }

    private void savePropertyChanges() {
        Iterator<String> iterator = this.propertyChanges.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String value = this.propertyChanges.get(key = iterator.next());
            this.innerRepo.setProperty(key, value == NULL ? null : value);
        }
        this.propertyChanges.clear();
    }

    private void mapDescriptor(IArtifactDescriptor descriptor) {
        IArtifactKey key = descriptor.getArtifactKey();
        List<IArtifactDescriptor> descriptors = this.artifactMap.get(key);
        if (descriptors == null) {
            descriptors = new ArrayList<IArtifactDescriptor>();
            this.artifactMap.put(key, descriptors);
        }
        descriptors.add(descriptor);
    }

    private void unmapDescriptor(IArtifactDescriptor descriptor) {
        IArtifactKey key = descriptor.getArtifactKey();
        List<IArtifactDescriptor> descriptors = this.artifactMap.get(key);
        if (descriptors == null) {
            this.descriptorsToRemove.add(descriptor);
            return;
        }
        descriptors.remove(descriptor);
        if (descriptors.isEmpty()) {
            this.artifactMap.remove(key);
        }
    }

    public synchronized void addDescriptors(IArtifactDescriptor[] descriptors) {
        int i = 0;
        while (i < descriptors.length) {
            ((ArtifactDescriptor)descriptors[i]).setRepository((IArtifactRepository)this);
            this.descriptorsToAdd.add(descriptors[i]);
            this.mapDescriptor(descriptors[i]);
            ++i;
        }
    }

    public synchronized void addDescriptor(IArtifactDescriptor toAdd) {
        ((ArtifactDescriptor)toAdd).setRepository((IArtifactRepository)this);
        this.descriptorsToAdd.add(toAdd);
        this.mapDescriptor(toAdd);
    }

    public synchronized IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        List<IArtifactDescriptor> result = this.artifactMap.get(key);
        if (result == null) {
            return this.innerRepo.getArtifactDescriptors(key);
        }
        result = new ArrayList<IArtifactDescriptor>(result);
        result.addAll(Arrays.asList(this.innerRepo.getArtifactDescriptors(key)));
        return result.toArray(new IArtifactDescriptor[result.size()]);
    }

    public synchronized boolean contains(IArtifactDescriptor descriptor) {
        return this.descriptorsToAdd.contains(descriptor) || this.innerRepo.contains(descriptor);
    }

    public synchronized boolean contains(IArtifactKey key) {
        return this.artifactMap.containsKey(key) || this.innerRepo.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.innerRepo.getArtifact(descriptor, destination, monitor);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.innerRepo.getRawArtifact(descriptor, destination, monitor);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        return null;
    }

    public synchronized void removeAll() {
        IArtifactDescriptor[] toRemove = this.descriptorsToAdd.toArray(new IArtifactDescriptor[this.descriptorsToAdd.size()]);
        int i = 0;
        while (i < toRemove.length) {
            this.doRemoveArtifact(toRemove[i]);
            ++i;
        }
    }

    public synchronized void removeDescriptor(IArtifactDescriptor descriptor) {
        this.doRemoveArtifact(descriptor);
    }

    public synchronized void removeDescriptor(IArtifactKey key) {
        IArtifactDescriptor[] toRemove = this.getArtifactDescriptors(key);
        int i = 0;
        while (i < toRemove.length) {
            this.doRemoveArtifact(toRemove[i]);
            ++i;
        }
    }

    private boolean doRemoveArtifact(IArtifactDescriptor descriptor) {
        boolean result = this.descriptorsToAdd.remove(descriptor);
        if (result) {
            this.unmapDescriptor(descriptor);
        }
        this.descriptorsToRemove.add(descriptor);
        return result;
    }

    public String getDescription() {
        return this.innerRepo.getDescription();
    }

    public URI getLocation() {
        return this.innerRepo.getLocation();
    }

    public String getName() {
        return this.innerRepo.getName();
    }

    public Map<String, String> getProperties() {
        return this.innerRepo.getProperties();
    }

    public String getProperty(String key) {
        return this.innerRepo.getProperty(key);
    }

    public String getProvider() {
        return this.innerRepo.getProvider();
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.innerRepo.getProvisioningAgent();
    }

    public String getType() {
        return this.innerRepo.getType();
    }

    public String getVersion() {
        return this.innerRepo.getVersion();
    }

    public boolean isModifiable() {
        return this.innerRepo.isModifiable();
    }

    public String setProperty(String key, String value) {
        String result = this.getProperties().get(key);
        this.propertyChanges.put(key, value == null ? NULL : value);
        return result;
    }

    public Object getAdapter(Class adapter) {
        return this.innerRepo.getAdapter(adapter);
    }

    public File getArtifactFile(IArtifactKey key) {
        if (this.innerRepo instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)this.innerRepo).getArtifactFile(key);
        }
        return null;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        if (this.innerRepo instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)this.innerRepo).getArtifactFile(descriptor);
        }
        return null;
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        return this.innerRepo.createArtifactDescriptor(key);
    }

    public IArtifactKey createArtifactKey(String classifier, String id, Version version) {
        return this.innerRepo.createArtifactKey(classifier, id, version);
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        final Collection<List<IArtifactDescriptor>> descs = this.artifactMap.values();
        IQueryable<IArtifactDescriptor> cached = new IQueryable<IArtifactDescriptor>(){

            public IQueryResult<IArtifactDescriptor> query(IQuery<IArtifactDescriptor> query, IProgressMonitor monitor) {
                return query.perform((Iterator)new CompoundIterator(descs.iterator()));
            }
        };
        return QueryUtil.compoundQueryable((IQueryable)cached, (IQueryable)this.innerRepo.descriptorQueryable());
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        final Iterator<IArtifactKey> keyIterator = this.artifactMap.keySet().iterator();
        IQueryable<IArtifactKey> cached = new IQueryable<IArtifactKey>(){

            public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> q, IProgressMonitor mon) {
                return q.perform(keyIterator);
            }
        };
        IQueryable compound = QueryUtil.compoundQueryable((IQueryable)cached, (IQueryable)this.innerRepo);
        return compound.query(query, monitor);
    }

    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.equinox.p2.directorywatcher", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

