/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.p2.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.p2.P2Factory;
import org.eclipse.b3.aggregator.p2.P2Package;
import org.eclipse.b3.aggregator.p2.RepositoryReference;
import org.eclipse.b3.aggregator.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.aggregator.p2.impl.PropertyImpl;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoryImpl
extends MinimalEObjectImpl.Container
implements MetadataRepository {
    private static final Method LocalMetadataRepository_createRepositoriesSnapshot;
    protected int eFlags = 0;
    protected IProvisioningAgent provisioningAgent;
    protected static final URI LOCATION_EDEFAULT;
    protected URI location = LOCATION_EDEFAULT;
    protected static final String NAME_EDEFAULT;
    protected String name = NAME_EDEFAULT;
    protected static final String TYPE_EDEFAULT;
    protected String type = TYPE_EDEFAULT;
    protected static final String VERSION_EDEFAULT;
    protected String version = VERSION_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String PROVIDER_EDEFAULT;
    protected String provider = PROVIDER_EDEFAULT;
    protected static final boolean MODIFIABLE_EDEFAULT = false;
    protected static final int MODIFIABLE_EFLAG = 1;
    protected EList<IInstallableUnit> installableUnits;
    protected EList<IRepositoryReference> references;
    protected EMap<String, String> propertyMap;
    private static final Pattern categoryRefPattern;
    private static final Pattern proxyFragmentPattern;

    static {
        try {
            LocalMetadataRepository_createRepositoriesSnapshot = LocalMetadataRepository.class.getDeclaredMethod("createRepositoriesSnapshot", new Class[0]);
            LocalMetadataRepository_createRepositoriesSnapshot.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        LOCATION_EDEFAULT = null;
        NAME_EDEFAULT = null;
        TYPE_EDEFAULT = null;
        VERSION_EDEFAULT = null;
        DESCRIPTION_EDEFAULT = null;
        PROVIDER_EDEFAULT = null;
        categoryRefPattern = Pattern.compile("^(@installableUnits\\[id='.*'),version='0\\.0\\.0\\.[0-9]{14}'\\]$");
        proxyFragmentPattern = Pattern.compile("^[^:]+:(.*)#\\/\\/@metadataRepository$");
    }

    protected MetadataRepositoryImpl() {
    }

    public void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        EList<IInstallableUnit> iuList = this.getInstallableUnits();
        for (IInstallableUnit iu : installableUnits) {
            iuList.add((Object)InstallableUnitImpl.importToModel(iu));
        }
    }

    public void addReferences(Collection<? extends IRepositoryReference> references) {
        for (IRepositoryReference iRepositoryReference : references) {
            this.addReference(iRepositoryReference.getLocation(), iRepositoryReference.getNickname(), iRepositoryReference.getType(), iRepositoryReference.getOptions());
        }
    }

    public void addRepositoryReferences(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr) throws CoreException {
        if (mdr instanceof LocalMetadataRepository) {
            try {
                List refs = (List)LocalMetadataRepository_createRepositoriesSnapshot.invoke((Object)mdr, new Object[0]);
                for (org.eclipse.equinox.p2.repository.spi.RepositoryReference ref : refs) {
                    this.addReference(ref.getLocation(), ref.getNickname(), ref.getType(), ref.getOptions());
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        } else if (mdr instanceof CompositeMetadataRepository) {
            List children = ((CompositeMetadataRepository)mdr).getChildren();
            for (URI child : children) {
                this.addRepositoryReferences(mdrMgr, mdrMgr.loadRepository(child, null));
            }
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLocation();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getType();
            }
            case 3: {
                return this.getVersion();
            }
            case 4: {
                return this.getDescription();
            }
            case 5: {
                return this.getProvider();
            }
            case 6: {
                return this.isModifiable();
            }
            case 7: {
                return this.getInstallableUnits();
            }
            case 8: {
                return this.getReferences();
            }
            case 9: {
                if (coreType) {
                    return this.getPropertyMap();
                }
                return this.getPropertyMap().map();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getInstallableUnits()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getReferences()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getPropertyMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 3: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 4: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 5: {
                return PROVIDER_EDEFAULT == null ? this.provider != null : !PROVIDER_EDEFAULT.equals(this.provider);
            }
            case 6: {
                return (this.eFlags & 1) != 0;
            }
            case 7: {
                return this.installableUnits != null && !this.installableUnits.isEmpty();
            }
            case 8: {
                return this.references != null && !this.references.isEmpty();
            }
            case 9: {
                return this.propertyMap != null && !this.propertyMap.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        Matcher m = categoryRefPattern.matcher(uriFragmentSegment);
        if (m.matches()) {
            uriFragmentSegment = String.valueOf(m.group(1)) + ']';
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataRepository)) {
            return false;
        }
        return this.getSafeLocation().equals(((MetadataRepository)obj).getSafeLocation());
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLocation((URI)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setType((String)newValue);
                return;
            }
            case 3: {
                this.setVersion((String)newValue);
                return;
            }
            case 4: {
                this.setDescription((String)newValue);
                return;
            }
            case 5: {
                this.setProvider((String)newValue);
                return;
            }
            case 6: {
                this.setModifiable((Boolean)newValue);
                return;
            }
            case 7: {
                this.getInstallableUnits().clear();
                this.getInstallableUnits().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
            case 9: {
                ((EStructuralFeature.Setting)this.getPropertyMap()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 4: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 5: {
                this.setProvider(PROVIDER_EDEFAULT);
                return;
            }
            case 6: {
                this.setModifiable(false);
                return;
            }
            case 7: {
                this.getInstallableUnits().clear();
                return;
            }
            case 8: {
                this.getReferences().clear();
                return;
            }
            case 9: {
                this.getPropertyMap().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public Object getAdapter(Class adapter) {
        return AdapterManager.getDefault().getAdapter((Object)this, adapter);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public EList<IInstallableUnit> getInstallableUnits() {
        if (this.installableUnits == null) {
            this.installableUnits = new EObjectContainmentEList.Resolving(IInstallableUnit.class, (InternalEObject)this, 7);
        }
        return this.installableUnits;
    }

    public URI getLocation() {
        return this.location;
    }

    @Override
    public URI getLocationFromProxy() {
        Matcher m = proxyFragmentPattern.matcher(this.eProxyURI().toString());
        try {
            return m.matches() ? new URI(m.group(1)) : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getNameFromProxy() {
        return null;
    }

    public Map<String, String> getProperties() {
        return this.getPropertyMap().map();
    }

    public String getProperty(String key) {
        return (String)this.getPropertyMap().get((Object)key);
    }

    @Override
    public EMap<String, String> getPropertyMap() {
        if (this.propertyMap == null) {
            this.propertyMap = new EcoreEMap(P2Package.Literals.PROPERTY, PropertyImpl.class, (InternalEObject)this, 9);
        }
        return this.propertyMap;
    }

    public String getProvider() {
        return this.provider;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.provisioningAgent;
    }

    @Override
    public EList<IRepositoryReference> getReferences() {
        if (this.references == null) {
            this.references = new EObjectContainmentEList.Resolving(IRepositoryReference.class, (InternalEObject)this, 8);
        }
        return this.references;
    }

    @Override
    public URI getSafeLocation() {
        return this.location != null ? this.location : this.getLocationFromProxy();
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isModifiable() {
        return (this.eFlags & 1) != 0;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor progress) {
        return query.perform(this.getInstallableUnits().iterator());
    }

    public void removeAll() {
        this.getInstallableUnits().clear();
    }

    public boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        if (installableUnits == null) {
            return false;
        }
        EList<IInstallableUnit> units = this.getInstallableUnits();
        return units.removeAll(installableUnits);
    }

    @Deprecated
    public boolean removeInstallableUnits(IInstallableUnit[] installableUnits, IProgressMonitor monitor) {
        return this.removeInstallableUnits(Arrays.asList(installableUnits));
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDescription, (Object)this.description));
        }
    }

    public void setLocation(URI newLocation) {
        URI oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLocation, (Object)this.location));
        }
    }

    public void setModifiable(boolean newModifiable) {
        boolean oldModifiable;
        boolean bl = oldModifiable = (this.eFlags & 1) != 0;
        this.eFlags = newModifiable ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldModifiable, newModifiable));
        }
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public String setProperty(String key, String value) {
        return (String)this.getPropertyMap().put((Object)key, (Object)value);
    }

    public void setProvider(String newProvider) {
        String oldProvider = this.provider;
        this.provider = newProvider;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldProvider, (Object)this.provider));
        }
    }

    public void setProvisioningAgent(IProvisioningAgent provisioningAgent) {
        this.provisioningAgent = provisioningAgent;
    }

    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldType, (Object)this.type));
        }
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldVersion, (Object)this.version));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", name: ");
        result.append(this.name);
        result.append(", type: ");
        result.append(this.type);
        result.append(", version: ");
        result.append(this.version);
        result.append(", description: ");
        result.append(this.description);
        result.append(", provider: ");
        result.append(this.provider);
        result.append(", modifiable: ");
        result.append((this.eFlags & 1) != 0);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return P2Package.Literals.METADATA_REPOSITORY;
    }

    private void addReference(URI location, String nickname, int type, int options) {
        RepositoryReference ref = P2Factory.eINSTANCE.createRepositoryReference();
        ref.setLocation(location);
        ref.setNickname(nickname);
        ref.setType(type);
        ref.setOptions(options);
        this.getReferences().add((Object)ref);
    }
}

