/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.engine.internal.MultiRangeRequirement;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.util.LogUtils;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementUtils {
    private static final VersionRange ANY_VERSION = VersionRange.emptyRange;

    public static IRequirement[] createAllAvailableVersionsRequirements(List<IInstallableUnit> ius, IMatchExpression<IInstallableUnit> filter) {
        HashMap versionMap = new HashMap();
        HashMap<String, HashSet<IMatchExpression>> filterMap = new HashMap<String, HashSet<IMatchExpression>>();
        for (IInstallableUnit iu : ius) {
            HashSet<IMatchExpression> filterSet;
            HashSet<Version> versionSet = (HashSet<Version>)versionMap.get(iu.getId());
            if (versionSet == null) {
                versionSet = new HashSet<Version>();
                versionMap.put(iu.getId(), versionSet);
            }
            if ((filterSet = (HashSet<IMatchExpression>)filterMap.get(iu.getId())) == null) {
                filterSet = new HashSet<IMatchExpression>();
                filterMap.put(iu.getId(), filterSet);
            }
            versionSet.add(iu.getVersion());
            filterSet.add(iu.getFilter());
        }
        IRequirement[] requirements = new IRequirement[versionMap.size()];
        int i = 0;
        for (Map.Entry iuEntry : versionMap.entrySet()) {
            String name = (String)iuEntry.getKey();
            String namespace = "org.eclipse.equinox.p2.iu";
            IMatchExpression inheritedFilter = null;
            for (IMatchExpression iuFilter : (Set)filterMap.get(name)) {
                if (inheritedFilter == null) {
                    inheritedFilter = iuFilter;
                    continue;
                }
                if (inheritedFilter.equals(iuFilter)) continue;
                LogUtils.log((int)1, (String)"More than one filter definition found on %s; using an empty filter", (Object[])new Object[]{name});
                inheritedFilter = null;
                break;
            }
            if (inheritedFilter != null) {
                if (filter == null) {
                    filter = inheritedFilter;
                } else {
                    Object[] inheritedFilterParams = inheritedFilter.getParameters();
                    Object[] filterParams = filter.getParameters();
                    Object[] compoundParams = new Object[inheritedFilterParams.length + filterParams.length];
                    System.arraycopy(inheritedFilterParams, 0, compoundParams, 0, inheritedFilterParams.length);
                    System.arraycopy(filterParams, 0, compoundParams, inheritedFilterParams.length, filterParams.length);
                    filter = ExpressionFactory.INSTANCE.matchExpression(ExpressionFactory.INSTANCE.and(new IExpression[]{inheritedFilter, filter}), compoundParams);
                }
            }
            requirements[i++] = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)ANY_VERSION, filter, (boolean)false, (boolean)false);
        }
        return requirements;
    }

    public static IRequirement createMultiRangeRequirement(MetadataRepository mdr, IRequirement req) {
        HashSet<Version> matchingVersions = new HashSet<Version>();
        String name = null;
        String namespace = "org.eclipse.equinox.p2.iu";
        for (IInstallableUnit iu : mdr.getInstallableUnits()) {
            if (!req.isMatch(iu)) continue;
            matchingVersions.add(iu.getVersion());
            if (name == null) {
                name = iu.getId();
                continue;
            }
            if (name.equals(iu.getId())) continue;
            throw new RuntimeException("Requirement must contain strict name filter");
        }
        return new MultiRangeRequirement(name, namespace, matchingVersions, null, (IMatchExpression<IInstallableUnit>)req.getFilter());
    }

    public static String getName(IRequirement req) {
        if (req instanceof IRequiredCapability) {
            return ((IRequiredCapability)req).getName();
        }
        if (req instanceof MultiRangeRequirement) {
            return ((MultiRangeRequirement)req).getName();
        }
        throw new RuntimeException("Unable to extrace IU name from requirement of class " + req.getClass().getName());
    }

    public static IRequirement versionUnion(IRequirement req1, IRequirement req2) {
        if (req1 instanceof MultiRangeRequirement && req2 instanceof MultiRangeRequirement) {
            MultiRangeRequirement vreq1 = (MultiRangeRequirement)req1;
            MultiRangeRequirement vreq2 = (MultiRangeRequirement)req2;
            if (!vreq1.getName().equals(vreq2.getName())) {
                throw new RuntimeException("Unable to create a version union of expressions with different name requests");
            }
            if (!vreq1.getNamespace().equals(vreq2.getNamespace())) {
                throw new RuntimeException("Unable to create a version union of expressions with different namespace requests");
            }
            IMatchExpression<IInstallableUnit> f1 = vreq1.getFilter();
            IMatchExpression<IInstallableUnit> f2 = vreq2.getFilter();
            if (f1 != null && !f1.equals(f2) || f1 == null && f2 != null) {
                throw new RuntimeException("Unable to create a version union of expressions with different filters");
            }
            HashSet<Version> allVersions = new HashSet<Version>();
            allVersions.addAll(vreq1.getVersions());
            allVersions.addAll(vreq2.getVersions());
            return new MultiRangeRequirement(vreq1.getName(), vreq1.getNamespace(), allVersions, null, f1);
        }
        throw new RuntimeException("Unable to create a version union of expressions: " + req1 + ", " + req2);
    }
}

