/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.IRepeatableIterator;
import org.eclipse.equinox.internal.p2.metadata.expression.Member;
import org.eclipse.equinox.internal.p2.metadata.expression.RepeatableIterator;
import org.eclipse.equinox.internal.p2.ql.expression.IQLConstants;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QLUtil
implements IExpression,
IQLConstants {
    static Set<?> asSet(Object val, boolean forcePrivateCopy) {
        HashSet result;
        if (val == null) {
            throw new IllegalArgumentException("Cannot convert null into an set");
        }
        if (val instanceof IRepeatableIterator) {
            Object provider = ((IRepeatableIterator)val).getIteratorProvider();
            if (!forcePrivateCopy) {
                if (provider instanceof Set) {
                    return (Set)provider;
                }
                if (provider instanceof IQueryResult) {
                    return ((IQueryResult)provider).toUnmodifiableSet();
                }
            }
            if (provider instanceof Collection) {
                val = provider;
            }
        } else if (!forcePrivateCopy) {
            if (val instanceof Set) {
                return (Set)val;
            }
            if (val instanceof IQueryResult) {
                return ((IQueryResult)val).toUnmodifiableSet();
            }
        }
        if (val instanceof Collection) {
            result = new HashSet((Collection)val);
        } else {
            result = new HashSet();
            IRepeatableIterator iterator = RepeatableIterator.create((Object)val);
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        return result;
    }

    public static boolean needsTranslationSupport(IExpression expression) {
        TranslationSupportFinder tsFinder = new TranslationSupportFinder();
        ((Expression)expression).accept((IExpressionVisitor)tsFinder);
        return tsFinder.isFound();
    }

    private static class TranslationSupportFinder
    implements IExpressionVisitor {
        private boolean found;

        TranslationSupportFinder() {
        }

        public boolean visit(IExpression expression) {
            if (expression.getExpressionType() == 13 && "translatedProperties".equals(((Member)expression).getName())) {
                this.found = true;
            }
            return !this.found;
        }

        boolean isFound() {
            return this.found;
        }
    }
}

