/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.AvailableVersion;
import org.eclipse.b3.aggregator.Configuration;
import org.eclipse.b3.aggregator.Contact;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.CustomCategory;
import org.eclipse.b3.aggregator.EnabledStatusProvider;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.impl.AggregatorImpl;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.aggregator.p2view.RequirementWrapper;
import org.eclipse.b3.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.b3.aggregator.presentation.AggregatorValidateAction;
import org.eclipse.b3.aggregator.presentation.DetachContributionResourceAction;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.util.AddIUsToContributionCommand;
import org.eclipse.b3.aggregator.util.AddIUsToCustomCategoryCommand;
import org.eclipse.b3.aggregator.util.AddIUsToParentRepositoryCommand;
import org.eclipse.b3.aggregator.util.AggregatorResourceImpl;
import org.eclipse.b3.aggregator.util.ItemSorter;
import org.eclipse.b3.aggregator.util.ItemUtils;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.aggregator.util.SortCommand;
import org.eclipse.b3.aggregator.util.TwoColumnMatrix;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(AggregatorEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                AggregatorActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                AggregatorEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(AggregatorEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return AggregatorActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (AggregatorActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)AggregatorActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    protected Map<EnabledStatusAction, Boolean> enabledStatusActionVisibility;
    protected boolean reloadOrCancelRepoActionVisible;
    protected ReloadOrCancelRepoAction reloadOrCancelRepoAction;
    protected BuildRepoAction cleanRepoAction;
    protected BuildRepoAction verifyRepoAction;
    protected BuildRepoAction buildRepoAction;
    protected BuildRepoAction cleanBuildRepoAction;
    protected List<IAction> addToParentRepositoryActions;
    protected List<IAction> addToCustomCategoriesActions;
    protected IAction selectMatchingIUAction;
    private Aggregator aggregator;
    private IEditorPart lastActiveEditorPart;
    private ISelection lastSelection;
    private boolean aggregatorSelected;

    private static String getString(String key) {
        return AggregatorEditorPlugin.INSTANCE.getString(key);
    }

    public AggregatorActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new AggregatorValidateAction();
        this.controlAction = new DetachContributionResourceAction();
        this.enabledStatusActionVisibility = new LinkedHashMap<EnabledStatusAction, Boolean>();
        this.enabledStatusActionVisibility.put(new EnabledStatusAction(true), Boolean.FALSE);
        this.enabledStatusActionVisibility.put(new EnabledStatusAction(false), Boolean.FALSE);
        this.reloadOrCancelRepoAction = new ReloadOrCancelRepoAction();
        this.reloadOrCancelRepoActionVisible = false;
        this.cleanRepoAction = new BuildRepoAction(Builder.ActionType.CLEAN);
        this.verifyRepoAction = new BuildRepoAction(Builder.ActionType.VERIFY);
        this.buildRepoAction = new BuildRepoAction(Builder.ActionType.BUILD);
        this.cleanBuildRepoAction = new BuildRepoAction(Builder.ActionType.CLEAN_BUILD);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_AggregatorEditor_menu"), "org.eclipse.b3.aggregatorMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("aggregator-settings"));
        toolBarManager.add((IContributionItem)new Separator("aggregator-additions"));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        MenuManager submenuManager;
        this.menuAboutToShowGen(menuManager);
        this.addToParentRepositoryActions = this.generateAddToParentRepositoryAction(this.lastSelection);
        this.addToCustomCategoriesActions = this.generateAddToCustomCategoryActions(this.lastSelection);
        if (this.addToParentRepositoryActions != null && this.addToParentRepositoryActions.size() > 0) {
            if (this.addToParentRepositoryActions.size() == 1) {
                IAction action = this.addToParentRepositoryActions.get(0);
                Object imageURL = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/Contribution.gif");
                if (imageURL != null && imageURL instanceof URL) {
                    action.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)imageURL)));
                }
                action.setText(AggregatorEditPlugin.INSTANCE.getString("_UI_Add_to_parent_Mapped_Repository"));
                menuManager.insertBefore("edit", action);
            } else {
                submenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_Add_to_parent_Mapped_Repository_As"));
                this.populateManager((IContributionManager)submenuManager, this.addToParentRepositoryActions, null);
                menuManager.insertBefore("edit", (IContributionItem)submenuManager);
            }
        }
        if (this.addToCustomCategoriesActions != null && this.addToCustomCategoriesActions.size() > 0) {
            submenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_Add_to_Custom_Category_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.addToCustomCategoriesActions, null);
            menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        }
        if (this.selectMatchingIUAction != null) {
            menuManager.insertBefore("edit", this.selectMatchingIUAction);
        }
        for (Map.Entry<EnabledStatusAction, Boolean> entry : this.enabledStatusActionVisibility.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.depopulateManager((IContributionManager)menuManager, Collections.singleton(entry.getKey()));
            menuManager.insertBefore("edit", (IAction)entry.getKey());
        }
        if (this.reloadOrCancelRepoActionVisible) {
            this.depopulateManager((IContributionManager)menuManager, Collections.singleton(this.reloadOrCancelRepoAction));
            menuManager.insertBefore("edit", (IContributionItem)new ActionContributionItem((IAction)this.reloadOrCancelRepoAction){

                public boolean isDynamic() {
                    return true;
                }
            });
        }
        if (this.aggregatorSelected) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            SortAction<Configuration> sortConfigurationsAction = new SortAction<Configuration>(editingDomain, this.aggregator.getConfigurations(), AggregatorFactory.eINSTANCE.createConfiguration(), "Configurations");
            SortAction<Contact> sortContactsAction = new SortAction<Contact>(editingDomain, this.aggregator.getContacts(), AggregatorFactory.eINSTANCE.createContact(), "Contacts");
            SortAction<Contribution> sortContributionsAction = new SortAction<Contribution>(editingDomain, this.aggregator.getContributions(), AggregatorFactory.eINSTANCE.createContribution(), "Contributions");
            SortAction<CustomCategory> sortCustomCategoriesAction = new SortAction<CustomCategory>(editingDomain, this.aggregator.getCustomCategories(), AggregatorFactory.eINSTANCE.createCustomCategory(), "Custom Categories");
            MenuManager submenuManager2 = new MenuManager("Sort");
            submenuManager2.add(sortConfigurationsAction);
            submenuManager2.add(sortContactsAction);
            submenuManager2.add(sortContributionsAction);
            submenuManager2.add(sortCustomCategoriesAction);
            menuManager.insertBefore("edit", (IContributionItem)submenuManager2);
        }
    }

    public void menuAboutToShowGen(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(AggregatorEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.lastSelection = event.getSelection();
        this.updateContextMenu(event.getSelection());
    }

    public void selectionChangedGen(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void updateContextMenu(ISelection selection) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        this.selectMatchingIUAction = null;
        this.reloadOrCancelRepoActionVisible = false;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() >= 1) {
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            List selectedItems = ((IStructuredSelection)selection).toList();
            int state = -1;
            boolean first = true;
            for (Map.Entry<EnabledStatusAction, Boolean> sa : this.enabledStatusActionVisibility.entrySet()) {
                sa.setValue(false);
                if (!sa.getKey().isSupportedFor(selectedItems)) continue;
                ArrayList<EnabledStatusProvider> items = new ArrayList<EnabledStatusProvider>();
                for (Object obj : selectedItems) {
                    items.add((EnabledStatusProvider)obj);
                }
                sa.getKey().setReference(items);
                sa.getKey().initialize(items, domain);
                if (first) {
                    state = sa.getKey().determineStatus(items);
                    first = false;
                }
                if ((state == 1 || state == 2) && sa.getKey().isEnableState()) {
                    sa.setValue(Boolean.TRUE);
                }
                if (state != 0 && state != 2 || sa.getKey().isEnableState()) continue;
                sa.setValue(Boolean.TRUE);
            }
            this.reloadOrCancelRepoAction.setEnabled(true);
            this.reloadOrCancelRepoAction.initMetadataRepositoryReferences();
            Aggregator aggregator = this.getAggregator();
            this.aggregatorSelected = false;
            if (selectedItems.size() == 1 && selectedItems.get(0).equals(aggregator)) {
                this.aggregatorSelected = true;
                this.reloadOrCancelRepoAction.setLoadText("Reload All Repositories");
                this.reloadOrCancelRepoActionVisible = true;
                ResourceSet resourceSet = ((AggregatorImpl)aggregator).eResource().getResourceSet();
                for (Resource resource : resourceSet.getResources()) {
                    if (!(resource instanceof MetadataRepositoryResourceImpl)) continue;
                    this.reloadOrCancelRepoAction.addMetadataRepositoryResource((MetadataRepositoryResourceImpl)resource);
                }
            } else {
                this.reloadOrCancelRepoAction.setLoadText("Reload Repository");
                for (Object object : selectedItems) {
                    if (object instanceof MetadataRepositoryReference) {
                        MetadataRepositoryReference metadataRepositoryReference = (MetadataRepositoryReference)object;
                        if (metadataRepositoryReference.isBranchEnabled()) {
                            MetadataRepositoryResourceImpl res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation((String)metadataRepositoryReference.getNature(), (String)metadataRepositoryReference.getResolvedLocation(), (Aggregator)aggregator);
                            this.reloadOrCancelRepoAction.addMetadataRepositoryResource(res);
                        } else {
                            this.reloadOrCancelRepoAction.setEnabled(false);
                        }
                        this.reloadOrCancelRepoActionVisible = true;
                        continue;
                    }
                    if (object instanceof MetadataRepositoryResourceImpl) {
                        MetadataRepositoryResourceImpl res = (MetadataRepositoryResourceImpl)object;
                        this.reloadOrCancelRepoAction.addMetadataRepositoryResource(res);
                        this.reloadOrCancelRepoActionVisible = true;
                        continue;
                    }
                    this.reloadOrCancelRepoAction.setEnabled(false);
                    this.reloadOrCancelRepoActionVisible = false;
                    this.reloadOrCancelRepoAction.initMetadataRepositoryReferences();
                    break;
                }
            }
            if (((IStructuredSelection)selection).size() == 1) {
                Object object;
                object = ((IStructuredSelection)selection).getFirstElement();
                newChildDescriptors = domain.getNewChildDescriptors(object, null);
                newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
                if (object instanceof RequirementWrapper) {
                    this.selectMatchingIUAction = new SelectMatchingIUAction(((RequirementWrapper)object).getGenuine());
                }
                if (object instanceof AvailableVersion) {
                    AvailableVersion av = (AvailableVersion)object;
                    MappedUnit mappedUnit = (MappedUnit)((EObject)av).eContainer();
                    IRequirement requiredCapability = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)mappedUnit.getName(), (VersionRange)new VersionRange(av.getVersion(), true, av.getVersion(), true), null, (boolean)false, (boolean)true);
                    this.selectMatchingIUAction = new SelectMatchingIUAction(null, requiredCapability);
                }
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertBefore("additions", (IContributionItem)new ActionContributionItem((IAction)this.cleanRepoAction));
        menuManager.insertBefore("additions", (IContributionItem)new ActionContributionItem((IAction)this.verifyRepoAction));
        menuManager.insertBefore("additions", (IContributionItem)new ActionContributionItem((IAction)this.buildRepoAction));
        menuManager.insertBefore("additions", (IContributionItem)new ActionContributionItem((IAction)this.cleanBuildRepoAction));
        menuManager.insertBefore("additions", (IContributionItem)new Separator());
        this.addGlobalActionsGen(menuManager);
    }

    protected void addGlobalActionsGen(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    private List<IAction> generateAddToCustomCategoryActions(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            ItemSorter itemSorter = new ItemSorter((Collection)((IStructuredSelection)selection).toList());
            ArrayList<IAction> addToActions = new ArrayList<IAction>();
            if (itemSorter.getTotalItemCount() > 0 && (itemSorter.getTotalItemCount() == itemSorter.getGroupItems(ItemSorter.ItemGroup.FEATURE).size() || itemSorter.getTotalItemCount() == itemSorter.getGroupItems(ItemSorter.ItemGroup.FEATURE_STRUCTURED).size())) {
                ArrayList<IInstallableUnit> features = new ArrayList<IInstallableUnit>();
                features.addAll(itemSorter.getGroupItems(ItemSorter.ItemGroup.FEATURE));
                features.addAll(ItemUtils.getIUs((Collection)itemSorter.getGroupItems(ItemSorter.ItemGroup.FEATURE_STRUCTURED)));
                for (CustomCategory customCategory : this.getAggregator().getCustomCategories()) {
                    addToActions.add((IAction)new AddToCustomCategoryAction(((IEditingDomainProvider)this.activeEditorPart).getEditingDomain(), customCategory, features));
                }
            }
            return addToActions;
        }
        return Collections.emptyList();
    }

    private List<IAction> generateAddToParentRepositoryAction(ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            ItemSorter itemSorter = new ItemSorter((Collection)((IStructuredSelection)selection).toList());
            if (itemSorter.getTotalItemCount() > 0 && (itemSorter.getTotalItemCount() == itemSorter.getGroupItems(ItemSorter.ItemGroup.IU).size() || itemSorter.getTotalItemCount() == itemSorter.getGroupItems(ItemSorter.ItemGroup.IU_STRUCTURED).size())) {
                ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
                ius.addAll(itemSorter.getGroupItems(ItemSorter.ItemGroup.IU));
                ius.addAll(ItemUtils.getIUs((Collection)itemSorter.getGroupItems(ItemSorter.ItemGroup.IU_STRUCTURED)));
                if (itemSorter.getTotalItemCount() == itemSorter.getGroupItems(ItemSorter.ItemGroup.FEATURE_STRUCTURED).size()) {
                    actions.add((IAction)new AddToParentRepositoryAction(((IEditingDomainProvider)this.activeEditorPart).getEditingDomain(), ius, 32));
                    actions.add((IAction)new AddToParentRepositoryAction(((IEditingDomainProvider)this.activeEditorPart).getEditingDomain(), ius, 64));
                    actions.add((IAction)new AddToParentRepositoryAction(((IEditingDomainProvider)this.activeEditorPart).getEditingDomain(), ius, 128));
                } else {
                    actions.add((IAction)new AddToParentRepositoryAction(((IEditingDomainProvider)this.activeEditorPart).getEditingDomain(), ius, 32));
                }
            }
            return actions;
        }
        return actions;
    }

    private Aggregator getAggregator() {
        if (this.activeEditorPart == null || !(this.activeEditorPart instanceof IEditingDomainProvider)) {
            return null;
        }
        if (this.lastActiveEditorPart == this.activeEditorPart) {
            return this.aggregator;
        }
        this.lastActiveEditorPart = this.activeEditorPart;
        IEditingDomainProvider edProvider = (IEditingDomainProvider)this.activeEditorPart;
        EList resources = edProvider.getEditingDomain().getResourceSet().getResources();
        Resource aggregatorResource = null;
        for (Resource resource : resources) {
            if (!(resource instanceof AggregatorResourceImpl)) continue;
            aggregatorResource = resource;
            break;
        }
        this.aggregator = aggregatorResource == null ? null : (Aggregator)aggregatorResource.getContents().get(0);
        return this.aggregator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AddToCustomCategoryAction
    extends Action {
        private EditingDomain domain;
        private AddIUsToCustomCategoryCommand command;

        public AddToCustomCategoryAction(EditingDomain domain, CustomCategory customCategory, List<IInstallableUnit> selectedFeatures) {
            Object imageURL = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/Contribution.gif");
            if (imageURL != null && imageURL instanceof URL) {
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)imageURL)));
            }
            this.domain = domain;
            this.command = new AddIUsToCustomCategoryCommand(customCategory, selectedFeatures);
            this.setText(customCategory.getLabel() == null || customCategory.getLabel().length() == 0 ? "''" : customCategory.getLabel());
            this.setEnabled(this.command.canExecute());
        }

        public void run() {
            this.domain.getCommandStack().execute((Command)this.command);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AddToParentRepositoryAction
    extends Action {
        private EditingDomain domain;
        private AddIUsToParentRepositoryCommand command;

        public AddToParentRepositoryAction(EditingDomain domain, List<IInstallableUnit> selectedIUs, int operation) {
            this.domain = domain;
            this.command = new AddIUsToParentRepositoryCommand(ResourceUtils.getAggregator((ResourceSet)domain.getResourceSet()), selectedIUs, operation);
            Object imageURL = null;
            if ((operation & 0x20) > 0) {
                imageURL = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/Feature.gif");
                this.setText(AggregatorEditorPlugin.INSTANCE.getString("_UI_Mapped_Feature"));
            } else if ((operation & 0x40) > 0) {
                imageURL = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/ExclusionRule.gif");
                this.setText(AggregatorEditorPlugin.INSTANCE.getString("_UI_Exclusion_Rule"));
            }
            if ((operation & 0x80) > 0) {
                imageURL = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/ValidConfigurationsRule.gif");
                this.setText(AggregatorEditorPlugin.INSTANCE.getString("_UI_Valid_Configurations_Rule"));
            }
            if (imageURL != null && imageURL instanceof URL) {
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)imageURL)));
            }
            this.setEnabled(this.command.canExecute());
        }

        public void run() {
            this.domain.getCommandStack().execute((Command)this.command);
        }
    }

    class BuildRepoAction
    extends Action {
        private final Builder.ActionType actionType;

        public BuildRepoAction(Builder.ActionType actionType) {
            Object imageURL;
            String txt;
            this.actionType = actionType;
            String imageURLPath = null;
            switch (actionType) {
                case CLEAN: {
                    txt = "Clean Repository";
                    break;
                }
                case VERIFY: {
                    txt = "Verify Repository";
                    break;
                }
                case BUILD: {
                    txt = "Build Repository";
                    imageURLPath = "full/obj16/start_task.gif";
                    break;
                }
                default: {
                    txt = "Clean then Build Repository";
                    imageURLPath = "full/obj16/start_task.gif";
                }
            }
            this.setText(txt);
            if (imageURLPath != null && (imageURL = AggregatorEditorPlugin.INSTANCE.getImage(imageURLPath)) != null && imageURL instanceof URL) {
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)imageURL)));
            }
        }

        public void run() {
            if (AggregatorActionBarContributor.this.getActiveEditor() == null) {
                MessageBox messageBox = new MessageBox(AggregatorActionBarContributor.this.getActiveEditor().getSite().getShell(), 33);
                messageBox.setMessage("No editor is active");
                messageBox.open();
                return;
            }
            if (this.saveModel()) {
                new Job("b3 Aggregator"){
                    {
                        this.setUser(true);
                        this.setPriority(30);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Builder builder = new Builder();
                            Resource resource = (Resource)((IEditingDomainProvider)((BuildRepoAction)BuildRepoAction.this).AggregatorActionBarContributor.this.activeEditorPart).getEditingDomain().getResourceSet().getResources().get(0);
                            URI emfURI = resource.getURI();
                            URL fileURL = FileLocator.toFileURL((URL)new java.net.URI(emfURI.toString()).toURL());
                            if (!"file".equals(fileURL.getProtocol())) {
                                throw new Exception("URI scheme is not \"file\"");
                            }
                            java.net.URI uri = new java.net.URI(String.valueOf(fileURL.getProtocol()) + ":/" + URLEncoder.encode(fileURL.getPath(), "UTF-8").replaceAll("\\+", "%20"));
                            builder.setBuildModelLocation(new File(uri));
                            builder.setAction(BuildRepoAction.this.actionType);
                            if (builder.run(true, monitor) != IApplication.EXIT_OK.intValue()) {
                                throw new Exception("Build failed (see log for more details)");
                            }
                        }
                        catch (Throwable e) {
                            Throwable cause = BuildRepoAction.this.unwind(e);
                            Status status = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.b3.aggregator.engine", 0, cause.getMessage(), cause);
                            return status;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        protected boolean saveModel() {
            if (AggregatorActionBarContributor.this.getActiveEditor() == null || !AggregatorActionBarContributor.this.getActiveEditor().isDirty()) {
                return true;
            }
            AggregatorActionBarContributor.this.getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
            if (AggregatorActionBarContributor.this.getActiveEditor().isDirty()) {
                MessageBox messageBox = new MessageBox(AggregatorActionBarContributor.this.getActiveEditor().getSite().getShell(), 33);
                messageBox.setMessage("Cannot save aggregator definition");
                messageBox.open();
                return false;
            }
            return true;
        }

        private Throwable unwind(Throwable t) {
            String msg;
            Throwable cause;
            Class<?> tc;
            while (!((tc = t.getClass()) != RuntimeException.class && tc != InvocationTargetException.class && tc != SAXException.class && tc != IOException.class || (cause = t.getCause()) == null || (msg = t.getMessage()) != null && !msg.equals(cause.toString()))) {
                t = cause;
            }
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EnabledStatusAction
    extends Action {
        public static final int ENABLE = 0;
        public static final int DISABLE = 1;
        public static final int BOTH = 2;
        private List<EnabledStatusProvider> refs;
        private boolean enableState;

        public EnabledStatusAction(boolean enableState) {
            this.enableState = enableState;
        }

        public int determineStatus(List<EnabledStatusProvider> selectedItems) {
            for (EnabledStatusProvider enabledStatusProvider : selectedItems) {
                if (enabledStatusProvider.isEnabled() == selectedItems.get(0).isEnabled()) continue;
                return 2;
            }
            return selectedItems.get(0).isEnabled() ? 0 : 1;
        }

        public List<EnabledStatusProvider> getRefs() {
            return this.refs;
        }

        public String getText() {
            if (this.refs == null) {
                return null;
            }
            return this.isEnableState() ? AggregatorEditorPlugin.INSTANCE.getString("_UI_Enable_menu_item") : AggregatorEditorPlugin.INSTANCE.getString("_UI_Disable_menu_item");
        }

        public void initialize(List<EnabledStatusProvider> selectedItems, EditingDomain domain) {
            Iterator<EnabledStatusProvider> iterator = selectedItems.iterator();
            if (iterator.hasNext()) {
                EnabledStatusProvider enabledStatusProvider = iterator.next();
                IEditingDomainItemProvider itemProvider = (IEditingDomainItemProvider)((AdapterFactoryEditingDomain)domain).getAdapterFactory().adapt((Object)enabledStatusProvider, IEditingDomainItemProvider.class);
                if (itemProvider instanceof ItemProviderAdapter) {
                    ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)itemProvider;
                    IItemPropertyDescriptor itemPropertyDescriptor = itemProviderAdapter.getPropertyDescriptor((Object)enabledStatusProvider, (Object)AggregatorPackage.Literals.ENABLED_STATUS_PROVIDER__ENABLED.getName());
                    this.setEnabled(itemPropertyDescriptor.canSetProperty((Object)enabledStatusProvider));
                    return;
                }
                this.setEnabled(false);
                return;
            }
            this.setEnabled(false);
        }

        public boolean isEnableState() {
            return this.enableState;
        }

        public boolean isSupportedFor(List<Object> items) {
            for (Object object : items) {
                if (object instanceof EnabledStatusProvider) continue;
                return false;
            }
            return true;
        }

        public void run() {
            CompoundCommand compoundCommand = new CompoundCommand();
            EditingDomain domain = ((IEditingDomainProvider)AggregatorActionBarContributor.this.activeEditorPart).getEditingDomain();
            for (EnabledStatusProvider ref : this.refs) {
                EStructuralFeature feature = ((EObject)ref).eClass().getEStructuralFeature("enabled");
                SetCommand command = (SetCommand)SetCommand.create((EditingDomain)domain, (Object)ref, (Object)feature, (Object)this.isEnableState());
                compoundCommand.append((Command)command);
            }
            compoundCommand.setLabel(this.getText());
            domain.getCommandStack().execute((Command)compoundCommand);
        }

        public void setReference(List<EnabledStatusProvider> refs) {
            this.refs = refs;
        }

        public void setRefs(List<EnabledStatusProvider> refs) {
            this.refs = refs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapToContributionAction
    extends Action {
        private EditingDomain domain;
        private AddIUsToContributionCommand command;

        public MapToContributionAction(EditingDomain domain, Contribution contribution, List<MetadataRepository> selectedMDRs, List<IInstallableUnit> selectedIUs) {
            Object imageURL = AggregatorEditPlugin.INSTANCE.getImage("full/obj16/Contribution.gif");
            if (imageURL != null && imageURL instanceof URL) {
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)imageURL)));
            }
            this.domain = domain;
            this.command = new AddIUsToContributionCommand(contribution, selectedMDRs, selectedIUs);
            this.setText(this.command.getLabel());
            this.setEnabled(this.command.canExecute());
        }

        public void run() {
            this.domain.getCommandStack().execute((Command)this.command);
        }
    }

    class ReloadOrCancelRepoAction
    extends Action {
        private Set<MetadataRepositoryResourceImpl> metadataRepositoryResources;
        private ImageDescriptor reloadImageDescriptor;
        private ImageDescriptor cancelImageDescriptor;
        private String loadText;
        private boolean nextActionIsLoad;

        public ReloadOrCancelRepoAction() {
            Object imageURL = AggregatorEditorPlugin.INSTANCE.getImage("full/obj16/refresh.gif");
            if (imageURL != null && imageURL instanceof URL) {
                this.reloadImageDescriptor = ImageDescriptor.createFromURL((URL)((URL)imageURL));
            }
            if ((imageURL = AggregatorEditorPlugin.INSTANCE.getImage("full/obj16/progress_stop.gif")) != null && imageURL instanceof URL) {
                this.cancelImageDescriptor = ImageDescriptor.createFromURL((URL)((URL)imageURL));
            }
        }

        public synchronized void addMetadataRepositoryResource(MetadataRepositoryResourceImpl res) {
            this.metadataRepositoryResources.add(res);
        }

        public synchronized ImageDescriptor getImageDescriptor() {
            return this.nextActionIsLoad ? this.reloadImageDescriptor : this.cancelImageDescriptor;
        }

        public synchronized String getText() {
            this.nextActionIsLoad = !this.isLoading();
            return this.nextActionIsLoad ? this.loadText : "Cancel Repository Loading";
        }

        public synchronized void initMetadataRepositoryReferences() {
            this.metadataRepositoryResources = new HashSet<MetadataRepositoryResourceImpl>();
        }

        public synchronized void run() {
            for (MetadataRepositoryResourceImpl mdr : this.metadataRepositoryResources) {
                if (mdr == null) continue;
                if (this.nextActionIsLoad) {
                    mdr.startAsynchronousLoad(true);
                    continue;
                }
                mdr.cancelLoadingJob();
            }
        }

        public void setLoadText(String loadText) {
            this.loadText = loadText;
        }

        private synchronized boolean isLoading() {
            for (MetadataRepositoryResourceImpl mdr : this.metadataRepositoryResources) {
                if (mdr.getStatus().getCode() != StatusCode.WAITING) continue;
                return true;
            }
            return false;
        }
    }

    class SelectMatchingIUAction
    extends Action {
        private IRequirement requirement;
        private MetadataRepository mdr;

        public SelectMatchingIUAction(IRequirement requirement) {
            this(null, requirement);
        }

        public SelectMatchingIUAction(MetadataRepository mdr, IRequirement requirement) {
            this.mdr = mdr;
            this.requirement = requirement;
            this.setText(AggregatorActionBarContributor.getString("_UI_Select_matching_IU_menu_item"));
        }

        public void run() {
            Viewer viewer;
            if (AggregatorActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)AggregatorActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                Shell parent = AggregatorActionBarContributor.this.activeEditorPart.getSite().getShell();
                final EditingDomain editingDomain = ((IEditingDomainProvider)AggregatorActionBarContributor.this.activeEditorPart).getEditingDomain();
                final LinkedHashMap<MetadataRepositoryResourceImpl, TwoColumnMatrix> foundIUs = new LinkedHashMap<MetadataRepositoryResourceImpl, TwoColumnMatrix>();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    TwoColumnMatrix result;
                    if (!(resource instanceof MetadataRepositoryResourceImpl)) continue;
                    MetadataRepositoryResourceImpl mdrResource = (MetadataRepositoryResourceImpl)resource;
                    if (this.mdr != null && this.mdr != mdrResource.getMetadataRepository() || (result = mdrResource.findIUPresentationsWhichSatisfies(this.requirement, true)) == null || result.size() <= 0) continue;
                    foundIUs.put(mdrResource, result);
                }
                if (foundIUs.size() == 0) {
                    parent.getDisplay().beep();
                    MessageDialog.openWarning((Shell)parent, (String)AggregatorActionBarContributor.getString("_UI_Warning_windowTitle"), (String)AggregatorActionBarContributor.getString("_UI_No_matching_IU_was_found"));
                } else if (foundIUs.size() == 1 && foundIUs.values().size() == 1) {
                    TwoColumnMatrix foundIU = (TwoColumnMatrix)foundIUs.values().iterator().next();
                    viewer.setSelection((ISelection)new TreeSelection(new TreePath((Object[])foundIU.getValue(0)).createChildPath(foundIU.getKey(0))), true);
                } else {
                    PopupDialog pppDialog = new PopupDialog(parent, 4, true, false, false, false, false, AggregatorActionBarContributor.getString("_UI_More_matching_IUs_were_found"), AggregatorActionBarContributor.getString("_UI_select_IU")){

                        protected Control createDialogArea(Composite parent) {
                            Composite composite = (Composite)super.createDialogArea(parent);
                            TreeViewer treeViewer = new TreeViewer(composite, 524288);
                            treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                                public Image getImage(Object element) {
                                    if (element == null) {
                                        return null;
                                    }
                                    Object realElement = this.getRealElement(element);
                                    if (realElement == null) {
                                        return null;
                                    }
                                    IItemLabelProvider labelProvider = (IItemLabelProvider)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt(realElement, IItemLabelProvider.class);
                                    if (labelProvider == null) {
                                        return null;
                                    }
                                    return ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(realElement));
                                }

                                public String getText(Object element) {
                                    if (element == null) {
                                        return "";
                                    }
                                    Object realElement = this.getRealElement(element);
                                    if (realElement == null) {
                                        return element.toString();
                                    }
                                    IItemLabelProvider labelProvider = (IItemLabelProvider)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt(realElement, IItemLabelProvider.class);
                                    if (labelProvider == null) {
                                        return realElement.toString();
                                    }
                                    return labelProvider.getText(realElement);
                                }

                                public boolean isLabelProperty(Object element, String property) {
                                    return false;
                                }

                                private Object getRealElement(Object element) {
                                    Object realElement = null;
                                    if (element instanceof Map.Entry) {
                                        realElement = ((Map.Entry)element).getKey();
                                    } else if (element instanceof TwoColumnMatrix.MatrixEntry) {
                                        realElement = ((TwoColumnMatrix.MatrixEntry)element).getKey();
                                    }
                                    return realElement;
                                }
                            });
                            treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                                public void dispose() {
                                }

                                public Object[] getChildren(Object parentElement) {
                                    return ((TwoColumnMatrix)((Map.Entry)parentElement).getValue()).getEntries().toArray();
                                }

                                public Object[] getElements(Object inputElement) {
                                    return ((Map)inputElement).entrySet().toArray();
                                }

                                public Object getParent(Object element) {
                                    return null;
                                }

                                public boolean hasChildren(Object element) {
                                    return element instanceof Map.Entry;
                                }

                                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                                }
                            });
                            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                                public void selectionChanged(SelectionChangedEvent event) {
                                    this.close();
                                    Object selection = ((TreeSelection)event.getSelection()).getFirstElement();
                                    TwoColumnMatrix.MatrixEntry matrixEntry = null;
                                    if (selection instanceof Map.Entry) {
                                        matrixEntry = ((TwoColumnMatrix)((Map.Entry)selection).getValue()).getEntry(0);
                                    } else if (selection instanceof TwoColumnMatrix.MatrixEntry) {
                                        matrixEntry = (TwoColumnMatrix.MatrixEntry)selection;
                                    }
                                    if (matrixEntry != null) {
                                        viewer.setSelection((ISelection)new TreeSelection(new TreePath((Object[])matrixEntry.getValue()).createChildPath(matrixEntry.getKey())), true);
                                    }
                                }
                            });
                            MouseListener ml = new MouseListener(treeViewer.getTree());
                            treeViewer.getTree().addMouseTrackListener((MouseTrackListener)ml);
                            treeViewer.getTree().addMouseMoveListener((MouseMoveListener)ml);
                            treeViewer.setInput((Object)foundIUs);
                            treeViewer.expandAll();
                            return composite;
                        }

                        class MouseListener
                        extends MouseTrackAdapter
                        implements MouseMoveListener {
                            private Tree tree;
                            private TreeItem lastSelectedTreeItem;

                            public MouseListener(Tree tree) {
                                this.tree = tree;
                            }

                            public void mouseExit(MouseEvent e) {
                                if (this.lastSelectedTreeItem != null) {
                                    this.lastSelectedTreeItem.setBackground(null);
                                    this.lastSelectedTreeItem = null;
                                }
                            }

                            public void mouseMove(MouseEvent e) {
                                TreeItem item = this.tree.getItem(new Point(e.x, e.y));
                                if (item != null && item.getItemCount() > 0) {
                                    item = item.getItem(0);
                                }
                                if (item == this.lastSelectedTreeItem) {
                                    return;
                                }
                                if (this.lastSelectedTreeItem != null) {
                                    this.lastSelectedTreeItem.setBackground(null);
                                }
                                if (item != null) {
                                    item.setBackground(this.tree.getDisplay().getSystemColor(19));
                                }
                                this.lastSelectedTreeItem = item;
                            }
                        }
                    };
                    pppDialog.open();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SortAction<T>
    extends Action {
        private EditingDomain editingDomain;
        private SortCommand<T> command;

        public SortAction(EditingDomain editingDomain, EList<T> containment, T itemTemplate, String label) {
            this.editingDomain = editingDomain;
            this.command = new SortCommand(editingDomain, containment, itemTemplate, label);
            this.setEnabled(this.command.canExecute());
            this.setText(label);
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)this.command.getImage())));
        }

        public void run() {
            this.editingDomain.getCommandStack().execute(this.command);
        }
    }
}

