/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.b3.aggregator.AggregatorPlugin;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public class CopyRequest
extends ArtifactRequest {
    private final File destination;

    public CopyRequest(IArtifactRepository src, IArtifactKey key, File destination) {
        super(key);
        this.setSourceRepository(src);
        this.destination = destination;
    }

    public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
        monitor.subTask("Downloading " + this.getArtifactKey().getId());
        this.setSourceRepository(sourceRepository);
        IArtifactDescriptor optimized = null;
        IArtifactDescriptor canonical = null;
        IArtifactDescriptor descriptor = null;
        IArtifactDescriptor[] descriptors = this.source.getArtifactDescriptors(this.getArtifactKey());
        if (descriptors.length > 0) {
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].getProperty("format") == null) {
                    canonical = descriptors[i];
                } else if (ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptors[i])) {
                    optimized = descriptors[i];
                }
                ++i;
            }
            boolean chooseCanonical = this.source.getLocation().equals("file");
            IArtifactDescriptor iArtifactDescriptor = descriptor = chooseCanonical ? canonical : optimized;
            if (descriptor == null) {
                IArtifactDescriptor iArtifactDescriptor2 = descriptor = !chooseCanonical ? canonical : optimized;
            }
        }
        if (descriptor == null) {
            this.setResult((IStatus)new Status(4, AggregatorPlugin.getPluginID(), "Artifact not found: " + this.getArtifactKey()));
            return;
        }
        IStatus status = this.transfer(descriptor, monitor);
        if (monitor.isCanceled()) {
            this.setResult(Status.CANCEL_STATUS);
            return;
        }
        if (status.isOK() || status.getSeverity() == 8) {
            this.setResult(status);
            return;
        }
        if (descriptor == canonical || canonical == null) {
            this.setResult(status);
            return;
        }
        this.setResult(this.transfer(canonical, monitor));
    }

    private IStatus transfer(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        IStatus status;
        while ((status = this.transferSingle(descriptor, monitor)).getSeverity() == 4 && status.getCode() == 13) {
        }
        return status;
    }

    private IStatus transferSingle(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        IStatus status;
        block12: {
            FileOutputStream destinationStream = null;
            status = null;
            try {
                try {
                    destinationStream = new FileOutputStream(this.destination);
                    status = this.source.getArtifact(descriptor, (OutputStream)destinationStream, monitor);
                }
                catch (IOException e) {
                    status = ExceptionUtils.createStatus((Throwable)e);
                    if (destinationStream == null) break block12;
                    try {
                        ((OutputStream)destinationStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (destinationStream != null) {
                    try {
                        ((OutputStream)destinationStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return status;
    }
}

