/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.engine.maven.InstallableUnitMapping;
import org.eclipse.b3.aggregator.engine.maven.MavenRepositoryHelper;
import org.eclipse.b3.p2.maven.MavenMetadata;
import org.eclipse.b3.p2.maven.metadata.MetaData;
import org.eclipse.b3.p2.maven.metadata.MetadataFactory;
import org.eclipse.b3.p2.maven.metadata.Versioning;
import org.eclipse.b3.p2.maven.metadata.Versions;
import org.eclipse.b3.p2.maven.util.DigestUtil;
import org.eclipse.b3.p2.maven.util.VersionUtil;
import org.eclipse.b3.p2.util.IUUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.internal.p2.metadata.BasicVersion;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenManager {
    public static MavenRepositoryHelper createMavenStructure(List<InstallableUnitMapping> ius) throws CoreException {
        ArrayList<InstallableUnitMapping> group;
        ArrayList<String[]> mappingRulesList = new ArrayList<String[]>();
        mappingRulesList.add(new String[]{"(& (classifier=osgi.bundle) (format=packed))", "${repoUrl}/p2.packed/plugins/${id}_${version}.jar.pack.gz"});
        mappingRulesList.add(new String[]{"(& (classifier=org.eclipse.update.feature) (format=packed))", "${repoUrl}/p2.packed/features/${id}_${version}.jar.pack.gz"});
        HashMap<String, ArrayList<InstallableUnitMapping>> groupMap = new HashMap<String, ArrayList<InstallableUnitMapping>>();
        for (InstallableUnitMapping iu : ius) {
            String groupId = iu.map().getGroupId();
            group = (ArrayList<InstallableUnitMapping>)groupMap.get(groupId);
            if (group == null) {
                group = new ArrayList<InstallableUnitMapping>();
                groupMap.put(groupId, group);
            }
            group.add(iu);
        }
        InstallableUnitMapping top = new InstallableUnitMapping();
        top.setTransient(true);
        MavenManager.addMappingRule(mappingRulesList, top);
        for (Map.Entry entry : groupMap.entrySet()) {
            group = new InstallableUnitMapping((String)entry.getKey());
            MavenManager.addMappingRule(mappingRulesList, (InstallableUnitMapping)((Object)group));
            for (InstallableUnitMapping iu : (List)entry.getValue()) {
                MavenManager.addMappingRule(mappingRulesList, iu);
                iu.setParent((InstallableUnitMapping)((Object)group));
                for (InstallableUnitMapping sibling : iu.getSiblings()) {
                    MavenManager.addMappingRule(mappingRulesList, sibling);
                    sibling.setParent((InstallableUnitMapping)((Object)group));
                }
            }
            ((InstallableUnitMapping)((Object)group)).setParent(top);
            ((InstallableUnitMapping)((Object)group)).setTransient(true);
        }
        return new MavenRepositoryHelper(top, (String[][])mappingRulesList.toArray((T[])new String[mappingRulesList.size()][]));
    }

    public static void saveMetadata(URI root, InstallableUnitMapping iu) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URIConverter uriConverter = resourceSet.getURIConverter();
        HashMap<String, MavenMetadataHelper> metadataCollector = new HashMap<String, MavenMetadataHelper>();
        MavenManager.savePOMs(root, iu, uriConverter, DigestUtil.MESSAGE_DIGESTERS, metadataCollector);
        MavenManager.saveXMLs(root, uriConverter, DigestUtil.MESSAGE_DIGESTERS, metadataCollector);
    }

    private static void addMappingRule(List<String[]> mappingRulesList, InstallableUnitMapping iu) throws CoreException {
        if (iu.getMainArtifact() != null) {
            IArtifactKey artifact = iu.getMainArtifact();
            mappingRulesList.add(new String[]{"(& (classifier=" + IUUtils.encodeFilterValue((String)artifact.getClassifier()) + ")(id=" + IUUtils.encodeFilterValue((String)artifact.getId()) + ")(version=" + IUUtils.encodeFilterValue((String)iu.getVersion().toString()) + "))", "${repoUrl}/" + iu.getRelativeFullPath()});
        }
    }

    private static URI createArtifactURI(URI root, InstallableUnitMapping iu) throws CoreException {
        if (iu.getMainArtifact() != null) {
            return URI.createURI((String)(String.valueOf(root.toString()) + "/" + iu.getRelativeFullPath()));
        }
        return null;
    }

    private static void createCheckSum(URI fileUri, URIConverter uriConverter, MessageDigest[] digests) throws CoreException {
        InputStream is = null;
        PrintWriter digestWriter = null;
        try {
            try {
                int n;
                MessageDigest[] messageDigestArray;
                int read;
                is = uriConverter.createInputStream(fileUri);
                MessageDigest[] messageDigestArray2 = digests;
                int n2 = digests.length;
                int n3 = 0;
                while (n3 < n2) {
                    MessageDigest digest = messageDigestArray2[n3];
                    digest.reset();
                    ++n3;
                }
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) != -1) {
                    messageDigestArray = digests;
                    n = digests.length;
                    int n4 = 0;
                    while (n4 < n) {
                        MessageDigest digest = messageDigestArray[n4];
                        digest.update(buffer, 0, read);
                        ++n4;
                    }
                }
                is.close();
                messageDigestArray = digests;
                n = digests.length;
                int n5 = 0;
                while (n5 < n) {
                    MessageDigest digest = messageDigestArray[n5];
                    byte[] result = digest.digest();
                    URI digestUri = URI.createURI((String)(String.valueOf(fileUri.toString()) + "." + digest.getAlgorithm().toLowerCase()));
                    digestWriter = new PrintWriter(uriConverter.createOutputStream(digestUri));
                    byte[] byArray = result;
                    int n6 = result.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        byte b = byArray[n7];
                        digestWriter.printf("%02x", b);
                        ++n7;
                    }
                    digestWriter.close();
                    ++n5;
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.fromMessage((Throwable)e, (String)"Error creating digest for %s", (Object[])new Object[]{fileUri.toString()});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (digestWriter != null) {
                digestWriter.close();
            }
        }
    }

    private static URI createPomURI(URI root, InstallableUnitMapping iu) throws CoreException {
        return URI.createURI((String)(String.valueOf(root.toString()) + "/" + iu.getRelativePath() + "/" + iu.getPomName()));
    }

    private static URI createXmlURI(URI root, MavenMetadataHelper md) throws CoreException {
        return URI.createURI((String)(String.valueOf(root.toString()) + "/" + md.getRelativePath() + "/maven-metadata.xml"));
    }

    private static void savePOMs(URI root, InstallableUnitMapping iu, URIConverter uriConverter, MessageDigest[] digests, Map<String, MavenMetadataHelper> metadataCollector) throws CoreException {
        if (!iu.isTransient()) {
            String key;
            MavenMetadataHelper md;
            URI pomUri = MavenManager.createPomURI(root, iu);
            iu.asPOM().save(pomUri);
            MavenManager.createCheckSum(pomUri, uriConverter, digests);
            URI artifactUri = MavenManager.createArtifactURI(root, iu);
            if (artifactUri != null) {
                MavenManager.createCheckSum(artifactUri, uriConverter, digests);
            }
            if ((md = metadataCollector.get(key = String.valueOf(iu.map().getGroupId()) + "/" + iu.map().getArtifactId())) == null) {
                md = new MavenMetadataHelper(iu.map().getGroupId(), iu.map().getArtifactId());
                metadataCollector.put(key, md);
            }
            md.addVersion(iu.getVersion());
        }
        for (InstallableUnitMapping child : iu.getChildren()) {
            MavenManager.savePOMs(root, child, uriConverter, digests, metadataCollector);
        }
    }

    private static void saveXMLs(URI root, URIConverter uriConverter, MessageDigest[] digests, Map<String, MavenMetadataHelper> metadataCollector) throws CoreException {
        String timestamp = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", new Date());
        for (MavenMetadataHelper mdh : metadataCollector.values()) {
            mdh.finalizeMetadata();
            MavenMetadata mdConainter = new MavenMetadata();
            MetaData md = mdConainter.getMetaData();
            md.setGroupId(mdh.getGroupId());
            md.setArtifactId(mdh.getArtifactId());
            md.setVersion("1");
            Versioning versioning = MetadataFactory.eINSTANCE.createVersioning();
            md.setVersioning(versioning);
            versioning.setLastUpdated(timestamp);
            Version release = mdh.getRelease();
            if (release != null) {
                versioning.setRelease(VersionUtil.getVersionString((Version)release));
            }
            Versions versions = MetadataFactory.eINSTANCE.createVersions();
            versioning.setVersions(versions);
            EList versionList = versions.getVersion();
            for (Version version : mdh.getVersions()) {
                versionList.add(VersionUtil.getVersionString((Version)version));
            }
            URI xmlUri = MavenManager.createXmlURI(root, mdh);
            mdConainter.save(xmlUri);
            MavenManager.createCheckSum(xmlUri, uriConverter, digests);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MavenMetadataHelper {
        private String groupId;
        private String artifactId;
        private List<Version> versionList;
        private boolean finalized;

        MavenMetadataHelper(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.versionList = new ArrayList<Version>();
        }

        public void addVersion(Version version) {
            if (this.finalized) {
                throw new Error("Version added after finalization");
            }
            this.versionList.add(version);
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getRelativePath() {
            return String.valueOf(this.groupId.replace('.', '/')) + "/" + this.artifactId;
        }

        public Version getRelease() {
            this.finalizeMetadata();
            Version[] versions = this.versionList.toArray(new Version[this.versionList.size()]);
            int idx = versions.length - 1;
            while (idx >= 0) {
                String qualifier = null;
                try {
                    qualifier = ((BasicVersion)versions[idx]).getQualifier();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (qualifier == null || qualifier.charAt(0) != 'R' && qualifier.charAt(0) != 'M') {
                    return versions[idx];
                }
                --idx;
            }
            return null;
        }

        public List<Version> getVersions() {
            this.finalizeMetadata();
            return this.versionList;
        }

        private void finalizeMetadata() {
            Collections.sort(this.versionList);
            this.finalized = true;
        }
    }
}

