/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.engine.maven.InstallableUnitMapping;
import org.eclipse.b3.aggregator.engine.maven.MavenManager;
import org.eclipse.b3.aggregator.engine.maven.MavenRepositoryHelper;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.p2.loader.IRepositoryLoader;
import org.eclipse.b3.p2.maven.indexer.IMaven2Indexer;
import org.eclipse.b3.p2.maven.indexer.IndexerUtils;
import org.eclipse.b3.p2.util.IUUtils;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.p2.util.RepositoryLoaderUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorGenerator
extends BuilderPhase {
    private IMetadataRepositoryManager mdrMgr = null;
    private IArtifactRepositoryManager arMgr = null;
    private Map<MetadataRepositoryReference, IArtifactRepository> arCache;

    static void mirror(Collection<IArtifactKey> keysToInstall, IArtifactRepository cache, IArtifactRepository source, IArtifactRepository dest, PackedStrategy strategy, List<String> errors, IProgressMonitor monitor) {
        IQueryResult result = source.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        IArtifactKey[] keys = (IArtifactKey[])result.toArray(IArtifactKey.class);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(keys.length * 100));
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            boolean found = false;
            for (IArtifactKey keyToInstall : keysToInstall) {
                if (!keyToInstall.equals(key)) continue;
                found = true;
                break;
            }
            if (found) {
                LogUtils.info((String)"- mirroring artifact %s", (Object[])new Object[]{key});
                IArtifactRepository sourceForCopy = cache != null && cache.contains(key) ? cache : source;
                PackedStrategy keyStrategy = !"osgi.bundle".equals(key.getClassifier()) ? PackedStrategy.SKIP : strategy;
                try {
                    IArtifactDescriptor[] aDescs = sourceForCopy.getArtifactDescriptors(key);
                    IArtifactDescriptor optimized = null;
                    IArtifactDescriptor canonical = null;
                    IArtifactDescriptor[] iArtifactDescriptorArray = aDescs;
                    int n3 = aDescs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArtifactDescriptor desc = iArtifactDescriptorArray[n4];
                        if (MirrorGenerator.isPacked(desc)) {
                            optimized = desc;
                        } else {
                            canonical = desc;
                        }
                        ++n4;
                    }
                    if (optimized == null && canonical == null) {
                        throw ExceptionUtils.fromMessage((String)"Found no usable descriptor for artifact %s in repository %s", (Object[])new Object[]{key, dest.getLocation()});
                    }
                    if (keyStrategy == PackedStrategy.SKIP && canonical == null) {
                        LogUtils.warning((String)"    canonical artifact unavailable, using optimized one instead", (Object[])new Object[0]);
                        keyStrategy = PackedStrategy.COPY;
                    } else if (keyStrategy != PackedStrategy.SKIP && optimized == null) {
                        keyStrategy = PackedStrategy.SKIP;
                    }
                    switch (keyStrategy) {
                        case SKIP: {
                            if (!MirrorGenerator.checkIfTargetPresent(dest, key, false)) {
                                LogUtils.debug((String)"    doing copy of canonical artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, dest, canonical, MirrorGenerator.createDestinationDescriptor(key, false), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        case COPY: {
                            if (!MirrorGenerator.checkIfTargetPresent(dest, key, true)) {
                                LogUtils.debug((String)"    doing copy of optimized artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, dest, optimized, MirrorGenerator.createDestinationDescriptor(key, true), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        default: {
                            boolean isVerify;
                            if (keyStrategy == PackedStrategy.UNPACK) {
                                if (!MirrorGenerator.checkIfTargetPresent(dest, key, false)) {
                                    LogUtils.debug((String)"    doing copy of optimized artifact into canonical target", (Object[])new Object[0]);
                                    MirrorGenerator.unpack(sourceForCopy, dest, optimized, MirrorGenerator.createDestinationDescriptor(key, false), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                                }
                                break;
                            }
                            boolean bl = isVerify = keyStrategy == PackedStrategy.VERIFY;
                            if (MirrorGenerator.checkIfTargetPresent(dest, key, true)) {
                                if (isVerify) {
                                    break;
                                }
                            } else {
                                LogUtils.debug((String)"    doing copy of optimized artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, dest, optimized, MirrorGenerator.createDestinationDescriptor(key, true), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                            }
                            if (isVerify) {
                                LogUtils.debug((String)"    unpacking optimized artifact for verification", (Object[])new Object[0]);
                            } else {
                                if (MirrorGenerator.checkIfTargetPresent(dest, key, false)) break;
                                LogUtils.debug((String)"    unpacking optimized artifact", (Object[])new Object[0]);
                            }
                            MirrorGenerator.unpackToSibling(dest, MirrorGenerator.getArtifactDescriptor(dest, key, true), MirrorGenerator.createDestinationDescriptor(key, false), isVerify, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    errors.add(Builder.getExceptionMessages(e));
                    dest.removeDescriptor(key);
                    LogUtils.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
            ++n2;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    static IArtifactDescriptor mirror(IArtifactRepository source, IArtifactRepository dest, IArtifactDescriptor sourceDesc, IArtifactDescriptor targetDesc, IProgressMonitor monitor) throws CoreException {
        if (dest.contains(targetDesc)) {
            return targetDesc;
        }
        RawMirrorRequest request = new RawMirrorRequest(sourceDesc, targetDesc, dest);
        request.perform(source, monitor);
        IStatus result = request.getResult();
        switch (result.getSeverity()) {
            case 1: {
                LogUtils.info((String)result.getMessage(), (Object[])new Object[0]);
            }
            case 0: {
                if (MirrorGenerator.getArtifactDescriptor(dest, targetDesc.getArtifactKey(), MirrorGenerator.isPacked(targetDesc)) != null) {
                    return targetDesc;
                }
                result = new Status(4, "org.eclipse.b3.aggregator.engine", "Zero bytes copied");
                break;
            }
            case 8: {
                LogUtils.warning((String)"Aggregation cancelled while mirroring artifact %s", (Object[])new Object[]{sourceDesc.getArtifactKey()});
                throw new OperationCanceledException();
            }
            default: {
                if (result.getCode() == 1201) {
                    LogUtils.warning((String)"  copy failed. Artifact %s is already present", (Object[])new Object[]{sourceDesc.getArtifactKey()});
                    return targetDesc;
                }
                result = MirrorGenerator.extractRootCause(result);
            }
        }
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to mirror artifact %s from repository %s: %s", (Object[])new Object[]{sourceDesc.getArtifactKey(), source.getLocation(), result.getMessage()});
    }

    private static boolean checkIfTargetPresent(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor found = MirrorGenerator.getArtifactDescriptor(destination, key, packed);
        if (found != null) {
            LogUtils.debug((String)"    %s artifact is already present", (Object[])new Object[]{packed ? "optimized" : "canonical"});
            return true;
        }
        return false;
    }

    private static IArtifactDescriptor createDestinationDescriptor(IArtifactKey key, boolean optimized) {
        ArtifactDescriptor desc = new ArtifactDescriptor(key);
        if (optimized) {
            desc.setProperty("format", "packed");
            desc.setProcessingSteps((IProcessingStepDescriptor[])new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)});
        }
        return desc;
    }

    private static IStatus extractDeeperRootCause(IStatus status) {
        IStatus deeper;
        Throwable t;
        if (status == null) {
            return null;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus deeper2 = MirrorGenerator.extractDeeperRootCause(children[i]);
                if (deeper2 != null) {
                    return deeper2;
                }
                ++i;
            }
        }
        if ((t = status.getException()) instanceof CoreException && (deeper = MirrorGenerator.extractDeeperRootCause(((CoreException)t).getStatus())) != null) {
            return deeper;
        }
        return status.getSeverity() == 4 ? status : null;
    }

    private static IStatus extractRootCause(IStatus status) {
        IStatus rootCause = MirrorGenerator.extractDeeperRootCause(status);
        return rootCause == null ? status : rootCause;
    }

    private static IArtifactDescriptor getArtifactDescriptor(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor[] iArtifactDescriptorArray = destination.getArtifactDescriptors(key);
        int n = iArtifactDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor candidate = iArtifactDescriptorArray[n2];
            if (MirrorGenerator.isPacked(candidate) ? packed : !packed) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isPacked(IArtifactDescriptor desc) {
        return desc != null && "packed".equals(desc.getProperty("format")) && ProcessingStepHandler.canProcess((IArtifactDescriptor)desc);
    }

    private static void unpack(IArtifactRepository source, IArtifactRepository target, IArtifactDescriptor optimized, IArtifactDescriptor canonical, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, canonical, source, target);
        request.perform(source, monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    private static void unpackToSibling(IArtifactRepository target, IArtifactDescriptor optimized, IArtifactDescriptor canonical, boolean verifyOnly, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, canonical, target);
        request.perform(target, monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            if (verifyOnly) {
                target.removeDescriptor(MirrorGenerator.getArtifactDescriptor(target, canonical.getArtifactKey(), false));
            }
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    public MirrorGenerator(Builder builder) {
        super(builder);
    }

    public Set<IArtifactKey> getArtifactKeysToExclude() throws CoreException {
        Builder builder = this.getBuilder();
        Aggregator aggregator = builder.getAggregator();
        HashSet<IArtifactKey> keysToExclude = new HashSet<IArtifactKey>();
        EList contribs = aggregator.getContributions();
        for (Contribution contrib : contribs) {
            for (MappedRepository repo : contrib.getRepositories(true)) {
                if (repo.isMirrorArtifacts()) continue;
                for (IInstallableUnit iu : ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo).getInstallableUnits()) {
                    keysToExclude.addAll(iu.getArtifacts());
                }
            }
        }
        return keysToExclude;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        LogUtils.info((String)"Starting mirror generation", (Object[])new Object[0]);
        long start = TimeUtils.getNow();
        Builder builder = this.getBuilder();
        File destination = new File(builder.getBuildRoot(), "final");
        java.net.URI finalURI = Builder.createURI(destination);
        File aggregateDestination = new File(destination, "aggregate");
        java.net.URI aggregateURI = Builder.createURI(aggregateDestination);
        this.mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IMetadataRepositoryManager.class);
        this.arMgr = (IArtifactRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IArtifactRepositoryManager.class);
        this.arCache = null;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        boolean artifactErrors = false;
        try {
            String name;
            Object errors;
            MetadataRepository childMdr;
            IArtifactRepository tempAr;
            boolean isCleanBuild = builder.isCleanBuild();
            Aggregator aggregator = builder.getAggregator();
            subMon.setTaskName("Mirroring meta-data and artifacts...");
            MonitorUtils.subTask((IProgressMonitor)subMon, (String)"Initializing");
            IArtifactRepository aggregateAr = null;
            if (!isCleanBuild) {
                this.arMgr.removeRepository(finalURI);
                this.arMgr.removeRepository(aggregateURI);
                aggregateDestination.mkdirs();
                File[] fileArray = destination.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File oldLocation = fileArray[n2];
                    if (!oldLocation.equals(aggregateDestination)) {
                        if (oldLocation.equals(new File(destination, "compositeArtifacts.jar"))) {
                            if (!oldLocation.delete()) {
                                throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{oldLocation.getAbsolutePath()});
                            }
                        } else {
                            File newLocation = new File(aggregateDestination, oldLocation.getName());
                            oldLocation.renameTo(newLocation);
                            throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                        }
                    }
                    ++n2;
                }
                try {
                    aggregateAr = this.arMgr.loadRepository(aggregateURI, (IProgressMonitor)subMon.newChild(5));
                }
                catch (ProvisionException oldLocation) {
                    // empty catch block
                }
            }
            if (aggregateAr == null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("p2.compressed", Boolean.toString(true));
                properties.put("publishPackFilesAsSiblings", Boolean.toString(true));
                String label = builder.getAggregator().getLabel();
                aggregateAr = this.arMgr.createRepository(aggregateURI, String.valueOf(label) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            }
            MonitorUtils.worked((IProgressMonitor)subMon, (int)5);
            try {
                tempAr = this.arMgr.loadRepository(Builder.createURI(builder.getTempRepositoryFolder()), (IProgressMonitor)subMon.newChild(1));
            }
            catch (ProvisionException e) {
                tempAr = null;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("p2.compressed", Boolean.toString(true));
            String label = aggregator.getLabel();
            IMetadataRepository aggregateMdr = this.mdrMgr.createRepository(aggregateURI, label, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            MonitorUtils.worked((IProgressMonitor)subMon, (int)10);
            Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate();
            Set<IArtifactKey> keysToExclude = this.getArtifactKeysToExclude();
            SubMonitor childMonitor = subMon.newChild(900, 6);
            EList contribs = aggregator.getContributions(true);
            MonitorUtils.begin((IProgressMonitor)childMonitor, (int)(contribs.size() * 100 + 20));
            boolean aggregatedMdrIsEmpty = true;
            boolean aggregatedArIsEmpty = true;
            PackedStrategy packedStrategy = aggregator.getPackedStrategy();
            MavenRepositoryHelper mavenHelper = null;
            if (aggregator.isMavenResult()) {
                ArrayList<InstallableUnitMapping> iusToMaven = new ArrayList<InstallableUnitMapping>();
                for (Contribution contrib : contribs) {
                    SubMonitor contribMonitor = childMonitor.newChild(10);
                    EList repos = contrib.getRepositories(true);
                    ArrayList<String> errors2 = new ArrayList<String>();
                    MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                    for (MappedRepository repo : repos) {
                        if (!repo.isMirrorArtifacts()) {
                            errors2.add(String.format("Repository %s must be set to mirror artifacts if maven result is required", repo.getLocation()));
                            MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                            continue;
                        }
                        childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                        ArrayList<IInstallableUnit> iusToMirror = null;
                        for (IInstallableUnit iu : childMdr.getInstallableUnits()) {
                            if (!unitsToAggregate.contains(iu)) continue;
                            if (iusToMirror == null) {
                                iusToMirror = new ArrayList<IInstallableUnit>();
                            }
                            iusToMirror.add(iu);
                        }
                        EList allMavenMappings = contrib.getAllMavenMappings();
                        if (iusToMirror != null) {
                            for (IInstallableUnit iu : iusToMirror) {
                                iusToMaven.add(new InstallableUnitMapping(iu, (List)allMavenMappings));
                            }
                        }
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                    }
                    if (errors2.size() > 0) {
                        artifactErrors = true;
                        builder.sendEmail(contrib, errors2);
                    }
                    MonitorUtils.done((IProgressMonitor)contribMonitor);
                }
                mavenHelper = MavenManager.createMavenStructure(iusToMaven);
                if (!(aggregateAr instanceof SimpleArtifactRepository)) {
                    throw ExceptionUtils.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
                }
                SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
                simpleAr.setRules(mavenHelper.getMappingRules());
                simpleAr.initializeAfterLoad(aggregateURI);
                if (packedStrategy != PackedStrategy.SKIP && packedStrategy != PackedStrategy.UNPACK && packedStrategy != PackedStrategy.UNPACK_AS_SIBLING) {
                    packedStrategy = PackedStrategy.UNPACK_AS_SIBLING;
                    LogUtils.info((String)"Maven result is required, changing packed strategy from %s to %s", (Object[])new Object[]{aggregator.getPackedStrategy().getName(), packedStrategy.getName()});
                }
            } else {
                Object repos;
                ArrayList<String[]> mappingRules = new ArrayList<String[]>();
                ArrayList referencedArtifacts = new ArrayList();
                for (Contribution contrib : contribs) {
                    SubMonitor contribMonitor = childMonitor.newChild(10);
                    repos = contrib.getRepositories(true);
                    ArrayList<String> errors3 = new ArrayList<String>();
                    MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                    childMdr = repos.iterator();
                    while (childMdr.hasNext()) {
                        MappedRepository repo = (MappedRepository)childMdr.next();
                        int ticksRemaining = 100;
                        if ("p2".equals(repo.getNature())) {
                            MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                            continue;
                        }
                        MetadataRepository childMdr2 = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                        Object iusToRefer = null;
                        for (IInstallableUnit iu : childMdr2.getInstallableUnits()) {
                            if (!unitsToAggregate.contains(iu)) continue;
                            if (iusToRefer == null) {
                                iusToRefer = new ArrayList<IInstallableUnit>();
                            }
                            ((ArrayList)iusToRefer).add(iu);
                        }
                        if (iusToRefer != null) {
                            int ticks = 50;
                            IArtifactRepository ar = this.getArtifactRepository((MetadataRepositoryReference)repo, (IProgressMonitor)contribMonitor.newChild(ticks));
                            ticksRemaining -= ticks;
                            Iterator iterator = ((ArrayList)iusToRefer).iterator();
                            while (iterator.hasNext()) {
                                IInstallableUnit iu = (IInstallableUnit)iterator.next();
                                String versionString = iu.getVersion().getOriginal();
                                if (versionString == null) {
                                    versionString = iu.getVersion().toString();
                                }
                                String originalPath = iu.getProperty("original.path");
                                String originalId = iu.getProperty("original.id");
                                if (originalId == null) {
                                    originalId = iu.getId();
                                }
                                for (IArtifactKey key : iu.getArtifacts()) {
                                    if (repo.isMirrorArtifacts()) {
                                        String location = "${repoUrl}/non-p2/" + repo.getNature() + '/' + key.getClassifier() + '/' + (originalPath != null ? String.valueOf(originalPath) + '/' : "") + originalId + '_' + versionString + '.' + key.getClassifier();
                                        mappingRules.add(new String[]{"(& (classifier=" + IUUtils.encodeFilterValue((String)key.getClassifier()) + ") (id=" + IUUtils.encodeFilterValue((String)key.getId()) + ") (version=" + IUUtils.encodeFilterValue((String)iu.getVersion().toString()) + "))", location});
                                        continue;
                                    }
                                    IArtifactDescriptor[] iArtifactDescriptorArray = ar.getArtifactDescriptors(key);
                                    int n = iArtifactDescriptorArray.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        IArtifactDescriptor desc = iArtifactDescriptorArray[n3];
                                        String ref = ((SimpleArtifactDescriptor)desc).getRepositoryProperty("artifact.reference");
                                        SimpleArtifactDescriptor ad = new SimpleArtifactDescriptor(desc);
                                        ad.setRepositoryProperty("artifact.reference", ref);
                                        referencedArtifacts.add(ad);
                                        ++n3;
                                    }
                                }
                            }
                        }
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)ticksRemaining);
                    }
                    if (errors3.size() > 0) {
                        artifactErrors = true;
                        builder.sendEmail(contrib, errors3);
                    }
                    MonitorUtils.done((IProgressMonitor)contribMonitor);
                }
                if (aggregateAr instanceof SimpleArtifactRepository) {
                    SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
                    ArrayList ruleList = new ArrayList(Arrays.asList(simpleAr.getRules()));
                    ruleList.addAll(mappingRules);
                    simpleAr.setRules((String[][])ruleList.toArray((T[])new String[ruleList.size()][]));
                    simpleAr.initializeAfterLoad(aggregateURI);
                    repos = referencedArtifacts.iterator();
                    while (repos.hasNext()) {
                        IArtifactDescriptor ad = (IArtifactDescriptor)repos.next();
                        simpleAr.addDescriptor(ad);
                    }
                    simpleAr.save();
                    aggregatedArIsEmpty = false;
                } else {
                    throw ExceptionUtils.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
                }
            }
            for (Contribution contrib : contribs) {
                SubMonitor contribMonitor = childMonitor.newChild(100);
                EList repos = contrib.getRepositories(true);
                errors = new ArrayList();
                MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                for (MappedRepository repo : repos) {
                    String msg;
                    if (builder.isMapVerbatim(repo)) {
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                        continue;
                    }
                    MetadataRepository childMdr3 = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                    ArrayList<IInstallableUnit> iusToMirror = null;
                    ArrayList<IArtifactKey> keysToMirror = null;
                    for (IInstallableUnit iu : childMdr3.getInstallableUnits()) {
                        if (!unitsToAggregate.remove(iu)) continue;
                        if (iusToMirror == null) {
                            iusToMirror = new ArrayList<IInstallableUnit>();
                        }
                        iusToMirror.add(iu);
                        if (!repo.isMirrorArtifacts()) continue;
                        for (IArtifactKey ak : iu.getArtifacts()) {
                            if (!keysToExclude.add(ak)) continue;
                            if (keysToMirror == null) {
                                keysToMirror = new ArrayList<IArtifactKey>();
                            }
                            keysToMirror.add(ak);
                        }
                    }
                    if (iusToMirror != null) {
                        msg = String.format("Mirroring meta-data from from %s", childMdr3.getLocation());
                        LogUtils.info((String)msg, (Object[])new Object[0]);
                        contribMonitor.subTask(msg);
                        this.mirror(iusToMirror, childMdr3, aggregateMdr, (IProgressMonitor)contribMonitor.newChild(5, 6));
                        aggregatedMdrIsEmpty = false;
                    } else {
                        MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)5);
                    }
                    if (keysToMirror != null) {
                        msg = String.format("Mirroring artifacts from from %s", childMdr3.getLocation());
                        LogUtils.info((String)msg, (Object[])new Object[0]);
                        contribMonitor.subTask(msg);
                        IArtifactRepository childAr = this.getArtifactRepository((MetadataRepositoryReference)repo, (IProgressMonitor)contribMonitor.newChild(1, 6));
                        MirrorGenerator.mirror(keysToMirror, tempAr, childAr, aggregateAr, packedStrategy, (List<String>)errors, (IProgressMonitor)contribMonitor.newChild(94, 6));
                        aggregatedArIsEmpty = false;
                        continue;
                    }
                    MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)95);
                }
                if (errors.size() > 0) {
                    artifactErrors = true;
                    builder.sendEmail(contrib, (List<String>)errors);
                }
                MonitorUtils.done((IProgressMonitor)contribMonitor);
            }
            List<IInstallableUnit> categories = builder.getCategoryIUs();
            if (!categories.isEmpty()) {
                this.mirror(categories, null, aggregateMdr, (IProgressMonitor)childMonitor.newChild(20));
                aggregatedMdrIsEmpty = false;
            }
            errors = new String[]{"compositeArtifacts.jar", "compositeContent.jar", "content.jar", "artifacts.jar"};
            int repos = ((String[])errors).length;
            int contribMonitor = 0;
            while (contribMonitor < repos) {
                String fileName = errors[contribMonitor];
                File file = new File(destination, fileName);
                if (file.exists() && !file.delete()) {
                    throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                ++contribMonitor;
            }
            MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
            ArrayList<MappedRepository> reposWithReferencedArtifacts = new ArrayList<MappedRepository>();
            ArrayList<MappedRepository> reposWithReferencedMetadata = new ArrayList<MappedRepository>();
            for (Contribution contrib : aggregator.getContributions(true)) {
                for (MappedRepository repo : contrib.getRepositories(true)) {
                    if (builder.isMapVerbatim(repo)) {
                        reposWithReferencedArtifacts.add(repo);
                        reposWithReferencedMetadata.add(repo);
                        continue;
                    }
                    if (repo.isMirrorArtifacts() || !"p2".equals(repo.getNature())) continue;
                    reposWithReferencedArtifacts.add(repo);
                }
            }
            if (mavenHelper != null) {
                LogUtils.info((String)"Adding maven metadata", (Object[])new Object[0]);
                MavenManager.saveMetadata((URI)URI.createFileURI((String)aggregateDestination.getAbsolutePath()), (InstallableUnitMapping)mavenHelper.getTop());
                IMaven2Indexer indexer = IndexerUtils.getIndexer((String)"nexus");
                if (indexer != null) {
                    LogUtils.info((String)"Adding maven index", (Object[])new Object[0]);
                    indexer.updateLocalIndex(new File(aggregateDestination.getAbsolutePath()).toURI(), false);
                }
                MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
                LogUtils.info((String)"Done adding maven metadata", (Object[])new Object[0]);
            }
            if (reposWithReferencedMetadata.isEmpty()) {
                LogUtils.info((String)"Making the aggregated metadata repository final at %s", (Object[])new Object[]{finalURI});
                File oldLocation = new File(aggregateDestination, "content.jar");
                File newLocation = new File(destination, oldLocation.getName());
                if (!oldLocation.renameTo(newLocation)) {
                    throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                }
                this.mdrMgr.removeRepository(aggregateURI);
            } else {
                LogUtils.info((String)"Building final metadata composite at %s", (Object[])new Object[]{finalURI});
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                name = builder.getAggregator().getLabel();
                this.mdrMgr.removeRepository(finalURI);
                CompositeMetadataRepository compositeMdr = (CompositeMetadataRepository)this.mdrMgr.createRepository(finalURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
                for (MappedRepository referenced : reposWithReferencedMetadata) {
                    compositeMdr.addChild(referenced.getMetadataRepository().getLocation());
                }
                if (aggregatedMdrIsEmpty) {
                    this.mdrMgr.removeRepository(aggregateURI);
                    File mdrFile = new File(aggregateDestination, "content.jar");
                    if (!mdrFile.delete()) {
                        throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{aggregateDestination.getAbsolutePath()});
                    }
                } else {
                    compositeMdr.addChild(finalURI.relativize(aggregateURI));
                }
                LogUtils.info((String)"Done building final metadata composite", (Object[])new Object[0]);
            }
            MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
            if (reposWithReferencedArtifacts.isEmpty()) {
                LogUtils.info((String)"Making the aggregated artifact repository final at %s", (Object[])new Object[]{finalURI});
                String[] stringArray = aggregateDestination.list();
                int mdrFile = stringArray.length;
                int compositeMdr = 0;
                while (compositeMdr < mdrFile) {
                    File newLocation;
                    File oldLocation;
                    name = stringArray[compositeMdr];
                    if (!"content.jar".equals(name) && !(oldLocation = new File(aggregateDestination, name)).renameTo(newLocation = new File(destination, name))) {
                        throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                    }
                    ++compositeMdr;
                }
                this.arMgr.removeRepository(aggregateURI);
            } else {
                LogUtils.info((String)"Building final artifact composite at %s", (Object[])new Object[]{finalURI});
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                name = builder.getAggregator().getLabel();
                this.arMgr.removeRepository(finalURI);
                CompositeArtifactRepository compositeAr = (CompositeArtifactRepository)this.arMgr.createRepository(finalURI, String.valueOf(name) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
                for (MappedRepository referenced : reposWithReferencedArtifacts) {
                    compositeAr.addChild(referenced.getMetadataRepository().getLocation());
                }
                if (aggregatedArIsEmpty) {
                    this.arMgr.removeRepository(aggregateURI);
                    File arFile = new File(aggregateDestination, "artifacts.jar");
                    if (!arFile.delete()) {
                        throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{arFile.getAbsolutePath()});
                    }
                } else {
                    compositeAr.addChild(finalURI.relativize(aggregateURI));
                }
                LogUtils.info((String)"Done building final artifact composite", (Object[])new Object[0]);
            }
            String[] content = aggregateDestination.list();
            if (content != null && content.length == 0 && !aggregateDestination.delete()) {
                throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{aggregateDestination.getAbsolutePath()});
            }
            MonitorUtils.done((IProgressMonitor)childMonitor);
        }
        finally {
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), (IRepositoryManager)this.mdrMgr);
            this.mdrMgr = null;
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), (IRepositoryManager)this.arMgr);
            this.arMgr = null;
            MonitorUtils.done((IProgressMonitor)subMon);
        }
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (artifactErrors) {
            throw ExceptionUtils.fromMessage((String)"Not all artifacts could be mirrored, see log for details", (Object[])new Object[0]);
        }
    }

    private IArtifactRepository getArtifactRepository(MetadataRepositoryReference repo, IProgressMonitor monitor) throws CoreException {
        IArtifactRepository ar;
        if (this.arCache == null) {
            this.arCache = new HashMap<MetadataRepositoryReference, IArtifactRepository>();
        }
        if ((ar = this.arCache.get(repo)) == null) {
            IConfigurationElement config = RepositoryLoaderUtils.getLoaderFor((String)repo.getNature());
            if (config == null) {
                throw ExceptionUtils.fromMessage((String)"No loader for %s", (Object[])new Object[]{repo.getNature()});
            }
            IRepositoryLoader repoLoader = (IRepositoryLoader)config.createExecutableExtension("class");
            ar = repoLoader.getArtifactRepository((IMetadataRepository)ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo), monitor);
            this.arCache.put(repo, ar);
        }
        return ar;
    }

    private void mirror(List<IInstallableUnit> iusToMirror, MetadataRepository source, IMetadataRepository dest, IProgressMonitor monitor) throws CoreException {
        dest.addInstallableUnits(iusToMirror);
        Builder builder = this.getBuilder();
        if (source != null && builder.isMirrorReferences()) {
            ArrayList<RepositoryReference> refs = new ArrayList<RepositoryReference>();
            for (IRepositoryReference ref : source.getReferences()) {
                String refType;
                java.net.URI location = ref.getLocation();
                String refKey = location.toString();
                String string = refType = ref.getType() == 0 ? "meta-data" : "artifacts";
                if (!builder.isMatchedReference(refKey)) {
                    LogUtils.debug((String)"- %s reference %s was ruled out by inclusion/exclusion patterns", (Object[])new Object[]{refType, refKey});
                    continue;
                }
                if (refKey.endsWith("/site.xml")) {
                    location = java.net.URI.create(refKey.substring(0, refKey.length() - 8));
                }
                LogUtils.debug((String)"- mirroring %s reference %s", (Object[])new Object[]{refType, refKey});
                refs.add(new RepositoryReference(location, ref.getNickname(), ref.getType(), 0));
            }
            dest.addReferences(refs);
        }
    }

    private static class CanonicalizeRequest
    extends MirrorRequest {
        private IArtifactDescriptor optimizedDescriptor;
        private IArtifactDescriptor canonicalDescriptor;

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactDescriptor canonicalDescriptor, IArtifactRepository targetRepository) {
            this(optimizedDescriptor, canonicalDescriptor, targetRepository, targetRepository);
        }

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactDescriptor canonicalDescriptor, IArtifactRepository sourceRepository, IArtifactRepository targetRepository) {
            super(canonicalDescriptor.getArtifactKey(), targetRepository, null, null);
            this.optimizedDescriptor = optimizedDescriptor;
            this.canonicalDescriptor = canonicalDescriptor;
            this.setSourceRepository(sourceRepository);
        }

        public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
            this.setSourceRepository(sourceRepository);
            this.setResult(this.transfer(this.canonicalDescriptor, this.optimizedDescriptor, monitor));
        }
    }
}

