/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.ExclusionRule;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.ValidConfigurationsRule;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.util.ItemUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIUsToParentRepositoryCommand
extends AbstractCommand {
    private Aggregator aggregator;
    private List<IInstallableUnit> selectedIUs;
    private int operation;
    private Map<IInstallableUnit, MappedRepository> mapIUMappedRepo = new HashMap<IInstallableUnit, MappedRepository>();
    private Map<MappedRepository, List<MappedUnit>> unitsAddedToMappedRepo = new HashMap<MappedRepository, List<MappedUnit>>();
    private Map<MappedRepository, List<MapRule>> rulesAddedToMappedRepo = new HashMap<MappedRepository, List<MapRule>>();

    public AddIUsToParentRepositoryCommand(Aggregator aggregator, List<IInstallableUnit> selectedIUs, int operation) {
        super(AggregatorEditPlugin.INSTANCE.getString("_UI_Add_to_parent_Mapped_Repository"));
        this.aggregator = aggregator;
        this.selectedIUs = selectedIUs;
        this.operation = operation;
    }

    public void execute() {
        this.unitsAddedToMappedRepo.clear();
        this.rulesAddedToMappedRepo.clear();
        for (IInstallableUnit iu : this.selectedIUs) {
            MapRule rule;
            MappedRepository repo = this.mapIUMappedRepo.get(iu);
            if (!repo.isEnabled()) continue;
            if ((this.operation & 0x20) > 0) {
                MappedUnit unit = ItemUtils.findMappedUnit(repo, iu);
                if (unit != null) continue;
                unit = AggregatorFactory.eINSTANCE.createMappedUnit(iu);
                repo.addUnit(unit);
                List<MappedUnit> units = this.unitsAddedToMappedRepo.get(repo);
                if (units == null) {
                    units = new ArrayList<MappedUnit>();
                    this.unitsAddedToMappedRepo.put(repo, units);
                }
                units.add(unit);
                continue;
            }
            if ((this.operation & 0xC0) <= 0 || (rule = ItemUtils.findMapRule(repo, iu)) != null) continue;
            rule = AggregatorFactory.eINSTANCE.createMapRule(iu, (this.operation & 0x40) > 0 ? ExclusionRule.class : ValidConfigurationsRule.class);
            repo.getMapRules().add((Object)rule);
            List<MapRule> rules = this.rulesAddedToMappedRepo.get(repo);
            if (rules == null) {
                rules = new ArrayList<MapRule>();
                this.rulesAddedToMappedRepo.put(repo, rules);
            }
            rules.add(rule);
        }
    }

    public void redo() {
        for (MappedRepository mappedRepo : this.unitsAddedToMappedRepo.keySet()) {
            for (MappedUnit unit : this.unitsAddedToMappedRepo.get(mappedRepo)) {
                mappedRepo.removeUnit(unit);
            }
            for (MapRule rule : this.rulesAddedToMappedRepo.get(mappedRepo)) {
                mappedRepo.getMapRules().remove((Object)rule);
            }
        }
    }

    protected boolean prepare() {
        boolean someEnabled = false;
        for (IInstallableUnit iu : this.selectedIUs) {
            if (!(((EObject)iu).eContainer() instanceof MetadataRepository)) {
                return false;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
            MappedRepository mappedRepo = ItemUtils.findMappedRepository(this.aggregator, mdr);
            if (mappedRepo == null) continue;
            if (ItemUtils.findMappedUnit(mappedRepo, iu) != null || ItemUtils.findMapRule(mappedRepo, iu) != null) {
                return false;
            }
            this.mapIUMappedRepo.put(iu, mappedRepo);
            boolean bl = someEnabled = someEnabled || mappedRepo.isBranchEnabled();
        }
        return this.mapIUMappedRepo.size() > 0 && someEnabled;
    }
}

