/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.engine.maven.InstallableUnitMapping;
import org.eclipse.b3.aggregator.engine.maven.MavenManager;
import org.eclipse.b3.aggregator.engine.maven.MavenRepositoryHelper;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.p2.loader.IRepositoryLoader;
import org.eclipse.b3.p2.maven.indexer.IMaven2Indexer;
import org.eclipse.b3.p2.maven.indexer.IndexerUtils;
import org.eclipse.b3.p2.util.IUUtils;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.p2.util.RepositoryLoaderUtils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.IOUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorGenerator
extends BuilderPhase {
    private IMetadataRepositoryManager mdrMgr = null;
    private IArtifactRepositoryManager arMgr = null;
    private Map<MetadataRepositoryReference, IArtifactRepository> arCache;

    static void mirror(Collection<IArtifactKey> keysToInstall, IArtifactRepository cache, IArtifactRepository source, IFileArtifactRepository dest, PackedStrategy strategy, List<String> errors, IProgressMonitor monitor) {
        IQueryResult result = source.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        IArtifactKey[] keys = (IArtifactKey[])result.toArray(IArtifactKey.class);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(keys.length * 100));
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            boolean found = false;
            Iterator<IArtifactKey> keyIterator = keysToInstall.iterator();
            while (keyIterator.hasNext()) {
                IArtifactKey keyToInstall = keyIterator.next();
                if (!keyToInstall.equals(key)) continue;
                found = true;
                keyIterator.remove();
                break;
            }
            if (found) {
                LogUtils.info((String)"- mirroring artifact %s", (Object[])new Object[]{key});
                IArtifactRepository sourceForCopy = cache != null && cache.contains(key) ? cache : source;
                PackedStrategy keyStrategy = !"osgi.bundle".equals(key.getClassifier()) ? PackedStrategy.SKIP : strategy;
                try {
                    IArtifactDescriptor[] aDescs = sourceForCopy.getArtifactDescriptors(key);
                    IArtifactDescriptor optimized = null;
                    IArtifactDescriptor canonical = null;
                    IArtifactDescriptor[] iArtifactDescriptorArray = aDescs;
                    int n3 = aDescs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArtifactDescriptor desc = iArtifactDescriptorArray[n4];
                        if (MirrorGenerator.isPacked(desc)) {
                            optimized = desc;
                        } else {
                            canonical = desc;
                        }
                        ++n4;
                    }
                    if (optimized == null && canonical == null) {
                        throw ExceptionUtils.fromMessage((String)"Found no usable descriptor for artifact %s in repository %s", (Object[])new Object[]{key, dest.getLocation()});
                    }
                    if (keyStrategy == PackedStrategy.SKIP && canonical == null) {
                        LogUtils.warning((String)"    canonical artifact unavailable, using optimized one instead", (Object[])new Object[0]);
                        keyStrategy = PackedStrategy.COPY;
                    } else if (keyStrategy != PackedStrategy.SKIP && optimized == null) {
                        keyStrategy = PackedStrategy.SKIP;
                    }
                    switch (keyStrategy) {
                        case SKIP: {
                            if (!MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, false)) {
                                LogUtils.debug((String)"    doing copy of canonical artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, (IArtifactRepository)dest, canonical, (IArtifactDescriptor)new ArtifactDescriptor(canonical), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        case COPY: {
                            if (!MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, true)) {
                                LogUtils.debug((String)"    doing copy of optimized artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, (IArtifactRepository)dest, optimized, (IArtifactDescriptor)new ArtifactDescriptor(optimized), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            break;
                        }
                        default: {
                            boolean isVerify;
                            if (keyStrategy == PackedStrategy.UNPACK) {
                                if (!MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, false)) {
                                    LogUtils.debug((String)"    doing copy of optimized artifact into canonical target", (Object[])new Object[0]);
                                    MirrorGenerator.unpack(sourceForCopy, dest, optimized, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                                }
                                break;
                            }
                            boolean bl = isVerify = keyStrategy == PackedStrategy.VERIFY;
                            if (MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, true)) {
                                if (isVerify) {
                                    break;
                                }
                            } else {
                                LogUtils.debug((String)"    doing copy of optimized artifact", (Object[])new Object[0]);
                                MirrorGenerator.mirror(sourceForCopy, (IArtifactRepository)dest, optimized, (IArtifactDescriptor)new ArtifactDescriptor(optimized), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                            }
                            if (isVerify) {
                                LogUtils.debug((String)"    unpacking optimized artifact for verification", (Object[])new Object[0]);
                            } else {
                                if (MirrorGenerator.checkIfTargetPresent((IArtifactRepository)dest, key, false)) break;
                                LogUtils.debug((String)"    unpacking optimized artifact", (Object[])new Object[0]);
                            }
                            MirrorGenerator.unpackToSibling(dest, MirrorGenerator.getArtifactDescriptor((IArtifactRepository)dest, key, true), isVerify, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    LogUtils.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    errors.add(Builder.getExceptionMessages(e));
                    dest.removeDescriptor(key);
                }
            }
            ++n2;
        }
        for (IArtifactKey key : keysToInstall) {
            String msg = "Artifact " + key + " could not be found in the artifact repository (" + source.getLocation() + ")";
            LogUtils.error((String)msg, (Object[])new Object[0]);
            errors.add(msg);
        }
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    static IArtifactDescriptor mirror(IArtifactRepository source, IArtifactRepository dest, IArtifactDescriptor sourceDesc, IArtifactDescriptor targetDesc, IProgressMonitor monitor) throws CoreException {
        if (dest.contains(targetDesc)) {
            return targetDesc;
        }
        RawMirrorRequest request = new RawMirrorRequest(sourceDesc, targetDesc, dest);
        request.perform(source, monitor);
        IStatus result = request.getResult();
        switch (result.getSeverity()) {
            case 1: {
                LogUtils.info((String)result.getMessage(), (Object[])new Object[0]);
            }
            case 0: {
                if (MirrorGenerator.getArtifactDescriptor(dest, targetDesc.getArtifactKey(), MirrorGenerator.isPacked(targetDesc)) != null) {
                    return targetDesc;
                }
                result = new Status(4, "org.eclipse.b3.aggregator.engine", "Zero bytes copied");
                break;
            }
            case 8: {
                LogUtils.warning((String)"Aggregation cancelled while mirroring artifact %s", (Object[])new Object[]{sourceDesc.getArtifactKey()});
                throw new OperationCanceledException();
            }
            default: {
                if (result.getCode() == 1201) {
                    LogUtils.warning((String)"  copy failed. Artifact %s is already present", (Object[])new Object[]{sourceDesc.getArtifactKey()});
                    return targetDesc;
                }
                result = MirrorGenerator.extractRootCause(result);
            }
        }
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to mirror artifact %s from repository %s: %s", (Object[])new Object[]{sourceDesc.getArtifactKey(), source.getLocation(), result.getMessage()});
    }

    private static boolean checkIfTargetPresent(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor found = MirrorGenerator.getArtifactDescriptor(destination, key, packed);
        if (found != null) {
            LogUtils.debug((String)"    %s artifact is already present", (Object[])new Object[]{packed ? "optimized" : "canonical"});
            return true;
        }
        return false;
    }

    private static IStatus extractDeeperRootCause(IStatus status) {
        IStatus deeper;
        Throwable t;
        if (status == null) {
            return null;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus deeper2 = MirrorGenerator.extractDeeperRootCause(children[i]);
                if (deeper2 != null) {
                    return deeper2;
                }
                ++i;
            }
        }
        if ((t = status.getException()) instanceof CoreException && (deeper = MirrorGenerator.extractDeeperRootCause(((CoreException)t).getStatus())) != null) {
            return deeper;
        }
        return status.getSeverity() == 4 ? status : null;
    }

    private static IStatus extractRootCause(IStatus status) {
        IStatus rootCause = MirrorGenerator.extractDeeperRootCause(status);
        return rootCause == null ? status : rootCause;
    }

    private static IArtifactDescriptor getArtifactDescriptor(IArtifactRepository destination, IArtifactKey key, boolean packed) {
        IArtifactDescriptor[] iArtifactDescriptorArray = destination.getArtifactDescriptors(key);
        int n = iArtifactDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor candidate = iArtifactDescriptorArray[n2];
            if (MirrorGenerator.isPacked(candidate) ? packed : !packed) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isPacked(IArtifactDescriptor desc) {
        return desc != null && "packed".equals(desc.getProperty("format")) && ProcessingStepHandler.canProcess((IArtifactDescriptor)desc);
    }

    private static void unpack(IArtifactRepository source, IFileArtifactRepository target, IArtifactDescriptor optimized, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, source, target);
        request.perform(source, monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    private static void unpackToSibling(IFileArtifactRepository target, IArtifactDescriptor optimized, boolean verifyOnly, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, target);
        request.perform((IArtifactRepository)target, monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            if (verifyOnly) {
                target.removeDescriptor(MirrorGenerator.getArtifactDescriptor((IArtifactRepository)target, optimized.getArtifactKey(), false));
            }
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        throw ExceptionUtils.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    public MirrorGenerator(Builder builder) {
        super(builder);
    }

    public Set<IArtifactKey> getArtifactKeysToExclude() throws CoreException {
        Builder builder = this.getBuilder();
        Aggregator aggregator = builder.getAggregator();
        HashSet<IArtifactKey> keysToExclude = new HashSet<IArtifactKey>();
        EList contribs = aggregator.getContributions();
        for (Contribution contrib : contribs) {
            for (MappedRepository repo : contrib.getRepositories(true)) {
                if (repo.isMirrorArtifacts()) continue;
                for (IInstallableUnit iu : ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo).getInstallableUnits()) {
                    keysToExclude.addAll(iu.getArtifacts());
                }
            }
        }
        return keysToExclude;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        LogUtils.info((String)"Starting mirror generation", (Object[])new Object[0]);
        long start = TimeUtils.getNow();
        Builder builder = this.getBuilder();
        File destination = new File(builder.getBuildRoot(), "final");
        java.net.URI finalURI = Builder.createURI(destination);
        File aggregateDestination = new File(destination, "aggregate");
        java.net.URI aggregateURI = Builder.createURI(aggregateDestination);
        this.mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IMetadataRepositoryManager.class);
        this.arMgr = (IArtifactRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), IArtifactRepositoryManager.class);
        this.arCache = null;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        boolean artifactErrors = false;
        try {
            String name;
            void var31_44;
            MetadataRepository childMdr;
            IArtifactRepository tempAr;
            boolean isCleanBuild = builder.isCleanBuild();
            Aggregator aggregator = builder.getAggregator();
            subMon.setTaskName("Mirroring meta-data and artifacts...");
            MonitorUtils.subTask((IProgressMonitor)subMon, (String)"Initializing");
            IFileArtifactRepository aggregateAr = null;
            if (!isCleanBuild) {
                this.arMgr.removeRepository(finalURI);
                this.arMgr.removeRepository(aggregateURI);
                aggregateDestination.mkdirs();
                File[] fileArray = destination.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File oldLocation = fileArray[n2];
                    if (!oldLocation.equals(aggregateDestination)) {
                        if (oldLocation.equals(new File(destination, "compositeArtifacts.jar"))) {
                            if (!oldLocation.delete()) {
                                throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{oldLocation.getAbsolutePath()});
                            }
                        } else {
                            File newLocation = new File(aggregateDestination, oldLocation.getName());
                            oldLocation.renameTo(newLocation);
                            throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                        }
                    }
                    ++n2;
                }
                try {
                    aggregateAr = (IFileArtifactRepository)this.arMgr.loadRepository(aggregateURI, (IProgressMonitor)subMon.newChild(5));
                }
                catch (ProvisionException oldLocation) {
                    // empty catch block
                }
            }
            if (aggregateAr == null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("p2.compressed", Boolean.toString(true));
                properties.put("publishPackFilesAsSiblings", Boolean.toString(true));
                String label = builder.getAggregator().getLabel();
                aggregateAr = (IFileArtifactRepository)this.arMgr.createRepository(aggregateURI, String.valueOf(label) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            }
            MonitorUtils.worked((IProgressMonitor)subMon, (int)5);
            try {
                tempAr = this.arMgr.loadRepository(Builder.createURI(builder.getTempRepositoryFolder()), (IProgressMonitor)subMon.newChild(1));
            }
            catch (ProvisionException e) {
                tempAr = null;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("p2.compressed", Boolean.toString(true));
            String label = aggregator.getLabel();
            IMetadataRepository aggregateMdr = this.mdrMgr.createRepository(aggregateURI, label, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            MonitorUtils.worked((IProgressMonitor)subMon, (int)10);
            Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate();
            Set<IArtifactKey> keysToExclude = this.getArtifactKeysToExclude();
            SubMonitor childMonitor = subMon.newChild(900, 6);
            EList contribs = aggregator.getContributions(true);
            MonitorUtils.begin((IProgressMonitor)childMonitor, (int)(contribs.size() * 100 + 20));
            boolean aggregatedMdrIsEmpty = true;
            boolean aggregatedArIsEmpty = true;
            PackedStrategy packedStrategy = aggregator.getPackedStrategy();
            MavenRepositoryHelper mavenHelper = null;
            if (aggregator.isMavenResult()) {
                HashSet<IInstallableUnit> copyOfUnitsToAggregate = new HashSet<IInstallableUnit>(unitsToAggregate);
                ArrayList<InstallableUnitMapping> iusToMaven = new ArrayList<InstallableUnitMapping>();
                for (Contribution contrib : contribs) {
                    SubMonitor contribMonitor2 = childMonitor.newChild(10);
                    EList eList = contrib.getRepositories(true);
                    ArrayList<String> errors2 = new ArrayList<String>();
                    MonitorUtils.begin((IProgressMonitor)contribMonitor2, (int)(eList.size() * 100));
                    for (MappedRepository mappedRepository : eList) {
                        if (!mappedRepository.isMirrorArtifacts()) {
                            String msg = String.format("Repository %s must be set to mirror artifacts if maven result is required", mappedRepository.getLocation());
                            LogUtils.error((String)msg, (Object[])new Object[0]);
                            errors2.add(msg);
                            MonitorUtils.worked((IProgressMonitor)contribMonitor2, (int)100);
                            continue;
                        }
                        MetadataRepository childMdr2 = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)mappedRepository);
                        ArrayList<IInstallableUnit> iusToMirror = null;
                        for (IInstallableUnit iu : childMdr2.getInstallableUnits()) {
                            if (!copyOfUnitsToAggregate.remove(iu)) continue;
                            if (iusToMirror == null) {
                                iusToMirror = new ArrayList<IInstallableUnit>();
                            }
                            iusToMirror.add(iu);
                        }
                        EList allMavenMappings = contrib.getAllMavenMappings();
                        if (iusToMirror != null) {
                            for (IInstallableUnit iu : iusToMirror) {
                                iusToMaven.add(new InstallableUnitMapping(contrib, iu, (List)allMavenMappings));
                            }
                        }
                        MonitorUtils.worked((IProgressMonitor)contribMonitor2, (int)100);
                    }
                    if (errors2.size() > 0) {
                        artifactErrors = true;
                        builder.sendEmail(contrib, errors2);
                        throw ExceptionUtils.fromMessage((String)"All repositories must be set to mirror artifacts if maven result is required", (Object[])new Object[0]);
                    }
                    MonitorUtils.done((IProgressMonitor)contribMonitor2);
                }
                mavenHelper = MavenManager.createMavenStructure(iusToMaven);
                if (!(aggregateAr instanceof SimpleArtifactRepository)) {
                    throw ExceptionUtils.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
                }
                SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
                simpleAr.setRules(mavenHelper.getMappingRules());
                simpleAr.initializeAfterLoad(aggregateURI);
                if (packedStrategy != PackedStrategy.SKIP && packedStrategy != PackedStrategy.UNPACK && packedStrategy != PackedStrategy.UNPACK_AS_SIBLING) {
                    packedStrategy = PackedStrategy.UNPACK_AS_SIBLING;
                    LogUtils.info((String)"Maven result is required, changing packed strategy from %s to %s", (Object[])new Object[]{aggregator.getPackedStrategy().getName(), packedStrategy.getName()});
                }
            }
            ArrayList<String[]> mappingRules = new ArrayList<String[]>();
            ArrayList<SimpleArtifactDescriptor> referencedArtifacts = new ArrayList<SimpleArtifactDescriptor>();
            HashSet<IInstallableUnit> copyOfUnitsToAggregate = null;
            for (Contribution contrib : contribs) {
                SubMonitor subMonitor = childMonitor.newChild(10);
                EList repos = contrib.getRepositories(true);
                MonitorUtils.begin((IProgressMonitor)subMonitor, (int)(repos.size() * 100));
                Iterator iterator = repos.iterator();
                while (iterator.hasNext()) {
                    MappedRepository mappedRepository = (MappedRepository)iterator.next();
                    int ticksRemaining = 100;
                    if ("p2".equals(mappedRepository.getNature())) {
                        MonitorUtils.worked((IProgressMonitor)subMonitor, (int)100);
                        continue;
                    }
                    if (copyOfUnitsToAggregate == null) {
                        copyOfUnitsToAggregate = new HashSet<IInstallableUnit>(unitsToAggregate);
                    }
                    childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)mappedRepository);
                    ArrayList<IInstallableUnit> iusToRefer = null;
                    for (IInstallableUnit iu : childMdr.getInstallableUnits()) {
                        if (!copyOfUnitsToAggregate.remove(iu)) continue;
                        if (iusToRefer == null) {
                            iusToRefer = new ArrayList<IInstallableUnit>();
                        }
                        iusToRefer.add(iu);
                    }
                    if (iusToRefer != null) {
                        int ticks = 50;
                        IArtifactRepository ar = this.getArtifactRepository((MetadataRepositoryReference)mappedRepository, (IProgressMonitor)subMonitor.newChild(ticks));
                        ticksRemaining -= ticks;
                        for (IInstallableUnit iInstallableUnit : iusToRefer) {
                            String versionString = iInstallableUnit.getVersion().getOriginal();
                            if (versionString == null) {
                                versionString = iInstallableUnit.getVersion().toString();
                            }
                            String originalPath = iInstallableUnit.getProperty("original.path");
                            String originalId = iInstallableUnit.getProperty("original.id");
                            if (originalId == null) {
                                originalId = iInstallableUnit.getId();
                            }
                            for (IArtifactKey key : iInstallableUnit.getArtifacts()) {
                                if (mappedRepository.isMirrorArtifacts()) {
                                    String location = "${repoUrl}/non-p2/" + mappedRepository.getNature() + '/' + key.getClassifier() + '/' + (originalPath != null ? String.valueOf(originalPath) + '/' : "") + originalId + '_' + versionString + '.' + key.getClassifier();
                                    mappingRules.add(new String[]{"(& (classifier=" + IUUtils.encodeFilterValue((String)key.getClassifier()) + ") (id=" + IUUtils.encodeFilterValue((String)key.getId()) + ") (version=" + IUUtils.encodeFilterValue((String)iInstallableUnit.getVersion().toString()) + "))", location});
                                    continue;
                                }
                                IArtifactDescriptor[] iArtifactDescriptorArray = ar.getArtifactDescriptors(key);
                                int n = iArtifactDescriptorArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
                                    String ref = ((SimpleArtifactDescriptor)desc).getRepositoryProperty("artifact.reference");
                                    SimpleArtifactDescriptor ad = new SimpleArtifactDescriptor(desc);
                                    ad.setRepositoryProperty("artifact.reference", ref);
                                    referencedArtifacts.add(ad);
                                    ++n2;
                                }
                            }
                        }
                    }
                    MonitorUtils.worked((IProgressMonitor)subMonitor, (int)ticksRemaining);
                }
                MonitorUtils.done((IProgressMonitor)subMonitor);
            }
            if (mappingRules.size() > 0 || referencedArtifacts.size() > 0) {
                if (aggregateAr instanceof SimpleArtifactRepository) {
                    SimpleArtifactRepository simpleAr = (SimpleArtifactRepository)aggregateAr;
                    ArrayList ruleList = new ArrayList(Arrays.asList(simpleAr.getRules()));
                    ruleList.addAll(mappingRules);
                    simpleAr.setRules((String[][])ruleList.toArray((T[])new String[ruleList.size()][]));
                    simpleAr.initializeAfterLoad(aggregateURI);
                    for (IArtifactDescriptor iArtifactDescriptor : referencedArtifacts) {
                        simpleAr.addDescriptor(iArtifactDescriptor);
                    }
                    simpleAr.save();
                    aggregatedArIsEmpty = false;
                } else {
                    throw ExceptionUtils.fromMessage((String)"Unexpected repository implementation: Expected %s, found %s", (Object[])new Object[]{SimpleArtifactRepository.class.getName(), aggregateAr.getClass().getName()});
                }
            }
            for (Contribution contrib : contribs) {
                SubMonitor subMonitor = childMonitor.newChild(100);
                EList repos3 = contrib.getRepositories(true);
                ArrayList<String> arrayList = new ArrayList<String>();
                MonitorUtils.begin((IProgressMonitor)subMonitor, (int)(repos3.size() * 100));
                for (MappedRepository mappedRepository : repos3) {
                    String msg;
                    if (builder.isMapVerbatim(mappedRepository)) {
                        MonitorUtils.worked((IProgressMonitor)subMonitor, (int)100);
                        continue;
                    }
                    childMdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)mappedRepository);
                    ArrayList<IInstallableUnit> iusToMirror = null;
                    ArrayList<IArtifactKey> keysToMirror = null;
                    for (IInstallableUnit iu : childMdr.getInstallableUnits()) {
                        if (!unitsToAggregate.remove(iu)) continue;
                        if (iusToMirror == null) {
                            iusToMirror = new ArrayList<IInstallableUnit>();
                        }
                        iusToMirror.add(iu);
                        if (!mappedRepository.isMirrorArtifacts()) continue;
                        for (IArtifactKey ak : iu.getArtifacts()) {
                            if (!keysToExclude.add(ak)) continue;
                            if (keysToMirror == null) {
                                keysToMirror = new ArrayList<IArtifactKey>();
                            }
                            keysToMirror.add(ak);
                        }
                    }
                    if (iusToMirror != null) {
                        msg = String.format("Mirroring meta-data from from %s", childMdr.getLocation());
                        LogUtils.info((String)msg, (Object[])new Object[0]);
                        subMonitor.subTask(msg);
                        this.mirror(iusToMirror, childMdr, aggregateMdr, (IProgressMonitor)subMonitor.newChild(5, 6));
                        aggregatedMdrIsEmpty = false;
                    } else {
                        MonitorUtils.worked((IProgressMonitor)subMonitor, (int)5);
                    }
                    if (keysToMirror != null) {
                        msg = String.format("Mirroring artifacts from from %s", childMdr.getLocation());
                        LogUtils.info((String)msg, (Object[])new Object[0]);
                        subMonitor.subTask(msg);
                        IArtifactRepository iArtifactRepository = this.getArtifactRepository((MetadataRepositoryReference)mappedRepository, (IProgressMonitor)subMonitor.newChild(1, 6));
                        MirrorGenerator.mirror(keysToMirror, tempAr, iArtifactRepository, aggregateAr, packedStrategy, arrayList, (IProgressMonitor)subMonitor.newChild(94, 6));
                        aggregatedArIsEmpty = false;
                        continue;
                    }
                    MonitorUtils.worked((IProgressMonitor)subMonitor, (int)95);
                }
                if (arrayList.size() > 0) {
                    artifactErrors = true;
                    builder.sendEmail(contrib, arrayList);
                }
                MonitorUtils.done((IProgressMonitor)subMonitor);
            }
            List<IInstallableUnit> categories = builder.getCategoryIUs();
            if (!categories.isEmpty()) {
                this.mirror(categories, null, aggregateMdr, (IProgressMonitor)childMonitor.newChild(20));
                aggregatedMdrIsEmpty = false;
            }
            String[] stringArray = new String[]{"compositeArtifacts.jar", "compositeContent.jar", "content.jar", "artifacts.jar"};
            int repos3 = stringArray.length;
            boolean bl = false;
            while (var31_44 < repos3) {
                String fileName = stringArray[var31_44];
                File file = new File(destination, fileName);
                if (file.exists() && !file.delete()) {
                    throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                ++var31_44;
            }
            MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
            ArrayList<MappedRepository> reposWithReferencedArtifacts = new ArrayList<MappedRepository>();
            ArrayList<MappedRepository> arrayList = new ArrayList<MappedRepository>();
            for (Contribution contrib : aggregator.getContributions(true)) {
                for (MappedRepository mappedRepository : contrib.getRepositories(true)) {
                    if (builder.isMapVerbatim(mappedRepository)) {
                        reposWithReferencedArtifacts.add(mappedRepository);
                        arrayList.add(mappedRepository);
                        continue;
                    }
                    if (mappedRepository.isMirrorArtifacts() || !"p2".equals(mappedRepository.getNature())) continue;
                    reposWithReferencedArtifacts.add(mappedRepository);
                }
            }
            if (mavenHelper != null) {
                IMaven2Indexer iMaven2Indexer;
                LogUtils.info((String)"Adding maven metadata", (Object[])new Object[0]);
                HashMap errors3 = new HashMap();
                MavenManager.saveMetadata((URI)URI.createFileURI((String)aggregateDestination.getAbsolutePath()), (InstallableUnitMapping)mavenHelper.getTop(), errors3);
                if (errors3.size() > 0) {
                    artifactErrors = true;
                    for (Map.Entry entry : errors3.entrySet()) {
                        builder.sendEmail((Contribution)entry.getKey(), (List)entry.getValue());
                    }
                }
                if ((iMaven2Indexer = IndexerUtils.getIndexer((String)"nexus")) != null) {
                    LogUtils.info((String)"Adding maven index", (Object[])new Object[0]);
                    iMaven2Indexer.updateLocalIndex(new File(aggregateDestination.getAbsolutePath()).toURI(), false);
                }
                MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
                LogUtils.info((String)"Done adding maven metadata", (Object[])new Object[0]);
            }
            if (arrayList.isEmpty()) {
                LogUtils.info((String)"Making the aggregated metadata repository final at %s", (Object[])new Object[]{finalURI});
                File oldLocation = new File(aggregateDestination, "content.jar");
                File file = new File(destination, oldLocation.getName());
                if (!oldLocation.renameTo(file)) {
                    throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), file.getAbsolutePath()});
                }
                this.mdrMgr.removeRepository(aggregateURI);
            } else {
                LogUtils.info((String)"Building final metadata composite at %s", (Object[])new Object[]{finalURI});
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                name = builder.getAggregator().getLabel();
                this.mdrMgr.removeRepository(finalURI);
                CompositeMetadataRepository compositeMetadataRepository = (CompositeMetadataRepository)this.mdrMgr.createRepository(finalURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
                for (MappedRepository mappedRepository : arrayList) {
                    compositeMetadataRepository.addChild(mappedRepository.getMetadataRepository().getLocation());
                }
                if (aggregatedMdrIsEmpty) {
                    this.mdrMgr.removeRepository(aggregateURI);
                    File file = new File(aggregateDestination, "content.jar");
                    if (!file.delete()) {
                        throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{aggregateDestination.getAbsolutePath()});
                    }
                } else {
                    compositeMetadataRepository.addChild(finalURI.relativize(aggregateURI));
                }
                LogUtils.info((String)"Done building final metadata composite", (Object[])new Object[0]);
            }
            MonitorUtils.worked((IProgressMonitor)childMonitor, (int)10);
            if (reposWithReferencedArtifacts.isEmpty()) {
                void var33_66;
                LogUtils.info((String)"Making the aggregated artifact repository final at %s", (Object[])new Object[]{finalURI});
                String[] stringArray2 = aggregateDestination.list();
                int n = stringArray2.length;
                boolean bl2 = false;
                while (var33_66 < n) {
                    File newLocation;
                    File oldLocation;
                    name = stringArray2[var33_66];
                    if (!"content.jar".equals(name) && !(oldLocation = new File(aggregateDestination, name)).renameTo(newLocation = new File(destination, name))) {
                        throw ExceptionUtils.fromMessage((String)"Unable to move %s to %s", (Object[])new Object[]{oldLocation.getAbsolutePath(), newLocation.getAbsolutePath()});
                    }
                    ++var33_66;
                }
                this.arMgr.removeRepository(aggregateURI);
            } else {
                LogUtils.info((String)"Building final artifact composite at %s", (Object[])new Object[]{finalURI});
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                name = builder.getAggregator().getLabel();
                this.arMgr.removeRepository(finalURI);
                CompositeArtifactRepository compositeArtifactRepository = (CompositeArtifactRepository)this.arMgr.createRepository(finalURI, String.valueOf(name) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
                for (MappedRepository mappedRepository : reposWithReferencedArtifacts) {
                    compositeArtifactRepository.addChild(mappedRepository.getMetadataRepository().getLocation());
                }
                if (aggregatedArIsEmpty) {
                    this.arMgr.removeRepository(aggregateURI);
                    File file = new File(aggregateDestination, "artifacts.jar");
                    if (!file.delete()) {
                        throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{file.getAbsolutePath()});
                    }
                } else {
                    compositeArtifactRepository.addChild(finalURI.relativize(aggregateURI));
                }
                LogUtils.info((String)"Done building final artifact composite", (Object[])new Object[0]);
            }
            String[] content = aggregateDestination.list();
            if (content != null && content.length == 0 && !aggregateDestination.delete()) {
                throw ExceptionUtils.fromMessage((String)"Unable to remove %s", (Object[])new Object[]{aggregateDestination.getAbsolutePath()});
            }
            MonitorUtils.done((IProgressMonitor)childMonitor);
        }
        finally {
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), (IRepositoryManager)this.mdrMgr);
            this.mdrMgr = null;
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.getBuilder().getProvisioningAgent(), (IRepositoryManager)this.arMgr);
            this.arMgr = null;
            MonitorUtils.done((IProgressMonitor)subMon);
        }
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (artifactErrors) {
            throw ExceptionUtils.fromMessage((String)"Not all artifacts could be mirrored, see log for details", (Object[])new Object[0]);
        }
    }

    private IArtifactRepository getArtifactRepository(MetadataRepositoryReference repo, IProgressMonitor monitor) throws CoreException {
        IArtifactRepository ar;
        if (this.arCache == null) {
            this.arCache = new HashMap<MetadataRepositoryReference, IArtifactRepository>();
        }
        if ((ar = this.arCache.get(repo)) == null) {
            IConfigurationElement config = RepositoryLoaderUtils.getLoaderFor((String)repo.getNature());
            if (config == null) {
                throw ExceptionUtils.fromMessage((String)"No loader for %s", (Object[])new Object[]{repo.getNature()});
            }
            IRepositoryLoader repoLoader = (IRepositoryLoader)config.createExecutableExtension("class");
            ar = repoLoader.getArtifactRepository((IMetadataRepository)ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo), monitor);
            this.arCache.put(repo, ar);
        }
        return ar;
    }

    private void mirror(List<IInstallableUnit> iusToMirror, MetadataRepository source, IMetadataRepository dest, IProgressMonitor monitor) throws CoreException {
        dest.addInstallableUnits(iusToMirror);
        Builder builder = this.getBuilder();
        if (source != null && builder.isMirrorReferences()) {
            ArrayList<RepositoryReference> refs = new ArrayList<RepositoryReference>();
            for (IRepositoryReference ref : source.getReferences()) {
                String refType;
                java.net.URI location = ref.getLocation();
                String refKey = location.toString();
                String string = refType = ref.getType() == 0 ? "meta-data" : "artifacts";
                if (!builder.isMatchedReference(refKey)) {
                    LogUtils.debug((String)"- %s reference %s was ruled out by inclusion/exclusion patterns", (Object[])new Object[]{refType, refKey});
                    continue;
                }
                if (refKey.endsWith("/site.xml")) {
                    location = java.net.URI.create(refKey.substring(0, refKey.length() - 8));
                }
                LogUtils.debug((String)"- mirroring %s reference %s", (Object[])new Object[]{refType, refKey});
                refs.add(new RepositoryReference(location, ref.getNickname(), ref.getType(), 0));
            }
            dest.addReferences(refs);
        }
    }

    private static class CanonicalizeRequest
    extends MirrorRequest {
        private IArtifactDescriptor optimizedDescriptor;

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactRepository sourceRepository, IFileArtifactRepository targetRepository) {
            super(optimizedDescriptor.getArtifactKey(), (IArtifactRepository)targetRepository, null, null);
            this.optimizedDescriptor = optimizedDescriptor;
            this.setSourceRepository(sourceRepository);
        }

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IFileArtifactRepository targetRepository) {
            this(optimizedDescriptor, (IArtifactRepository)targetRepository, targetRepository);
        }

        public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
            IFileArtifactRepository fbTarget = (IFileArtifactRepository)this.target;
            IArtifactKey artifactKey = this.optimizedDescriptor.getArtifactKey();
            File destination = fbTarget.getArtifactFile((IArtifactDescriptor)new ArtifactDescriptor(artifactKey));
            BufferedOutputStream out = null;
            try {
                File destFolder = destination.getParentFile();
                destFolder.mkdirs();
                if (!destFolder.isDirectory()) {
                    throw new IOException("Unable to create path " + destFolder.getAbsolutePath());
                }
                out = new BufferedOutputStream(new FileOutputStream(destination));
                IStatus status = sourceRepository.getArtifact(this.optimizedDescriptor, (OutputStream)out, monitor);
                if (!status.isOK()) {
                    this.setResult(status);
                    IOUtils.close((Closeable)out);
                    return;
                }
            }
            catch (IOException e) {
                this.setResult((IStatus)new Status(4, "org.eclipse.b3.aggregator.engine", e.getMessage(), (Throwable)e));
                return;
            }
            finally {
                IOUtils.close(out);
            }
            IOUtils.close((Closeable)out);
            ArtifactDescriptor canonical = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor((IArtifactKey)artifactKey, (File)destination);
            for (Map.Entry entry : this.optimizedDescriptor.getProperties().entrySet()) {
                String propKey = (String)entry.getKey();
                if (propKey.equals("download.md5") || propKey.equals("download.size") || propKey.equals("artifact.size") || propKey.equals("format") || propKey.equals("artifact.uuid")) continue;
                canonical.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            fbTarget.addDescriptor((IArtifactDescriptor)canonical);
            this.setResult(Status.OK_STATUS);
        }
    }
}

