/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.maven.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.b3.p2.maven.util.DigestUtil;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class XMLResourceImplWithCheck
extends XMLResourceImpl {
    private static URIConverter uriConverter = new ExtensibleURIConverterImpl();

    static {
        URIHandlerWithCheck.register(uriConverter);
    }

    public XMLResourceImplWithCheck(URI uri) {
        super(uri);
        this.setEncoding("UTF-8");
    }

    public URIConverter getURIConverter() {
        return uriConverter;
    }

    public static class InputStreamWithInfo
    extends ByteArrayInputStream {
        private String md5;
        private String sha1;
        private Long timestamp;

        public InputStreamWithInfo(byte[] bytes) {
            super(bytes);
        }

        public byte[] getContent() {
            return this.buf;
        }

        public String getMd5() {
            return this.md5;
        }

        public String getSha1() {
            return this.sha1;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URIHandlerWithCheck
    extends URIHandlerImpl {
        private static final long MAX_FILE_LENGTH = 10000000L;
        private static final SimpleDateFormat LAST_MODIFIED_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        private URIConverter owner;
        private HttpClient httpClient;

        public static void register(URIConverter owner) {
            new URIHandlerWithCheck(owner);
        }

        private URIHandlerWithCheck(URIConverter owner) {
            this.owner = owner;
            owner.getURIHandlers().add(0, (Object)this);
            this.httpClient = new HttpClient();
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            try {
                String uriString = uri.toString();
                String uriStringMD5 = String.valueOf(uriString) + ".md5";
                String uriStringSHA1 = String.valueOf(uriString) + ".sha1";
                String md5 = null;
                try {
                    md5 = this.getDigest(uriStringMD5, DigestUtil.MESSAGE_DIGESTERS[0].getDigestLength() << 1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                String sha1 = null;
                try {
                    sha1 = this.getDigest(uriStringSHA1, DigestUtil.MESSAGE_DIGESTERS[1].getDigestLength() << 1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                InputStreamWithInfo result = this.download(uriString);
                byte[] content = result.getContent();
                String[] checkSums = DigestUtil.createCheckSum(content, DigestUtil.MESSAGE_DIGESTERS);
                if (md5 == null || !md5.equals(checkSums[0])) {
                    LogUtils.warning((String)"Invalid MD5 for %s: found %s, expected %s", (Object[])new Object[]{uriString, md5 != null ? md5 : "none", checkSums[0]});
                }
                if (sha1 == null || !sha1.equals(checkSums[1])) {
                    LogUtils.warning((String)"Invalid SHA1 for %s: found %s, expected %s", (Object[])new Object[]{uriString, sha1 != null ? sha1 : "none", checkSums[0]});
                }
                result.setMd5(md5);
                result.setSha1(sha1);
                return result;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }

        public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
            for (URIHandler handler : this.owner.getURIHandlers()) {
                if (handler == this || !handler.canHandle(uri)) continue;
                return handler.createOutputStream(uri, options);
            }
            return super.createOutputStream(uri, options);
        }

        private InputStreamWithInfo download(String uriStr) throws Exception {
            InputStream is;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            long lastModified = 0L;
            java.net.URI uri = new java.net.URI(uriStr);
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                GetMethod method = new GetMethod(uriStr);
                if (this.httpClient.executeMethod((HttpMethod)method) == 404) {
                    throw new FileNotFoundException();
                }
                Header header = method.getResponseHeader("last-modified");
                if (header != null) {
                    try {
                        lastModified = LAST_MODIFIED_DATE_FORMAT.parse(header.getValue()).getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                is = method.getResponseBodyAsStream();
            } else {
                URLConnection conn = uri.toURL().openConnection();
                lastModified = conn.getLastModified();
                is = conn.getInputStream();
            }
            try {
                int read;
                long total = 0L;
                while ((read = is.read(buffer)) != -1) {
                    if ((total += (long)read) > 10000000L) {
                        throw new IOException("Remote file (" + uriStr + ") exceeds maximum expected size of " + 10000000L + " bytes");
                    }
                    os.write(buffer, 0, read);
                }
                InputStreamWithInfo result = new InputStreamWithInfo(os.toByteArray());
                result.setTimestamp(lastModified);
                InputStreamWithInfo inputStreamWithInfo = result;
                return inputStreamWithInfo;
            }
            finally {
                is.close();
                os.close();
            }
        }

        private String getDigest(String uri, int len) throws Exception {
            String line = new String(this.download(uri).getContent());
            if (line.length() < len) {
                throw new Exception("Invalid digest: " + line);
            }
            return line.substring(0, len);
        }
    }
}

