/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.legacy;

import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.legacy.ResourceTransformer;
import org.eclipse.b3.aggregator.legacy.TreePath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class AggregatorTransformer_100_2_110
extends ResourceTransformer {
    private static final String AGGREGATOR_NODE = "Aggregator";
    private static final String AGGREGATION_NODE = "Aggregation";
    private static final String VALIDATION_SET = "ValidationSet";
    private static final String VALIDATION_SETS_REF = "validationSets";

    @Override
    protected void doTransform(EObject srcEObject, TreePath trgtParentTreePath) {
        try {
            EClass scrEClass = srcEObject.eClass();
            if (AGGREGATOR_NODE.equals(scrEClass.getName())) {
                this.transformAggregatorNode(srcEObject, trgtParentTreePath);
            } else {
                super.doTransform(srcEObject, trgtParentTreePath);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void initTransformer(Resource srcResource, Resource trgtResource, EPackage trgtPackage, Map<String, Object> context) {
        super.initTransformer(srcResource, trgtResource, trgtPackage, context);
    }

    private void transformAggregatorNode(EObject srcEObject, TreePath targetParentTreePath) {
        EObject aggregation = this.createTrgtEObject(AGGREGATION_NODE, srcEObject);
        EClass aggregationClass = aggregation.eClass();
        targetParentTreePath.addToLastSegmentContainer(aggregation);
        EObject validationSet = this.createTrgtEObject(VALIDATION_SET, null);
        EClass validationSetClass = validationSet.eClass();
        EList validationSets = (EList)this.getValue(aggregation, VALIDATION_SETS_REF);
        validationSets.add((Object)validationSet);
        TreePath vsTreePath = targetParentTreePath.createChildTreePath(aggregation, (EReference)aggregationClass.getEStructuralFeature(VALIDATION_SETS_REF));
        validationSet.eSet(validationSetClass.getEStructuralFeature("label"), (Object)"main");
        this.copyAttributes(srcEObject, aggregation);
        for (EReference srcERef : srcEObject.eClass().getEAllContainments()) {
            TreePath treePath;
            EObject target;
            Object srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef);
            if (srcERefValue == null) continue;
            String refName = srcERef.getName();
            if (AggregatorTransformer_100_2_110.equalsOneOf(refName, "configurations", "customCategories", "contacts", "buildmaster", "mavenMappings")) {
                target = aggregation;
                treePath = targetParentTreePath;
            } else {
                target = validationSet;
                treePath = vsTreePath;
            }
            EReference targetERef = (EReference)target.eClass().getEStructuralFeature(refName);
            if (targetERef == null) continue;
            TreePath targetTreePath = treePath.createChildTreePath(target, targetERef);
            if (!srcERef.isMany()) {
                this.transform((EObject)srcERefValue, targetTreePath);
                continue;
            }
            for (EObject srcChild : (List)srcERefValue) {
                this.transform(srcChild, targetTreePath);
            }
        }
    }
}

