/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregationType;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Architecture;
import org.eclipse.b3.aggregator.AvailableVersion;
import org.eclipse.b3.aggregator.AvailableVersionsHeader;
import org.eclipse.b3.aggregator.Bundle;
import org.eclipse.b3.aggregator.Category;
import org.eclipse.b3.aggregator.Configuration;
import org.eclipse.b3.aggregator.Contact;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.CustomCategory;
import org.eclipse.b3.aggregator.DescriptionProvider;
import org.eclipse.b3.aggregator.ExclusionRule;
import org.eclipse.b3.aggregator.Feature;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.InstallableUnitType;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.MavenItem;
import org.eclipse.b3.aggregator.MavenMapping;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.OperatingSystem;
import org.eclipse.b3.aggregator.PackedStrategy;
import org.eclipse.b3.aggregator.Product;
import org.eclipse.b3.aggregator.Property;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.ValidConfigurationsRule;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.VersionMatch;
import org.eclipse.b3.aggregator.WindowSystem;
import org.eclipse.b3.aggregator.impl.AggregationImpl;
import org.eclipse.b3.aggregator.impl.AvailableVersionImpl;
import org.eclipse.b3.aggregator.impl.AvailableVersionsHeaderImpl;
import org.eclipse.b3.aggregator.impl.BundleImpl;
import org.eclipse.b3.aggregator.impl.CategoryImpl;
import org.eclipse.b3.aggregator.impl.ConfigurationImpl;
import org.eclipse.b3.aggregator.impl.ContactImpl;
import org.eclipse.b3.aggregator.impl.ContributionImpl;
import org.eclipse.b3.aggregator.impl.CustomCategoryImpl;
import org.eclipse.b3.aggregator.impl.DescriptionProviderImpl;
import org.eclipse.b3.aggregator.impl.ExclusionRuleImpl;
import org.eclipse.b3.aggregator.impl.FeatureImpl;
import org.eclipse.b3.aggregator.impl.InfosProviderImpl;
import org.eclipse.b3.aggregator.impl.MappedRepositoryImpl;
import org.eclipse.b3.aggregator.impl.MavenItemImpl;
import org.eclipse.b3.aggregator.impl.MavenMappingImpl;
import org.eclipse.b3.aggregator.impl.MetadataRepositoryReferenceImpl;
import org.eclipse.b3.aggregator.impl.ProductImpl;
import org.eclipse.b3.aggregator.impl.PropertyImpl;
import org.eclipse.b3.aggregator.impl.StatusImpl;
import org.eclipse.b3.aggregator.impl.ValidConfigurationsRuleImpl;
import org.eclipse.b3.aggregator.impl.ValidationSetImpl;
import org.eclipse.b3.aggregator.util.InstallableUnitUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorFactoryImpl
extends EFactoryImpl
implements AggregatorFactory {
    @Deprecated
    public static AggregatorPackage getPackage() {
        return AggregatorPackage.eINSTANCE;
    }

    public static AggregatorFactory init() {
        try {
            AggregatorFactory theAggregatorFactory = (AggregatorFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/b3/2011/aggregator/1.1.0");
            if (theAggregatorFactory != null) {
                return theAggregatorFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new AggregatorFactoryImpl();
    }

    public String convertAggregationTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertArchitectureToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertInstallableUnitTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertOperatingSystemToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertPackedStrategyToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertStatusCodeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 31: {
                return this.convertAggregationTypeToString(eDataType, instanceValue);
            }
            case 32: {
                return this.convertArchitectureToString(eDataType, instanceValue);
            }
            case 33: {
                return this.convertInstallableUnitTypeToString(eDataType, instanceValue);
            }
            case 34: {
                return this.convertOperatingSystemToString(eDataType, instanceValue);
            }
            case 35: {
                return this.convertPackedStrategyToString(eDataType, instanceValue);
            }
            case 36: {
                return this.convertStatusCodeToString(eDataType, instanceValue);
            }
            case 37: {
                return this.convertVersionMatchToString(eDataType, instanceValue);
            }
            case 38: {
                return this.convertWindowSystemToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertVersionMatchToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertWindowSystemToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return (EObject)this.createAggregation();
            }
            case 1: {
                return (EObject)this.createAvailableVersionsHeader();
            }
            case 2: {
                return (EObject)this.createAvailableVersion();
            }
            case 3: {
                return (EObject)this.createBundle();
            }
            case 4: {
                return (EObject)this.createCategory();
            }
            case 6: {
                return (EObject)this.createConfiguration();
            }
            case 7: {
                return (EObject)this.createContact();
            }
            case 8: {
                return (EObject)this.createContribution();
            }
            case 9: {
                return (EObject)this.createFeature();
            }
            case 11: {
                return (EObject)this.createCustomCategory();
            }
            case 12: {
                return (EObject)this.createDescriptionProvider();
            }
            case 14: {
                return (EObject)this.createExclusionRule();
            }
            case 16: {
                return (EObject)this.createInfosProvider();
            }
            case 19: {
                return (EObject)this.createMappedRepository();
            }
            case 22: {
                return (EObject)this.createMavenItem();
            }
            case 23: {
                return (EObject)this.createMavenMapping();
            }
            case 24: {
                return (EObject)this.createMetadataRepositoryReference();
            }
            case 25: {
                return (EObject)this.createProduct();
            }
            case 26: {
                return (EObject)this.createProperty();
            }
            case 27: {
                return (EObject)this.createStatus();
            }
            case 29: {
                return (EObject)this.createValidationSet();
            }
            case 30: {
                return (EObject)this.createValidConfigurationsRule();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public Aggregation createAggregation() {
        AggregationImpl aggregation = new AggregationImpl();
        return aggregation;
    }

    public AggregationType createAggregationTypeFromString(EDataType eDataType, String initialValue) {
        AggregationType result = AggregationType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public Architecture createArchitectureFromString(EDataType eDataType, String initialValue) {
        Architecture result = Architecture.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public AvailableVersion createAvailableVersion() {
        AvailableVersionImpl availableVersion = new AvailableVersionImpl();
        return availableVersion;
    }

    @Override
    public AvailableVersionsHeader createAvailableVersionsHeader() {
        AvailableVersionsHeaderImpl availableVersionsHeader = new AvailableVersionsHeaderImpl();
        return availableVersionsHeader;
    }

    @Override
    public Bundle createBundle() {
        BundleImpl bundle = new BundleImpl();
        return bundle;
    }

    @Override
    public Category createCategory() {
        CategoryImpl category = new CategoryImpl();
        return category;
    }

    @Override
    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        return configuration;
    }

    @Override
    public Contact createContact() {
        ContactImpl contact = new ContactImpl();
        return contact;
    }

    @Override
    public Contribution createContribution() {
        ContributionImpl contribution = new ContributionImpl();
        return contribution;
    }

    @Override
    public CustomCategory createCustomCategory() {
        CustomCategoryImpl customCategory = new CustomCategoryImpl();
        return customCategory;
    }

    @Override
    public DescriptionProvider createDescriptionProvider() {
        DescriptionProviderImpl descriptionProvider = new DescriptionProviderImpl();
        return descriptionProvider;
    }

    @Override
    public ExclusionRule createExclusionRule() {
        ExclusionRuleImpl exclusionRule = new ExclusionRuleImpl();
        return exclusionRule;
    }

    @Override
    public Feature createFeature() {
        FeatureImpl feature = new FeatureImpl();
        return feature;
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 31: {
                return this.createAggregationTypeFromString(eDataType, initialValue);
            }
            case 32: {
                return this.createArchitectureFromString(eDataType, initialValue);
            }
            case 33: {
                return this.createInstallableUnitTypeFromString(eDataType, initialValue);
            }
            case 34: {
                return this.createOperatingSystemFromString(eDataType, initialValue);
            }
            case 35: {
                return this.createPackedStrategyFromString(eDataType, initialValue);
            }
            case 36: {
                return this.createStatusCodeFromString(eDataType, initialValue);
            }
            case 37: {
                return this.createVersionMatchFromString(eDataType, initialValue);
            }
            case 38: {
                return this.createWindowSystemFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public InfosProvider createInfosProvider() {
        InfosProviderImpl infosProvider = new InfosProviderImpl();
        return infosProvider;
    }

    public InstallableUnitType createInstallableUnitTypeFromString(EDataType eDataType, String initialValue) {
        InstallableUnitType result = InstallableUnitType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public MappedRepository createMappedRepository() {
        MappedRepositoryImpl mappedRepository = new MappedRepositoryImpl();
        return mappedRepository;
    }

    @Override
    public MappedRepository createMappedRepository(MetadataRepository mdr) {
        MappedRepository mappedRepo = this.createMappedRepository();
        mappedRepo.setMetadataRepository(mdr);
        mappedRepo.setLocation(mdr.getLocation().toString());
        return mappedRepo;
    }

    @Override
    public MappedUnit createMappedUnit(IInstallableUnit iu) {
        MappedUnit mu = null;
        switch (InstallableUnitUtils.getType(iu)) {
            case FEATURE: {
                mu = this.createFeature();
                break;
            }
            case CATEGORY: {
                mu = this.createCategory();
                break;
            }
            case BUNDLE: 
            case FRAGMENT: {
                mu = this.createBundle();
                break;
            }
            case PRODUCT: {
                mu = this.createProduct();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IU type");
            }
        }
        mu.setName(iu.getId());
        mu.setVersionRange(new VersionRange(iu.getVersion(), true, Version.MAX_VERSION, true));
        return mu;
    }

    @Override
    public MapRule createMapRule(IInstallableUnit iu, Class<? extends MapRule> ruleClass) {
        MapRule mr = null;
        if (ruleClass.isAssignableFrom(ExclusionRule.class)) {
            mr = this.createExclusionRule();
        } else if (ruleClass.isAssignableFrom(ValidConfigurationsRule.class)) {
            mr = this.createValidConfigurationsRule();
        } else {
            throw new IllegalArgumentException("Unknown rule class " + ruleClass);
        }
        mr.setName(iu.getId());
        mr.setVersionRange(new VersionRange(iu.getVersion(), true, Version.MAX_VERSION, true));
        return mr;
    }

    @Override
    public MavenItem createMavenItem() {
        MavenItemImpl mavenItem = new MavenItemImpl();
        return mavenItem;
    }

    @Override
    public MavenMapping createMavenMapping() {
        MavenMappingImpl mavenMapping = new MavenMappingImpl();
        return mavenMapping;
    }

    @Override
    public MetadataRepositoryReference createMetadataRepositoryReference() {
        MetadataRepositoryReferenceImpl metadataRepositoryReference = new MetadataRepositoryReferenceImpl();
        return metadataRepositoryReference;
    }

    public OperatingSystem createOperatingSystemFromString(EDataType eDataType, String initialValue) {
        OperatingSystem result = OperatingSystem.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public PackedStrategy createPackedStrategyFromString(EDataType eDataType, String initialValue) {
        PackedStrategy result = PackedStrategy.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public Product createProduct() {
        ProductImpl product = new ProductImpl();
        return product;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    @Override
    public Property createProperty(String key, String value) {
        PropertyImpl property = new PropertyImpl(key, value);
        return property;
    }

    @Override
    public Status createStatus() {
        StatusImpl status = new StatusImpl();
        return status;
    }

    @Override
    public Status createStatus(StatusCode statusCode) {
        return StatusImpl.createStatus(statusCode);
    }

    @Override
    public Status createStatus(StatusCode statusCode, String message) {
        return StatusImpl.createStatus(statusCode, message);
    }

    public StatusCode createStatusCodeFromString(EDataType eDataType, String initialValue) {
        StatusCode result = StatusCode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public ValidationSet createValidationSet() {
        ValidationSetImpl validationSet = new ValidationSetImpl();
        return validationSet;
    }

    @Override
    public ValidConfigurationsRule createValidConfigurationsRule() {
        ValidConfigurationsRuleImpl validConfigurationsRule = new ValidConfigurationsRuleImpl();
        return validConfigurationsRule;
    }

    public VersionMatch createVersionMatchFromString(EDataType eDataType, String initialValue) {
        VersionMatch result = VersionMatch.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public WindowSystem createWindowSystemFromString(EDataType eDataType, String initialValue) {
        WindowSystem result = WindowSystem.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    @Override
    public AggregatorPackage getAggregatorPackage() {
        return (AggregatorPackage)this.getEPackage();
    }
}

