/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.engine.ModelAbstractCommand;
import org.eclipse.b3.aggregator.impl.MetadataRepositoryReferenceImpl;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.kohsuke.args4j.Option;

public class Modifier
extends ModelAbstractCommand {
    @Option(name="--action", usage="Specifies the type of the execution.")
    private ActionType action;
    @Option(name="--repoLocation", usage="Appoints a new repository for aggregation")
    private String repoLocation;
    @Option(name="--validationSet", usage="Appoints the targeted valiation set")
    private String validationSetName;

    public String getShortDescription() {
        return "Modifies the validationSets model from the command line";
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        try {
            EList metadataRepos;
            Aggregation aggregation = this.loadModelFromFile();
            EList validationSets = aggregation.getValidationSets(true);
            ValidationSet validationSet = null;
            if (this.validationSetName == null) {
                if (validationSets.size() != 1) {
                    throw ExceptionUtils.fromMessage((String)"Unable to determine what validation set to modify", (Object[])new Object[0]);
                }
                validationSet = (ValidationSet)validationSets.get(0);
            } else {
                for (ValidationSet vs : validationSets) {
                    if (!this.validationSetName.equals(vs.getLabel())) continue;
                    validationSet = vs;
                    break;
                }
                if (validationSet == null) {
                    throw ExceptionUtils.fromMessage((String)("Unable to find a validation set named '" + this.validationSetName + '\''), (Object[])new Object[0]);
                }
            }
            if (this.action == ActionType.ADD) {
                MetadataRepositoryReferenceImpl newRepository = (MetadataRepositoryReferenceImpl)AggregatorFactory.eINSTANCE.createMetadataRepositoryReference();
                newRepository.setLocation(this.repoLocation);
                metadataRepos = validationSet.getValidationRepositories();
                metadataRepos.add((Object)newRepository);
            } else if (this.action == ActionType.REMOVE) {
                HashSet<MetadataRepositoryReference> removees = new HashSet<MetadataRepositoryReference>();
                metadataRepos = validationSet.getValidationRepositories();
                for (MetadataRepositoryReference metadataRepositoryReference : metadataRepos) {
                    if (!metadataRepositoryReference.getLocation().equals(this.repoLocation)) continue;
                    removees.add(metadataRepositoryReference);
                }
                if (removees.size() == 0) {
                    throw ExceptionUtils.fromMessage((String)("Unable to find validation repository " + this.repoLocation), (Object[])new Object[0]);
                }
                metadataRepos.removeAll(removees);
            }
            EObject eObj = (EObject)aggregation;
            Resource resource = eObj.eResource();
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            resource.save(saveOptions);
        }
        catch (Exception e) {
            ExceptionUtils.wrap((Throwable)e);
        }
        return 0;
    }

    public static enum ActionType {
        ADD,
        REMOVE;

    }
}

