/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.EnabledStatusProvider;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.impl.ContributionImpl;
import org.eclipse.b3.aggregator.util.AggregatorResource;
import org.eclipse.b3.aggregator.util.ResourceDiagnosticImpl;
import org.eclipse.b3.aggregator.util.VerificationDiagnostic;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatorResourceImpl
extends XMIResourceImpl
implements AggregatorResource {
    protected EList<Resource.Diagnostic> infos;
    private boolean analysisRequest;
    private boolean analysisIsRunning;

    public AggregatorResourceImpl(URI uri) {
        super(uri);
    }

    private void analyze(EObject object) {
        if (object instanceof EnabledStatusProvider && !((EnabledStatusProvider)object).isEnabled()) {
            return;
        }
        if (object instanceof InfosProvider) {
            InfosProvider iProvider = (InfosProvider)object;
            for (String error : iProvider.getErrors()) {
                this.getErrors().add((Object)new ResourceDiagnosticImpl(error, EcoreUtil.getURI((EObject)object).toString()));
            }
            for (String warning : iProvider.getWarnings()) {
                this.getWarnings().add((Object)new ResourceDiagnosticImpl(warning, EcoreUtil.getURI((EObject)object).toString()));
            }
            for (String info : iProvider.getInfos()) {
                this.getInfos().add((Object)new ResourceDiagnosticImpl(info, EcoreUtil.getURI((EObject)object).toString()));
            }
        }
        if (object.eContents() == null) {
            return;
        }
        for (EObject childObject : object.eContents()) {
            this.analyze(childObject);
        }
    }

    @Override
    public void analyzeResource() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AggregatorResourceImpl aggregatorResourceImpl = AggregatorResourceImpl.this;
                synchronized (aggregatorResourceImpl) {
                    while (AggregatorResourceImpl.this.analysisRequest) {
                        try {
                            Iterator iterator;
                            AggregatorResourceImpl.this.analysisRequest = false;
                            AggregatorResourceImpl.this.analysisIsRunning = true;
                            AggregatorResourceImpl.this.eNotify((Notification)new NotifyAnalyzeResourceStarted());
                            if (AggregatorResourceImpl.this.errors != null) {
                                iterator = AggregatorResourceImpl.this.errors.iterator();
                                while (iterator.hasNext()) {
                                    if (((Resource.Diagnostic)iterator.next()).getClass() != ResourceDiagnosticImpl.class) continue;
                                    iterator.remove();
                                }
                            }
                            if (AggregatorResourceImpl.this.warnings != null) {
                                iterator = AggregatorResourceImpl.this.warnings.iterator();
                                while (iterator.hasNext()) {
                                    if (((Resource.Diagnostic)iterator.next()).getClass() != ResourceDiagnosticImpl.class) continue;
                                    iterator.remove();
                                }
                            }
                            if (AggregatorResourceImpl.this.infos != null) {
                                iterator = AggregatorResourceImpl.this.infos.iterator();
                                while (iterator.hasNext()) {
                                    if (((Resource.Diagnostic)iterator.next()).getClass() != ResourceDiagnosticImpl.class) continue;
                                    iterator.remove();
                                }
                            }
                            Aggregation aggregation = (Aggregation)AggregatorResourceImpl.this.getContents().get(0);
                            AggregatorResourceImpl.this.analyze((EObject)aggregation);
                        }
                        finally {
                            AggregatorResourceImpl.this.eNotify((Notification)new NotifyAnalyzeResourceFinished());
                            AggregatorResourceImpl.this.analysisIsRunning = false;
                        }
                    }
                }
            }
        };
        if (this.analysisRequest) {
            return;
        }
        this.analysisRequest = true;
        if (this.analysisIsRunning) {
            return;
        }
        new Thread(runnable).start();
    }

    @Override
    public Aggregation getAggregation() {
        return (Aggregation)this.getContents().get(0);
    }

    @Override
    public EList<Resource.Diagnostic> getInfos() {
        if (this.infos == null) {
            this.infos = new NotifyingListImpl<Resource.Diagnostic>(){
                private static final long serialVersionUID = 1L;

                public int getFeatureID() {
                    return 1001;
                }

                public Object getNotifier() {
                    return AggregatorResourceImpl.this;
                }

                protected boolean isNotificationRequired() {
                    return AggregatorResourceImpl.this.eNotificationRequired();
                }
            };
        }
        return this.infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVerificationMarkers(List<VerificationDiagnostic> verificationDiagnostics) {
        AggregatorResourceImpl aggregatorResourceImpl = this;
        synchronized (aggregatorResourceImpl) {
            if (this.errors != null) {
                Iterator iterator = this.errors.iterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof VerificationDiagnostic)) continue;
                    iterator.remove();
                }
            }
            URI baseURI = this.getURI();
            EList errors = this.getErrors();
            for (VerificationDiagnostic verificationDiagnostic : verificationDiagnostics) {
                verificationDiagnostic.resolveLocation(baseURI);
                EObject eObject = this.getResourceSet().getEObject(verificationDiagnostic.getLocationURI(), true);
                if (eObject instanceof ContributionImpl) {
                    ((ContributionImpl)eObject).setStatus(AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN));
                }
                errors.add((Object)verificationDiagnostic);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NotifyAnalyzeResourceFinished
    extends NotificationImpl {
        public NotifyAnalyzeResourceFinished() {
            super(1, false, true);
        }

        public int getFeatureID(Class<?> expectedClass) {
            return 1003;
        }

        public Object getNotifier() {
            return AggregatorResourceImpl.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NotifyAnalyzeResourceStarted
    extends NotificationImpl {
        public NotifyAnalyzeResourceStarted() {
            super(1, true, false);
        }

        public int getFeatureID(Class<?> expectedClass) {
            return 1002;
        }

        public Object getNotifier() {
            return AggregatorResourceImpl.this;
        }
    }
}

