/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class SourceCompositeGenerator
extends BuilderPhase {
    private final ValidationSet validationSet;

    public SourceCompositeGenerator(Builder builder, ValidationSet validationSet) {
        super(builder);
        this.validationSet = validationSet;
    }

    private IRepository<IInstallableUnit> createLocalMdr(URI locationBase, MetadataRepository mdr) throws URISyntaxException, NoSuchAlgorithmException {
        URI location = new URI(String.valueOf(locationBase.toString()) + "/transformed/" + this.encode(mdr.getLocation().toString()));
        LocalMetadataRepository localMdr = new LocalMetadataRepository(this.getBuilder().getProvisioningAgent(), location, mdr.getName(), mdr.getProperties());
        localMdr.setDescription(mdr.getDescription());
        localMdr.setProvider(mdr.getProvider());
        localMdr.addInstallableUnits((Collection)mdr.getInstallableUnits());
        localMdr.setProperty("p2.compressed", "true");
        return localMdr;
    }

    private String encode(String location) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        StringBuilder encoded = new StringBuilder();
        byte[] byArray = digest.digest(location.getBytes());
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            encoded.append(String.format("%02x", b));
            ++n2;
        }
        return encoded.toString();
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        EList contribs = this.validationSet.getAllContributions();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + contribs.size() * 100));
        String info = "Starting generation of composite repository";
        LogUtils.info((String)info, (Object[])new Object[0]);
        subMon.setTaskName("Generating composite from all sources...");
        long start = TimeUtils.getNow();
        String name = String.valueOf(this.validationSet.getLabel()) + " Source Composite";
        boolean errorsFound = false;
        Builder builder = this.getBuilder();
        IMetadataRepositoryManager mdrMgr = builder.getMdrManager();
        URI sourceLocationURI = builder.getSourceCompositeURI(this.validationSet);
        mdrMgr.removeRepository(sourceLocationURI);
        FileUtils.deleteAll((File)new File(builder.getBuildRoot(), "interim"));
        HashMap properties = new HashMap();
        CompositeMetadataRepository compositeMdr = (CompositeMetadataRepository)mdrMgr.createRepository(sourceLocationURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        this.getBuilder().setSourceComposite(this.validationSet, compositeMdr);
        MonitorUtils.worked((IProgressMonitor)subMon, (int)100);
        for (Contribution contrib : contribs) {
            SubMonitor contribMonitor = subMon.newChild(100);
            EList repos = contrib.getRepositories(true);
            MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 200));
            ArrayList<String> errors = new ArrayList<String>();
            for (MappedRepository repo : repos) {
                try {
                    URI childLocation = new URI(repo.getResolvedLocation());
                    LogUtils.info((String)"Adding child meta-data repository %s", (Object[])new Object[]{childLocation});
                    if (!"p2".equals(repo.getNature())) {
                        childLocation = this.createLocalMdr(sourceLocationURI, ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo)).getLocation();
                    }
                    compositeMdr.addChild(childLocation);
                }
                catch (Exception e) {
                    String msg = Builder.getExceptionMessages(e);
                    errors.add(msg);
                    LogUtils.error((Throwable)e, (String)msg, (Object[])new Object[0]);
                }
                contribMonitor.worked(200);
            }
            MonitorUtils.done((IProgressMonitor)contribMonitor);
            if (errors.isEmpty()) continue;
            this.getBuilder().sendEmail(contrib, errors);
            errorsFound = true;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        if (errorsFound) {
            throw ExceptionUtils.fromMessage((String)"CompositeRepository generation was not successful", (Object[])new Object[0]);
        }
    }
}

