/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import java.util.Collection;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Bundle;
import org.eclipse.b3.aggregator.Category;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.DescriptionProvider;
import org.eclipse.b3.aggregator.Feature;
import org.eclipse.b3.aggregator.IdentificationProvider;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.Product;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.impl.MetadataRepositoryReferenceImpl;
import org.eclipse.b3.aggregator.util.GeneralUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedRepositoryImpl
extends MetadataRepositoryReferenceImpl
implements MappedRepository {
    protected static final String DESCRIPTION_EDEFAULT = "";
    protected String description = "";
    protected EList<Product> products;
    protected EList<Bundle> bundles;
    protected EList<Feature> features;
    protected EList<Category> categories;
    protected static final boolean MIRROR_ARTIFACTS_EDEFAULT = true;
    protected static final int MIRROR_ARTIFACTS_EFLAG = 2;
    protected static final String CATEGORY_PREFIX_EDEFAULT = null;
    protected String categoryPrefix = CATEGORY_PREFIX_EDEFAULT;
    protected EList<MapRule> mapRules;

    protected MappedRepositoryImpl() {
        this.eFlags |= 2;
    }

    @Override
    public void addUnit(MappedUnit unit) {
        if (unit instanceof Feature) {
            this.getFeatures().add((Object)((Feature)unit));
        } else if (unit instanceof Category) {
            this.getCategories().add((Object)((Category)unit));
        } else if (unit instanceof Bundle) {
            this.getBundles().add((Object)((Bundle)unit));
        } else if (unit instanceof Product) {
            this.getProducts().add((Object)((Product)unit));
        } else {
            throw new IllegalArgumentException("Unknown IU type");
        }
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == DescriptionProvider.class) {
            switch (derivedFeatureID) {
                case 9: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == DescriptionProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 9;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getDescription();
            }
            case 10: {
                return this.getProducts();
            }
            case 11: {
                return this.getBundles();
            }
            case 12: {
                return this.getFeatures();
            }
            case 13: {
                return this.getCategories();
            }
            case 14: {
                return this.isMirrorArtifacts();
            }
            case 15: {
                return this.getCategoryPrefix();
            }
            case 16: {
                return this.getMapRules();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getProducts()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getBundles()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getFeatures()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getCategories()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getMapRules()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 10: {
                return this.products != null && !this.products.isEmpty();
            }
            case 11: {
                return this.bundles != null && !this.bundles.isEmpty();
            }
            case 12: {
                return this.features != null && !this.features.isEmpty();
            }
            case 13: {
                return this.categories != null && !this.categories.isEmpty();
            }
            case 14: {
                return (this.eFlags & 2) == 0;
            }
            case 15: {
                return CATEGORY_PREFIX_EDEFAULT == null ? this.categoryPrefix != null : !CATEGORY_PREFIX_EDEFAULT.equals(this.categoryPrefix);
            }
            case 16: {
                return this.mapRules != null && !this.mapRules.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDescription((String)newValue);
                return;
            }
            case 10: {
                this.getProducts().clear();
                this.getProducts().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getBundles().clear();
                this.getBundles().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getFeatures().clear();
                this.getFeatures().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getCategories().clear();
                this.getCategories().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.setMirrorArtifacts((Boolean)newValue);
                return;
            }
            case 15: {
                this.setCategoryPrefix((String)newValue);
                return;
            }
            case 16: {
                this.getMapRules().clear();
                this.getMapRules().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.MAPPED_REPOSITORY;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 10: {
                this.getProducts().clear();
                return;
            }
            case 11: {
                this.getBundles().clear();
                return;
            }
            case 12: {
                this.getFeatures().clear();
                return;
            }
            case 13: {
                this.getCategories().clear();
                return;
            }
            case 14: {
                this.setMirrorArtifacts(true);
                return;
            }
            case 15: {
                this.setCategoryPrefix(CATEGORY_PREFIX_EDEFAULT);
                return;
            }
            case 16: {
                this.getMapRules().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public Aggregation getAggregation() {
        return GeneralUtils.getAggregation((EObject)this);
    }

    @Override
    public EList<Bundle> getBundles() {
        if (this.bundles == null) {
            this.bundles = new EObjectContainmentEList.Resolving(Bundle.class, (InternalEObject)this, 11);
        }
        return this.bundles;
    }

    @Override
    public EList<Category> getCategories() {
        if (this.categories == null) {
            this.categories = new EObjectContainmentEList.Resolving(Category.class, (InternalEObject)this, 13);
        }
        return this.categories;
    }

    @Override
    public String getCategoryPrefix() {
        return this.categoryPrefix;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public EList<MappedUnit> getEnabledUnits() {
        EList<Category> categories = this.getCategories();
        EList<Product> products = this.getProducts();
        EList<Feature> features = this.getFeatures();
        EList<Bundle> bundles = this.getBundles();
        BasicEList units = new BasicEList(categories.size() + products.size() + features.size() + bundles.size());
        for (Category category : categories) {
            if (!category.isEnabled()) continue;
            units.add((Object)category);
        }
        for (Product product : products) {
            if (!product.isEnabled()) continue;
            units.add((Object)product);
        }
        for (Feature feature : features) {
            if (!feature.isEnabled()) continue;
            units.add((Object)feature);
        }
        for (Bundle bundle : bundles) {
            if (!bundle.isEnabled()) continue;
            units.add((Object)bundle);
        }
        return units;
    }

    @Override
    public EList<Feature> getFeatures() {
        if (this.features == null) {
            this.features = new EObjectContainmentEList.Resolving(Feature.class, (InternalEObject)this, 12);
        }
        return this.features;
    }

    @Override
    public String getIdentification() {
        return this.getLocation();
    }

    @Override
    public EList<MapRule> getMapRules() {
        if (this.mapRules == null) {
            this.mapRules = new EObjectContainmentEList.Resolving(MapRule.class, (InternalEObject)this, 16);
        }
        return this.mapRules;
    }

    @Override
    public EList<MapRule> getMapRules(boolean enabledOnly) {
        EList<MapRule> mrules = this.getMapRules();
        if (enabledOnly) {
            mrules = GeneralUtils.getEnabled(mrules);
        }
        return mrules;
    }

    @Override
    public EList<Product> getProducts() {
        if (this.products == null) {
            this.products = new EObjectContainmentEList.Resolving(Product.class, (InternalEObject)this, 10);
        }
        return this.products;
    }

    @Override
    public synchronized Status getStatus() {
        if (this.isBranchEnabled()) {
            Status status = super.getStatus();
            if (status.getCode() == StatusCode.OK) {
                for (MappedUnit unit : this.getEnabledUnits()) {
                    if (unit.getStatus().getCode() == StatusCode.OK) continue;
                    return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
                }
                for (MapRule rule : this.getMapRules()) {
                    if (rule.getStatus().getCode() == StatusCode.OK) continue;
                    return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
                }
            }
            return status;
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public EList<MappedUnit> getUnits(boolean enabledOnly) {
        EList<Category> categories = this.getCategories();
        if (enabledOnly) {
            categories = GeneralUtils.getEnabled(categories);
        }
        EList<Product> products = this.getProducts();
        if (enabledOnly) {
            products = GeneralUtils.getEnabled(products);
        }
        EList<Feature> features = this.getFeatures();
        if (enabledOnly) {
            features = GeneralUtils.getEnabled(features);
        }
        EList<Bundle> bundles = this.getBundles();
        if (enabledOnly) {
            bundles = GeneralUtils.getEnabled(bundles);
        }
        BasicEList units = new BasicEList(categories.size() + products.size() + features.size() + bundles.size());
        units.addAll(categories);
        units.addAll(products);
        units.addAll(features);
        units.addAll(bundles);
        return units;
    }

    @Override
    public boolean isBranchEnabled() {
        return super.isBranchEnabled() && (this.eContainer() == null || ((Contribution)this.eContainer()).isEnabled());
    }

    @Override
    public boolean isMapExclusive() {
        return this.getFeatures().size() > 0 || this.getCategories().size() > 0 || this.getProducts().size() > 0 || this.getBundles().size() > 0;
    }

    @Override
    public boolean isMirrorArtifacts() {
        return (this.eFlags & 2) != 0;
    }

    @Override
    public void removeUnit(MappedUnit unit) {
        if (unit instanceof Feature) {
            this.getFeatures().remove((Object)unit);
        } else if (unit instanceof Category) {
            this.getCategories().remove((Object)unit);
        } else if (unit instanceof Bundle) {
            this.getBundles().remove((Object)unit);
        } else if (unit instanceof Product) {
            this.getProducts().remove((Object)unit);
        } else {
            throw new IllegalArgumentException("Unknown IU type");
        }
    }

    @Override
    public void setCategoryPrefix(String newCategoryPrefix) {
        String oldCategoryPrefix = this.categoryPrefix;
        this.categoryPrefix = newCategoryPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldCategoryPrefix, (Object)this.categoryPrefix));
        }
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public void setMirrorArtifacts(boolean newMirrorArtifacts) {
        boolean oldMirrorArtifacts;
        boolean bl = oldMirrorArtifacts = (this.eFlags & 2) != 0;
        this.eFlags = newMirrorArtifacts ? (this.eFlags |= 2) : (this.eFlags &= 0xFFFFFFFD);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldMirrorArtifacts, newMirrorArtifacts));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (description: ");
        result.append(this.description);
        result.append(", mirrorArtifacts: ");
        result.append((this.eFlags & 2) != 0);
        result.append(", categoryPrefix: ");
        result.append(this.categoryPrefix);
        result.append(')');
        return result.toString();
    }
}

