/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.InstallableUnitRequest;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.provider.AggregatorItemProviderAdapter;
import org.eclipse.b3.aggregator.provider.ContributionItemProvider;
import org.eclipse.b3.aggregator.util.GeneralUtils;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.p2.util.RepositoryTranslationSupport;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;

public class InstallableUnitRequestItemProvider
extends AggregatorItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    public InstallableUnitRequestItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void addDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DescriptionProvider_description_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DescriptionProvider_description_feature", "_UI_DescriptionProvider_type"), (EStructuralFeature)AggregatorPackage.Literals.DESCRIPTION_PROVIDER__DESCRIPTION, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ContributionItemProvider.DynamicItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_InstallableUnitRequest_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_InstallableUnitRequest_name_feature", "_UI_InstallableUnitRequest_type"), (EStructuralFeature)AggregatorPackage.Literals.INSTALLABLE_UNIT_REQUEST__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                InstallableUnitRequest self = (InstallableUnitRequest)object;
                MappedRepository container = (MappedRepository)((EObject)self).eContainer();
                MetadataRepository repo = container.getMetadataRepository(false);
                if (repo == null || ((EObject)repo).eIsProxy()) {
                    return Collections.singleton(null);
                }
                IQueryResult queryResult = repo.query(InstallableUnitRequestItemProvider.this.getInstallableUnitQuery(), null);
                if (queryResult.isEmpty()) {
                    return Collections.singleton(null);
                }
                ArrayList<String> result = new ArrayList<String>();
                Set availableUnits = queryResult.toSet();
                HashSet<String> availableUnitNames = new HashSet<String>(availableUnits.size());
                for (Object e : availableUnits) {
                    availableUnitNames.add(((IInstallableUnit)e).getId());
                }
                if (self.getName() != null && !availableUnitNames.contains(self.getName())) {
                    result.add(self.getName());
                }
                result.addAll(availableUnitNames);
                for (InstallableUnitRequest installableUnitRequest : InstallableUnitRequestItemProvider.this.getContainerChildren(container)) {
                    int idx;
                    String iu;
                    if (installableUnitRequest == self || (iu = installableUnitRequest.getName()) == null || (idx = result.indexOf(iu)) < 0) continue;
                    result.remove(idx);
                }
                Collections.sort(result);
                result.add(0, null);
                return result;
            }
        });
    }

    protected void addVersionRangePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_InstallableUnitRequest_versionRange_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_InstallableUnitRequest_versionRange_feature", "_UI_InstallableUnitRequest_type"), (EStructuralFeature)AggregatorPackage.Literals.INSTALLABLE_UNIT_REQUEST__VERSION_RANGE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected boolean appendIUText(Object object, String typeKey, StringBuilder bld) {
        InstallableUnitRequest iuRef = (InstallableUnitRequest)object;
        String id = iuRef.getName();
        VersionRange versionRange = iuRef.getVersionRange();
        if (versionRange == null) {
            versionRange = VersionRange.emptyRange;
        }
        bld.append(this.getString(typeKey));
        bld.append(" : ");
        if (id == null) {
            bld.append("not mapped");
            return false;
        }
        if (id.endsWith(".feature.group")) {
            id = id.substring(0, id.length() - ".feature.group".length());
        }
        bld.append(id);
        String name = null;
        IInstallableUnit iu = iuRef.resolveAsSingleton();
        if (iu != null && (name = RepositoryTranslationSupport.getInstance((IQueryable)((MetadataRepository)((InstallableUnitImpl)iu).eContainer())).getIUProperty(iu, "org.eclipse.equinox.p2.name")).startsWith("%")) {
            name = null;
        }
        if (name != null || !VersionRange.emptyRange.equals((Object)versionRange)) {
            bld.append(" / ");
            if (!VersionRange.emptyRange.equals((Object)versionRange)) {
                bld.append(P2Utils.versionRangeToString((VersionRange)versionRange));
            }
            if (name != null) {
                bld.append(" (");
                bld.append(name);
                bld.append(")");
            }
        }
        return true;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Collection<?> getChildren(Object object) {
        if (!((InstallableUnitRequest)object).isBranchDisabledOrMappedRepositoryBroken()) {
            return super.getChildren(object);
        }
        return Collections.emptyList();
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(AggregatorPackage.Literals.INSTALLABLE_UNIT_REQUEST__AVAILABLE_VERSIONS_HEADER);
        }
        return this.childrenFeatures;
    }

    protected List<? extends InstallableUnitRequest> getContainerChildren(MappedRepository container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getForeground(Object object) {
        return !((InstallableUnitRequest)object).isBranchDisabledOrMappedRepositoryBroken() ? null : IItemColorProvider.GRAYED_OUT_COLOR;
    }

    protected IQuery<IInstallableUnit> getInstallableUnitQuery() {
        throw new UnsupportedOperationException();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addDescriptionPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addVersionRangePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public ResourceLocator getResourceLocator() {
        return AggregatorEditPlugin.INSTANCE;
    }

    public String getText(Object object) {
        String label = ((InstallableUnitRequest)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_InstallableUnitRequest_type") : String.valueOf(this.getString("_UI_InstallableUnitRequest_type")) + " " + label;
    }

    public boolean hasChildren(Object object) {
        return !((InstallableUnitRequest)object).isBranchDisabledOrMappedRepositoryBroken();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(InstallableUnitRequest.class)) {
            case 5: 
            case 6: {
                InstallableUnitRequest iuRequest = (InstallableUnitRequest)notification.getNotifier();
                iuRequest.resolveAvailableVersions(true);
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                GeneralUtils.getAggregatorResource((EObject)((EObject)iuRequest)).analyzeResource();
                return;
            }
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }
}

