/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.engine.internal.MultiRangeRequirement;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.util.Trivial;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPFilter;
import org.eclipse.equinox.internal.p2.metadata.expression.MatchExpression;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.osgi.framework.InvalidSyntaxException;

public class RequirementUtils {
    private static final VersionRange ANY_VERSION = VersionRange.emptyRange;

    public static IRequirement[] createAllAvailableVersionsRequirements(List<IInstallableUnit> ius, IMatchExpression<IInstallableUnit> filter) {
        HashMap<String, HashSet<IInstallableUnit>> iuMap = new HashMap<String, HashSet<IInstallableUnit>>();
        for (IInstallableUnit iu : ius) {
            HashSet<IInstallableUnit> iuSet = (HashSet<IInstallableUnit>)iuMap.get(iu.getId());
            if (iuSet == null) {
                iuSet = new HashSet<IInstallableUnit>();
                iuMap.put(iu.getId(), iuSet);
            }
            iuSet.add(iu);
        }
        IRequirement[] requirements = new IRequirement[iuMap.size()];
        int i = 0;
        for (Map.Entry iuEntry : iuMap.entrySet()) {
            String name = (String)iuEntry.getKey();
            IMatchExpression requirementFilter = filter;
            for (IInstallableUnit iu : (Set)iuEntry.getValue()) {
                IMatchExpression iuFilter = iu.getFilter();
                if (iuFilter == null) continue;
                if (requirementFilter == null) {
                    requirementFilter = iuFilter;
                    continue;
                }
                if (requirementFilter.equals(iuFilter)) continue;
                Object[] p1 = iuFilter.getParameters();
                Object[] p2 = requirementFilter.getParameters();
                if (p1.length == 1 && p2.length == 1 && p1[0] instanceof LDAPFilter && p2[0] instanceof LDAPFilter) {
                    LDAPFilter f1 = (LDAPFilter)p1[0];
                    LDAPFilter f2 = (LDAPFilter)p2[0];
                    try {
                        Filter bf1 = FilterFactory.newInstance((String)f1.toString());
                        Filter bf2 = FilterFactory.newInstance((String)f2.toString());
                        Filter t1 = bf1.addFilterWithOr(bf2);
                        IFilterExpression expr = ExpressionUtil.parseLDAP((String)t1.toString());
                        requirementFilter = ExpressionUtil.getFactory().matchExpression((IExpression)((MatchExpression)iuFilter).getOperand(), new Object[]{expr});
                        continue;
                    }
                    catch (InvalidSyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                Object[] compoundParams = new Object[p1.length + p2.length];
                System.arraycopy(p1, 0, compoundParams, 0, p1.length);
                System.arraycopy(p2, 0, compoundParams, p1.length, p2.length);
                requirementFilter = ExpressionFactory.INSTANCE.matchExpression(ExpressionFactory.INSTANCE.or(new IExpression[]{iuFilter, requirementFilter}), compoundParams);
            }
            requirements[i++] = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)name, (VersionRange)ANY_VERSION, requirementFilter, (boolean)false, (boolean)false);
        }
        return requirements;
    }

    public static IRequirement createMultiRangeRequirement(MetadataRepository mdr, IRequirement req) {
        HashSet<Version> matchingVersions = new HashSet<Version>();
        String name = null;
        String namespace = "org.eclipse.equinox.p2.iu";
        for (IInstallableUnit iu : mdr.getInstallableUnits()) {
            if (!req.isMatch(iu)) continue;
            matchingVersions.add(iu.getVersion());
            if (name == null) {
                name = iu.getId();
                continue;
            }
            if (name.equals(iu.getId())) continue;
            throw new RuntimeException("Requirement must contain strict name filter");
        }
        return new MultiRangeRequirement(name, namespace, matchingVersions, null, (IMatchExpression<IInstallableUnit>)req.getFilter());
    }

    public static String getName(IRequirement req) {
        if (req instanceof IRequiredCapability) {
            return ((IRequiredCapability)req).getName();
        }
        if (req instanceof MultiRangeRequirement) {
            return ((MultiRangeRequirement)req).getName();
        }
        throw new RuntimeException("Unable to extract IU name from requirement of class " + req.getClass().getName());
    }

    public static boolean isIncluded(MapRule rule, IVersionedId iu) {
        if (rule == null || iu == null) {
            return false;
        }
        if (!Trivial.equalsAllowNull((Object)rule.getName(), (Object)iu.getId())) {
            return false;
        }
        VersionRange range = rule.getVersionRange();
        return range == null ? true : range.isIncluded(iu.getVersion());
    }

    public static boolean isIntersectingWith(IRequirement req, VersionRange range) {
        if (range == null) {
            return true;
        }
        if (req == null) {
            return false;
        }
        if (req instanceof IRequiredCapability) {
            return ((IRequiredCapability)req).getRange().intersect(range) != null;
        }
        if (req instanceof MultiRangeRequirement) {
            for (VersionRange r : ((MultiRangeRequirement)req).getVersionRanges()) {
                if (r.intersect(range) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static IRequirement versionUnion(IRequirement req1, IRequirement req2) {
        if (req1 instanceof MultiRangeRequirement && req2 instanceof MultiRangeRequirement) {
            MultiRangeRequirement vreq1 = (MultiRangeRequirement)req1;
            MultiRangeRequirement vreq2 = (MultiRangeRequirement)req2;
            if (!vreq1.getName().equals(vreq2.getName())) {
                throw new RuntimeException("Unable to create a version union of expressions with different name requests");
            }
            if (!vreq1.getNamespace().equals(vreq2.getNamespace())) {
                throw new RuntimeException("Unable to create a version union of expressions with different namespace requests");
            }
            IMatchExpression<IInstallableUnit> f1 = vreq1.getFilter();
            IMatchExpression<IInstallableUnit> f2 = vreq2.getFilter();
            if (f1 != null && !f1.equals(f2) || f1 == null && f2 != null) {
                throw new RuntimeException("Unable to create a version union of expressions with different filters");
            }
            HashSet<Version> allVersions = new HashSet<Version>();
            allVersions.addAll(vreq1.getVersions());
            allVersions.addAll(vreq2.getVersions());
            return new MultiRangeRequirement(vreq1.getName(), vreq1.getNamespace(), allVersions, null, f1);
        }
        throw new RuntimeException("Unable to create a version union of expressions: " + req1 + ", " + req2);
    }
}

