/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.util;

import java.text.ChoiceFormat;
import java.text.MessageFormat;

public class TimeUtils {
    private static final MessageFormat TIME_FORMAT = new MessageFormat("{0}{1}");
    private static final double[] LIMITS = new double[]{0.0, 1.0, 2.0};
    private static final String[] MINUTES_PART = new String[]{"", "1 minute ", "{0,number} minutes "};
    private static final String[] SECONDS_PART = new String[]{"0 seconds", "1 second", "{1,number} seconds"};
    private static final ChoiceFormat MINUTES_FORMAT = new ChoiceFormat(LIMITS, MINUTES_PART);
    private static final ChoiceFormat SECONDS_FORMAT = new ChoiceFormat(LIMITS, SECONDS_PART);
    private static final int MS_IN_SECOND = 1000;
    private static final int SEC_IN_MINUTE = 60;

    static {
        TIME_FORMAT.setFormat(0, MINUTES_FORMAT);
        TIME_FORMAT.setFormat(1, SECONDS_FORMAT);
    }

    public static long getDuration(long fromTime) {
        return System.currentTimeMillis() - fromTime;
    }

    public static String getFormattedDuration(long fromTime) {
        long milliseconds = TimeUtils.getDuration(fromTime);
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        Object[] args = new Object[]{minutes, seconds % 60L};
        return TIME_FORMAT.format(args);
    }

    public static long getNow() {
        return System.currentTimeMillis();
    }
}

