/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.AvailableFrom;
import org.eclipse.b3.aggregator.AvailableVersion;
import org.eclipse.b3.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.b3.aggregator.provider.AggregatorItemProviderAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.p2.metadata.Version;

public class AvailableVersionItemProvider
extends AggregatorItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    public AvailableVersionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void addAvailableFromPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AvailableVersion_availableFrom_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AvailableVersion_availableFrom_feature", "_UI_AvailableVersion_type"), (EStructuralFeature)AggregatorPackage.Literals.AVAILABLE_VERSION__AVAILABLE_FROM, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFilterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AvailableVersion_filter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AvailableVersion_filter_feature", "_UI_AvailableVersion_type"), (EStructuralFeature)AggregatorPackage.Literals.AVAILABLE_VERSION__FILTER, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVersionMatchPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AvailableVersion_versionMatch_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AvailableVersion_versionMatch_feature", "_UI_AvailableVersion_type"), (EStructuralFeature)AggregatorPackage.Literals.AVAILABLE_VERSION__VERSION_MATCH, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AvailableVersion_version_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AvailableVersion_version_feature", "_UI_AvailableVersion_type"), (EStructuralFeature)AggregatorPackage.Literals.AVAILABLE_VERSION__VERSION, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public Object getForeground(Object object) {
        if (((AvailableVersion)object).getAvailableFrom() == AvailableFrom.AGGREGATION) {
            return IItemColorProvider.GRAYED_OUT_COLOR;
        }
        return null;
    }

    public Object getImage(Object object) {
        Version version = ((AvailableVersion)object).getVersion();
        if (version == null) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/NoVersionAvailable"));
        }
        switch (((AvailableVersion)object).getVersionMatch()) {
            case BELOW: {
                return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/VersionBelowRange"));
            }
            case MATCHES: {
                return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/VersionOK"));
            }
            case ABOVE: {
                return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/VersionAboveRange"));
            }
        }
        return null;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addVersionMatchPropertyDescriptor(object);
            this.addVersionPropertyDescriptor(object);
            this.addFilterPropertyDescriptor(object);
            this.addAvailableFromPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public ResourceLocator getResourceLocator() {
        return AggregatorEditPlugin.INSTANCE;
    }

    public String getText(Object object) {
        AvailableVersion av = (AvailableVersion)object;
        Version version = av.getVersion();
        if (version == null) {
            return "no version is available";
        }
        StringBuffer sb = new StringBuffer();
        version.toString(sb);
        if (av.getAvailableFrom() != AvailableFrom.REPOSITORY) {
            sb.append(" (from another ");
            switch (av.getAvailableFrom()) {
                case CONTRIBUTION: {
                    sb.append("Repository in this Contribution");
                    break;
                }
                case VALIDATION_SET: {
                    sb.append("Contribution in this Validation Set");
                    break;
                }
                case AGGREGATION: {
                    sb.append("Validation Set");
                }
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String getTooltipText(Object object) {
        Version version = ((AvailableVersion)object).getVersion();
        if (version == null) {
            return null;
        }
        switch (((AvailableVersion)object).getVersionMatch()) {
            case BELOW: {
                return "This version is too low to match the version range";
            }
            case MATCHES: {
                return "This version matches the version range";
            }
            case ABOVE: {
                return "This version is too high to match the version range";
            }
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AvailableVersion.class)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }
}

