/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.presentation;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.ValidationSetVerifier;
import org.eclipse.b3.aggregator.impl.AggregationImpl;
import org.eclipse.b3.aggregator.impl.ContributionImpl;
import org.eclipse.b3.aggregator.presentation.AggregatorEditor;
import org.eclipse.b3.aggregator.util.AggregatorResourceImpl;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.aggregator.util.VerificationDiagnostic;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;
import org.xml.sax.SAXException;

public class DiagnosticMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] noResolutions = new IMarkerResolution[0];

    static void clearVerificationMarkers(Aggregation aggregation) {
        ((AggregationImpl)aggregation).clearStatus();
    }

    static AggregatorEditor getAggregatorEditor(IMarker marker) {
        try {
            IEditorPart ep;
            IFile file = (IFile)marker.getResource();
            AggregatorEditor editor = null;
            IWorkbenchPage firstPage = null;
            IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.getInstance().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow wbw = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = wbw.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage wbp = iWorkbenchPageArray[n4];
                    if (firstPage == null) {
                        firstPage = wbp;
                    }
                    IEditorReference[] iEditorReferenceArray = wbp.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorInput epInput;
                        IEditorReference eref = iEditorReferenceArray[n6];
                        IEditorPart ep2 = eref.getEditor(false);
                        if (ep2 instanceof AggregatorEditor && (epInput = ep2.getEditorInput()) instanceof FileEditorInput && ((FileEditorInput)epInput).getFile().equals((Object)file)) {
                            editor = (AggregatorEditor)ep2;
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (editor == null && firstPage != null && (ep = IDE.openEditor(firstPage, (IFile)file)) instanceof AggregatorEditor) {
                editor = (AggregatorEditor)ep;
            }
            return editor;
        }
        catch (CoreException e) {
            return null;
        }
    }

    static Contribution getContribution(URI uri, ResourceSet resourceSet) {
        Contribution contrib = null;
        if (uri.fragment() != null) {
            contrib = (Contribution)resourceSet.getEObject(uri, true);
        }
        return contrib;
    }

    static List<Contribution> getContributions(IMarker marker, ResourceSet resourceSet) {
        VerificationDiagnostic.Singleton[] relatedDiags;
        String uriAttribute = marker.getAttribute("uri", null);
        if (uriAttribute == null) {
            return Collections.emptyList();
        }
        Contribution contrib = DiagnosticMarkerResolutionGenerator.getContribution(URI.createURI((String)uriAttribute), resourceSet);
        if (contrib == null) {
            return Collections.emptyList();
        }
        try {
            relatedDiags = (VerificationDiagnostic.Singleton[])marker.getAttribute("p2.verification.related.diagnostics");
        }
        catch (CoreException e) {
            relatedDiags = null;
        }
        if (relatedDiags == null) {
            return Collections.singletonList(contrib);
        }
        UniqueEList.FastCompare contribs = new UniqueEList.FastCompare();
        VerificationDiagnostic.Singleton[] singletonArray = relatedDiags;
        int n = relatedDiags.length;
        int n2 = 0;
        while (n2 < n) {
            VerificationDiagnostic.Singleton relatedDiag = singletonArray[n2];
            Contribution relatedContrib = DiagnosticMarkerResolutionGenerator.getContribution(relatedDiag.getLocationURI(), resourceSet);
            if (relatedContrib != null) {
                contribs.add(relatedContrib);
            }
            ++n2;
        }
        return contribs;
    }

    static Throwable unwind(Throwable t) {
        String msg;
        Throwable cause;
        Class<?> tc;
        while (!((tc = t.getClass()) != RuntimeException.class && tc != InvocationTargetException.class && tc != SAXException.class && tc != IOException.class || (cause = t.getCause()) == null || (msg = t.getMessage()) != null && !msg.equals(cause.toString()))) {
            t = cause;
        }
        return t;
    }

    static void verifyAggregation(final Aggregation aggregation) {
        new Job("b3 Aggregator"){
            {
                super($anonymous0);
                this.setUser(true);
                this.setPriority(30);
            }

            protected IStatus run(IProgressMonitor monitor) {
                Resource resource = ((EObject)aggregation).eResource();
                try {
                    DiagnosticMarkerResolutionGenerator.clearVerificationMarkers(aggregation);
                    Builder builder = new Builder();
                    URI emfURI = resource.getURI();
                    URL fileURL = FileLocator.toFileURL((URL)new java.net.URI(emfURI.toString()).toURL());
                    if (!"file".equals(fileURL.getProtocol())) {
                        throw new Exception("URI scheme is not \"file\"");
                    }
                    java.net.URI uri = new java.net.URI(String.valueOf(fileURL.getProtocol()) + ":/" + URLEncoder.encode(fileURL.getPath(), "UTF-8").replaceAll("\\+", "%20"));
                    builder.setBuildModelLocation(new File(uri));
                    builder.setAction(Builder.ActionType.VALIDATE);
                    if (builder.run(true, monitor) != IApplication.EXIT_OK.intValue()) {
                        throw new Exception("Build failed (see log for more details)");
                    }
                }
                catch (Exception e) {
                    Status status;
                    Throwable cause = DiagnosticMarkerResolutionGenerator.unwind(e);
                    Object object = status = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.b3.aggregator.engine", 0, cause.getMessage(), cause);
                    if (resource != null && status instanceof ValidationSetVerifier.AnalyzedPlannerStatus) {
                        ((AggregatorResourceImpl)resource).updateVerificationMarkers(((ValidationSetVerifier.AnalyzedPlannerStatus)status).getVerificationDiagnostics());
                    }
                    return status;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            Contribution contribB;
            ValidationSet vB;
            Object severity = marker.getAttribute("severity");
            if (!(severity instanceof Integer) || (Integer)severity != 2) {
                return noResolutions;
            }
            Object verType = marker.getAttribute("p2.verification.error.type");
            if (!VerificationDiagnostic.Singleton.class.getName().equals(verType)) {
                return noResolutions;
            }
            AggregatorEditor editor = DiagnosticMarkerResolutionGenerator.getAggregatorEditor(marker);
            ResourceSet resourceSet = editor.getEditingDomain().getResourceSet();
            List<Contribution> contribs = DiagnosticMarkerResolutionGenerator.getContributions(marker, resourceSet);
            if (contribs.size() < 2) {
                return noResolutions;
            }
            Contribution contribA = contribs.get(0);
            ValidationSet vA = (ValidationSet)((EObject)contribA).eContainer();
            if (!vA.isExtensionOf(vB = (ValidationSet)((EObject)(contribB = contribs.get(1))).eContainer()) && !vB.isExtensionOf(vA)) {
                return noResolutions;
            }
            Aggregation aggregation = ResourceUtils.getAggregation((ResourceSet)resourceSet);
            EList vss = aggregation.getValidationSets(true);
            ArrayList<AggregatorMarkerResolution> resolutions = new ArrayList<AggregatorMarkerResolution>();
            boolean hasSelfA = false;
            boolean hasSelfB = false;
            for (ValidationSet vs : vss) {
                if (!vA.isExtensionOf(vs)) {
                    resolutions.add(new MoveToExisting(contribA, vs));
                }
                if (!vB.isExtensionOf(vs)) {
                    resolutions.add(new MoveToExisting(contribB, vs));
                }
                if (vs.getLabel().equals(contribA.getLabel())) {
                    hasSelfA = true;
                }
                if (!vs.getLabel().equals(contribB.getLabel())) continue;
                hasSelfB = true;
            }
            if (!hasSelfA) {
                resolutions.add(new MoveToNew(contribA));
            }
            if (!hasSelfB) {
                resolutions.add(new MoveToNew(contribB));
            }
            if (!hasSelfA && !hasSelfB) {
                resolutions.add(new MoveBothToNew(contribA, contribB));
            }
            if (resolutions.isEmpty()) {
                return noResolutions;
            }
            return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
        }
        catch (CoreException e) {
            return noResolutions;
        }
    }

    public boolean hasResolutions(IMarker marker) {
        return this.getResolutions(marker).length > 0;
    }

    static abstract class AggregatorMarkerResolution
    implements IMarkerResolution {
        protected final Contribution contribution;

        AggregatorMarkerResolution(Contribution contribution) {
            this.contribution = contribution;
        }

        abstract ValidationSet getReceiver(Contribution var1, ResourceSet var2);

        public void run(IMarker marker) {
            String uriAttribute = marker.getAttribute("uri", null);
            URI uri = URI.createURI((String)uriAttribute);
            if (uri.fragment() == null) {
                return;
            }
            AggregatorEditor editor = DiagnosticMarkerResolutionGenerator.getAggregatorEditor(marker);
            if (editor == null) {
                return;
            }
            ResourceSet resourceSet = editor.getEditingDomain().getResourceSet();
            ValidationSet child = this.getReceiver(this.contribution, resourceSet);
            child.getContributions().add((Object)this.contribution);
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            DiagnosticMarkerResolutionGenerator.verifyAggregation(ResourceUtils.getAggregation((ResourceSet)resourceSet));
        }
    }

    static class MoveBothToNew
    extends MoveToNew {
        private final Contribution other;

        MoveBothToNew(Contribution contribution, Contribution other) {
            super(contribution);
            this.other = other;
        }

        @Override
        public String getLabel() {
            return String.format("Move conflicting contributions %s and %s into two new separate validation sets", this.contribution.getLabel(), this.other.getLabel());
        }

        @Override
        public void run(IMarker marker) {
            String uriAttribute = marker.getAttribute("uri", null);
            URI uri = URI.createURI((String)uriAttribute);
            if (uri.fragment() == null) {
                return;
            }
            AggregatorEditor editor = DiagnosticMarkerResolutionGenerator.getAggregatorEditor(marker);
            if (editor == null) {
                return;
            }
            ResourceSet resourceSet = editor.getEditingDomain().getResourceSet();
            ValidationSet vs = this.getReceiver(this.contribution, resourceSet);
            vs.getContributions().add((Object)this.contribution);
            vs = this.getReceiver(this.other, resourceSet);
            vs.getContributions().add((Object)this.other);
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            DiagnosticMarkerResolutionGenerator.verifyAggregation(ResourceUtils.getAggregation((ResourceSet)resourceSet));
        }
    }

    static class MoveToExisting
    extends AggregatorMarkerResolution {
        private final ValidationSet receiver;

        MoveToExisting(Contribution contribution, ValidationSet receiver) {
            super(contribution);
            this.receiver = receiver;
        }

        public String getLabel() {
            return String.format("Move contribution %s into a validation set '%s'", this.contribution.getLabel(), this.receiver.getLabel());
        }

        @Override
        ValidationSet getReceiver(Contribution contribution, ResourceSet resourceSet) {
            return this.receiver;
        }
    }

    static class MoveToNew
    extends AggregatorMarkerResolution {
        MoveToNew(Contribution contribution) {
            super(contribution);
        }

        public String getLabel() {
            return String.format("Move contribution %s into a new validation set", this.contribution.getLabel());
        }

        @Override
        ValidationSet getReceiver(Contribution contrib, ResourceSet resourceSet) {
            ((ContributionImpl)contrib).setStatus(null);
            Aggregation aggregation = ResourceUtils.getAggregation((ResourceSet)resourceSet);
            ValidationSet current = (ValidationSet)((EObject)contrib).eContainer();
            ValidationSet newVs = AggregatorFactory.eINSTANCE.createValidationSet();
            newVs.getExtends().add((Object)current);
            newVs.setLabel(contrib.getLabel());
            aggregation.getValidationSets().add((Object)newVs);
            return newVs;
        }
    }
}

