/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.sat4j.pb.tools.WeightedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizationFunction {
    private IQueryable<IInstallableUnit> picker;
    private IInstallableUnit selectionContext;
    private Map<String, Map<Version, IInstallableUnit>> slice;
    private int numberOfInstalledIUs;
    private IQueryable<IInstallableUnit> lastState;
    private List<Projector.AbstractVariable> abstractVariables;

    public OptimizationFunction(IQueryable<IInstallableUnit> lastState, List<Projector.AbstractVariable> abstractVariables, IQueryable<IInstallableUnit> picker, IInstallableUnit selectionContext, Map<String, Map<Version, IInstallableUnit>> slice) {
        this.lastState = lastState;
        this.abstractVariables = abstractVariables;
        this.picker = picker;
        this.selectionContext = selectionContext;
        this.slice = slice;
    }

    public List<WeightedObject<? extends Object>> createOptimizationFunction(IInstallableUnit metaIu, Collection<IInstallableUnit> newRoots) {
        BigInteger POWER;
        IQueryable<IInstallableUnit> queryable;
        this.numberOfInstalledIUs = this.sizeOf(this.lastState);
        ArrayList<WeightedObject<? extends Object>> weightedObjects = new ArrayList<WeightedObject<? extends Object>>();
        Set transitiveClosure = newRoots.isEmpty() ? CollectionUtils.emptySet() : ((queryable = new Slicer(this.picker, this.selectionContext, false).slice(newRoots.toArray(new IInstallableUnit[newRoots.size()]), (IProgressMonitor)new NullProgressMonitor())) == null ? CollectionUtils.emptySet() : queryable.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toSet());
        Set<Map.Entry<String, Map<Version, IInstallableUnit>>> s = this.slice.entrySet();
        BigInteger maxWeight = POWER = BigInteger.valueOf(this.numberOfInstalledIUs > 0 ? this.numberOfInstalledIUs + 1 : 2);
        for (Map.Entry<String, Map<Version, IInstallableUnit>> entry : s) {
            ArrayList<IInstallableUnit> conflictingEntries = new ArrayList<IInstallableUnit>(entry.getValue().values());
            if (conflictingEntries.size() == 1) {
                IInstallableUnit iu = (IInstallableUnit)conflictingEntries.get(0);
                if (iu == metaIu) continue;
                weightedObjects.add(WeightedObject.newWO((Object)iu, (BigInteger)POWER));
                continue;
            }
            Collections.sort(conflictingEntries, Collections.reverseOrder());
            BigInteger weight = POWER;
            boolean foundInstalled = false;
            boolean foundRoot = false;
            for (IInstallableUnit iu : conflictingEntries) {
                if (!foundRoot && this.isInstalled(iu) && !transitiveClosure.contains(iu)) {
                    foundInstalled = true;
                    weightedObjects.add(WeightedObject.newWO((Object)iu, (BigInteger)BigInteger.ONE));
                } else if (!foundInstalled && !foundRoot && this.isRoot(iu, newRoots)) {
                    foundRoot = true;
                    weightedObjects.add(WeightedObject.newWO((Object)iu, (BigInteger)BigInteger.ONE));
                } else {
                    weightedObjects.add(WeightedObject.newWO((Object)iu, (BigInteger)weight));
                }
                weight = weight.multiply(POWER);
            }
            if (weight.compareTo(maxWeight) <= 0) continue;
            maxWeight = weight;
        }
        maxWeight = maxWeight.multiply(POWER).multiply(BigInteger.valueOf(s.size()));
        BigInteger abstractWeight = maxWeight.negate();
        for (Projector.AbstractVariable var : this.abstractVariables) {
            weightedObjects.add(WeightedObject.newWO((Object)var, (BigInteger)abstractWeight));
        }
        maxWeight = maxWeight.multiply(POWER).add(BigInteger.ONE);
        BigInteger optionalWeight = maxWeight.negate();
        long countOptional = 1L;
        ArrayList<IInstallableUnit> requestedPatches = new ArrayList<IInstallableUnit>();
        Collection reqs = metaIu.getRequirements();
        for (IRequirement req : reqs) {
            if (req.getMin() > 0 || !req.isGreedy()) continue;
            IQueryResult matches = this.picker.query(QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]), null);
            for (IInstallableUnit match : matches) {
                if (match instanceof IInstallableUnitPatch) {
                    requestedPatches.add(match);
                    ++countOptional;
                    continue;
                }
                weightedObjects.add((WeightedObject<? extends Object>)WeightedObject.newWO((Object)match, (BigInteger)optionalWeight));
            }
        }
        BigInteger patchWeight = maxWeight.multiply(POWER).multiply(BigInteger.valueOf(countOptional)).negate();
        Iterator iterator = requestedPatches.iterator();
        while (iterator.hasNext()) {
            weightedObjects.add((WeightedObject<? extends Object>)WeightedObject.newWO((Object)((IInstallableUnit)iterator.next()), (BigInteger)patchWeight));
        }
        return weightedObjects;
    }

    protected boolean isInstalled(IInstallableUnit iu) {
        return !this.lastState.query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty();
    }

    private boolean isRoot(IInstallableUnit iu, Collection<IInstallableUnit> newRoots) {
        return newRoots.contains(iu);
    }

    private int sizeOf(IQueryable<IInstallableUnit> installedIUs) {
        IQueryResult qr = installedIUs.query(QueryUtil.createIUAnyQuery(), null);
        if (qr instanceof Collector) {
            return ((Collector)qr).size();
        }
        return qr.toUnmodifiableSet().size();
    }
}

